/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.components.embedder_support.view;

import a.b.c.b.j;
import a.b.c.b.o;
import a.b.c.b.p;
import a.b.c.b.q;
import a.b.d.a.a0;
import a.b.d.a.g;
import a.b.d.a.w;
import a.b.d.a.z;
import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Rect;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.view.DragEvent;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewStructure;
import android.view.accessibility.AccessibilityNodeProvider;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputConnection;
import android.widget.FrameLayout;
import java.util.Iterator;
import org.chromium.base.TraceEvent;
import org.chromium.content_public.browser.WebContents;
import org.chromium.ui.base.EventForwarder;

public class ContentView
extends FrameLayout
implements z.a,
w {
    public static final String TAG = "cr.ContentView";
    public static final int DEFAULT_MEASURE_SPEC = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
    public final WebContents mWebContents;
    public z mViewEventSink;
    public EventForwarder mEventForwarder;
    public TouchEventDelegate mDelegate;
    public int mDesiredWidthMeasureSpec;
    public int mDesiredHeightMeasureSpec;

    public static ContentView createContentView(Context context, WebContents webContents) {
        if (Build.VERSION.SDK_INT >= 23) {
            return new ContentViewApi23(context, webContents);
        }
        return new ContentView(context, webContents);
    }

    public ContentView(Context context, WebContents webContents) {
        ContentView contentView = this;
        super(context, null, 16842885);
        contentView.mDesiredHeightMeasureSpec = this.mDesiredWidthMeasureSpec = DEFAULT_MEASURE_SPEC;
        if (contentView.getScrollBarStyle() == 0) {
            ContentView contentView2 = this;
            contentView2.setHorizontalScrollBarEnabled(false);
            contentView2.setVerticalScrollBarEnabled(false);
        }
        ContentView contentView3 = this;
        contentView3.mWebContents = webContents;
        contentView3.setFocusable(true);
        contentView3.setFocusableInTouchMode(true);
        if (Build.VERSION.SDK_INT >= 26) {
            this.setDefaultFocusHighlightEnabled(false);
        }
    }

    private EventForwarder getEventForwarder() {
        if (this.mEventForwarder == null) {
            this.mEventForwarder = this.mWebContents.getEventForwarder();
        }
        return this.mEventForwarder;
    }

    private z getViewEventSink() {
        if (this.mViewEventSink == null) {
            this.mViewEventSink = z.a(this.mWebContents);
        }
        return this.mViewEventSink;
    }

    public a0 getWebContentsAccessibility() {
        return !this.mWebContents.isDestroyed() ? a0.fromWebContents(this.mWebContents) : null;
    }

    public boolean performAccessibilityAction(int n2, Bundle bundle) {
        a0 a02 = this.getWebContentsAccessibility();
        return a02 != null && a02.supportsAction(n2) ? a02.performAction(n2, bundle) : super.performAccessibilityAction(n2, bundle);
    }

    public void setDesiredMeasureSpec(int n2, int n3) {
        this.mDesiredWidthMeasureSpec = n2;
        this.mDesiredHeightMeasureSpec = n3;
    }

    public void setTouchEventDelegate(TouchEventDelegate touchEventDelegate) {
        this.mDelegate = touchEventDelegate;
    }

    public void onMeasure(int n2, int n3) {
        int n4 = this.mDesiredWidthMeasureSpec;
        if (n4 == DEFAULT_MEASURE_SPEC) {
            n4 = n2;
        }
        n2 = this.mDesiredHeightMeasureSpec;
        if (n2 == DEFAULT_MEASURE_SPEC) {
            n2 = n3;
        }
        super.onMeasure(n4, n2);
    }

    public AccessibilityNodeProvider getAccessibilityNodeProvider() {
        a0 a02 = this.getWebContentsAccessibility();
        a02 = a02 != null ? a02.getAccessibilityNodeProvider() : null;
        if (a02 == null) {
            a02 = super.getAccessibilityNodeProvider();
        }
        return a02;
    }

    @Override
    public void onScrollChanged(int n2, int n3, int n4, int n5) {
        super.onScrollChanged(n2, n3, n4, n5);
    }

    public InputConnection onCreateInputConnection(EditorInfo editorInfo) {
        if (this.mWebContents.isDestroyed()) {
            return null;
        }
        return g.fromWebContents(this.mWebContents).onCreateInputConnection(editorInfo);
    }

    public boolean onCheckIsTextEditor() {
        if (this.mWebContents.isDestroyed()) {
            return false;
        }
        return g.fromWebContents(this.mWebContents).onCheckIsTextEditor();
    }

    public void onFocusChanged(boolean bl, int n2, Rect rect) {
        o o2;
        block7: {
            ContentView contentView = this;
            ContentView contentView2 = contentView;
            TraceEvent.begin("ContentView.onFocusChanged");
            super.onFocusChanged(bl, n2, rect);
            z z2 = contentView.getViewEventSink();
            boolean bl2 = true;
            ((o)z2).n = bl2;
            o2 = (o)contentView2.getViewEventSink();
            Boolean bl3 = o2.k;
            if (bl3 == null) break block7;
            if (bl3 != bl) break block7;
        }
        o2.k = bl;
        o2.a();
        return;
        finally {
            TraceEvent.end("ContentView.onFocusChanged");
        }
    }

    public void onWindowFocusChanged(boolean bl) {
        ContentView contentView = iterator;
        super.onWindowFocusChanged(bl);
        Iterator<p> iterator = q.a((WebContents)((o)contentView.getViewEventSink()).j).j.iterator();
        while (iterator.hasNext()) {
            ((p)iterator.next()).onWindowFocusChanged(bl);
        }
    }

    public boolean onKeyUp(int n2, KeyEvent keyEvent) {
        return this.getEventForwarder().onKeyUp(n2, keyEvent);
    }

    public boolean dispatchKeyEvent(KeyEvent keyEvent) {
        return this.isFocused() ? this.getEventForwarder().dispatchKeyEvent(keyEvent) : super.dispatchKeyEvent(keyEvent);
    }

    public boolean onDragEvent(DragEvent dragEvent) {
        return this.getEventForwarder().onDragEvent(dragEvent, (View)this);
    }

    public boolean dispatchTouchEvent(MotionEvent motionEvent) {
        TouchEventDelegate touchEventDelegate = this.mDelegate;
        if (touchEventDelegate != null && touchEventDelegate.dispatchTouchEvent(motionEvent)) {
            return true;
        }
        return super.dispatchTouchEvent(motionEvent);
    }

    public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        TouchEventDelegate touchEventDelegate = this.mDelegate;
        if (touchEventDelegate != null && touchEventDelegate.onInterceptTouchEvent(motionEvent)) {
            return true;
        }
        return super.onInterceptTouchEvent(motionEvent);
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        return this.getEventForwarder().onTouchEvent(motionEvent);
    }

    public boolean onHoverEvent(MotionEvent motionEvent) {
        ContentView contentView = this;
        boolean bl = contentView.getEventForwarder().onHoverEvent(motionEvent);
        a0 a02 = contentView.getWebContentsAccessibility();
        if (a02 != null && !a02.isTouchExplorationEnabled()) {
            super.onHoverEvent(motionEvent);
        }
        return bl;
    }

    public boolean onGenericMotionEvent(MotionEvent motionEvent) {
        return this.getEventForwarder().onGenericMotionEvent(motionEvent);
    }

    public boolean performLongClick() {
        return false;
    }

    public void onConfigurationChanged(Configuration configuration) {
        ((o)this.getViewEventSink()).a(configuration);
        super.onConfigurationChanged(configuration);
    }

    public void scrollBy(int n2, int n3) {
        this.getEventForwarder().scrollBy(n2, n3);
    }

    public void scrollTo(int n2, int n3) {
        this.getEventForwarder().scrollTo(n2, n3);
    }

    public int computeHorizontalScrollExtent() {
        int n2;
        a.b.d.a.q q2 = a.b.d.a.q.fromWebContents(((ContentView)((Object)q2)).mWebContents);
        if (q2 != null) {
            j j2 = (j)q2;
            n2 = (int)Math.ceil(j2.a(j2.e));
        } else {
            n2 = 0;
        }
        return n2;
    }

    public int computeHorizontalScrollOffset() {
        int n2;
        a.b.d.a.q q2 = a.b.d.a.q.fromWebContents(((ContentView)((Object)q2)).mWebContents);
        if (q2 != null) {
            j j2 = (j)q2;
            n2 = (int)Math.floor(j2.a(j2.a));
        } else {
            n2 = 0;
        }
        return n2;
    }

    public int computeHorizontalScrollRange() {
        int n2;
        a.b.d.a.q q2 = a.b.d.a.q.fromWebContents(((ContentView)((Object)q2)).mWebContents);
        if (q2 != null) {
            j j2 = (j)q2;
            n2 = (int)Math.ceil(j2.a(j2.c));
        } else {
            n2 = 0;
        }
        return n2;
    }

    public int computeVerticalScrollExtent() {
        int n2;
        a.b.d.a.q q2 = a.b.d.a.q.fromWebContents(((ContentView)((Object)q2)).mWebContents);
        if (q2 != null) {
            j j2 = (j)q2;
            n2 = (int)Math.ceil(j2.a(j2.f));
        } else {
            n2 = 0;
        }
        return n2;
    }

    public int computeVerticalScrollOffset() {
        int n2;
        a.b.d.a.q q2 = a.b.d.a.q.fromWebContents(((ContentView)((Object)q2)).mWebContents);
        if (q2 != null) {
            j j2 = (j)q2;
            n2 = (int)Math.floor(j2.a(j2.b));
        } else {
            n2 = 0;
        }
        return n2;
    }

    public int computeVerticalScrollRange() {
        int n2;
        a.b.d.a.q q2 = a.b.d.a.q.fromWebContents(((ContentView)((Object)q2)).mWebContents);
        if (q2 != null) {
            j j2 = (j)q2;
            n2 = (int)Math.ceil(j2.a(j2.d));
        } else {
            n2 = 0;
        }
        return n2;
    }

    public boolean awakenScrollBars(int n2, boolean bl) {
        if (this.getScrollBarStyle() == 0) {
            return false;
        }
        return super.awakenScrollBars(n2, bl);
    }

    public void onAttachedToWindow() {
        ContentView contentView = iterator;
        super.onAttachedToWindow();
        q q2 = q.a(((o)contentView.getViewEventSink()).j);
        q2.m = true;
        q2.a();
        Iterator<p> iterator = q2.j.iterator();
        while (iterator.hasNext()) {
            ((p)iterator.next()).onAttachedToWindow();
        }
    }

    public void onDetachedFromWindow() {
        ContentView contentView = iterator;
        super.onDetachedFromWindow();
        q q2 = q.a(((o)contentView.getViewEventSink()).j);
        q2.b();
        q2.m = false;
        Iterator<p> iterator = q2.j.iterator();
        while (iterator.hasNext()) {
            ((p)iterator.next()).onDetachedFromWindow();
        }
    }

    public void extractSmartClipData(int n2, int n3, int n4, int n5) {
        this.mWebContents.requestSmartClipExtract(n2, n3, n4, n5);
    }

    public void setSmartClipResultHandler(Handler handler) {
        this.mWebContents.setSmartClipResultHandler(handler);
    }

    @Override
    public boolean super_onKeyUp(int n2, KeyEvent keyEvent) {
        return super.onKeyUp(n2, keyEvent);
    }

    @Override
    public boolean super_dispatchKeyEvent(KeyEvent keyEvent) {
        return super.dispatchKeyEvent(keyEvent);
    }

    @Override
    public boolean super_onGenericMotionEvent(MotionEvent motionEvent) {
        return super.onGenericMotionEvent(motionEvent);
    }

    public static class ContentViewApi23
    extends ContentView {
        public ContentViewApi23(Context context, WebContents webContents) {
            super(context, webContents);
        }

        public void onProvideVirtualStructure(ViewStructure viewStructure) {
            if ((this = ((ContentView)this).getWebContentsAccessibility()) != null) {
                this.onProvideVirtualStructure(viewStructure, false);
            }
        }
    }

    public static interface TouchEventDelegate {
        public boolean dispatchTouchEvent(MotionEvent var1);

        public boolean onInterceptTouchEvent(MotionEvent var1);
    }
}

