/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base.task;

import a.b.a.c;
import a.b.a.f;
import a.b.a.q.h;
import a.b.a.q.i;
import android.os.Process;
import android.support.annotation.GuardedBy;
import android.support.annotation.Nullable;
import android.util.Pair;
import java.util.AbstractSequentialList;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.chromium.base.TraceEvent;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.base.task.PostTask;

@JNINamespace(value="base")
public class TaskRunnerImpl
implements h {
    public static final /* synthetic */ boolean $assertionsDisabled;
    public final i mTaskTraits;
    public final String mTraceEvent;
    public final int mTaskRunnerType;
    public final Object mLock;
    @GuardedBy(value="mLock")
    public long mNativeTaskRunnerAndroid;
    public final Runnable mRunPreNativeTaskClosure;
    @GuardedBy(value="mLock")
    public boolean mIsDestroying;
    public final f mLifetimeAssert;
    @Nullable
    public LinkedList<Runnable> mPreNativeTasks;
    @Nullable
    public List<Pair<Runnable, Long>> mPreNativeDelayedTasks;

    public TaskRunnerImpl(i i2) {
        this(i2, "TaskRunnerImpl", 0);
    }

    public TaskRunnerImpl(i i2, String string2, int n2) {
        f f2;
        TaskRunnerImpl taskRunnerImpl = this;
        taskRunnerImpl.mLock = new Object();
        taskRunnerImpl.mRunPreNativeTaskClosure = taskRunnerImpl::runPreNativeTask;
        if (!c.b) {
            f2 = null;
        } else {
            f f3;
            f2 = f3;
            f3 = new f(new f.d(this, new f.a(), false));
        }
        TaskRunnerImpl taskRunnerImpl2 = this;
        TaskRunnerImpl taskRunnerImpl3 = this;
        taskRunnerImpl3.mLifetimeAssert = f2;
        taskRunnerImpl3.mPreNativeTasks = new LinkedList();
        taskRunnerImpl3.mPreNativeDelayedTasks = new ArrayList<Pair<Runnable, Long>>();
        taskRunnerImpl2.mTaskTraits = i2;
        taskRunnerImpl2.mTraceEvent = string2 + ".PreNativeTask.run";
        this.mTaskRunnerType = n2;
        if (!PostTask.registerPreNativeTaskRunnerLocked(this)) {
            this.initNativeTaskRunner();
        }
    }

    private native long nativeInit(int var1, boolean var2, int var3, boolean var4, byte var5, byte[] var6);

    private native void nativeDestroy(long var1);

    private native void nativePostDelayedTask(long var1, Runnable var3, long var4);

    static {
        $assertionsDisabled = TaskRunnerImpl.class.desiredAssertionStatus() ^ true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void destroy() {
        TaskRunnerImpl taskRunnerImpl = this;
        Object object = taskRunnerImpl.mLock;
        synchronized (object) {
            Throwable throwable2;
            block4: {
                block3: {
                    try {
                        f f2 = taskRunnerImpl.mLifetimeAssert;
                        boolean bl = true;
                        if (!c.b) break block3;
                        f2.a.a = bl;
                    }
                    catch (Throwable throwable2) {
                        break block4;
                    }
                }
                this.mIsDestroying = true;
                this.destroyInternal();
                return;
            }
            throw throwable2;
        }
    }

    @GuardedBy(value="mLock")
    public void destroyInternal() {
        long l2 = this.mNativeTaskRunnerAndroid;
        if (l2 != 0L) {
            this.nativeDestroy(l2);
        }
        this.mNativeTaskRunnerAndroid = 0L;
    }

    @Override
    public void disableLifetimeCheck() {
        f f2 = ((TaskRunnerImpl)((Object)f2)).mLifetimeAssert;
        boolean bl = true;
        if (c.b) {
            f2.a.a = bl;
        }
    }

    @Override
    public void postTask(Runnable runnable) {
        this.postDelayedTask(runnable, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void postDelayedTask(Runnable var1_1, long var2_2) {
        var4_3 = this.mLock;
        synchronized (var4_3) {
            if (!TaskRunnerImpl.$assertionsDisabled && this.mIsDestroying) {
                throw new AssertionError();
            }
            if (this.mPreNativeTasks == null) {
                this.postDelayedTaskToNative(var1_1, var2_2);
                return;
            }
            if (var2_2 == 0L) {
                v0 = this;
                v1 = v0;
                v0.mPreNativeTasks.add(var1_1);
            }
            ** GOTO lbl19
            {
                v1.schedulePreNativeTask();
                ** GOTO lbl24
lbl19:
                // 1 sources

                v3 = this;
            }
            this = v4;
            {
                v4 = new Pair((Object)var1_1, (Object)var2_2);
                v3.mPreNativeDelayedTasks.add((Pair<Runnable, Long>)this);
            }
lbl24:
            // 2 sources

            return;
        }
    }

    public void schedulePreNativeTask() {
        PostTask.getPrenativeThreadPoolExecutor().execute(this.mRunPreNativeTaskClosure);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void runPreNativeTask() {
        v0 = this;
        var1_2 = TraceEvent.scoped(v0.mTraceEvent);
        var2_3 = v0.mLock;
        {
            catch (Throwable var0_1) {
                if (var1_2 == null) throw var0_1;
                try {
                    var1_2.close();
                    throw var0_1;
                }
                catch (Throwable v1) {
                    var0_1.addSuppressed(v1);
                }
                throw var0_1;
            }
            {
                ** synchronized (var2_3)
            }
lbl-1000:
            // 1 sources

            {
                if (v0.mPreNativeTasks == null) {
                    // MONITOREXIT @DISABLED, blocks:[2, 8, 9, 12] lbl17 : MonitorExitStatement: MONITOREXIT : var2_3
                    if (var1_2 == null) return;
                    var1_2.close();
                    return;
                }
                v2 = this;
                this = this.mPreNativeTasks.poll();
                // MONITOREXIT @DISABLED, blocks:[2, 8, 9] lbl23 : MonitorExitStatement: MONITOREXIT : var2_3
                {
                    var2_4 = v2.mTaskTraits.b;
                    if (var2_4 == 1) ** GOTO lbl31
                    if (var2_4 == 2) ** GOTO lbl29
                }
            }
            {
                block13: {
                    Process.setThreadPriority((int)10);
                    break block13;
lbl29:
                    // 1 sources

                    Process.setThreadPriority((int)-1);
                    break block13;
lbl31:
                    // 1 sources

                    Process.setThreadPriority((int)0);
                }
                this.run();
                if (var1_2 == null) return;
                var1_2.close();
                return;
            }
            {
                catch (Throwable v3) {}
                {
                    throw v3;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initNativeTaskRunner() {
        Object object = this.mLock;
        TaskRunnerImpl taskRunnerImpl = this;
        synchronized (object) {
            taskRunnerImpl.initNativeTaskRunnerInternal();
            taskRunnerImpl.migratePreNativeTasksToNative();
            return;
        }
    }

    @GuardedBy(value="mLock")
    public void initNativeTaskRunnerInternal() {
        if (((TaskRunnerImpl)((Object)i2)).mNativeTaskRunnerAndroid == 0L) {
            TaskRunnerImpl taskRunnerImpl = i2;
            i i2 = ((TaskRunnerImpl)((Object)i2)).mTaskTraits;
            taskRunnerImpl.mNativeTaskRunnerAndroid = taskRunnerImpl.nativeInit(taskRunnerImpl.mTaskRunnerType, i2.a, i2.b, i2.c, i2.d, i2.e);
        }
    }

    @GuardedBy(value="mLock")
    public void migratePreNativeTasksToNative() {
        Object object = this.mPreNativeTasks;
        if (object != null) {
            object = ((AbstractSequentialList)object).iterator();
            while (object.hasNext()) {
                this.postDelayedTaskToNative((Runnable)object.next(), 0L);
            }
            for (Pair<Runnable, Long> pair : this.mPreNativeDelayedTasks) {
                this.postDelayedTaskToNative((Runnable)pair.first, (Long)pair.second);
            }
            TaskRunnerImpl taskRunnerImpl = this;
            taskRunnerImpl.mPreNativeTasks = null;
            taskRunnerImpl.mPreNativeDelayedTasks = null;
        }
    }

    @GuardedBy(value="mLock")
    public void postDelayedTaskToNative(Runnable runnable, long l2) {
        TaskRunnerImpl taskRunnerImpl = this;
        taskRunnerImpl.nativePostDelayedTask(taskRunnerImpl.mNativeTaskRunnerAndroid, runnable, l2);
    }

    public native boolean nativeBelongsToCurrentThread(long var1);
}

