/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base.metrics;

import org.chromium.base.ThreadUtils;
import org.chromium.base.annotations.JNINamespace;

@JNINamespace(value="base::android")
public class RecordUserAction {
    public static Throwable sDisabledBy;
    public static long sNativeActionCallback;
    public static final /* synthetic */ boolean $assertionsDisabled;

    public static void setDisabledForTests(boolean bl) {
        Throwable throwable;
        Throwable throwable2;
        if (bl && (throwable2 = sDisabledBy) != null) {
            throw new IllegalStateException("UserActions are already disabled.", throwable2);
        }
        if (bl) {
            Throwable throwable3;
            throwable = throwable3;
            throwable3 = new Throwable();
        } else {
            throwable = null;
        }
        sDisabledBy = throwable;
    }

    public static void record(final String string2) {
        if (sDisabledBy != null) {
            return;
        }
        if (ThreadUtils.runningOnUiThread()) {
            RecordUserAction.nativeRecordUserAction(string2);
            return;
        }
        ThreadUtils.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                RecordUserAction.nativeRecordUserAction(string2);
            }
        });
    }

    public static void setActionCallbackForTesting(UserActionCallback userActionCallback) {
        if (!$assertionsDisabled && sNativeActionCallback != 0L) {
            throw new AssertionError();
        }
        sNativeActionCallback = RecordUserAction.nativeAddActionCallbackForTesting(userActionCallback);
    }

    public static void removeActionCallbackForTesting() {
        if (!$assertionsDisabled && sNativeActionCallback == 0L) {
            throw new AssertionError();
        }
        RecordUserAction.nativeRemoveActionCallbackForTesting(sNativeActionCallback);
        sNativeActionCallback = 0L;
    }

    public static native void nativeRecordUserAction(String var0);

    public static native long nativeAddActionCallbackForTesting(UserActionCallback var0);

    public static native void nativeRemoveActionCallbackForTesting(long var0);

    static {
        $assertionsDisabled = RecordUserAction.class.desiredAssertionStatus() ^ true;
    }

    public static interface UserActionCallback {
        public void onActionRecorded(String var1);
    }
}

