/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base;

import a.b.a.g;
import a.b.a.i;
import a.b.a.q.a;
import android.annotation.SuppressLint;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.os.Build;
import android.os.Environment;
import android.os.SystemClock;
import android.system.Os;
import android.text.TextUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicBoolean;
import org.chromium.base.ContextUtils;
import org.chromium.base.annotations.MainDex;
import org.chromium.base.metrics.RecordHistogram;

@MainDex
public abstract class PathUtils {
    public static final String TAG = "PathUtils";
    public static final String THUMBNAIL_DIRECTORY_NAME = "textures";
    public static final int DATA_DIRECTORY = 0;
    public static final int THUMBNAIL_DIRECTORY = 1;
    public static final int CACHE_DIRECTORY = 2;
    public static final int NUM_DIRECTORIES = 3;
    public static final AtomicBoolean sInitializationStarted;
    public static FutureTask<String[]> sDirPathFetchTask;
    public static String sDataDirectorySuffix;
    public static String sCacheSubDirectory;
    public static final /* synthetic */ boolean $assertionsDisabled;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String[] getOrComputeDirectoryPaths() {
        String[] stringArray;
        if (!sDirPathFetchTask.cancel(false)) return sDirPathFetchTask.get();
        i i2 = i.h();
        try {
            stringArray = PathUtils.setPrivateDataDirectorySuffixInternal();
        }
        catch (Throwable throwable) {
            try {
                i2.close();
                throw throwable;
            }
            catch (Throwable throwable2) {
                try {
                    throwable.addSuppressed(throwable2);
                    throw throwable;
                }
                catch (ExecutionException executionException) {
                    return null;
                }
                catch (InterruptedException interruptedException) {}
                return null;
            }
        }
        {
            i2.close();
            return stringArray;
        }
    }

    @SuppressLint(value={"NewApi"})
    public static void chmod(String objectArray, int n2) {
        if (Build.VERSION.SDK_INT < 21) {
            return;
        }
        try {
            Os.chmod((String)objectArray, (int)n2);
        }
        catch (Exception exception) {
            String string2 = "Failed to set permissions for path \"" + (String)objectArray + "\"";
            objectArray = new Object[]{};
            g.b(TAG, string2, objectArray);
        }
    }

    public static String[] setPrivateDataDirectorySuffixInternal() {
        String[] stringArray = new String[3];
        String[] stringArray2 = stringArray;
        Context context = ContextUtils.getApplicationContext();
        stringArray2[0] = context.getDir(sDataDirectorySuffix, 0).getPath();
        PathUtils.chmod(stringArray2[0], 448);
        stringArray[1] = context.getDir(THUMBNAIL_DIRECTORY_NAME, 0).getPath();
        if (context.getCacheDir() != null) {
            stringArray2[2] = sCacheSubDirectory == null ? context.getCacheDir().getPath() : new File(context.getCacheDir(), sCacheSubDirectory).getPath();
        }
        return stringArray2;
    }

    public static void setPrivateDataDirectorySuffix(String string2, String string3) {
        if (!sInitializationStarted.getAndSet(true)) {
            if (!$assertionsDisabled && ContextUtils.getApplicationContext() == null) {
                throw new AssertionError();
            }
            sDataDirectorySuffix = string2;
            sCacheSubDirectory = string3;
            sDirPathFetchTask = new FutureTask<String[]>(PathUtils::setPrivateDataDirectorySuffixInternal);
            a.THREAD_POOL_EXECUTOR.execute(sDirPathFetchTask);
        }
    }

    public static void setPrivateDataDirectorySuffix(String string2) {
        PathUtils.setPrivateDataDirectorySuffix(string2, null);
    }

    public static String getDirectoryPath(int n2) {
        return Holder.DIRECTORY_PATHS[n2];
    }

    public static String getDataDirectory() {
        if (!$assertionsDisabled && sDirPathFetchTask == null) {
            throw new AssertionError((Object)"setDataDirectorySuffix must be called first.");
        }
        return PathUtils.getDirectoryPath(0);
    }

    public static String getCacheDirectory() {
        if (!$assertionsDisabled && sDirPathFetchTask == null) {
            throw new AssertionError((Object)"setDataDirectorySuffix must be called first.");
        }
        return PathUtils.getDirectoryPath(2);
    }

    public static String getThumbnailCacheDirectory() {
        if (!$assertionsDisabled && sDirPathFetchTask == null) {
            throw new AssertionError((Object)"setDataDirectorySuffix must be called first.");
        }
        return PathUtils.getDirectoryPath(1);
    }

    public static String getDownloadsDirectory() {
        i i2 = i.g();
        try {
            long l2 = SystemClock.elapsedRealtime();
            String string2 = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DOWNLOADS).getPath();
            RecordHistogram.recordTimesHistogram("Android.StrictMode.DownloadsDir", SystemClock.elapsedRealtime() - l2);
            return string2;
        }
        finally {
            try {
                i2.close();
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                throwable2.addSuppressed(throwable);
            }
        }
    }

    public static String[] getAllPrivateDownloadsDirectories() {
        ArrayList<String> arrayList;
        File[] fileArray;
        if (Build.VERSION.SDK_INT >= 19) {
            File[] fileArray2 = i.h();
            fileArray = fileArray2;
            try {
                fileArray = ContextUtils.getApplicationContext().getExternalFilesDirs(Environment.DIRECTORY_DOWNLOADS);
                fileArray2.close();
            }
            catch (Throwable throwable) {
                try {
                    fileArray.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        File[] fileArray3 = new File[1];
        fileArray = fileArray3;
        fileArray3[0] = Environment.getExternalStorageDirectory();
        ArrayList<String> arrayList2 = arrayList;
        arrayList = new ArrayList<String>();
        for (int i2 = 0; i2 < fileArray.length; ++i2) {
            if (fileArray[i2] == null || TextUtils.isEmpty((CharSequence)fileArray[i2].getAbsolutePath())) continue;
            arrayList2.add(fileArray[i2].getAbsolutePath());
        }
        ArrayList<String> arrayList3 = arrayList2;
        return arrayList3.toArray(new String[arrayList3.size()]);
    }

    public static String getNativeLibraryDirectory() {
        ApplicationInfo applicationInfo = ContextUtils.getApplicationContext().getApplicationInfo();
        int n2 = applicationInfo.flags;
        if ((n2 & 0x80) == 0 && (n2 & 1) != 0) {
            return "/system/lib/";
        }
        return applicationInfo.nativeLibraryDir;
    }

    public static String getExternalStorageDirectory() {
        return Environment.getExternalStorageDirectory().getAbsolutePath();
    }

    public static /* synthetic */ String[] access$000() {
        return PathUtils.getOrComputeDirectoryPaths();
    }

    static {
        $assertionsDisabled = PathUtils.class.desiredAssertionStatus() ^ true;
        sInitializationStarted = new AtomicBoolean();
    }

    public static class Holder {
        public static final String[] DIRECTORY_PATHS = PathUtils.access$000();
    }
}

