/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base;

import android.annotation.SuppressLint;
import android.os.Build;
import android.os.Process;
import android.os.StrictMode;
import android.os.SystemClock;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.chromium.base.CommandLine;
import org.chromium.base.ContextUtils;
import org.chromium.base.ThreadUtils;
import org.chromium.base.TimeUtils;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.base.annotations.MainDex;

@JNINamespace(value="base::android")
@MainDex
public class EarlyTraceEvent {
    public static final String TRACE_CONFIG_FILENAME = "/data/local/chrome-trace-config.json";
    public static final int STATE_DISABLED = 0;
    public static final int STATE_ENABLED = 1;
    public static final int STATE_FINISHING = 2;
    public static final int STATE_FINISHED = 3;
    public static final String BACKGROUND_STARTUP_TRACING_ENABLED_KEY = "bg_startup_tracing";
    public static boolean sCachedBackgroundStartupTracingFlag;
    public static final Object sLock;
    public static volatile int sState = 0;
    public static List<Event> sCompletedEvents;
    public static Map<String, Event> sPendingEventByKey;
    public static List<AsyncEvent> sAsyncEvents;
    public static List<String> sPendingAsyncEvents;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void maybeEnable() {
        StrictMode.ThreadPolicy threadPolicy;
        boolean bl;
        block10: {
            ThreadUtils.assertOnUiThread();
            if (sState != 0) {
                return;
            }
            bl = false;
            threadPolicy = StrictMode.allowThreadDiskReads();
            try {
                if (CommandLine.getInstance().hasSwitch("trace-startup")) {
                    bl = true;
                } else {
                    try {
                        bl = new File(TRACE_CONFIG_FILENAME).exists();
                    }
                    catch (SecurityException securityException) {}
                }
                if (!ContextUtils.getAppSharedPreferences().getBoolean(BACKGROUND_STARTUP_TRACING_ENABLED_KEY, false)) break block10;
                if (bl) {
                    EarlyTraceEvent.setBackgroundStartupTracingFlag(false);
                    sCachedBackgroundStartupTracingFlag = false;
                    break block10;
                }
                sCachedBackgroundStartupTracingFlag = true;
                bl = true;
            }
            catch (Throwable throwable) {
                StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)threadPolicy);
                throw throwable;
            }
        }
        StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)threadPolicy);
        if (bl) {
            EarlyTraceEvent.enable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void enable() {
        Object object = sLock;
        synchronized (object) {
            if (sState != 0) {
                return;
            }
            sCompletedEvents = new ArrayList<Event>();
            sPendingEventByKey = new HashMap<String, Event>();
            sAsyncEvents = new ArrayList<AsyncEvent>();
            sPendingAsyncEvents = new ArrayList<String>();
            sState = 1;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void disable() {
        Object object = sLock;
        synchronized (object) {
            if (!EarlyTraceEvent.enabled()) {
                return;
            }
            sState = 2;
            EarlyTraceEvent.maybeFinishLocked();
            return;
        }
    }

    public static boolean isActive() {
        int n2 = sState;
        return n2 == 1 || n2 == 2;
    }

    public static boolean enabled() {
        return sState == 1;
    }

    public static void setBackgroundStartupTracingFlag(boolean bl) {
        ContextUtils.getAppSharedPreferences().edit().putBoolean(BACKGROUND_STARTUP_TRACING_ENABLED_KEY, bl).apply();
    }

    public static boolean getBackgroundStartupTracingFlag() {
        return sCachedBackgroundStartupTracingFlag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void begin(String string2) {
        Event event;
        if (!EarlyTraceEvent.enabled()) {
            return;
        }
        Event event2 = event;
        event = new Event(string2);
        Object object = sLock;
        synchronized (object) {
            if (!EarlyTraceEvent.enabled()) {
                return;
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl11 : MonitorExitStatement: MONITOREXIT : var2_2
            if (sPendingEventByKey.put(EarlyTraceEvent.makeEventKeyForCurrentThread(string2), event2) != null) throw new IllegalArgumentException("Multiple pending trace events can't have the same name: " + string2);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void end(String object) {
        if (!EarlyTraceEvent.isActive()) {
            return;
        }
        Object object2 = sLock;
        synchronized (object2) {
            if (!EarlyTraceEvent.isActive()) {
                return;
            }
            if ((object = sPendingEventByKey.remove(EarlyTraceEvent.makeEventKeyForCurrentThread((String)object))) == null) {
                return;
            }
            ((Event)object).end();
            sCompletedEvents.add((Event)object);
            if (sState == 2) {
                EarlyTraceEvent.maybeFinishLocked();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void startAsync(String string2, long l2) {
        AsyncEvent asyncEvent;
        if (!EarlyTraceEvent.enabled()) {
            return;
        }
        AsyncEvent asyncEvent2 = asyncEvent;
        asyncEvent = new AsyncEvent(string2, l2, true);
        Object object = sLock;
        synchronized (object) {
            if (!EarlyTraceEvent.enabled()) {
                return;
            }
            Object object2 = object;
            sAsyncEvents.add(asyncEvent2);
            {
                sPendingAsyncEvents.add(string2);
            }
            {
                // ** MonitorExit[v1] (shouldn't be in output)
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void finishAsync(String string2, long l2) {
        AsyncEvent asyncEvent;
        if (!EarlyTraceEvent.isActive()) {
            return;
        }
        AsyncEvent asyncEvent2 = asyncEvent;
        asyncEvent = new AsyncEvent(string2, l2, false);
        Object object = sLock;
        synchronized (object) {
            if (!EarlyTraceEvent.isActive()) {
                return;
            }
            if (!sPendingAsyncEvents.remove(string2)) {
                return;
            }
            sAsyncEvents.add(asyncEvent2);
            {
                if (sState == 2) {
                    EarlyTraceEvent.maybeFinishLocked();
                }
                return;
            }
        }
    }

    public static void resetForTesting() {
        sState = 0;
        sCompletedEvents = null;
        sPendingEventByKey = null;
        sAsyncEvents = null;
        sPendingAsyncEvents = null;
    }

    public static void maybeFinishLocked() {
        if (!sCompletedEvents.isEmpty()) {
            EarlyTraceEvent.dumpEvents(sCompletedEvents);
            sCompletedEvents.clear();
        }
        if (!sAsyncEvents.isEmpty()) {
            EarlyTraceEvent.dumpAsyncEvents(sAsyncEvents);
            sAsyncEvents.clear();
        }
        if (sPendingEventByKey.isEmpty() && sPendingAsyncEvents.isEmpty()) {
            sState = 3;
            sPendingEventByKey = null;
            sCompletedEvents = null;
            sPendingAsyncEvents = null;
            sAsyncEvents = null;
        }
    }

    public static void dumpEvents(List<Event> object) {
        long l2 = EarlyTraceEvent.getOffsetNanos();
        object = object.iterator();
        while (object.hasNext()) {
            Event event = (Event)object.next();
            EarlyTraceEvent.nativeRecordEarlyEvent(event.mName, event.mBeginTimeNanos + l2, event.mEndTimeNanos + l2, event.mThreadId, event.mEndThreadTimeMillis - event.mBeginThreadTimeMillis);
        }
    }

    public static void dumpAsyncEvents(List<AsyncEvent> object) {
        long l2 = EarlyTraceEvent.getOffsetNanos();
        object = object.iterator();
        while (object.hasNext()) {
            AsyncEvent asyncEvent = (AsyncEvent)object.next();
            if (asyncEvent.mIsStart) {
                EarlyTraceEvent.nativeRecordEarlyStartAsyncEvent(asyncEvent.mName, asyncEvent.mId, asyncEvent.mTimestampNanos + l2);
                continue;
            }
            EarlyTraceEvent.nativeRecordEarlyFinishAsyncEvent(asyncEvent.mName, asyncEvent.mId, asyncEvent.mTimestampNanos + l2);
        }
    }

    public static long getOffsetNanos() {
        return TimeUtils.nativeGetTimeTicksNowUs() * 1000L - Event.elapsedRealtimeNanos();
    }

    public static String makeEventKeyForCurrentThread(String string2) {
        return string2 + "@" + Process.myTid();
    }

    public static native void nativeRecordEarlyEvent(String var0, long var1, long var3, int var5, long var6);

    public static native void nativeRecordEarlyStartAsyncEvent(String var0, long var1, long var3);

    public static native void nativeRecordEarlyFinishAsyncEvent(String var0, long var1, long var3);

    static {
        sLock = new Object();
    }

    public static final class AsyncEvent {
        public final boolean mIsStart;
        public final String mName;
        public final long mId;
        public final long mTimestampNanos;

        public AsyncEvent(String string2, long l2, boolean bl) {
            AsyncEvent asyncEvent = this;
            this.mName = string2;
            this.mId = l2;
            asyncEvent.mIsStart = bl;
            asyncEvent.mTimestampNanos = Event.elapsedRealtimeNanos();
        }
    }

    public static final class Event {
        public static final /* synthetic */ boolean $assertionsDisabled;
        public final String mName;
        public final int mThreadId;
        public final long mBeginTimeNanos;
        public final long mBeginThreadTimeMillis;
        public long mEndTimeNanos;
        public long mEndThreadTimeMillis;

        public Event(String string2) {
            Event event = this;
            event.mName = string2;
            event.mThreadId = Process.myTid();
            event.mBeginTimeNanos = Event.elapsedRealtimeNanos();
            event.mBeginThreadTimeMillis = SystemClock.currentThreadTimeMillis();
        }

        @SuppressLint(value={"NewApi"})
        public static long elapsedRealtimeNanos() {
            if (Build.VERSION.SDK_INT >= 17) {
                return SystemClock.elapsedRealtimeNanos();
            }
            return SystemClock.elapsedRealtime() * 1000000L;
        }

        static {
            $assertionsDisabled = EarlyTraceEvent.class.desiredAssertionStatus() ^ true;
        }

        public void end() {
            if (!$assertionsDisabled && this.mEndTimeNanos != 0L) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && this.mEndThreadTimeMillis != 0L) {
                throw new AssertionError();
            }
            Event event = this;
            event.mEndTimeNanos = Event.elapsedRealtimeNanos();
            event.mEndThreadTimeMillis = SystemClock.currentThreadTimeMillis();
        }
    }
}

