/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base;

import android.content.ContentResolver;
import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.ParcelFileDescriptor;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.chromium.base.ContextUtils;

public abstract class ContentUriUtils {
    public static final String TAG = "ContentUriUtils";
    public static FileProviderUtil sFileProviderUtil;
    public static final Object sLock;
    public static final /* synthetic */ boolean $assertionsDisabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setFileProviderUtil(FileProviderUtil fileProviderUtil) {
        Object object = sLock;
        synchronized (object) {
            sFileProviderUtil = fileProviderUtil;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Uri getContentUriFromFile(File file) {
        Object object = sLock;
        synchronized (object) {
            if (sFileProviderUtil != null) {
                return sFileProviderUtil.getContentUriFromFile(file);
            }
            return null;
        }
    }

    public static int openContentUriForRead(String string2) {
        if ((string2 = ContentUriUtils.getAssetFileDescriptor(string2)) != null) {
            return string2.getParcelFileDescriptor().detachFd();
        }
        return -1;
    }

    public static boolean contentUriExists(String string2) {
        boolean bl;
        block4: {
            string2 = ContentUriUtils.getAssetFileDescriptor(string2);
            bl = string2 != null;
            if (string2 == null) break block4;
            try {
                string2.close();
            }
            catch (IOException iOException) {}
        }
        return bl;
    }

    public static String getMimeType(String stringArray) {
        String[] stringArray2 = stringArray;
        stringArray = ContextUtils.getApplicationContext().getContentResolver();
        Uri uri = Uri.parse((String)stringArray2);
        if (ContentUriUtils.isVirtualDocument(uri)) {
            return (stringArray = stringArray.getStreamTypes(uri, "*/*")) != null && stringArray.length > 0 ? stringArray[0] : null;
        }
        return stringArray.getType(uri);
    }

    public static AssetFileDescriptor getAssetFileDescriptor(String string2) {
        block14: {
            Uri uri;
            ContentResolver contentResolver;
            block13: {
                block15: {
                    contentResolver = ContextUtils.getApplicationContext().getContentResolver();
                    uri = Uri.parse((String)string2);
                    if (!ContentUriUtils.isVirtualDocument(uri)) break block13;
                    String[] stringArray = contentResolver.getStreamTypes(uri, "*/*");
                    if (stringArray == null) break block14;
                    if (stringArray.length <= 0) break block14;
                    contentResolver = contentResolver.openTypedAssetFileDescriptor(uri, stringArray[0], null);
                    if (contentResolver == null) break block15;
                    if (contentResolver.getStartOffset() == 0L) break block15;
                    try {
                        contentResolver.close();
                    }
                    catch (IOException iOException) {}
                    throw new SecurityException("Cannot open files with non-zero offset type.");
                }
                return contentResolver;
            }
            contentResolver = contentResolver.openFileDescriptor(uri, "r");
            if (contentResolver == null) break block14;
            try {
                return new AssetFileDescriptor((ParcelFileDescriptor)contentResolver, 0L, -1L);
            }
            catch (Exception exception) {
                Log.w((String)TAG, (String)("Unknown content uri: " + string2), (Throwable)exception);
            }
            catch (SecurityException securityException) {
                Log.w((String)TAG, (String)("Cannot open content uri: " + string2), (Throwable)securityException);
            }
            catch (FileNotFoundException fileNotFoundException) {
                Log.w((String)TAG, (String)("Cannot find content uri: " + string2), (Throwable)fileNotFoundException);
            }
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    public static String getDisplayName(Uri var0, Context var1_2, String var2_3) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Nullable
    public static String maybeGetDisplayName(String string2) {
        String string3;
        try {
            string3 = ContentUriUtils.getDisplayName(Uri.parse((String)string2), ContextUtils.getApplicationContext(), "_display_name");
        }
        catch (Exception exception) {
            Log.w((String)TAG, (String)("Cannot open content uri: " + string2), (Throwable)exception);
            return null;
        }
        if (TextUtils.isEmpty((CharSequence)string3)) {
            string3 = null;
        }
        return string3;
    }

    /*
     * Exception decompiling
     */
    public static boolean isVirtualDocument(Uri var0) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static boolean hasVirtualFlag(Cursor cursor) {
        if (Build.VERSION.SDK_INT < 24) {
            return false;
        }
        int n2 = cursor.getColumnIndex("flags");
        return n2 > -1 && (cursor.getLong(n2) & 0x200L) != 0L;
    }

    public static boolean isContentUri(String string2) {
        if (string2 == null) {
            return false;
        }
        return (string2 = Uri.parse((String)string2)) != null && "content".equals(string2.getScheme());
    }

    public static void delete(String string2) {
        if (!$assertionsDisabled && !ContentUriUtils.isContentUri(string2)) {
            throw new AssertionError();
        }
        ContextUtils.getApplicationContext().getContentResolver().delete(Uri.parse((String)string2), null, null);
    }

    static {
        $assertionsDisabled = ContentUriUtils.class.desiredAssertionStatus() ^ true;
        sLock = new Object();
    }

    public static interface FileProviderUtil {
        public Uri getContentUriFromFile(File var1);
    }
}

