
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     services/viz/public/interfaces/compositing/shared_quad_state.mojom
//

package com.vccorp.viz.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


public final class SharedQuadState extends org.chromium.mojo.bindings.Struct {

    private static final int STRUCT_SIZE = 64;
    private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(64, 0)};
    private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    public com.vccorp.gfx.mojom.Transform quadToTargetTransform;
    public com.vccorp.gfx.mojom.Rect quadLayerRect;
    public com.vccorp.gfx.mojom.Rect visibleQuadLayerRect;
    public com.vccorp.gfx.mojom.RRectF roundedCornerBounds;
    public com.vccorp.gfx.mojom.Rect clipRect;
    public boolean isClipped;
    public boolean areContentsOpaque;
    public float opacity;
    public int blendMode;
    public int sortingContextId;

    private SharedQuadState(int version) {
        super(STRUCT_SIZE, version);
    }

    public SharedQuadState() {
        this(0);
    }

    public static SharedQuadState deserialize(com.vccorp.mojo.bindings.Message message) {
        return decode(new com.vccorp.mojo.bindings.Decoder(message));
    }

    /**
     * Similar to the method above, but deserializes from a |ByteBuffer| instance.
     *
     * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
     */
    public static SharedQuadState deserialize(java.nio.ByteBuffer data) {
        return deserialize(new com.vccorp.mojo.bindings.Message(
                data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
    }

    @SuppressWarnings("unchecked")
    public static SharedQuadState decode(com.vccorp.mojo.bindings.Decoder decoder0) {
        if (decoder0 == null) {
            return null;
        }
        decoder0.increaseStackDepth();
        SharedQuadState result;
        try {
            com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            final int elementsOrVersion = mainDataHeader.elementsOrVersion;
            result = new SharedQuadState(elementsOrVersion);
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                result.quadToTargetTransform = com.vccorp.gfx.mojom.Transform.decode(decoder1);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, false);
                result.quadLayerRect = com.vccorp.gfx.mojom.Rect.decode(decoder1);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(24, false);
                result.visibleQuadLayerRect = com.vccorp.gfx.mojom.Rect.decode(decoder1);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(32, false);
                result.roundedCornerBounds = com.vccorp.gfx.mojom.RRectF.decode(decoder1);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(40, false);
                result.clipRect = com.vccorp.gfx.mojom.Rect.decode(decoder1);
                }
                {
                    
                result.isClipped = decoder0.readBoolean(48, 0);
                }
                {
                    
                result.areContentsOpaque = decoder0.readBoolean(48, 1);
                }
                {
                    
                result.opacity = decoder0.readFloat(52);
                }
                {
                    
                result.blendMode = decoder0.readInt(56);
                }
                {
                    
                result.sortingContextId = decoder0.readInt(60);
                }

        } finally {
            decoder0.decreaseStackDepth();
        }
        return result;
    }

    @SuppressWarnings("unchecked")
    @Override
    protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
        org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        
        encoder0.encode(this.quadToTargetTransform, 8, false);
        
        encoder0.encode(this.quadLayerRect, 16, false);
        
        encoder0.encode(this.visibleQuadLayerRect, 24, false);
        
        encoder0.encode(this.roundedCornerBounds, 32, false);
        
        encoder0.encode(this.clipRect, 40, false);
        
        encoder0.encode(this.isClipped, 48, 0);
        
        encoder0.encode(this.areContentsOpaque, 48, 1);
        
        encoder0.encode(this.opacity, 52);
        
        encoder0.encode(this.blendMode, 56);
        
        encoder0.encode(this.sortingContextId, 60);
    }
}