
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     services/viz/public/interfaces/compositing/render_pass.mojom
//

package com.vccorp.viz.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


public final class RenderPass extends org.chromium.mojo.bindings.Struct {

    private static final int STRUCT_SIZE = 96;
    private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(96, 0)};
    private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    public long id;
    public com.vccorp.gfx.mojom.Rect outputRect;
    public com.vccorp.gfx.mojom.Rect damageRect;
    public com.vccorp.gfx.mojom.Transform transformToRootTarget;
    public FilterOperations filters;
    public FilterOperations backdropFilters;
    public com.vccorp.gfx.mojom.RRectF backdropFilterBounds;
    public com.vccorp.gfx.mojom.ColorSpace colorSpace;
    public boolean hasTransparentBackground;
    public boolean cacheRenderPass;
    public boolean hasDamageFromContributingContent;
    public boolean generateMipmap;
    public CopyOutputRequest[] copyRequests;
    public DrawQuad[] quadList;

    private RenderPass(int version) {
        super(STRUCT_SIZE, version);
        this.cacheRenderPass = (boolean) false;
        this.hasDamageFromContributingContent = (boolean) false;
        this.generateMipmap = (boolean) false;
    }

    public RenderPass() {
        this(0);
    }

    public static RenderPass deserialize(com.vccorp.mojo.bindings.Message message) {
        return decode(new com.vccorp.mojo.bindings.Decoder(message));
    }

    /**
     * Similar to the method above, but deserializes from a |ByteBuffer| instance.
     *
     * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
     */
    public static RenderPass deserialize(java.nio.ByteBuffer data) {
        return deserialize(new com.vccorp.mojo.bindings.Message(
                data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
    }

    @SuppressWarnings("unchecked")
    public static RenderPass decode(com.vccorp.mojo.bindings.Decoder decoder0) {
        if (decoder0 == null) {
            return null;
        }
        decoder0.increaseStackDepth();
        RenderPass result;
        try {
            com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            final int elementsOrVersion = mainDataHeader.elementsOrVersion;
            result = new RenderPass(elementsOrVersion);
                {
                    
                result.id = decoder0.readLong(8);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, false);
                result.outputRect = com.vccorp.gfx.mojom.Rect.decode(decoder1);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(24, false);
                result.damageRect = com.vccorp.gfx.mojom.Rect.decode(decoder1);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(32, false);
                result.transformToRootTarget = com.vccorp.gfx.mojom.Transform.decode(decoder1);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(40, false);
                result.filters = FilterOperations.decode(decoder1);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(48, false);
                result.backdropFilters = FilterOperations.decode(decoder1);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(56, false);
                result.backdropFilterBounds = com.vccorp.gfx.mojom.RRectF.decode(decoder1);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(64, false);
                result.colorSpace = com.vccorp.gfx.mojom.ColorSpace.decode(decoder1);
                }
                {
                    
                result.hasTransparentBackground = decoder0.readBoolean(72, 0);
                }
                {
                    
                result.cacheRenderPass = decoder0.readBoolean(72, 1);
                }
                {
                    
                result.hasDamageFromContributingContent = decoder0.readBoolean(72, 2);
                }
                {
                    
                result.generateMipmap = decoder0.readBoolean(72, 3);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(80, false);
                {
                    com.vccorp.mojo.bindings.DataHeader si1 = decoder1.readDataHeaderForPointerArray(com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                    result.copyRequests = new CopyOutputRequest[si1.elementsOrVersion];
                    for (int i1 = 0; i1 < si1.elementsOrVersion; ++i1) {
                        
                        com.vccorp.mojo.bindings.Decoder decoder2 = decoder1.readPointer(com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i1, false);
                        result.copyRequests[i1] = CopyOutputRequest.decode(decoder2);
                    }
                }
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(88, false);
                {
                    com.vccorp.mojo.bindings.DataHeader si1 = decoder1.readDataHeaderForPointerArray(com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                    result.quadList = new DrawQuad[si1.elementsOrVersion];
                    for (int i1 = 0; i1 < si1.elementsOrVersion; ++i1) {
                        
                        com.vccorp.mojo.bindings.Decoder decoder2 = decoder1.readPointer(com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i1, false);
                        result.quadList[i1] = DrawQuad.decode(decoder2);
                    }
                }
                }

        } finally {
            decoder0.decreaseStackDepth();
        }
        return result;
    }

    @SuppressWarnings("unchecked")
    @Override
    protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
        org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        
        encoder0.encode(this.id, 8);
        
        encoder0.encode(this.outputRect, 16, false);
        
        encoder0.encode(this.damageRect, 24, false);
        
        encoder0.encode(this.transformToRootTarget, 32, false);
        
        encoder0.encode(this.filters, 40, false);
        
        encoder0.encode(this.backdropFilters, 48, false);
        
        encoder0.encode(this.backdropFilterBounds, 56, false);
        
        encoder0.encode(this.colorSpace, 64, false);
        
        encoder0.encode(this.hasTransparentBackground, 72, 0);
        
        encoder0.encode(this.cacheRenderPass, 72, 1);
        
        encoder0.encode(this.hasDamageFromContributingContent, 72, 2);
        
        encoder0.encode(this.generateMipmap, 72, 3);
        
        if (this.copyRequests == null) {
            encoder0.encodeNullPointer(80, false);
        } else {
            org.chromium.mojo.bindings.Encoder encoder1 = encoder0.encodePointerArray(this.copyRequests.length, 80, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
            for (int i0 = 0; i0 < this.copyRequests.length; ++i0) {
                
                encoder1.encode(this.copyRequests[i0], com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i0, false);
            }
        }
        
        if (this.quadList == null) {
            encoder0.encodeNullPointer(88, false);
        } else {
            org.chromium.mojo.bindings.Encoder encoder1 = encoder0.encodePointerArray(this.quadList.length, 88, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
            for (int i0 = 0; i0 < this.quadList.length; ++i0) {
                
                encoder1.encode(this.quadList[i0], com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i0, false);
            }
        }
    }
}