
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     services/viz/public/interfaces/hit_test/hit_test_region_list.mojom
//

package com.vccorp.viz.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


public final class HitTestRegion extends org.chromium.mojo.bindings.Struct {

    private static final int STRUCT_SIZE = 40;
    private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(40, 0)};
    private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    public int flags;
    public int asyncHitTestReasons;
    public FrameSinkId frameSinkId;
    public com.vccorp.gfx.mojom.Rect rect;
    public com.vccorp.gfx.mojom.Transform transform;

    private HitTestRegion(int version) {
        super(STRUCT_SIZE, version);
    }

    public HitTestRegion() {
        this(0);
    }

    public static HitTestRegion deserialize(com.vccorp.mojo.bindings.Message message) {
        return decode(new com.vccorp.mojo.bindings.Decoder(message));
    }

    /**
     * Similar to the method above, but deserializes from a |ByteBuffer| instance.
     *
     * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
     */
    public static HitTestRegion deserialize(java.nio.ByteBuffer data) {
        return deserialize(new com.vccorp.mojo.bindings.Message(
                data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
    }

    @SuppressWarnings("unchecked")
    public static HitTestRegion decode(com.vccorp.mojo.bindings.Decoder decoder0) {
        if (decoder0 == null) {
            return null;
        }
        decoder0.increaseStackDepth();
        HitTestRegion result;
        try {
            com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            final int elementsOrVersion = mainDataHeader.elementsOrVersion;
            result = new HitTestRegion(elementsOrVersion);
                {
                    
                result.flags = decoder0.readInt(8);
                }
                {
                    
                result.asyncHitTestReasons = decoder0.readInt(12);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, false);
                result.frameSinkId = FrameSinkId.decode(decoder1);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(24, false);
                result.rect = com.vccorp.gfx.mojom.Rect.decode(decoder1);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(32, false);
                result.transform = com.vccorp.gfx.mojom.Transform.decode(decoder1);
                }

        } finally {
            decoder0.decreaseStackDepth();
        }
        return result;
    }

    @SuppressWarnings("unchecked")
    @Override
    protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
        org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        
        encoder0.encode(this.flags, 8);
        
        encoder0.encode(this.asyncHitTestReasons, 12);
        
        encoder0.encode(this.frameSinkId, 16, false);
        
        encoder0.encode(this.rect, 24, false);
        
        encoder0.encode(this.transform, 32, false);
    }
}