
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     services/viz/public/interfaces/compositing/compositor_frame_sink.mojom
//

package com.vccorp.viz.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


class CompositorFrameSinkClient_Internal {

    public static final com.vccorp.mojo.bindings.Interface.Manager<CompositorFrameSinkClient, CompositorFrameSinkClient.Proxy> MANAGER =
            new com.vccorp.mojo.bindings.Interface.Manager<CompositorFrameSinkClient, CompositorFrameSinkClient.Proxy>() {

        @Override
        public String getName() {
            return "viz.mojom.CompositorFrameSinkClient";
        }

        @Override
        public int getVersion() {
          return 0;
        }

        @Override
        public Proxy buildProxy(com.vccorp.mojo.system.Core core,
                                com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }

        @Override
        public Stub buildStub(com.vccorp.mojo.system.Core core, CompositorFrameSinkClient impl) {
            return new Stub(core, impl);
        }

        @Override
        public CompositorFrameSinkClient[] buildArray(int size) {
          return new CompositorFrameSinkClient[size];
        }
    };


    private static final int DID_RECEIVE_COMPOSITOR_FRAME_ACK_ORDINAL = 0;

    private static final int ON_BEGIN_FRAME_ORDINAL = 1;

    private static final int ON_BEGIN_FRAME_PAUSED_CHANGED_ORDINAL = 2;

    private static final int RECLAIM_RESOURCES_ORDINAL = 3;


    static final class Proxy extends com.vccorp.mojo.bindings.Interface.AbstractProxy implements CompositorFrameSinkClient.Proxy {

        Proxy(com.vccorp.mojo.system.Core core,
              com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }


        @Override
        public void didReceiveCompositorFrameAck(
ReturnedResource[] resources) {

            CompositorFrameSinkClientDidReceiveCompositorFrameAckParams _message = new CompositorFrameSinkClientDidReceiveCompositorFrameAckParams();

            _message.resources = resources;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(DID_RECEIVE_COMPOSITOR_FRAME_ACK_ORDINAL)));

        }


        @Override
        public void onBeginFrame(
BeginFrameArgs args, java.util.Map<Integer, com.vccorp.gfx.mojom.PresentationFeedback> presentations) {

            CompositorFrameSinkClientOnBeginFrameParams _message = new CompositorFrameSinkClientOnBeginFrameParams();

            _message.args = args;

            _message.presentations = presentations;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(ON_BEGIN_FRAME_ORDINAL)));

        }


        @Override
        public void onBeginFramePausedChanged(
boolean paused) {

            CompositorFrameSinkClientOnBeginFramePausedChangedParams _message = new CompositorFrameSinkClientOnBeginFramePausedChangedParams();

            _message.paused = paused;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(ON_BEGIN_FRAME_PAUSED_CHANGED_ORDINAL)));

        }


        @Override
        public void reclaimResources(
ReturnedResource[] resources) {

            CompositorFrameSinkClientReclaimResourcesParams _message = new CompositorFrameSinkClientReclaimResourcesParams();

            _message.resources = resources;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(RECLAIM_RESOURCES_ORDINAL)));

        }


    }

    static final class Stub extends com.vccorp.mojo.bindings.Interface.Stub<CompositorFrameSinkClient> {

        Stub(com.vccorp.mojo.system.Core core, CompositorFrameSinkClient impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                CompositorFrameSinkClient_Internal.MANAGER, messageWithHeader);





                    case DID_RECEIVE_COMPOSITOR_FRAME_ACK_ORDINAL: {

                        CompositorFrameSinkClientDidReceiveCompositorFrameAckParams data =
                                CompositorFrameSinkClientDidReceiveCompositorFrameAckParams.deserialize(messageWithHeader.getPayload());

                        getImpl().didReceiveCompositorFrameAck(data.resources);
                        return true;
                    }





                    case ON_BEGIN_FRAME_ORDINAL: {

                        CompositorFrameSinkClientOnBeginFrameParams data =
                                CompositorFrameSinkClientOnBeginFrameParams.deserialize(messageWithHeader.getPayload());

                        getImpl().onBeginFrame(data.args, data.presentations);
                        return true;
                    }





                    case ON_BEGIN_FRAME_PAUSED_CHANGED_ORDINAL: {

                        CompositorFrameSinkClientOnBeginFramePausedChangedParams data =
                                CompositorFrameSinkClientOnBeginFramePausedChangedParams.deserialize(messageWithHeader.getPayload());

                        getImpl().onBeginFramePausedChanged(data.paused);
                        return true;
                    }





                    case RECLAIM_RESOURCES_ORDINAL: {

                        CompositorFrameSinkClientReclaimResourcesParams data =
                                CompositorFrameSinkClientReclaimResourcesParams.deserialize(messageWithHeader.getPayload());

                        getImpl().reclaimResources(data.resources);
                        return true;
                    }


                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(com.vccorp.mojo.bindings.Message message, com.vccorp.mojo.bindings.MessageReceiver receiver) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), CompositorFrameSinkClient_Internal.MANAGER, messageWithHeader, receiver);










                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }


    
    static final class CompositorFrameSinkClientDidReceiveCompositorFrameAckParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public ReturnedResource[] resources;

        private CompositorFrameSinkClientDidReceiveCompositorFrameAckParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public CompositorFrameSinkClientDidReceiveCompositorFrameAckParams() {
            this(0);
        }

        public static CompositorFrameSinkClientDidReceiveCompositorFrameAckParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static CompositorFrameSinkClientDidReceiveCompositorFrameAckParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static CompositorFrameSinkClientDidReceiveCompositorFrameAckParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            CompositorFrameSinkClientDidReceiveCompositorFrameAckParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new CompositorFrameSinkClientDidReceiveCompositorFrameAckParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    {
                        com.vccorp.mojo.bindings.DataHeader si1 = decoder1.readDataHeaderForPointerArray(com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                        result.resources = new ReturnedResource[si1.elementsOrVersion];
                        for (int i1 = 0; i1 < si1.elementsOrVersion; ++i1) {
                            
                            com.vccorp.mojo.bindings.Decoder decoder2 = decoder1.readPointer(com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i1, false);
                            result.resources[i1] = ReturnedResource.decode(decoder2);
                        }
                    }
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            if (this.resources == null) {
                encoder0.encodeNullPointer(8, false);
            } else {
                org.chromium.mojo.bindings.Encoder encoder1 = encoder0.encodePointerArray(this.resources.length, 8, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                for (int i0 = 0; i0 < this.resources.length; ++i0) {
                    
                    encoder1.encode(this.resources[i0], com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i0, false);
                }
            }
        }
    }



    
    static final class CompositorFrameSinkClientOnBeginFrameParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public BeginFrameArgs args;
        public java.util.Map<Integer, com.vccorp.gfx.mojom.PresentationFeedback> presentations;

        private CompositorFrameSinkClientOnBeginFrameParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public CompositorFrameSinkClientOnBeginFrameParams() {
            this(0);
        }

        public static CompositorFrameSinkClientOnBeginFrameParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static CompositorFrameSinkClientOnBeginFrameParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static CompositorFrameSinkClientOnBeginFrameParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            CompositorFrameSinkClientOnBeginFrameParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new CompositorFrameSinkClientOnBeginFrameParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.args = BeginFrameArgs.decode(decoder1);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, false);
                    {
                        decoder1.readDataHeaderForMap();
                        int[] keys0;
                        com.vccorp.gfx.mojom.PresentationFeedback[] values0;
                        {
                            
                            keys0 = decoder1.readInts(com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE, com.vccorp.mojo.bindings.BindingsHelper.NOTHING_NULLABLE, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                        }
                        {
                            
                            com.vccorp.mojo.bindings.Decoder decoder2 = decoder1.readPointer(com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE, false);
                            {
                                com.vccorp.mojo.bindings.DataHeader si2 = decoder2.readDataHeaderForPointerArray(keys0.length);
                                values0 = new com.vccorp.gfx.mojom.PresentationFeedback[si2.elementsOrVersion];
                                for (int i2 = 0; i2 < si2.elementsOrVersion; ++i2) {
                                    
                                    com.vccorp.mojo.bindings.Decoder decoder3 = decoder2.readPointer(com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i2, false);
                                    values0[i2] = com.vccorp.gfx.mojom.PresentationFeedback.decode(decoder3);
                                }
                            }
                        }
                        result.presentations = new java.util.HashMap<Integer, com.vccorp.gfx.mojom.PresentationFeedback>();
                        for (int index0 = 0; index0 < keys0.length; ++index0) {
                            result.presentations.put(keys0[index0],  values0[index0]);
                        }
                    }
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.args, 8, false);
            
            if (this.presentations == null) {
                encoder0.encodeNullPointer(16, false);
            } else {
                org.chromium.mojo.bindings.Encoder encoder1 = encoder0.encoderForMap(16);
                int size0 = this.presentations.size();
                int[] keys0 = new int[size0];
                com.vccorp.gfx.mojom.PresentationFeedback[] values0 = new com.vccorp.gfx.mojom.PresentationFeedback[size0];
                int index0 = 0;
                for (java.util.Map.Entry<Integer, com.vccorp.gfx.mojom.PresentationFeedback> entry0 : this.presentations.entrySet()) {
                    keys0[index0] = entry0.getKey();
                    values0[index0] = entry0.getValue();
                    ++index0;
                }
                
                encoder1.encode(keys0, com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE, com.vccorp.mojo.bindings.BindingsHelper.NOTHING_NULLABLE, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                
                {
                    org.chromium.mojo.bindings.Encoder encoder2 = encoder1.encodePointerArray(values0.length, com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                    for (int i1 = 0; i1 < values0.length; ++i1) {
                        
                        encoder2.encode(values0[i1], com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i1, false);
                    }
                }
            }
        }
    }



    
    static final class CompositorFrameSinkClientOnBeginFramePausedChangedParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public boolean paused;

        private CompositorFrameSinkClientOnBeginFramePausedChangedParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public CompositorFrameSinkClientOnBeginFramePausedChangedParams() {
            this(0);
        }

        public static CompositorFrameSinkClientOnBeginFramePausedChangedParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static CompositorFrameSinkClientOnBeginFramePausedChangedParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static CompositorFrameSinkClientOnBeginFramePausedChangedParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            CompositorFrameSinkClientOnBeginFramePausedChangedParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new CompositorFrameSinkClientOnBeginFramePausedChangedParams(elementsOrVersion);
                    {
                        
                    result.paused = decoder0.readBoolean(8, 0);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.paused, 8, 0);
        }
    }



    
    static final class CompositorFrameSinkClientReclaimResourcesParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public ReturnedResource[] resources;

        private CompositorFrameSinkClientReclaimResourcesParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public CompositorFrameSinkClientReclaimResourcesParams() {
            this(0);
        }

        public static CompositorFrameSinkClientReclaimResourcesParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static CompositorFrameSinkClientReclaimResourcesParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static CompositorFrameSinkClientReclaimResourcesParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            CompositorFrameSinkClientReclaimResourcesParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new CompositorFrameSinkClientReclaimResourcesParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    {
                        com.vccorp.mojo.bindings.DataHeader si1 = decoder1.readDataHeaderForPointerArray(com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                        result.resources = new ReturnedResource[si1.elementsOrVersion];
                        for (int i1 = 0; i1 < si1.elementsOrVersion; ++i1) {
                            
                            com.vccorp.mojo.bindings.Decoder decoder2 = decoder1.readPointer(com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i1, false);
                            result.resources[i1] = ReturnedResource.decode(decoder2);
                        }
                    }
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            if (this.resources == null) {
                encoder0.encodeNullPointer(8, false);
            } else {
                org.chromium.mojo.bindings.Encoder encoder1 = encoder0.encodePointerArray(this.resources.length, 8, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                for (int i0 = 0; i0 < this.resources.length; ++i0) {
                    
                    encoder1.encode(this.resources[i0], com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i0, false);
                }
            }
        }
    }



}
