
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     services/shape_detection/public/mojom/facedetection.mojom
//

package com.vccorp.shape_detection.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


class FaceDetection_Internal {

    public static final com.vccorp.mojo.bindings.Interface.Manager<FaceDetection, FaceDetection.Proxy> MANAGER =
            new com.vccorp.mojo.bindings.Interface.Manager<FaceDetection, FaceDetection.Proxy>() {

        @Override
        public String getName() {
            return "shape_detection.mojom.FaceDetection";
        }

        @Override
        public int getVersion() {
          return 0;
        }

        @Override
        public Proxy buildProxy(com.vccorp.mojo.system.Core core,
                                com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }

        @Override
        public Stub buildStub(com.vccorp.mojo.system.Core core, FaceDetection impl) {
            return new Stub(core, impl);
        }

        @Override
        public FaceDetection[] buildArray(int size) {
          return new FaceDetection[size];
        }
    };


    private static final int DETECT_ORDINAL = 0;


    static final class Proxy extends com.vccorp.mojo.bindings.Interface.AbstractProxy implements FaceDetection.Proxy {

        Proxy(com.vccorp.mojo.system.Core core,
              com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }


        @Override
        public void detect(
com.vccorp.skia.mojom.Bitmap bitmapData,
DetectResponse callback) {

            FaceDetectionDetectParams _message = new FaceDetectionDetectParams();

            _message.bitmapData = bitmapData;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    DETECT_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new FaceDetectionDetectResponseParamsForwardToCallback(callback));

        }


    }

    static final class Stub extends com.vccorp.mojo.bindings.Interface.Stub<FaceDetection> {

        Stub(com.vccorp.mojo.system.Core core, FaceDetection impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                FaceDetection_Internal.MANAGER, messageWithHeader);




                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(com.vccorp.mojo.bindings.Message message, com.vccorp.mojo.bindings.MessageReceiver receiver) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), FaceDetection_Internal.MANAGER, messageWithHeader, receiver);







                    case DETECT_ORDINAL: {

                        FaceDetectionDetectParams data =
                                FaceDetectionDetectParams.deserialize(messageWithHeader.getPayload());

                        getImpl().detect(data.bitmapData, new FaceDetectionDetectResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }


                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }


    
    static final class FaceDetectionDetectParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public com.vccorp.skia.mojom.Bitmap bitmapData;

        private FaceDetectionDetectParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public FaceDetectionDetectParams() {
            this(0);
        }

        public static FaceDetectionDetectParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static FaceDetectionDetectParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static FaceDetectionDetectParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            FaceDetectionDetectParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new FaceDetectionDetectParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.bitmapData = com.vccorp.skia.mojom.Bitmap.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.bitmapData, 8, false);
        }
    }



    
    static final class FaceDetectionDetectResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public FaceDetectionResult[] results;

        private FaceDetectionDetectResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public FaceDetectionDetectResponseParams() {
            this(0);
        }

        public static FaceDetectionDetectResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static FaceDetectionDetectResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static FaceDetectionDetectResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            FaceDetectionDetectResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new FaceDetectionDetectResponseParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    {
                        com.vccorp.mojo.bindings.DataHeader si1 = decoder1.readDataHeaderForPointerArray(com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                        result.results = new FaceDetectionResult[si1.elementsOrVersion];
                        for (int i1 = 0; i1 < si1.elementsOrVersion; ++i1) {
                            
                            com.vccorp.mojo.bindings.Decoder decoder2 = decoder1.readPointer(com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i1, false);
                            result.results[i1] = FaceDetectionResult.decode(decoder2);
                        }
                    }
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            if (this.results == null) {
                encoder0.encodeNullPointer(8, false);
            } else {
                org.chromium.mojo.bindings.Encoder encoder1 = encoder0.encodePointerArray(this.results.length, 8, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                for (int i0 = 0; i0 < this.results.length; ++i0) {
                    
                    encoder1.encode(this.results[i0], com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i0, false);
                }
            }
        }
    }

    static class FaceDetectionDetectResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final FaceDetection.DetectResponse mCallback;

        FaceDetectionDetectResponseParamsForwardToCallback(FaceDetection.DetectResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(DETECT_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                FaceDetectionDetectResponseParams response = FaceDetectionDetectResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.results);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class FaceDetectionDetectResponseParamsProxyToResponder implements FaceDetection.DetectResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        FaceDetectionDetectResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(FaceDetectionResult[] results) {
            FaceDetectionDetectResponseParams _response = new FaceDetectionDetectResponseParams();

            _response.results = results;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    DETECT_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



}
