
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     services/shape_detection/public/mojom/barcodedetection.mojom
//

package com.vccorp.shape_detection.mojom;

import com.vccorp.mojo.bindings.DeserializationException;

public final class BarcodeFormat {
    private static final boolean IS_EXTENSIBLE = false;

    public static final int AZTEC = 0;
    public static final int CODE_128 = 1; // AZTEC + 1
    public static final int CODE_39 = 2; // CODE_128 + 1
    public static final int CODE_93 = 3; // CODE_39 + 1
    public static final int CODABAR = 4; // CODE_93 + 1
    public static final int DATA_MATRIX = 5; // CODABAR + 1
    public static final int EAN_13 = 6; // DATA_MATRIX + 1
    public static final int EAN_8 = 7; // EAN_13 + 1
    public static final int ITF = 8; // EAN_8 + 1
    public static final int PDF417 = 9; // ITF + 1
    public static final int QR_CODE = 10; // PDF417 + 1
    public static final int UNKNOWN = 11; // QR_CODE + 1
    public static final int UPC_A = 12; // UNKNOWN + 1
    public static final int UPC_E = 13; // UPC_A + 1

    public static boolean isKnownValue(int value) {
        return value >= 0 && value <= 13;
    }

    public static void validate(int value) {
        if (IS_EXTENSIBLE || isKnownValue(value)) return;
        throw new DeserializationException("Invalid enum value.");
    }

    private BarcodeFormat() {}
}