
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     services/network/public/mojom/network_context.mojom
//

package com.vccorp.network.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


public final class UrlLoaderFactoryParams extends org.chromium.mojo.bindings.Struct {

    private static final int STRUCT_SIZE = 48;
    private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(48, 0)};
    private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    public int processId;
    public com.vccorp.url.mojom.Origin requestInitiatorSiteLock;
    public boolean isCorbEnabled;
    public int corbDetachableResourceType;
    public int corbExcludedResourceType;
    public boolean disableWebSecurity;
    public TrustedUrlLoaderHeaderClient headerClient;
    public CorsOriginPattern[] factoryBoundAllowPatterns;

    private UrlLoaderFactoryParams(int version) {
        super(STRUCT_SIZE, version);
        this.processId = (int) NetworkContextConstants.INVALID_PROCESS_ID;
        this.isCorbEnabled = (boolean) true;
        this.corbDetachableResourceType = (int) -1;
        this.corbExcludedResourceType = (int) -1;
        this.disableWebSecurity = (boolean) false;
    }

    public UrlLoaderFactoryParams() {
        this(0);
    }

    public static UrlLoaderFactoryParams deserialize(com.vccorp.mojo.bindings.Message message) {
        return decode(new com.vccorp.mojo.bindings.Decoder(message));
    }

    /**
     * Similar to the method above, but deserializes from a |ByteBuffer| instance.
     *
     * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
     */
    public static UrlLoaderFactoryParams deserialize(java.nio.ByteBuffer data) {
        return deserialize(new com.vccorp.mojo.bindings.Message(
                data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
    }

    @SuppressWarnings("unchecked")
    public static UrlLoaderFactoryParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
        if (decoder0 == null) {
            return null;
        }
        decoder0.increaseStackDepth();
        UrlLoaderFactoryParams result;
        try {
            com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            final int elementsOrVersion = mainDataHeader.elementsOrVersion;
            result = new UrlLoaderFactoryParams(elementsOrVersion);
                {
                    
                result.processId = decoder0.readInt(8);
                }
                {
                    
                result.isCorbEnabled = decoder0.readBoolean(12, 0);
                }
                {
                    
                result.disableWebSecurity = decoder0.readBoolean(12, 1);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, true);
                result.requestInitiatorSiteLock = com.vccorp.url.mojom.Origin.decode(decoder1);
                }
                {
                    
                result.corbDetachableResourceType = decoder0.readInt(24);
                }
                {
                    
                result.corbExcludedResourceType = decoder0.readInt(28);
                }
                {
                    
                result.headerClient = decoder0.readServiceInterface(32, true, TrustedUrlLoaderHeaderClient.MANAGER);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(40, false);
                {
                    com.vccorp.mojo.bindings.DataHeader si1 = decoder1.readDataHeaderForPointerArray(com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                    result.factoryBoundAllowPatterns = new CorsOriginPattern[si1.elementsOrVersion];
                    for (int i1 = 0; i1 < si1.elementsOrVersion; ++i1) {
                        
                        com.vccorp.mojo.bindings.Decoder decoder2 = decoder1.readPointer(com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i1, false);
                        result.factoryBoundAllowPatterns[i1] = CorsOriginPattern.decode(decoder2);
                    }
                }
                }

        } finally {
            decoder0.decreaseStackDepth();
        }
        return result;
    }

    @SuppressWarnings("unchecked")
    @Override
    protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
        org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        
        encoder0.encode(this.processId, 8);
        
        encoder0.encode(this.isCorbEnabled, 12, 0);
        
        encoder0.encode(this.disableWebSecurity, 12, 1);
        
        encoder0.encode(this.requestInitiatorSiteLock, 16, true);
        
        encoder0.encode(this.corbDetachableResourceType, 24);
        
        encoder0.encode(this.corbExcludedResourceType, 28);
        
        encoder0.encode(this.headerClient, 32, true, TrustedUrlLoaderHeaderClient.MANAGER);
        
        if (this.factoryBoundAllowPatterns == null) {
            encoder0.encodeNullPointer(40, false);
        } else {
            org.chromium.mojo.bindings.Encoder encoder1 = encoder0.encodePointerArray(this.factoryBoundAllowPatterns.length, 40, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
            for (int i0 = 0; i0 < this.factoryBoundAllowPatterns.length; ++i0) {
                
                encoder1.encode(this.factoryBoundAllowPatterns[i0], com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i0, false);
            }
        }
    }
}