
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     services/network/public/mojom/network_context.mojom
//

package com.vccorp.network.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


class TrustedHeaderClient_Internal {

    public static final com.vccorp.mojo.bindings.Interface.Manager<TrustedHeaderClient, TrustedHeaderClient.Proxy> MANAGER =
            new com.vccorp.mojo.bindings.Interface.Manager<TrustedHeaderClient, TrustedHeaderClient.Proxy>() {

        @Override
        public String getName() {
            return "network.mojom.TrustedHeaderClient";
        }

        @Override
        public int getVersion() {
          return 0;
        }

        @Override
        public Proxy buildProxy(com.vccorp.mojo.system.Core core,
                                com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }

        @Override
        public Stub buildStub(com.vccorp.mojo.system.Core core, TrustedHeaderClient impl) {
            return new Stub(core, impl);
        }

        @Override
        public TrustedHeaderClient[] buildArray(int size) {
          return new TrustedHeaderClient[size];
        }
    };


    private static final int ON_BEFORE_SEND_HEADERS_ORDINAL = 0;

    private static final int ON_HEADERS_RECEIVED_ORDINAL = 1;


    static final class Proxy extends com.vccorp.mojo.bindings.Interface.AbstractProxy implements TrustedHeaderClient.Proxy {

        Proxy(com.vccorp.mojo.system.Core core,
              com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }


        @Override
        public void onBeforeSendHeaders(
HttpRequestHeaders headers, 
OnBeforeSendHeadersResponse callback) {

            TrustedHeaderClientOnBeforeSendHeadersParams _message = new TrustedHeaderClientOnBeforeSendHeadersParams();

            _message.headers = headers;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    ON_BEFORE_SEND_HEADERS_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new TrustedHeaderClientOnBeforeSendHeadersResponseParamsForwardToCallback(callback));

        }


        @Override
        public void onHeadersReceived(
String headers, 
OnHeadersReceivedResponse callback) {

            TrustedHeaderClientOnHeadersReceivedParams _message = new TrustedHeaderClientOnHeadersReceivedParams();

            _message.headers = headers;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    ON_HEADERS_RECEIVED_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new TrustedHeaderClientOnHeadersReceivedResponseParamsForwardToCallback(callback));

        }


    }

    static final class Stub extends com.vccorp.mojo.bindings.Interface.Stub<TrustedHeaderClient> {

        Stub(com.vccorp.mojo.system.Core core, TrustedHeaderClient impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                TrustedHeaderClient_Internal.MANAGER, messageWithHeader);






                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(com.vccorp.mojo.bindings.Message message, com.vccorp.mojo.bindings.MessageReceiver receiver) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), TrustedHeaderClient_Internal.MANAGER, messageWithHeader, receiver);







                    case ON_BEFORE_SEND_HEADERS_ORDINAL: {

                        TrustedHeaderClientOnBeforeSendHeadersParams data =
                                TrustedHeaderClientOnBeforeSendHeadersParams.deserialize(messageWithHeader.getPayload());

                        getImpl().onBeforeSendHeaders(data.headers, new TrustedHeaderClientOnBeforeSendHeadersResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }







                    case ON_HEADERS_RECEIVED_ORDINAL: {

                        TrustedHeaderClientOnHeadersReceivedParams data =
                                TrustedHeaderClientOnHeadersReceivedParams.deserialize(messageWithHeader.getPayload());

                        getImpl().onHeadersReceived(data.headers, new TrustedHeaderClientOnHeadersReceivedResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }


                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }


    
    static final class TrustedHeaderClientOnBeforeSendHeadersParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public HttpRequestHeaders headers;

        private TrustedHeaderClientOnBeforeSendHeadersParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public TrustedHeaderClientOnBeforeSendHeadersParams() {
            this(0);
        }

        public static TrustedHeaderClientOnBeforeSendHeadersParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static TrustedHeaderClientOnBeforeSendHeadersParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static TrustedHeaderClientOnBeforeSendHeadersParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            TrustedHeaderClientOnBeforeSendHeadersParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new TrustedHeaderClientOnBeforeSendHeadersParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.headers = HttpRequestHeaders.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.headers, 8, false);
        }
    }



    
    static final class TrustedHeaderClientOnBeforeSendHeadersResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int result;
        public HttpRequestHeaders headers;

        private TrustedHeaderClientOnBeforeSendHeadersResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public TrustedHeaderClientOnBeforeSendHeadersResponseParams() {
            this(0);
        }

        public static TrustedHeaderClientOnBeforeSendHeadersResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static TrustedHeaderClientOnBeforeSendHeadersResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static TrustedHeaderClientOnBeforeSendHeadersResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            TrustedHeaderClientOnBeforeSendHeadersResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new TrustedHeaderClientOnBeforeSendHeadersResponseParams(elementsOrVersion);
                    {
                        
                    result.result = decoder0.readInt(8);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, true);
                    result.headers = HttpRequestHeaders.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.result, 8);
            
            encoder0.encode(this.headers, 16, true);
        }
    }

    static class TrustedHeaderClientOnBeforeSendHeadersResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final TrustedHeaderClient.OnBeforeSendHeadersResponse mCallback;

        TrustedHeaderClientOnBeforeSendHeadersResponseParamsForwardToCallback(TrustedHeaderClient.OnBeforeSendHeadersResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(ON_BEFORE_SEND_HEADERS_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                TrustedHeaderClientOnBeforeSendHeadersResponseParams response = TrustedHeaderClientOnBeforeSendHeadersResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.result, response.headers);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class TrustedHeaderClientOnBeforeSendHeadersResponseParamsProxyToResponder implements TrustedHeaderClient.OnBeforeSendHeadersResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        TrustedHeaderClientOnBeforeSendHeadersResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(Integer result, HttpRequestHeaders headers) {
            TrustedHeaderClientOnBeforeSendHeadersResponseParams _response = new TrustedHeaderClientOnBeforeSendHeadersResponseParams();

            _response.result = result;

            _response.headers = headers;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    ON_BEFORE_SEND_HEADERS_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class TrustedHeaderClientOnHeadersReceivedParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public String headers;

        private TrustedHeaderClientOnHeadersReceivedParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public TrustedHeaderClientOnHeadersReceivedParams() {
            this(0);
        }

        public static TrustedHeaderClientOnHeadersReceivedParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static TrustedHeaderClientOnHeadersReceivedParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static TrustedHeaderClientOnHeadersReceivedParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            TrustedHeaderClientOnHeadersReceivedParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new TrustedHeaderClientOnHeadersReceivedParams(elementsOrVersion);
                    {
                        
                    result.headers = decoder0.readString(8, false);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.headers, 8, false);
        }
    }



    
    static final class TrustedHeaderClientOnHeadersReceivedResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 32;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(32, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int result;
        public String headers;
        public com.vccorp.url.mojom.Url allowedUnsafeRedirectUrl;

        private TrustedHeaderClientOnHeadersReceivedResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public TrustedHeaderClientOnHeadersReceivedResponseParams() {
            this(0);
        }

        public static TrustedHeaderClientOnHeadersReceivedResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static TrustedHeaderClientOnHeadersReceivedResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static TrustedHeaderClientOnHeadersReceivedResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            TrustedHeaderClientOnHeadersReceivedResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new TrustedHeaderClientOnHeadersReceivedResponseParams(elementsOrVersion);
                    {
                        
                    result.result = decoder0.readInt(8);
                    }
                    {
                        
                    result.headers = decoder0.readString(16, true);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(24, false);
                    result.allowedUnsafeRedirectUrl = com.vccorp.url.mojom.Url.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.result, 8);
            
            encoder0.encode(this.headers, 16, true);
            
            encoder0.encode(this.allowedUnsafeRedirectUrl, 24, false);
        }
    }

    static class TrustedHeaderClientOnHeadersReceivedResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final TrustedHeaderClient.OnHeadersReceivedResponse mCallback;

        TrustedHeaderClientOnHeadersReceivedResponseParamsForwardToCallback(TrustedHeaderClient.OnHeadersReceivedResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(ON_HEADERS_RECEIVED_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                TrustedHeaderClientOnHeadersReceivedResponseParams response = TrustedHeaderClientOnHeadersReceivedResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.result, response.headers, response.allowedUnsafeRedirectUrl);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class TrustedHeaderClientOnHeadersReceivedResponseParamsProxyToResponder implements TrustedHeaderClient.OnHeadersReceivedResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        TrustedHeaderClientOnHeadersReceivedResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(Integer result, String headers, com.vccorp.url.mojom.Url allowedUnsafeRedirectUrl) {
            TrustedHeaderClientOnHeadersReceivedResponseParams _response = new TrustedHeaderClientOnHeadersReceivedResponseParams();

            _response.result = result;

            _response.headers = headers;

            _response.allowedUnsafeRedirectUrl = allowedUnsafeRedirectUrl;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    ON_HEADERS_RECEIVED_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



}
