
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     services/network/public/mojom/network_service.mojom
//

package com.vccorp.network.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


public final class HttpAuthDynamicParams extends org.chromium.mojo.bindings.Struct {

    private static final int STRUCT_SIZE = 40;
    private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(40, 0)};
    private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    public String serverWhitelist;
    public String delegateWhitelist;
    public boolean delegateByKdcPolicy;
    public boolean negotiateDisableCnameLookup;
    public boolean enableNegotiatePort;
    public boolean ntlmV2Enabled;
    public String androidNegotiateAccountType;

    private HttpAuthDynamicParams(int version) {
        super(STRUCT_SIZE, version);
        this.delegateByKdcPolicy = (boolean) false;
        this.negotiateDisableCnameLookup = (boolean) false;
        this.enableNegotiatePort = (boolean) true;
        this.ntlmV2Enabled = (boolean) false;
    }

    public HttpAuthDynamicParams() {
        this(0);
    }

    public static HttpAuthDynamicParams deserialize(com.vccorp.mojo.bindings.Message message) {
        return decode(new com.vccorp.mojo.bindings.Decoder(message));
    }

    /**
     * Similar to the method above, but deserializes from a |ByteBuffer| instance.
     *
     * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
     */
    public static HttpAuthDynamicParams deserialize(java.nio.ByteBuffer data) {
        return deserialize(new com.vccorp.mojo.bindings.Message(
                data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
    }

    @SuppressWarnings("unchecked")
    public static HttpAuthDynamicParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
        if (decoder0 == null) {
            return null;
        }
        decoder0.increaseStackDepth();
        HttpAuthDynamicParams result;
        try {
            com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            final int elementsOrVersion = mainDataHeader.elementsOrVersion;
            result = new HttpAuthDynamicParams(elementsOrVersion);
                {
                    
                result.serverWhitelist = decoder0.readString(8, false);
                }
                {
                    
                result.delegateWhitelist = decoder0.readString(16, false);
                }
                {
                    
                result.delegateByKdcPolicy = decoder0.readBoolean(24, 0);
                }
                {
                    
                result.negotiateDisableCnameLookup = decoder0.readBoolean(24, 1);
                }
                {
                    
                result.enableNegotiatePort = decoder0.readBoolean(24, 2);
                }
                {
                    
                result.ntlmV2Enabled = decoder0.readBoolean(24, 3);
                }
                {
                    
                result.androidNegotiateAccountType = decoder0.readString(32, false);
                }

        } finally {
            decoder0.decreaseStackDepth();
        }
        return result;
    }

    @SuppressWarnings("unchecked")
    @Override
    protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
        org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        
        encoder0.encode(this.serverWhitelist, 8, false);
        
        encoder0.encode(this.delegateWhitelist, 16, false);
        
        encoder0.encode(this.delegateByKdcPolicy, 24, 0);
        
        encoder0.encode(this.negotiateDisableCnameLookup, 24, 1);
        
        encoder0.encode(this.enableNegotiatePort, 24, 2);
        
        encoder0.encode(this.ntlmV2Enabled, 24, 3);
        
        encoder0.encode(this.androidNegotiateAccountType, 32, false);
    }
}