
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     services/network/public/mojom/host_resolver.mojom
//

package com.vccorp.network.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


public final class DnsConfigOverrides extends org.chromium.mojo.bindings.Struct {

    private static final int STRUCT_SIZE = 72;
    private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(72, 0)};
    private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

    public static final class Tristate {
        private static final boolean IS_EXTENSIBLE = false;

        public static final int NO_OVERRIDE = 0;
        public static final int TRISTATE_TRUE = 1; // NO_OVERRIDE + 1
        public static final int TRISTATE_FALSE = 2; // TRISTATE_TRUE + 1

        public static boolean isKnownValue(int value) {
            return value >= 0 && value <= 2;
        }

        public static void validate(int value) {
            if (IS_EXTENSIBLE || isKnownValue(value)) return;
            throw new DeserializationException("Invalid enum value.");
        }

        private Tristate() {}
    }
    public IpEndPoint[] nameservers;
    public String[] search;
    public DnsHost[] hosts;
    public int appendToMultiLabelName;
    public int randomizePorts;
    public byte ndots;
    public com.vccorp.mojo_base.mojom.TimeDelta timeout;
    public int attempts;
    public int rotate;
    public int useLocalIpv6;
    public DnsOverHttpsServer[] dnsOverHttpsServers;

    private DnsConfigOverrides(int version) {
        super(STRUCT_SIZE, version);
        this.appendToMultiLabelName = (int) DnsConfigOverrides.Tristate.NO_OVERRIDE;
        this.randomizePorts = (int) DnsConfigOverrides.Tristate.NO_OVERRIDE;
        this.ndots = (byte) -1;
        this.attempts = (int) -1;
        this.rotate = (int) DnsConfigOverrides.Tristate.NO_OVERRIDE;
        this.useLocalIpv6 = (int) DnsConfigOverrides.Tristate.NO_OVERRIDE;
    }

    public DnsConfigOverrides() {
        this(0);
    }

    public static DnsConfigOverrides deserialize(com.vccorp.mojo.bindings.Message message) {
        return decode(new com.vccorp.mojo.bindings.Decoder(message));
    }

    /**
     * Similar to the method above, but deserializes from a |ByteBuffer| instance.
     *
     * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
     */
    public static DnsConfigOverrides deserialize(java.nio.ByteBuffer data) {
        return deserialize(new com.vccorp.mojo.bindings.Message(
                data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
    }

    @SuppressWarnings("unchecked")
    public static DnsConfigOverrides decode(com.vccorp.mojo.bindings.Decoder decoder0) {
        if (decoder0 == null) {
            return null;
        }
        decoder0.increaseStackDepth();
        DnsConfigOverrides result;
        try {
            com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            final int elementsOrVersion = mainDataHeader.elementsOrVersion;
            result = new DnsConfigOverrides(elementsOrVersion);
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, true);
                if (decoder1 == null) {
                    result.nameservers = null;
                } else {
                    com.vccorp.mojo.bindings.DataHeader si1 = decoder1.readDataHeaderForPointerArray(com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                    result.nameservers = new IpEndPoint[si1.elementsOrVersion];
                    for (int i1 = 0; i1 < si1.elementsOrVersion; ++i1) {
                        
                        com.vccorp.mojo.bindings.Decoder decoder2 = decoder1.readPointer(com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i1, false);
                        result.nameservers[i1] = IpEndPoint.decode(decoder2);
                    }
                }
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, true);
                if (decoder1 == null) {
                    result.search = null;
                } else {
                    com.vccorp.mojo.bindings.DataHeader si1 = decoder1.readDataHeaderForPointerArray(com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                    result.search = new String[si1.elementsOrVersion];
                    for (int i1 = 0; i1 < si1.elementsOrVersion; ++i1) {
                        
                        result.search[i1] = decoder1.readString(com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i1, false);
                    }
                }
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(24, true);
                if (decoder1 == null) {
                    result.hosts = null;
                } else {
                    com.vccorp.mojo.bindings.DataHeader si1 = decoder1.readDataHeaderForPointerArray(com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                    result.hosts = new DnsHost[si1.elementsOrVersion];
                    for (int i1 = 0; i1 < si1.elementsOrVersion; ++i1) {
                        
                        com.vccorp.mojo.bindings.Decoder decoder2 = decoder1.readPointer(com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i1, false);
                        result.hosts[i1] = DnsHost.decode(decoder2);
                    }
                }
                }
                {
                    
                result.appendToMultiLabelName = decoder0.readInt(32);
                    DnsConfigOverrides.Tristate.validate(result.appendToMultiLabelName);
                }
                {
                    
                result.randomizePorts = decoder0.readInt(36);
                    DnsConfigOverrides.Tristate.validate(result.randomizePorts);
                }
                {
                    
                result.ndots = decoder0.readByte(40);
                }
                {
                    
                result.attempts = decoder0.readInt(44);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(48, true);
                result.timeout = com.vccorp.mojo_base.mojom.TimeDelta.decode(decoder1);
                }
                {
                    
                result.rotate = decoder0.readInt(56);
                    DnsConfigOverrides.Tristate.validate(result.rotate);
                }
                {
                    
                result.useLocalIpv6 = decoder0.readInt(60);
                    DnsConfigOverrides.Tristate.validate(result.useLocalIpv6);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(64, true);
                if (decoder1 == null) {
                    result.dnsOverHttpsServers = null;
                } else {
                    com.vccorp.mojo.bindings.DataHeader si1 = decoder1.readDataHeaderForPointerArray(com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                    result.dnsOverHttpsServers = new DnsOverHttpsServer[si1.elementsOrVersion];
                    for (int i1 = 0; i1 < si1.elementsOrVersion; ++i1) {
                        
                        com.vccorp.mojo.bindings.Decoder decoder2 = decoder1.readPointer(com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i1, false);
                        result.dnsOverHttpsServers[i1] = DnsOverHttpsServer.decode(decoder2);
                    }
                }
                }

        } finally {
            decoder0.decreaseStackDepth();
        }
        return result;
    }

    @SuppressWarnings("unchecked")
    @Override
    protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
        org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        
        if (this.nameservers == null) {
            encoder0.encodeNullPointer(8, true);
        } else {
            org.chromium.mojo.bindings.Encoder encoder1 = encoder0.encodePointerArray(this.nameservers.length, 8, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
            for (int i0 = 0; i0 < this.nameservers.length; ++i0) {
                
                encoder1.encode(this.nameservers[i0], com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i0, false);
            }
        }
        
        if (this.search == null) {
            encoder0.encodeNullPointer(16, true);
        } else {
            org.chromium.mojo.bindings.Encoder encoder1 = encoder0.encodePointerArray(this.search.length, 16, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
            for (int i0 = 0; i0 < this.search.length; ++i0) {
                
                encoder1.encode(this.search[i0], com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i0, false);
            }
        }
        
        if (this.hosts == null) {
            encoder0.encodeNullPointer(24, true);
        } else {
            org.chromium.mojo.bindings.Encoder encoder1 = encoder0.encodePointerArray(this.hosts.length, 24, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
            for (int i0 = 0; i0 < this.hosts.length; ++i0) {
                
                encoder1.encode(this.hosts[i0], com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i0, false);
            }
        }
        
        encoder0.encode(this.appendToMultiLabelName, 32);
        
        encoder0.encode(this.randomizePorts, 36);
        
        encoder0.encode(this.ndots, 40);
        
        encoder0.encode(this.attempts, 44);
        
        encoder0.encode(this.timeout, 48, true);
        
        encoder0.encode(this.rotate, 56);
        
        encoder0.encode(this.useLocalIpv6, 60);
        
        if (this.dnsOverHttpsServers == null) {
            encoder0.encodeNullPointer(64, true);
        } else {
            org.chromium.mojo.bindings.Encoder encoder1 = encoder0.encodePointerArray(this.dnsOverHttpsServers.length, 64, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
            for (int i0 = 0; i0 < this.dnsOverHttpsServers.length; ++i0) {
                
                encoder1.encode(this.dnsOverHttpsServers[i0], com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i0, false);
            }
        }
    }
}