
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     services/network/public/mojom/network_context.mojom
//

package com.vccorp.network.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


class CustomProxyConfigClient_Internal {

    public static final com.vccorp.mojo.bindings.Interface.Manager<CustomProxyConfigClient, CustomProxyConfigClient.Proxy> MANAGER =
            new com.vccorp.mojo.bindings.Interface.Manager<CustomProxyConfigClient, CustomProxyConfigClient.Proxy>() {

        @Override
        public String getName() {
            return "network.mojom.CustomProxyConfigClient";
        }

        @Override
        public int getVersion() {
          return 0;
        }

        @Override
        public Proxy buildProxy(com.vccorp.mojo.system.Core core,
                                com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }

        @Override
        public Stub buildStub(com.vccorp.mojo.system.Core core, CustomProxyConfigClient impl) {
            return new Stub(core, impl);
        }

        @Override
        public CustomProxyConfigClient[] buildArray(int size) {
          return new CustomProxyConfigClient[size];
        }
    };


    private static final int ON_CUSTOM_PROXY_CONFIG_UPDATED_ORDINAL = 0;

    private static final int MARK_PROXIES_AS_BAD_ORDINAL = 1;

    private static final int CLEAR_BAD_PROXIES_CACHE_ORDINAL = 2;


    static final class Proxy extends com.vccorp.mojo.bindings.Interface.AbstractProxy implements CustomProxyConfigClient.Proxy {

        Proxy(com.vccorp.mojo.system.Core core,
              com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }


        @Override
        public void onCustomProxyConfigUpdated(
CustomProxyConfig proxyConfig) {

            CustomProxyConfigClientOnCustomProxyConfigUpdatedParams _message = new CustomProxyConfigClientOnCustomProxyConfigUpdatedParams();

            _message.proxyConfig = proxyConfig;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(ON_CUSTOM_PROXY_CONFIG_UPDATED_ORDINAL)));

        }


        @Override
        public void markProxiesAsBad(
com.vccorp.mojo_base.mojom.TimeDelta bypassDuration, ProxyList badProxies,
MarkProxiesAsBadResponse callback) {

            CustomProxyConfigClientMarkProxiesAsBadParams _message = new CustomProxyConfigClientMarkProxiesAsBadParams();

            _message.bypassDuration = bypassDuration;

            _message.badProxies = badProxies;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    MARK_PROXIES_AS_BAD_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new CustomProxyConfigClientMarkProxiesAsBadResponseParamsForwardToCallback(callback));

        }


        @Override
        public void clearBadProxiesCache(
) {

            CustomProxyConfigClientClearBadProxiesCacheParams _message = new CustomProxyConfigClientClearBadProxiesCacheParams();


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(CLEAR_BAD_PROXIES_CACHE_ORDINAL)));

        }


    }

    static final class Stub extends com.vccorp.mojo.bindings.Interface.Stub<CustomProxyConfigClient> {

        Stub(com.vccorp.mojo.system.Core core, CustomProxyConfigClient impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                CustomProxyConfigClient_Internal.MANAGER, messageWithHeader);





                    case ON_CUSTOM_PROXY_CONFIG_UPDATED_ORDINAL: {

                        CustomProxyConfigClientOnCustomProxyConfigUpdatedParams data =
                                CustomProxyConfigClientOnCustomProxyConfigUpdatedParams.deserialize(messageWithHeader.getPayload());

                        getImpl().onCustomProxyConfigUpdated(data.proxyConfig);
                        return true;
                    }







                    case CLEAR_BAD_PROXIES_CACHE_ORDINAL: {

                        CustomProxyConfigClientClearBadProxiesCacheParams.deserialize(messageWithHeader.getPayload());

                        getImpl().clearBadProxiesCache();
                        return true;
                    }


                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(com.vccorp.mojo.bindings.Message message, com.vccorp.mojo.bindings.MessageReceiver receiver) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), CustomProxyConfigClient_Internal.MANAGER, messageWithHeader, receiver);









                    case MARK_PROXIES_AS_BAD_ORDINAL: {

                        CustomProxyConfigClientMarkProxiesAsBadParams data =
                                CustomProxyConfigClientMarkProxiesAsBadParams.deserialize(messageWithHeader.getPayload());

                        getImpl().markProxiesAsBad(data.bypassDuration, data.badProxies, new CustomProxyConfigClientMarkProxiesAsBadResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }




                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }


    
    static final class CustomProxyConfigClientOnCustomProxyConfigUpdatedParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public CustomProxyConfig proxyConfig;

        private CustomProxyConfigClientOnCustomProxyConfigUpdatedParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public CustomProxyConfigClientOnCustomProxyConfigUpdatedParams() {
            this(0);
        }

        public static CustomProxyConfigClientOnCustomProxyConfigUpdatedParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static CustomProxyConfigClientOnCustomProxyConfigUpdatedParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static CustomProxyConfigClientOnCustomProxyConfigUpdatedParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            CustomProxyConfigClientOnCustomProxyConfigUpdatedParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new CustomProxyConfigClientOnCustomProxyConfigUpdatedParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.proxyConfig = CustomProxyConfig.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.proxyConfig, 8, false);
        }
    }



    
    static final class CustomProxyConfigClientMarkProxiesAsBadParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public com.vccorp.mojo_base.mojom.TimeDelta bypassDuration;
        public ProxyList badProxies;

        private CustomProxyConfigClientMarkProxiesAsBadParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public CustomProxyConfigClientMarkProxiesAsBadParams() {
            this(0);
        }

        public static CustomProxyConfigClientMarkProxiesAsBadParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static CustomProxyConfigClientMarkProxiesAsBadParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static CustomProxyConfigClientMarkProxiesAsBadParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            CustomProxyConfigClientMarkProxiesAsBadParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new CustomProxyConfigClientMarkProxiesAsBadParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.bypassDuration = com.vccorp.mojo_base.mojom.TimeDelta.decode(decoder1);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, false);
                    result.badProxies = ProxyList.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.bypassDuration, 8, false);
            
            encoder0.encode(this.badProxies, 16, false);
        }
    }



    
    static final class CustomProxyConfigClientMarkProxiesAsBadResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 8;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(8, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

        private CustomProxyConfigClientMarkProxiesAsBadResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public CustomProxyConfigClientMarkProxiesAsBadResponseParams() {
            this(0);
        }

        public static CustomProxyConfigClientMarkProxiesAsBadResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static CustomProxyConfigClientMarkProxiesAsBadResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static CustomProxyConfigClientMarkProxiesAsBadResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            CustomProxyConfigClientMarkProxiesAsBadResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new CustomProxyConfigClientMarkProxiesAsBadResponseParams(elementsOrVersion);

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    }

    static class CustomProxyConfigClientMarkProxiesAsBadResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final CustomProxyConfigClient.MarkProxiesAsBadResponse mCallback;

        CustomProxyConfigClientMarkProxiesAsBadResponseParamsForwardToCallback(CustomProxyConfigClient.MarkProxiesAsBadResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(MARK_PROXIES_AS_BAD_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                mCallback.call();
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class CustomProxyConfigClientMarkProxiesAsBadResponseParamsProxyToResponder implements CustomProxyConfigClient.MarkProxiesAsBadResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        CustomProxyConfigClientMarkProxiesAsBadResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call() {
            CustomProxyConfigClientMarkProxiesAsBadResponseParams _response = new CustomProxyConfigClientMarkProxiesAsBadResponseParams();

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    MARK_PROXIES_AS_BAD_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class CustomProxyConfigClientClearBadProxiesCacheParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 8;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(8, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

        private CustomProxyConfigClientClearBadProxiesCacheParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public CustomProxyConfigClientClearBadProxiesCacheParams() {
            this(0);
        }

        public static CustomProxyConfigClientClearBadProxiesCacheParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static CustomProxyConfigClientClearBadProxiesCacheParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static CustomProxyConfigClientClearBadProxiesCacheParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            CustomProxyConfigClientClearBadProxiesCacheParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new CustomProxyConfigClientClearBadProxiesCacheParams(elementsOrVersion);

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    }



}
