
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     media/mojo/interfaces/video_decode_perf_history.mojom
//

package com.vccorp.media.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


class VideoDecodePerfHistory_Internal {

    public static final com.vccorp.mojo.bindings.Interface.Manager<VideoDecodePerfHistory, VideoDecodePerfHistory.Proxy> MANAGER =
            new com.vccorp.mojo.bindings.Interface.Manager<VideoDecodePerfHistory, VideoDecodePerfHistory.Proxy>() {

        @Override
        public String getName() {
            return "media.mojom.VideoDecodePerfHistory";
        }

        @Override
        public int getVersion() {
          return 0;
        }

        @Override
        public Proxy buildProxy(com.vccorp.mojo.system.Core core,
                                com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }

        @Override
        public Stub buildStub(com.vccorp.mojo.system.Core core, VideoDecodePerfHistory impl) {
            return new Stub(core, impl);
        }

        @Override
        public VideoDecodePerfHistory[] buildArray(int size) {
          return new VideoDecodePerfHistory[size];
        }
    };


    private static final int GET_PERF_INFO_ORDINAL = 0;


    static final class Proxy extends com.vccorp.mojo.bindings.Interface.AbstractProxy implements VideoDecodePerfHistory.Proxy {

        Proxy(com.vccorp.mojo.system.Core core,
              com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }


        @Override
        public void getPerfInfo(
PredictionFeatures features, 
GetPerfInfoResponse callback) {

            VideoDecodePerfHistoryGetPerfInfoParams _message = new VideoDecodePerfHistoryGetPerfInfoParams();

            _message.features = features;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    GET_PERF_INFO_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new VideoDecodePerfHistoryGetPerfInfoResponseParamsForwardToCallback(callback));

        }


    }

    static final class Stub extends com.vccorp.mojo.bindings.Interface.Stub<VideoDecodePerfHistory> {

        Stub(com.vccorp.mojo.system.Core core, VideoDecodePerfHistory impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                VideoDecodePerfHistory_Internal.MANAGER, messageWithHeader);




                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(com.vccorp.mojo.bindings.Message message, com.vccorp.mojo.bindings.MessageReceiver receiver) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), VideoDecodePerfHistory_Internal.MANAGER, messageWithHeader, receiver);







                    case GET_PERF_INFO_ORDINAL: {

                        VideoDecodePerfHistoryGetPerfInfoParams data =
                                VideoDecodePerfHistoryGetPerfInfoParams.deserialize(messageWithHeader.getPayload());

                        getImpl().getPerfInfo(data.features, new VideoDecodePerfHistoryGetPerfInfoResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }


                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }


    
    static final class VideoDecodePerfHistoryGetPerfInfoParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public PredictionFeatures features;

        private VideoDecodePerfHistoryGetPerfInfoParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public VideoDecodePerfHistoryGetPerfInfoParams() {
            this(0);
        }

        public static VideoDecodePerfHistoryGetPerfInfoParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static VideoDecodePerfHistoryGetPerfInfoParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static VideoDecodePerfHistoryGetPerfInfoParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            VideoDecodePerfHistoryGetPerfInfoParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new VideoDecodePerfHistoryGetPerfInfoParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.features = PredictionFeatures.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.features, 8, false);
        }
    }



    
    static final class VideoDecodePerfHistoryGetPerfInfoResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public boolean isSmooth;
        public boolean isPowerEfficient;

        private VideoDecodePerfHistoryGetPerfInfoResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public VideoDecodePerfHistoryGetPerfInfoResponseParams() {
            this(0);
        }

        public static VideoDecodePerfHistoryGetPerfInfoResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static VideoDecodePerfHistoryGetPerfInfoResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static VideoDecodePerfHistoryGetPerfInfoResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            VideoDecodePerfHistoryGetPerfInfoResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new VideoDecodePerfHistoryGetPerfInfoResponseParams(elementsOrVersion);
                    {
                        
                    result.isSmooth = decoder0.readBoolean(8, 0);
                    }
                    {
                        
                    result.isPowerEfficient = decoder0.readBoolean(8, 1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.isSmooth, 8, 0);
            
            encoder0.encode(this.isPowerEfficient, 8, 1);
        }
    }

    static class VideoDecodePerfHistoryGetPerfInfoResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final VideoDecodePerfHistory.GetPerfInfoResponse mCallback;

        VideoDecodePerfHistoryGetPerfInfoResponseParamsForwardToCallback(VideoDecodePerfHistory.GetPerfInfoResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(GET_PERF_INFO_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                VideoDecodePerfHistoryGetPerfInfoResponseParams response = VideoDecodePerfHistoryGetPerfInfoResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.isSmooth, response.isPowerEfficient);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class VideoDecodePerfHistoryGetPerfInfoResponseParamsProxyToResponder implements VideoDecodePerfHistory.GetPerfInfoResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        VideoDecodePerfHistoryGetPerfInfoResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(Boolean isSmooth, Boolean isPowerEfficient) {
            VideoDecodePerfHistoryGetPerfInfoResponseParams _response = new VideoDecodePerfHistoryGetPerfInfoResponseParams();

            _response.isSmooth = isSmooth;

            _response.isPowerEfficient = isPowerEfficient;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    GET_PERF_INFO_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



}
