
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     media/mojo/interfaces/audio_logging.mojom
//

package com.vccorp.media.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


class AudioLogFactory_Internal {

    public static final com.vccorp.mojo.bindings.Interface.Manager<AudioLogFactory, AudioLogFactory.Proxy> MANAGER =
            new com.vccorp.mojo.bindings.Interface.Manager<AudioLogFactory, AudioLogFactory.Proxy>() {

        @Override
        public String getName() {
            return "media.mojom.AudioLogFactory";
        }

        @Override
        public int getVersion() {
          return 0;
        }

        @Override
        public Proxy buildProxy(com.vccorp.mojo.system.Core core,
                                com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }

        @Override
        public Stub buildStub(com.vccorp.mojo.system.Core core, AudioLogFactory impl) {
            return new Stub(core, impl);
        }

        @Override
        public AudioLogFactory[] buildArray(int size) {
          return new AudioLogFactory[size];
        }
    };


    private static final int CREATE_AUDIO_LOG_ORDINAL = 0;


    static final class Proxy extends com.vccorp.mojo.bindings.Interface.AbstractProxy implements AudioLogFactory.Proxy {

        Proxy(com.vccorp.mojo.system.Core core,
              com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }


        @Override
        public void createAudioLog(
int component, int componentId, com.vccorp.mojo.bindings.InterfaceRequest<AudioLog> audioLogRequest) {

            AudioLogFactoryCreateAudioLogParams _message = new AudioLogFactoryCreateAudioLogParams();

            _message.component = component;

            _message.componentId = componentId;

            _message.audioLogRequest = audioLogRequest;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(CREATE_AUDIO_LOG_ORDINAL)));

        }


    }

    static final class Stub extends com.vccorp.mojo.bindings.Interface.Stub<AudioLogFactory> {

        Stub(com.vccorp.mojo.system.Core core, AudioLogFactory impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                AudioLogFactory_Internal.MANAGER, messageWithHeader);





                    case CREATE_AUDIO_LOG_ORDINAL: {

                        AudioLogFactoryCreateAudioLogParams data =
                                AudioLogFactoryCreateAudioLogParams.deserialize(messageWithHeader.getPayload());

                        getImpl().createAudioLog(data.component, data.componentId, data.audioLogRequest);
                        return true;
                    }


                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(com.vccorp.mojo.bindings.Message message, com.vccorp.mojo.bindings.MessageReceiver receiver) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), AudioLogFactory_Internal.MANAGER, messageWithHeader, receiver);




                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }


    
    static final class AudioLogFactoryCreateAudioLogParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int component;
        public int componentId;
        public com.vccorp.mojo.bindings.InterfaceRequest<AudioLog> audioLogRequest;

        private AudioLogFactoryCreateAudioLogParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public AudioLogFactoryCreateAudioLogParams() {
            this(0);
        }

        public static AudioLogFactoryCreateAudioLogParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static AudioLogFactoryCreateAudioLogParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static AudioLogFactoryCreateAudioLogParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            AudioLogFactoryCreateAudioLogParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new AudioLogFactoryCreateAudioLogParams(elementsOrVersion);
                    {
                        
                    result.component = decoder0.readInt(8);
                        AudioLogComponent.validate(result.component);
                    }
                    {
                        
                    result.componentId = decoder0.readInt(12);
                    }
                    {
                        
                    result.audioLogRequest = decoder0.readInterfaceRequest(16, false);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.component, 8);
            
            encoder0.encode(this.componentId, 12);
            
            encoder0.encode(this.audioLogRequest, 16, false);
        }
    }



}
