
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     gpu/ipc/common/gpu_feature_info.mojom
//

package com.vccorp.gpu.mojom;

import com.vccorp.mojo.bindings.DeserializationException;

public final class GpuFeatureStatus {
    private static final boolean IS_EXTENSIBLE = false;

    public static final int ENABLED = 0;
    public static final int BLACKLISTED = 1; // ENABLED + 1
    public static final int DISABLED = 2; // BLACKLISTED + 1
    public static final int SOFTWARE = 3; // DISABLED + 1
    public static final int UNDEFINED = 4; // SOFTWARE + 1
    public static final int MAX = 5; // UNDEFINED + 1

    public static boolean isKnownValue(int value) {
        return value >= 0 && value <= 5;
    }

    public static void validate(int value) {
        if (IS_EXTENSIBLE || isKnownValue(value)) return;
        throw new DeserializationException("Invalid enum value.");
    }

    private GpuFeatureStatus() {}
}