
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     ui/gfx/mojo/color_space.mojom
//

package com.vccorp.gfx.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


public final class ColorSpace extends org.chromium.mojo.bindings.Struct {

    private static final int STRUCT_SIZE = 40;
    private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(40, 0)};
    private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    public int primaries;
    public int transfer;
    public int matrix;
    public int range;
    public float[] customPrimaryMatrix;
    public float[] customTransferParams;

    private ColorSpace(int version) {
        super(STRUCT_SIZE, version);
    }

    public ColorSpace() {
        this(0);
    }

    public static ColorSpace deserialize(com.vccorp.mojo.bindings.Message message) {
        return decode(new com.vccorp.mojo.bindings.Decoder(message));
    }

    /**
     * Similar to the method above, but deserializes from a |ByteBuffer| instance.
     *
     * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
     */
    public static ColorSpace deserialize(java.nio.ByteBuffer data) {
        return deserialize(new com.vccorp.mojo.bindings.Message(
                data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
    }

    @SuppressWarnings("unchecked")
    public static ColorSpace decode(com.vccorp.mojo.bindings.Decoder decoder0) {
        if (decoder0 == null) {
            return null;
        }
        decoder0.increaseStackDepth();
        ColorSpace result;
        try {
            com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            final int elementsOrVersion = mainDataHeader.elementsOrVersion;
            result = new ColorSpace(elementsOrVersion);
                {
                    
                result.primaries = decoder0.readInt(8);
                    ColorSpacePrimaryId.validate(result.primaries);
                }
                {
                    
                result.transfer = decoder0.readInt(12);
                    ColorSpaceTransferId.validate(result.transfer);
                }
                {
                    
                result.matrix = decoder0.readInt(16);
                    ColorSpaceMatrixId.validate(result.matrix);
                }
                {
                    
                result.range = decoder0.readInt(20);
                    ColorSpaceRangeId.validate(result.range);
                }
                {
                    
                result.customPrimaryMatrix = decoder0.readFloats(24, com.vccorp.mojo.bindings.BindingsHelper.NOTHING_NULLABLE, 9);
                }
                {
                    
                result.customTransferParams = decoder0.readFloats(32, com.vccorp.mojo.bindings.BindingsHelper.NOTHING_NULLABLE, 7);
                }

        } finally {
            decoder0.decreaseStackDepth();
        }
        return result;
    }

    @SuppressWarnings("unchecked")
    @Override
    protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
        org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        
        encoder0.encode(this.primaries, 8);
        
        encoder0.encode(this.transfer, 12);
        
        encoder0.encode(this.matrix, 16);
        
        encoder0.encode(this.range, 20);
        
        encoder0.encode(this.customPrimaryMatrix, 24, com.vccorp.mojo.bindings.BindingsHelper.NOTHING_NULLABLE, 9);
        
        encoder0.encode(this.customTransferParams, 32, com.vccorp.mojo.bindings.BindingsHelper.NOTHING_NULLABLE, 7);
    }
}