// Copyright 2017 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

package com.vccorp.device.nfc;

import com.vccorp.device.mojom.Nfc;
import com.vccorp.device.mojom.NfcProvider;
import com.vccorp.mojo.bindings.InterfaceRequest;
import com.vccorp.mojo.system.MojoException;
import com.vccorp.services.service_manager.InterfaceFactory;

import org.chromium.device.nfc.NfcDelegate;

/**
 * Android implementation of the NfcProvider Mojo interface.
 */
public class NfcProviderImpl implements NfcProvider {
    private static final String TAG = "NfcProviderImpl";
    private NfcDelegate mDelegate;

    public NfcProviderImpl(NfcDelegate delegate) {
        mDelegate = delegate;
    }

    @Override
    public void close() {}

    @Override
    public void onConnectionError(MojoException e) {}

    @Override
    public void getNfcForHost(int hostId, InterfaceRequest<Nfc> request) {
        Nfc.MANAGER.bind(new NfcImpl(hostId, mDelegate), request);
    }

    /**
     * A factory for implementations of the NfcProvider interface.
     */
    public static class Factory implements InterfaceFactory<NfcProvider> {
        private NfcDelegate mDelegate;

        public Factory(NfcDelegate delegate) {
            mDelegate = delegate;
        }

        @Override
        public NfcProvider createImpl() {
            return new NfcProviderImpl(mDelegate);
        }
    }
}
