
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     device/usb/public/mojom/device.mojom
//

package com.vccorp.device.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


public final class UsbEndpointInfo extends org.chromium.mojo.bindings.Struct {

    private static final int STRUCT_SIZE = 40;
    private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(40, 0)};
    private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    public byte endpointNumber;
    public int direction;
    public int type;
    public int packetSize;
    public int synchronizationType;
    public int usageType;
    public byte pollingInterval;
    public byte[] extraData;

    private UsbEndpointInfo(int version) {
        super(STRUCT_SIZE, version);
    }

    public UsbEndpointInfo() {
        this(0);
    }

    public static UsbEndpointInfo deserialize(com.vccorp.mojo.bindings.Message message) {
        return decode(new com.vccorp.mojo.bindings.Decoder(message));
    }

    /**
     * Similar to the method above, but deserializes from a |ByteBuffer| instance.
     *
     * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
     */
    public static UsbEndpointInfo deserialize(java.nio.ByteBuffer data) {
        return deserialize(new com.vccorp.mojo.bindings.Message(
                data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
    }

    @SuppressWarnings("unchecked")
    public static UsbEndpointInfo decode(com.vccorp.mojo.bindings.Decoder decoder0) {
        if (decoder0 == null) {
            return null;
        }
        decoder0.increaseStackDepth();
        UsbEndpointInfo result;
        try {
            com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            final int elementsOrVersion = mainDataHeader.elementsOrVersion;
            result = new UsbEndpointInfo(elementsOrVersion);
                {
                    
                result.endpointNumber = decoder0.readByte(8);
                }
                {
                    
                result.pollingInterval = decoder0.readByte(9);
                }
                {
                    
                result.direction = decoder0.readInt(12);
                    UsbTransferDirection.validate(result.direction);
                }
                {
                    
                result.type = decoder0.readInt(16);
                    UsbTransferType.validate(result.type);
                }
                {
                    
                result.packetSize = decoder0.readInt(20);
                }
                {
                    
                result.synchronizationType = decoder0.readInt(24);
                    UsbSynchronizationType.validate(result.synchronizationType);
                }
                {
                    
                result.usageType = decoder0.readInt(28);
                    UsbUsageType.validate(result.usageType);
                }
                {
                    
                result.extraData = decoder0.readBytes(32, com.vccorp.mojo.bindings.BindingsHelper.NOTHING_NULLABLE, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                }

        } finally {
            decoder0.decreaseStackDepth();
        }
        return result;
    }

    @SuppressWarnings("unchecked")
    @Override
    protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
        org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        
        encoder0.encode(this.endpointNumber, 8);
        
        encoder0.encode(this.pollingInterval, 9);
        
        encoder0.encode(this.direction, 12);
        
        encoder0.encode(this.type, 16);
        
        encoder0.encode(this.packetSize, 20);
        
        encoder0.encode(this.synchronizationType, 24);
        
        encoder0.encode(this.usageType, 28);
        
        encoder0.encode(this.extraData, 32, com.vccorp.mojo.bindings.BindingsHelper.NOTHING_NULLABLE, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
    }
}