
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     services/device/public/mojom/serial.mojom
//

package com.vccorp.device.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


public final class SerialHostControlSignals extends org.chromium.mojo.bindings.Struct {

    private static final int STRUCT_SIZE = 16;
    private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
    private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    public boolean dtr;
    public boolean hasDtr;
    public boolean rts;
    public boolean hasRts;

    private SerialHostControlSignals(int version) {
        super(STRUCT_SIZE, version);
        this.hasDtr = (boolean) false;
        this.hasRts = (boolean) false;
    }

    public SerialHostControlSignals() {
        this(0);
    }

    public static SerialHostControlSignals deserialize(com.vccorp.mojo.bindings.Message message) {
        return decode(new com.vccorp.mojo.bindings.Decoder(message));
    }

    /**
     * Similar to the method above, but deserializes from a |ByteBuffer| instance.
     *
     * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
     */
    public static SerialHostControlSignals deserialize(java.nio.ByteBuffer data) {
        return deserialize(new com.vccorp.mojo.bindings.Message(
                data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
    }

    @SuppressWarnings("unchecked")
    public static SerialHostControlSignals decode(com.vccorp.mojo.bindings.Decoder decoder0) {
        if (decoder0 == null) {
            return null;
        }
        decoder0.increaseStackDepth();
        SerialHostControlSignals result;
        try {
            com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            final int elementsOrVersion = mainDataHeader.elementsOrVersion;
            result = new SerialHostControlSignals(elementsOrVersion);
                {
                    
                result.dtr = decoder0.readBoolean(8, 0);
                }
                {
                    
                result.hasDtr = decoder0.readBoolean(8, 1);
                }
                {
                    
                result.rts = decoder0.readBoolean(8, 2);
                }
                {
                    
                result.hasRts = decoder0.readBoolean(8, 3);
                }

        } finally {
            decoder0.decreaseStackDepth();
        }
        return result;
    }

    @SuppressWarnings("unchecked")
    @Override
    protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
        org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        
        encoder0.encode(this.dtr, 8, 0);
        
        encoder0.encode(this.hasDtr, 8, 1);
        
        encoder0.encode(this.rts, 8, 2);
        
        encoder0.encode(this.hasRts, 8, 3);
    }
}