
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     third_party/blink/public/mojom/reporting/reporting.mojom
//

package com.vccorp.blink.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


class ReportingServiceProxy_Internal {

    public static final com.vccorp.mojo.bindings.Interface.Manager<ReportingServiceProxy, ReportingServiceProxy.Proxy> MANAGER =
            new com.vccorp.mojo.bindings.Interface.Manager<ReportingServiceProxy, ReportingServiceProxy.Proxy>() {

        @Override
        public String getName() {
            return "blink.mojom.ReportingServiceProxy";
        }

        @Override
        public int getVersion() {
          return 0;
        }

        @Override
        public Proxy buildProxy(com.vccorp.mojo.system.Core core,
                                com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }

        @Override
        public Stub buildStub(com.vccorp.mojo.system.Core core, ReportingServiceProxy impl) {
            return new Stub(core, impl);
        }

        @Override
        public ReportingServiceProxy[] buildArray(int size) {
          return new ReportingServiceProxy[size];
        }
    };


    private static final int QUEUE_INTERVENTION_REPORT_ORDINAL = 0;

    private static final int QUEUE_DEPRECATION_REPORT_ORDINAL = 1;

    private static final int QUEUE_CSP_VIOLATION_REPORT_ORDINAL = 2;

    private static final int QUEUE_FEATURE_POLICY_VIOLATION_REPORT_ORDINAL = 3;


    static final class Proxy extends com.vccorp.mojo.bindings.Interface.AbstractProxy implements ReportingServiceProxy.Proxy {

        Proxy(com.vccorp.mojo.system.Core core,
              com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }


        @Override
        public void queueInterventionReport(
com.vccorp.url.mojom.Url url, String message, String sourceFile, int lineNumber, int columnNumber) {

            ReportingServiceProxyQueueInterventionReportParams _message = new ReportingServiceProxyQueueInterventionReportParams();

            _message.url = url;

            _message.message = message;

            _message.sourceFile = sourceFile;

            _message.lineNumber = lineNumber;

            _message.columnNumber = columnNumber;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(QUEUE_INTERVENTION_REPORT_ORDINAL)));

        }


        @Override
        public void queueDeprecationReport(
com.vccorp.url.mojom.Url url, String id, com.vccorp.mojo_base.mojom.Time anticipatedRemoval, String message, String sourceFile, int lineNumber, int columnNumber) {

            ReportingServiceProxyQueueDeprecationReportParams _message = new ReportingServiceProxyQueueDeprecationReportParams();

            _message.url = url;

            _message.id = id;

            _message.anticipatedRemoval = anticipatedRemoval;

            _message.message = message;

            _message.sourceFile = sourceFile;

            _message.lineNumber = lineNumber;

            _message.columnNumber = columnNumber;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(QUEUE_DEPRECATION_REPORT_ORDINAL)));

        }


        @Override
        public void queueCspViolationReport(
com.vccorp.url.mojom.Url url, String group, String documentUri, String referrer, String violatedDirective, String effectiveDirective, String originalPolicy, String disposition, String blockedUri, int lineNumber, int columnNumber, String sourceFile, short statusCode, String scriptSample) {

            ReportingServiceProxyQueueCspViolationReportParams _message = new ReportingServiceProxyQueueCspViolationReportParams();

            _message.url = url;

            _message.group = group;

            _message.documentUri = documentUri;

            _message.referrer = referrer;

            _message.violatedDirective = violatedDirective;

            _message.effectiveDirective = effectiveDirective;

            _message.originalPolicy = originalPolicy;

            _message.disposition = disposition;

            _message.blockedUri = blockedUri;

            _message.lineNumber = lineNumber;

            _message.columnNumber = columnNumber;

            _message.sourceFile = sourceFile;

            _message.statusCode = statusCode;

            _message.scriptSample = scriptSample;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(QUEUE_CSP_VIOLATION_REPORT_ORDINAL)));

        }


        @Override
        public void queueFeaturePolicyViolationReport(
com.vccorp.url.mojom.Url url, String policyId, String disposition, String message, String sourceFile, int lineNumber, int columnNumber) {

            ReportingServiceProxyQueueFeaturePolicyViolationReportParams _message = new ReportingServiceProxyQueueFeaturePolicyViolationReportParams();

            _message.url = url;

            _message.policyId = policyId;

            _message.disposition = disposition;

            _message.message = message;

            _message.sourceFile = sourceFile;

            _message.lineNumber = lineNumber;

            _message.columnNumber = columnNumber;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(QUEUE_FEATURE_POLICY_VIOLATION_REPORT_ORDINAL)));

        }


    }

    static final class Stub extends com.vccorp.mojo.bindings.Interface.Stub<ReportingServiceProxy> {

        Stub(com.vccorp.mojo.system.Core core, ReportingServiceProxy impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                ReportingServiceProxy_Internal.MANAGER, messageWithHeader);





                    case QUEUE_INTERVENTION_REPORT_ORDINAL: {

                        ReportingServiceProxyQueueInterventionReportParams data =
                                ReportingServiceProxyQueueInterventionReportParams.deserialize(messageWithHeader.getPayload());

                        getImpl().queueInterventionReport(data.url, data.message, data.sourceFile, data.lineNumber, data.columnNumber);
                        return true;
                    }





                    case QUEUE_DEPRECATION_REPORT_ORDINAL: {

                        ReportingServiceProxyQueueDeprecationReportParams data =
                                ReportingServiceProxyQueueDeprecationReportParams.deserialize(messageWithHeader.getPayload());

                        getImpl().queueDeprecationReport(data.url, data.id, data.anticipatedRemoval, data.message, data.sourceFile, data.lineNumber, data.columnNumber);
                        return true;
                    }





                    case QUEUE_CSP_VIOLATION_REPORT_ORDINAL: {

                        ReportingServiceProxyQueueCspViolationReportParams data =
                                ReportingServiceProxyQueueCspViolationReportParams.deserialize(messageWithHeader.getPayload());

                        getImpl().queueCspViolationReport(data.url, data.group, data.documentUri, data.referrer, data.violatedDirective, data.effectiveDirective, data.originalPolicy, data.disposition, data.blockedUri, data.lineNumber, data.columnNumber, data.sourceFile, data.statusCode, data.scriptSample);
                        return true;
                    }





                    case QUEUE_FEATURE_POLICY_VIOLATION_REPORT_ORDINAL: {

                        ReportingServiceProxyQueueFeaturePolicyViolationReportParams data =
                                ReportingServiceProxyQueueFeaturePolicyViolationReportParams.deserialize(messageWithHeader.getPayload());

                        getImpl().queueFeaturePolicyViolationReport(data.url, data.policyId, data.disposition, data.message, data.sourceFile, data.lineNumber, data.columnNumber);
                        return true;
                    }


                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(com.vccorp.mojo.bindings.Message message, com.vccorp.mojo.bindings.MessageReceiver receiver) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), ReportingServiceProxy_Internal.MANAGER, messageWithHeader, receiver);










                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }


    
    static final class ReportingServiceProxyQueueInterventionReportParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 40;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(40, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public com.vccorp.url.mojom.Url url;
        public String message;
        public String sourceFile;
        public int lineNumber;
        public int columnNumber;

        private ReportingServiceProxyQueueInterventionReportParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public ReportingServiceProxyQueueInterventionReportParams() {
            this(0);
        }

        public static ReportingServiceProxyQueueInterventionReportParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static ReportingServiceProxyQueueInterventionReportParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static ReportingServiceProxyQueueInterventionReportParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            ReportingServiceProxyQueueInterventionReportParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new ReportingServiceProxyQueueInterventionReportParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.url = com.vccorp.url.mojom.Url.decode(decoder1);
                    }
                    {
                        
                    result.message = decoder0.readString(16, false);
                    }
                    {
                        
                    result.sourceFile = decoder0.readString(24, true);
                    }
                    {
                        
                    result.lineNumber = decoder0.readInt(32);
                    }
                    {
                        
                    result.columnNumber = decoder0.readInt(36);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.url, 8, false);
            
            encoder0.encode(this.message, 16, false);
            
            encoder0.encode(this.sourceFile, 24, true);
            
            encoder0.encode(this.lineNumber, 32);
            
            encoder0.encode(this.columnNumber, 36);
        }
    }



    
    static final class ReportingServiceProxyQueueDeprecationReportParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 56;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(56, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public com.vccorp.url.mojom.Url url;
        public String id;
        public com.vccorp.mojo_base.mojom.Time anticipatedRemoval;
        public String message;
        public String sourceFile;
        public int lineNumber;
        public int columnNumber;

        private ReportingServiceProxyQueueDeprecationReportParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public ReportingServiceProxyQueueDeprecationReportParams() {
            this(0);
        }

        public static ReportingServiceProxyQueueDeprecationReportParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static ReportingServiceProxyQueueDeprecationReportParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static ReportingServiceProxyQueueDeprecationReportParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            ReportingServiceProxyQueueDeprecationReportParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new ReportingServiceProxyQueueDeprecationReportParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.url = com.vccorp.url.mojom.Url.decode(decoder1);
                    }
                    {
                        
                    result.id = decoder0.readString(16, false);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(24, true);
                    result.anticipatedRemoval = com.vccorp.mojo_base.mojom.Time.decode(decoder1);
                    }
                    {
                        
                    result.message = decoder0.readString(32, false);
                    }
                    {
                        
                    result.sourceFile = decoder0.readString(40, true);
                    }
                    {
                        
                    result.lineNumber = decoder0.readInt(48);
                    }
                    {
                        
                    result.columnNumber = decoder0.readInt(52);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.url, 8, false);
            
            encoder0.encode(this.id, 16, false);
            
            encoder0.encode(this.anticipatedRemoval, 24, true);
            
            encoder0.encode(this.message, 32, false);
            
            encoder0.encode(this.sourceFile, 40, true);
            
            encoder0.encode(this.lineNumber, 48);
            
            encoder0.encode(this.columnNumber, 52);
        }
    }



    
    static final class ReportingServiceProxyQueueCspViolationReportParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 112;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(112, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public com.vccorp.url.mojom.Url url;
        public String group;
        public String documentUri;
        public String referrer;
        public String violatedDirective;
        public String effectiveDirective;
        public String originalPolicy;
        public String disposition;
        public String blockedUri;
        public int lineNumber;
        public int columnNumber;
        public String sourceFile;
        public short statusCode;
        public String scriptSample;

        private ReportingServiceProxyQueueCspViolationReportParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public ReportingServiceProxyQueueCspViolationReportParams() {
            this(0);
        }

        public static ReportingServiceProxyQueueCspViolationReportParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static ReportingServiceProxyQueueCspViolationReportParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static ReportingServiceProxyQueueCspViolationReportParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            ReportingServiceProxyQueueCspViolationReportParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new ReportingServiceProxyQueueCspViolationReportParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.url = com.vccorp.url.mojom.Url.decode(decoder1);
                    }
                    {
                        
                    result.group = decoder0.readString(16, false);
                    }
                    {
                        
                    result.documentUri = decoder0.readString(24, false);
                    }
                    {
                        
                    result.referrer = decoder0.readString(32, false);
                    }
                    {
                        
                    result.violatedDirective = decoder0.readString(40, false);
                    }
                    {
                        
                    result.effectiveDirective = decoder0.readString(48, false);
                    }
                    {
                        
                    result.originalPolicy = decoder0.readString(56, false);
                    }
                    {
                        
                    result.disposition = decoder0.readString(64, false);
                    }
                    {
                        
                    result.blockedUri = decoder0.readString(72, false);
                    }
                    {
                        
                    result.lineNumber = decoder0.readInt(80);
                    }
                    {
                        
                    result.columnNumber = decoder0.readInt(84);
                    }
                    {
                        
                    result.sourceFile = decoder0.readString(88, true);
                    }
                    {
                        
                    result.statusCode = decoder0.readShort(96);
                    }
                    {
                        
                    result.scriptSample = decoder0.readString(104, false);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.url, 8, false);
            
            encoder0.encode(this.group, 16, false);
            
            encoder0.encode(this.documentUri, 24, false);
            
            encoder0.encode(this.referrer, 32, false);
            
            encoder0.encode(this.violatedDirective, 40, false);
            
            encoder0.encode(this.effectiveDirective, 48, false);
            
            encoder0.encode(this.originalPolicy, 56, false);
            
            encoder0.encode(this.disposition, 64, false);
            
            encoder0.encode(this.blockedUri, 72, false);
            
            encoder0.encode(this.lineNumber, 80);
            
            encoder0.encode(this.columnNumber, 84);
            
            encoder0.encode(this.sourceFile, 88, true);
            
            encoder0.encode(this.statusCode, 96);
            
            encoder0.encode(this.scriptSample, 104, false);
        }
    }



    
    static final class ReportingServiceProxyQueueFeaturePolicyViolationReportParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 56;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(56, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public com.vccorp.url.mojom.Url url;
        public String policyId;
        public String disposition;
        public String message;
        public String sourceFile;
        public int lineNumber;
        public int columnNumber;

        private ReportingServiceProxyQueueFeaturePolicyViolationReportParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public ReportingServiceProxyQueueFeaturePolicyViolationReportParams() {
            this(0);
        }

        public static ReportingServiceProxyQueueFeaturePolicyViolationReportParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static ReportingServiceProxyQueueFeaturePolicyViolationReportParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static ReportingServiceProxyQueueFeaturePolicyViolationReportParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            ReportingServiceProxyQueueFeaturePolicyViolationReportParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new ReportingServiceProxyQueueFeaturePolicyViolationReportParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.url = com.vccorp.url.mojom.Url.decode(decoder1);
                    }
                    {
                        
                    result.policyId = decoder0.readString(16, false);
                    }
                    {
                        
                    result.disposition = decoder0.readString(24, false);
                    }
                    {
                        
                    result.message = decoder0.readString(32, true);
                    }
                    {
                        
                    result.sourceFile = decoder0.readString(40, true);
                    }
                    {
                        
                    result.lineNumber = decoder0.readInt(48);
                    }
                    {
                        
                    result.columnNumber = decoder0.readInt(52);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.url, 8, false);
            
            encoder0.encode(this.policyId, 16, false);
            
            encoder0.encode(this.disposition, 24, false);
            
            encoder0.encode(this.message, 32, true);
            
            encoder0.encode(this.sourceFile, 40, true);
            
            encoder0.encode(this.lineNumber, 48);
            
            encoder0.encode(this.columnNumber, 52);
        }
    }



}
