
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     third_party/blink/public/mojom/quota/quota_dispatcher_host.mojom
//

package com.vccorp.blink.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


class QuotaDispatcherHost_Internal {

    public static final com.vccorp.mojo.bindings.Interface.Manager<QuotaDispatcherHost, QuotaDispatcherHost.Proxy> MANAGER =
            new com.vccorp.mojo.bindings.Interface.Manager<QuotaDispatcherHost, QuotaDispatcherHost.Proxy>() {

        @Override
        public String getName() {
            return "blink.mojom.QuotaDispatcherHost";
        }

        @Override
        public int getVersion() {
          return 0;
        }

        @Override
        public Proxy buildProxy(com.vccorp.mojo.system.Core core,
                                com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }

        @Override
        public Stub buildStub(com.vccorp.mojo.system.Core core, QuotaDispatcherHost impl) {
            return new Stub(core, impl);
        }

        @Override
        public QuotaDispatcherHost[] buildArray(int size) {
          return new QuotaDispatcherHost[size];
        }
    };


    private static final int QUERY_STORAGE_USAGE_AND_QUOTA_ORDINAL = 0;

    private static final int REQUEST_STORAGE_QUOTA_ORDINAL = 1;


    static final class Proxy extends com.vccorp.mojo.bindings.Interface.AbstractProxy implements QuotaDispatcherHost.Proxy {

        Proxy(com.vccorp.mojo.system.Core core,
              com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }


        @Override
        public void queryStorageUsageAndQuota(
com.vccorp.url.mojom.Origin origin, int storageType,
QueryStorageUsageAndQuotaResponse callback) {

            QuotaDispatcherHostQueryStorageUsageAndQuotaParams _message = new QuotaDispatcherHostQueryStorageUsageAndQuotaParams();

            _message.origin = origin;

            _message.storageType = storageType;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    QUERY_STORAGE_USAGE_AND_QUOTA_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new QuotaDispatcherHostQueryStorageUsageAndQuotaResponseParamsForwardToCallback(callback));

        }


        @Override
        public void requestStorageQuota(
com.vccorp.url.mojom.Origin origin, int storageType, long requestedSize,
RequestStorageQuotaResponse callback) {

            QuotaDispatcherHostRequestStorageQuotaParams _message = new QuotaDispatcherHostRequestStorageQuotaParams();

            _message.origin = origin;

            _message.storageType = storageType;

            _message.requestedSize = requestedSize;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    REQUEST_STORAGE_QUOTA_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new QuotaDispatcherHostRequestStorageQuotaResponseParamsForwardToCallback(callback));

        }


    }

    static final class Stub extends com.vccorp.mojo.bindings.Interface.Stub<QuotaDispatcherHost> {

        Stub(com.vccorp.mojo.system.Core core, QuotaDispatcherHost impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                QuotaDispatcherHost_Internal.MANAGER, messageWithHeader);






                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(com.vccorp.mojo.bindings.Message message, com.vccorp.mojo.bindings.MessageReceiver receiver) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), QuotaDispatcherHost_Internal.MANAGER, messageWithHeader, receiver);







                    case QUERY_STORAGE_USAGE_AND_QUOTA_ORDINAL: {

                        QuotaDispatcherHostQueryStorageUsageAndQuotaParams data =
                                QuotaDispatcherHostQueryStorageUsageAndQuotaParams.deserialize(messageWithHeader.getPayload());

                        getImpl().queryStorageUsageAndQuota(data.origin, data.storageType, new QuotaDispatcherHostQueryStorageUsageAndQuotaResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }







                    case REQUEST_STORAGE_QUOTA_ORDINAL: {

                        QuotaDispatcherHostRequestStorageQuotaParams data =
                                QuotaDispatcherHostRequestStorageQuotaParams.deserialize(messageWithHeader.getPayload());

                        getImpl().requestStorageQuota(data.origin, data.storageType, data.requestedSize, new QuotaDispatcherHostRequestStorageQuotaResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }


                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }


    
    static final class QuotaDispatcherHostQueryStorageUsageAndQuotaParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public com.vccorp.url.mojom.Origin origin;
        public int storageType;

        private QuotaDispatcherHostQueryStorageUsageAndQuotaParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public QuotaDispatcherHostQueryStorageUsageAndQuotaParams() {
            this(0);
        }

        public static QuotaDispatcherHostQueryStorageUsageAndQuotaParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static QuotaDispatcherHostQueryStorageUsageAndQuotaParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static QuotaDispatcherHostQueryStorageUsageAndQuotaParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            QuotaDispatcherHostQueryStorageUsageAndQuotaParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new QuotaDispatcherHostQueryStorageUsageAndQuotaParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.origin = com.vccorp.url.mojom.Origin.decode(decoder1);
                    }
                    {
                        
                    result.storageType = decoder0.readInt(16);
                        StorageType.validate(result.storageType);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.origin, 8, false);
            
            encoder0.encode(this.storageType, 16);
        }
    }



    
    static final class QuotaDispatcherHostQueryStorageUsageAndQuotaResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 40;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(40, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int error;
        public long currentUsage;
        public long currentQuota;
        public UsageBreakdown usageBreakdown;

        private QuotaDispatcherHostQueryStorageUsageAndQuotaResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public QuotaDispatcherHostQueryStorageUsageAndQuotaResponseParams() {
            this(0);
        }

        public static QuotaDispatcherHostQueryStorageUsageAndQuotaResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static QuotaDispatcherHostQueryStorageUsageAndQuotaResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static QuotaDispatcherHostQueryStorageUsageAndQuotaResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            QuotaDispatcherHostQueryStorageUsageAndQuotaResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new QuotaDispatcherHostQueryStorageUsageAndQuotaResponseParams(elementsOrVersion);
                    {
                        
                    result.error = decoder0.readInt(8);
                        QuotaStatusCode.validate(result.error);
                    }
                    {
                        
                    result.currentUsage = decoder0.readLong(16);
                    }
                    {
                        
                    result.currentQuota = decoder0.readLong(24);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(32, false);
                    result.usageBreakdown = UsageBreakdown.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.error, 8);
            
            encoder0.encode(this.currentUsage, 16);
            
            encoder0.encode(this.currentQuota, 24);
            
            encoder0.encode(this.usageBreakdown, 32, false);
        }
    }

    static class QuotaDispatcherHostQueryStorageUsageAndQuotaResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final QuotaDispatcherHost.QueryStorageUsageAndQuotaResponse mCallback;

        QuotaDispatcherHostQueryStorageUsageAndQuotaResponseParamsForwardToCallback(QuotaDispatcherHost.QueryStorageUsageAndQuotaResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(QUERY_STORAGE_USAGE_AND_QUOTA_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                QuotaDispatcherHostQueryStorageUsageAndQuotaResponseParams response = QuotaDispatcherHostQueryStorageUsageAndQuotaResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.error, response.currentUsage, response.currentQuota, response.usageBreakdown);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class QuotaDispatcherHostQueryStorageUsageAndQuotaResponseParamsProxyToResponder implements QuotaDispatcherHost.QueryStorageUsageAndQuotaResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        QuotaDispatcherHostQueryStorageUsageAndQuotaResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(Integer error, Long currentUsage, Long currentQuota, UsageBreakdown usageBreakdown) {
            QuotaDispatcherHostQueryStorageUsageAndQuotaResponseParams _response = new QuotaDispatcherHostQueryStorageUsageAndQuotaResponseParams();

            _response.error = error;

            _response.currentUsage = currentUsage;

            _response.currentQuota = currentQuota;

            _response.usageBreakdown = usageBreakdown;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    QUERY_STORAGE_USAGE_AND_QUOTA_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class QuotaDispatcherHostRequestStorageQuotaParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 32;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(32, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public com.vccorp.url.mojom.Origin origin;
        public int storageType;
        public long requestedSize;

        private QuotaDispatcherHostRequestStorageQuotaParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public QuotaDispatcherHostRequestStorageQuotaParams() {
            this(0);
        }

        public static QuotaDispatcherHostRequestStorageQuotaParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static QuotaDispatcherHostRequestStorageQuotaParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static QuotaDispatcherHostRequestStorageQuotaParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            QuotaDispatcherHostRequestStorageQuotaParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new QuotaDispatcherHostRequestStorageQuotaParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.origin = com.vccorp.url.mojom.Origin.decode(decoder1);
                    }
                    {
                        
                    result.storageType = decoder0.readInt(16);
                        StorageType.validate(result.storageType);
                    }
                    {
                        
                    result.requestedSize = decoder0.readLong(24);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.origin, 8, false);
            
            encoder0.encode(this.storageType, 16);
            
            encoder0.encode(this.requestedSize, 24);
        }
    }



    
    static final class QuotaDispatcherHostRequestStorageQuotaResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 32;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(32, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int error;
        public long currentUsage;
        public long grantedQuota;

        private QuotaDispatcherHostRequestStorageQuotaResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public QuotaDispatcherHostRequestStorageQuotaResponseParams() {
            this(0);
        }

        public static QuotaDispatcherHostRequestStorageQuotaResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static QuotaDispatcherHostRequestStorageQuotaResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static QuotaDispatcherHostRequestStorageQuotaResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            QuotaDispatcherHostRequestStorageQuotaResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new QuotaDispatcherHostRequestStorageQuotaResponseParams(elementsOrVersion);
                    {
                        
                    result.error = decoder0.readInt(8);
                        QuotaStatusCode.validate(result.error);
                    }
                    {
                        
                    result.currentUsage = decoder0.readLong(16);
                    }
                    {
                        
                    result.grantedQuota = decoder0.readLong(24);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.error, 8);
            
            encoder0.encode(this.currentUsage, 16);
            
            encoder0.encode(this.grantedQuota, 24);
        }
    }

    static class QuotaDispatcherHostRequestStorageQuotaResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final QuotaDispatcherHost.RequestStorageQuotaResponse mCallback;

        QuotaDispatcherHostRequestStorageQuotaResponseParamsForwardToCallback(QuotaDispatcherHost.RequestStorageQuotaResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(REQUEST_STORAGE_QUOTA_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                QuotaDispatcherHostRequestStorageQuotaResponseParams response = QuotaDispatcherHostRequestStorageQuotaResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.error, response.currentUsage, response.grantedQuota);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class QuotaDispatcherHostRequestStorageQuotaResponseParamsProxyToResponder implements QuotaDispatcherHost.RequestStorageQuotaResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        QuotaDispatcherHostRequestStorageQuotaResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(Integer error, Long currentUsage, Long grantedQuota) {
            QuotaDispatcherHostRequestStorageQuotaResponseParams _response = new QuotaDispatcherHostRequestStorageQuotaResponseParams();

            _response.error = error;

            _response.currentUsage = currentUsage;

            _response.grantedQuota = grantedQuota;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    REQUEST_STORAGE_QUOTA_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



}
