
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     third_party/blink/public/mojom/permissions/permission.mojom
//

package com.vccorp.blink.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


public final class PermissionDescriptorExtension extends com.vccorp.mojo.bindings.Union {

    public static final class Tag {
        public static final int Midi = 0;
        public static final int Clipboard = 1;
    };
    private MidiPermissionDescriptor mMidi;
    private ClipboardPermissionDescriptor mClipboard;

    public void setMidi(MidiPermissionDescriptor midi) {
        this.mTag = Tag.Midi;
        this.mMidi = midi;
    }

    public MidiPermissionDescriptor getMidi() {
        assert this.mTag == Tag.Midi;
        return this.mMidi;
    }

    public void setClipboard(ClipboardPermissionDescriptor clipboard) {
        this.mTag = Tag.Clipboard;
        this.mClipboard = clipboard;
    }

    public ClipboardPermissionDescriptor getClipboard() {
        assert this.mTag == Tag.Clipboard;
        return this.mClipboard;
    }


    @Override
    public final void encode(org.chromium.mojo.bindings.Encoder encoder0, int offset) {
        encoder0.encode(com.vccorp.mojo.bindings.BindingsHelper.UNION_SIZE, offset);
        encoder0.encode(this.mTag, offset + 4);
        switch (mTag) {
            case Tag.Midi: {
                
                encoder0.encode(this.mMidi, offset + 8, false);
                break;
            }
            case Tag.Clipboard: {
                
                encoder0.encode(this.mClipboard, offset + 8, false);
                break;
            }
            default: {
                break;
            }
        }
    }

    public static PermissionDescriptorExtension deserialize(com.vccorp.mojo.bindings.Message message) {
        return decode(new com.vccorp.mojo.bindings.Decoder(message).decoderForSerializedUnion(), 0);
    }

    public static final PermissionDescriptorExtension decode(com.vccorp.mojo.bindings.Decoder decoder0, int offset) {
        com.vccorp.mojo.bindings.DataHeader dataHeader = decoder0.readDataHeaderForUnion(offset);
        if (dataHeader.size == 0) {
            return null;
        }
        PermissionDescriptorExtension result = new PermissionDescriptorExtension();
        switch (dataHeader.elementsOrVersion) {
            case Tag.Midi: {
                
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(offset + com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE, false);
                result.mMidi = MidiPermissionDescriptor.decode(decoder1);
                result.mTag = Tag.Midi;
                break;
            }
            case Tag.Clipboard: {
                
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(offset + com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE, false);
                result.mClipboard = ClipboardPermissionDescriptor.decode(decoder1);
                result.mTag = Tag.Clipboard;
                break;
            }
            default: {
                break;
            }
        }
        return result;
    }
}