
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     third_party/blink/public/mojom/frame/document_interface_broker.mojom
//

package com.vccorp.blink.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


class DocumentInterfaceBroker_Internal {

    public static final com.vccorp.mojo.bindings.Interface.Manager<DocumentInterfaceBroker, DocumentInterfaceBroker.Proxy> MANAGER =
            new com.vccorp.mojo.bindings.Interface.Manager<DocumentInterfaceBroker, DocumentInterfaceBroker.Proxy>() {

        @Override
        public String getName() {
            return "blink.mojom.DocumentInterfaceBroker";
        }

        @Override
        public int getVersion() {
          return 0;
        }

        @Override
        public Proxy buildProxy(com.vccorp.mojo.system.Core core,
                                com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }

        @Override
        public Stub buildStub(com.vccorp.mojo.system.Core core, DocumentInterfaceBroker impl) {
            return new Stub(core, impl);
        }

        @Override
        public DocumentInterfaceBroker[] buildArray(int size) {
          return new DocumentInterfaceBroker[size];
        }
    };


    private static final int GET_AUDIO_CONTEXT_MANAGER_ORDINAL = 0;

    private static final int GET_AUTHENTICATOR_ORDINAL = 1;

    private static final int GET_CREDENTIAL_MANAGER_ORDINAL = 2;

    private static final int GET_FRAME_HOST_TEST_INTERFACE_ORDINAL = 3;

    private static final int GET_VIRTUAL_AUTHENTICATOR_MANAGER_ORDINAL = 4;


    static final class Proxy extends com.vccorp.mojo.bindings.Interface.AbstractProxy implements DocumentInterfaceBroker.Proxy {

        Proxy(com.vccorp.mojo.system.Core core,
              com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }


        @Override
        public void getAudioContextManager(
com.vccorp.mojo.bindings.InterfaceRequest<AudioContextManager> request) {

            DocumentInterfaceBrokerGetAudioContextManagerParams _message = new DocumentInterfaceBrokerGetAudioContextManagerParams();

            _message.request = request;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(GET_AUDIO_CONTEXT_MANAGER_ORDINAL)));

        }


        @Override
        public void getAuthenticator(
com.vccorp.mojo.bindings.InterfaceRequest<Authenticator> request) {

            DocumentInterfaceBrokerGetAuthenticatorParams _message = new DocumentInterfaceBrokerGetAuthenticatorParams();

            _message.request = request;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(GET_AUTHENTICATOR_ORDINAL)));

        }


        @Override
        public void getCredentialManager(
com.vccorp.mojo.bindings.InterfaceRequest<CredentialManager> request) {

            DocumentInterfaceBrokerGetCredentialManagerParams _message = new DocumentInterfaceBrokerGetCredentialManagerParams();

            _message.request = request;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(GET_CREDENTIAL_MANAGER_ORDINAL)));

        }


        @Override
        public void getFrameHostTestInterface(
com.vccorp.mojo.bindings.InterfaceRequest<FrameHostTestInterface> request) {

            DocumentInterfaceBrokerGetFrameHostTestInterfaceParams _message = new DocumentInterfaceBrokerGetFrameHostTestInterfaceParams();

            _message.request = request;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(GET_FRAME_HOST_TEST_INTERFACE_ORDINAL)));

        }


        @Override
        public void getVirtualAuthenticatorManager(
com.vccorp.mojo.bindings.InterfaceRequest<com.vccorp.blink.test.mojom.VirtualAuthenticatorManager> request) {

            DocumentInterfaceBrokerGetVirtualAuthenticatorManagerParams _message = new DocumentInterfaceBrokerGetVirtualAuthenticatorManagerParams();

            _message.request = request;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(GET_VIRTUAL_AUTHENTICATOR_MANAGER_ORDINAL)));

        }


    }

    static final class Stub extends com.vccorp.mojo.bindings.Interface.Stub<DocumentInterfaceBroker> {

        Stub(com.vccorp.mojo.system.Core core, DocumentInterfaceBroker impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                DocumentInterfaceBroker_Internal.MANAGER, messageWithHeader);





                    case GET_AUDIO_CONTEXT_MANAGER_ORDINAL: {

                        DocumentInterfaceBrokerGetAudioContextManagerParams data =
                                DocumentInterfaceBrokerGetAudioContextManagerParams.deserialize(messageWithHeader.getPayload());

                        getImpl().getAudioContextManager(data.request);
                        return true;
                    }





                    case GET_AUTHENTICATOR_ORDINAL: {

                        DocumentInterfaceBrokerGetAuthenticatorParams data =
                                DocumentInterfaceBrokerGetAuthenticatorParams.deserialize(messageWithHeader.getPayload());

                        getImpl().getAuthenticator(data.request);
                        return true;
                    }





                    case GET_CREDENTIAL_MANAGER_ORDINAL: {

                        DocumentInterfaceBrokerGetCredentialManagerParams data =
                                DocumentInterfaceBrokerGetCredentialManagerParams.deserialize(messageWithHeader.getPayload());

                        getImpl().getCredentialManager(data.request);
                        return true;
                    }





                    case GET_FRAME_HOST_TEST_INTERFACE_ORDINAL: {

                        DocumentInterfaceBrokerGetFrameHostTestInterfaceParams data =
                                DocumentInterfaceBrokerGetFrameHostTestInterfaceParams.deserialize(messageWithHeader.getPayload());

                        getImpl().getFrameHostTestInterface(data.request);
                        return true;
                    }





                    case GET_VIRTUAL_AUTHENTICATOR_MANAGER_ORDINAL: {

                        DocumentInterfaceBrokerGetVirtualAuthenticatorManagerParams data =
                                DocumentInterfaceBrokerGetVirtualAuthenticatorManagerParams.deserialize(messageWithHeader.getPayload());

                        getImpl().getVirtualAuthenticatorManager(data.request);
                        return true;
                    }


                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(com.vccorp.mojo.bindings.Message message, com.vccorp.mojo.bindings.MessageReceiver receiver) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), DocumentInterfaceBroker_Internal.MANAGER, messageWithHeader, receiver);












                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }


    
    static final class DocumentInterfaceBrokerGetAudioContextManagerParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public com.vccorp.mojo.bindings.InterfaceRequest<AudioContextManager> request;

        private DocumentInterfaceBrokerGetAudioContextManagerParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public DocumentInterfaceBrokerGetAudioContextManagerParams() {
            this(0);
        }

        public static DocumentInterfaceBrokerGetAudioContextManagerParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static DocumentInterfaceBrokerGetAudioContextManagerParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static DocumentInterfaceBrokerGetAudioContextManagerParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            DocumentInterfaceBrokerGetAudioContextManagerParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new DocumentInterfaceBrokerGetAudioContextManagerParams(elementsOrVersion);
                    {
                        
                    result.request = decoder0.readInterfaceRequest(8, false);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.request, 8, false);
        }
    }



    
    static final class DocumentInterfaceBrokerGetAuthenticatorParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public com.vccorp.mojo.bindings.InterfaceRequest<Authenticator> request;

        private DocumentInterfaceBrokerGetAuthenticatorParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public DocumentInterfaceBrokerGetAuthenticatorParams() {
            this(0);
        }

        public static DocumentInterfaceBrokerGetAuthenticatorParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static DocumentInterfaceBrokerGetAuthenticatorParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static DocumentInterfaceBrokerGetAuthenticatorParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            DocumentInterfaceBrokerGetAuthenticatorParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new DocumentInterfaceBrokerGetAuthenticatorParams(elementsOrVersion);
                    {
                        
                    result.request = decoder0.readInterfaceRequest(8, false);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.request, 8, false);
        }
    }



    
    static final class DocumentInterfaceBrokerGetCredentialManagerParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public com.vccorp.mojo.bindings.InterfaceRequest<CredentialManager> request;

        private DocumentInterfaceBrokerGetCredentialManagerParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public DocumentInterfaceBrokerGetCredentialManagerParams() {
            this(0);
        }

        public static DocumentInterfaceBrokerGetCredentialManagerParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static DocumentInterfaceBrokerGetCredentialManagerParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static DocumentInterfaceBrokerGetCredentialManagerParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            DocumentInterfaceBrokerGetCredentialManagerParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new DocumentInterfaceBrokerGetCredentialManagerParams(elementsOrVersion);
                    {
                        
                    result.request = decoder0.readInterfaceRequest(8, false);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.request, 8, false);
        }
    }



    
    static final class DocumentInterfaceBrokerGetFrameHostTestInterfaceParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public com.vccorp.mojo.bindings.InterfaceRequest<FrameHostTestInterface> request;

        private DocumentInterfaceBrokerGetFrameHostTestInterfaceParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public DocumentInterfaceBrokerGetFrameHostTestInterfaceParams() {
            this(0);
        }

        public static DocumentInterfaceBrokerGetFrameHostTestInterfaceParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static DocumentInterfaceBrokerGetFrameHostTestInterfaceParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static DocumentInterfaceBrokerGetFrameHostTestInterfaceParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            DocumentInterfaceBrokerGetFrameHostTestInterfaceParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new DocumentInterfaceBrokerGetFrameHostTestInterfaceParams(elementsOrVersion);
                    {
                        
                    result.request = decoder0.readInterfaceRequest(8, false);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.request, 8, false);
        }
    }



    
    static final class DocumentInterfaceBrokerGetVirtualAuthenticatorManagerParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public com.vccorp.mojo.bindings.InterfaceRequest<com.vccorp.blink.test.mojom.VirtualAuthenticatorManager> request;

        private DocumentInterfaceBrokerGetVirtualAuthenticatorManagerParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public DocumentInterfaceBrokerGetVirtualAuthenticatorManagerParams() {
            this(0);
        }

        public static DocumentInterfaceBrokerGetVirtualAuthenticatorManagerParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static DocumentInterfaceBrokerGetVirtualAuthenticatorManagerParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static DocumentInterfaceBrokerGetVirtualAuthenticatorManagerParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            DocumentInterfaceBrokerGetVirtualAuthenticatorManagerParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new DocumentInterfaceBrokerGetVirtualAuthenticatorManagerParams(elementsOrVersion);
                    {
                        
                    result.request = decoder0.readInterfaceRequest(8, false);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.request, 8, false);
        }
    }



}
