
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     third_party/blink/public/mojom/cookie_store/cookie_store.mojom
//

package com.vccorp.blink.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


class CookieStore_Internal {

    public static final com.vccorp.mojo.bindings.Interface.Manager<CookieStore, CookieStore.Proxy> MANAGER =
            new com.vccorp.mojo.bindings.Interface.Manager<CookieStore, CookieStore.Proxy>() {

        @Override
        public String getName() {
            return "blink.mojom.CookieStore";
        }

        @Override
        public int getVersion() {
          return 0;
        }

        @Override
        public Proxy buildProxy(com.vccorp.mojo.system.Core core,
                                com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }

        @Override
        public Stub buildStub(com.vccorp.mojo.system.Core core, CookieStore impl) {
            return new Stub(core, impl);
        }

        @Override
        public CookieStore[] buildArray(int size) {
          return new CookieStore[size];
        }
    };


    private static final int APPEND_SUBSCRIPTIONS_ORDINAL = 0;

    private static final int GET_SUBSCRIPTIONS_ORDINAL = 1;


    static final class Proxy extends com.vccorp.mojo.bindings.Interface.AbstractProxy implements CookieStore.Proxy {

        Proxy(com.vccorp.mojo.system.Core core,
              com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }


        @Override
        public void appendSubscriptions(
long serviceWorkerRegistrationId, CookieChangeSubscription[] subscriptions, 
AppendSubscriptionsResponse callback) {

            CookieStoreAppendSubscriptionsParams _message = new CookieStoreAppendSubscriptionsParams();

            _message.serviceWorkerRegistrationId = serviceWorkerRegistrationId;

            _message.subscriptions = subscriptions;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    APPEND_SUBSCRIPTIONS_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new CookieStoreAppendSubscriptionsResponseParamsForwardToCallback(callback));

        }


        @Override
        public void getSubscriptions(
long serviceWorkerRegistrationId, 
GetSubscriptionsResponse callback) {

            CookieStoreGetSubscriptionsParams _message = new CookieStoreGetSubscriptionsParams();

            _message.serviceWorkerRegistrationId = serviceWorkerRegistrationId;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    GET_SUBSCRIPTIONS_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new CookieStoreGetSubscriptionsResponseParamsForwardToCallback(callback));

        }


    }

    static final class Stub extends com.vccorp.mojo.bindings.Interface.Stub<CookieStore> {

        Stub(com.vccorp.mojo.system.Core core, CookieStore impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                CookieStore_Internal.MANAGER, messageWithHeader);






                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(com.vccorp.mojo.bindings.Message message, com.vccorp.mojo.bindings.MessageReceiver receiver) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), CookieStore_Internal.MANAGER, messageWithHeader, receiver);







                    case APPEND_SUBSCRIPTIONS_ORDINAL: {

                        CookieStoreAppendSubscriptionsParams data =
                                CookieStoreAppendSubscriptionsParams.deserialize(messageWithHeader.getPayload());

                        getImpl().appendSubscriptions(data.serviceWorkerRegistrationId, data.subscriptions, new CookieStoreAppendSubscriptionsResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }







                    case GET_SUBSCRIPTIONS_ORDINAL: {

                        CookieStoreGetSubscriptionsParams data =
                                CookieStoreGetSubscriptionsParams.deserialize(messageWithHeader.getPayload());

                        getImpl().getSubscriptions(data.serviceWorkerRegistrationId, new CookieStoreGetSubscriptionsResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }


                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }


    
    static final class CookieStoreAppendSubscriptionsParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public long serviceWorkerRegistrationId;
        public CookieChangeSubscription[] subscriptions;

        private CookieStoreAppendSubscriptionsParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public CookieStoreAppendSubscriptionsParams() {
            this(0);
        }

        public static CookieStoreAppendSubscriptionsParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static CookieStoreAppendSubscriptionsParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static CookieStoreAppendSubscriptionsParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            CookieStoreAppendSubscriptionsParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new CookieStoreAppendSubscriptionsParams(elementsOrVersion);
                    {
                        
                    result.serviceWorkerRegistrationId = decoder0.readLong(8);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, false);
                    {
                        com.vccorp.mojo.bindings.DataHeader si1 = decoder1.readDataHeaderForPointerArray(com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                        result.subscriptions = new CookieChangeSubscription[si1.elementsOrVersion];
                        for (int i1 = 0; i1 < si1.elementsOrVersion; ++i1) {
                            
                            com.vccorp.mojo.bindings.Decoder decoder2 = decoder1.readPointer(com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i1, false);
                            result.subscriptions[i1] = CookieChangeSubscription.decode(decoder2);
                        }
                    }
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.serviceWorkerRegistrationId, 8);
            
            if (this.subscriptions == null) {
                encoder0.encodeNullPointer(16, false);
            } else {
                org.chromium.mojo.bindings.Encoder encoder1 = encoder0.encodePointerArray(this.subscriptions.length, 16, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                for (int i0 = 0; i0 < this.subscriptions.length; ++i0) {
                    
                    encoder1.encode(this.subscriptions[i0], com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i0, false);
                }
            }
        }
    }



    
    static final class CookieStoreAppendSubscriptionsResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public boolean success;

        private CookieStoreAppendSubscriptionsResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public CookieStoreAppendSubscriptionsResponseParams() {
            this(0);
        }

        public static CookieStoreAppendSubscriptionsResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static CookieStoreAppendSubscriptionsResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static CookieStoreAppendSubscriptionsResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            CookieStoreAppendSubscriptionsResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new CookieStoreAppendSubscriptionsResponseParams(elementsOrVersion);
                    {
                        
                    result.success = decoder0.readBoolean(8, 0);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.success, 8, 0);
        }
    }

    static class CookieStoreAppendSubscriptionsResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final CookieStore.AppendSubscriptionsResponse mCallback;

        CookieStoreAppendSubscriptionsResponseParamsForwardToCallback(CookieStore.AppendSubscriptionsResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(APPEND_SUBSCRIPTIONS_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                CookieStoreAppendSubscriptionsResponseParams response = CookieStoreAppendSubscriptionsResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.success);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class CookieStoreAppendSubscriptionsResponseParamsProxyToResponder implements CookieStore.AppendSubscriptionsResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        CookieStoreAppendSubscriptionsResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(Boolean success) {
            CookieStoreAppendSubscriptionsResponseParams _response = new CookieStoreAppendSubscriptionsResponseParams();

            _response.success = success;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    APPEND_SUBSCRIPTIONS_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class CookieStoreGetSubscriptionsParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public long serviceWorkerRegistrationId;

        private CookieStoreGetSubscriptionsParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public CookieStoreGetSubscriptionsParams() {
            this(0);
        }

        public static CookieStoreGetSubscriptionsParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static CookieStoreGetSubscriptionsParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static CookieStoreGetSubscriptionsParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            CookieStoreGetSubscriptionsParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new CookieStoreGetSubscriptionsParams(elementsOrVersion);
                    {
                        
                    result.serviceWorkerRegistrationId = decoder0.readLong(8);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.serviceWorkerRegistrationId, 8);
        }
    }



    
    static final class CookieStoreGetSubscriptionsResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public CookieChangeSubscription[] subscriptions;
        public boolean success;

        private CookieStoreGetSubscriptionsResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public CookieStoreGetSubscriptionsResponseParams() {
            this(0);
        }

        public static CookieStoreGetSubscriptionsResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static CookieStoreGetSubscriptionsResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static CookieStoreGetSubscriptionsResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            CookieStoreGetSubscriptionsResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new CookieStoreGetSubscriptionsResponseParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    {
                        com.vccorp.mojo.bindings.DataHeader si1 = decoder1.readDataHeaderForPointerArray(com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                        result.subscriptions = new CookieChangeSubscription[si1.elementsOrVersion];
                        for (int i1 = 0; i1 < si1.elementsOrVersion; ++i1) {
                            
                            com.vccorp.mojo.bindings.Decoder decoder2 = decoder1.readPointer(com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i1, false);
                            result.subscriptions[i1] = CookieChangeSubscription.decode(decoder2);
                        }
                    }
                    }
                    {
                        
                    result.success = decoder0.readBoolean(16, 0);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            if (this.subscriptions == null) {
                encoder0.encodeNullPointer(8, false);
            } else {
                org.chromium.mojo.bindings.Encoder encoder1 = encoder0.encodePointerArray(this.subscriptions.length, 8, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                for (int i0 = 0; i0 < this.subscriptions.length; ++i0) {
                    
                    encoder1.encode(this.subscriptions[i0], com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i0, false);
                }
            }
            
            encoder0.encode(this.success, 16, 0);
        }
    }

    static class CookieStoreGetSubscriptionsResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final CookieStore.GetSubscriptionsResponse mCallback;

        CookieStoreGetSubscriptionsResponseParamsForwardToCallback(CookieStore.GetSubscriptionsResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(GET_SUBSCRIPTIONS_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                CookieStoreGetSubscriptionsResponseParams response = CookieStoreGetSubscriptionsResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.subscriptions, response.success);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class CookieStoreGetSubscriptionsResponseParamsProxyToResponder implements CookieStore.GetSubscriptionsResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        CookieStoreGetSubscriptionsResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(CookieChangeSubscription[] subscriptions, Boolean success) {
            CookieStoreGetSubscriptionsResponseParams _response = new CookieStoreGetSubscriptionsResponseParams();

            _response.subscriptions = subscriptions;

            _response.success = success;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    GET_SUBSCRIPTIONS_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



}
