package com.vccorp;

import android.app.Application;
import android.content.Intent;

import com.vccorp.base.BuildConfig;
import com.vccorp.base.multidex.ChromiumMultiDexInstaller;

import org.chromium.base.ApplicationStatus;
import org.chromium.base.CommandLine;
import org.chromium.base.ContextUtils;
import org.chromium.base.PathUtils;


public class SHWebViewController {
    public static final String TAG = SHWebViewController.class.getSimpleName();
    public static final String COMMAND_LINE_ARGS_KEY = "commandLineArgs";
    public static final String COMMAND_LINE_FILE = "/data/local/tmp/content-shell-command-line";
    private static final String PRIVATE_DATA_DIRECTORY_SUFFIX = "content_shell";
    private static SHWebViewController shWebViewController;
    private Application myApplication;

    private SHWebViewController(Application application, String appKey, String secretKey, String playerId, String versionName) {
        this.myApplication = application;
        boolean isBrowserProcess = !ContextUtils.getProcessName().contains(":");
        ContextUtils.initApplicationContext(application);
        if (isBrowserProcess) {
            if (BuildConfig.IS_MULTIDEX_ENABLED) {
                ChromiumMultiDexInstaller.install(application);
            }
            PathUtils.setPrivateDataDirectorySuffix(PRIVATE_DATA_DIRECTORY_SUFFIX);
            ApplicationStatus.initialize(application);
        }
        initCommandLine();
//        SecureManager.shareInstance().configKey(appKey, secretKey, playerId, versionName);

    }

    public void initCommandLine() {
        if (!CommandLine.isInitialized()) {
            CommandLine.initFromFile(COMMAND_LINE_FILE);
        }
    }

    public static SHWebViewController initialized(Application application, String appKey,
                                                  String secretKey, String playerId, String versionName) {
        if (shWebViewController == null) {
            shWebViewController = new SHWebViewController(application,appKey,secretKey,playerId,versionName );
        }
        return shWebViewController;
    }

    public static String[] getCommandLineParamsFromIntent(Intent intent) {
        return intent != null ? intent.getStringArrayExtra(COMMAND_LINE_ARGS_KEY) : null;
    }

    public static SHWebViewController shared() {
        return shWebViewController;
    }

    public Application getMyApplication() {
        return myApplication;
    }
}
