/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.ui.resources;

import a.b.a.a;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import org.chromium.base.ContextUtils;
import org.chromium.base.annotations.JNINamespace;

@JNINamespace(value="ui")
public class HandleViewResources {
    public static final float HANDLE_HORIZONTAL_PADDING_RATIO = 0.25f;
    public static final int[] LEFT_HANDLE_ATTRS;
    public static final int[] CENTER_HANDLE_ATTRS;
    public static final int[] RIGHT_HANDLE_ATTRS;
    public static final /* synthetic */ boolean $assertionsDisabled;

    public static Drawable getLeftHandleDrawable(Context context) {
        return HandleViewResources.getHandleDrawable(context, LEFT_HANDLE_ATTRS);
    }

    public static Drawable getCenterHandleDrawable(Context context) {
        return HandleViewResources.getHandleDrawable(context, CENTER_HANDLE_ATTRS);
    }

    public static Drawable getRightHandleDrawable(Context context) {
        return HandleViewResources.getHandleDrawable(context, RIGHT_HANDLE_ATTRS);
    }

    public static Drawable getHandleDrawable(Context context, int[] object) {
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(object);
        object = typedArray;
        Drawable drawable2 = typedArray.getDrawable(0);
        if (drawable2 == null) {
            Resources resources;
            try {
                resources = context.getResources();
            }
            catch (Resources.NotFoundException notFoundException) {}
            context = a.b(resources, object.getResourceId(0, 0));
        }
        context = drawable2;
        object.recycle();
        return context;
    }

    public static Bitmap getHandleBitmap(Context context, int[] nArray) {
        Bitmap bitmap;
        BitmapFactory.Options options;
        if (context == null) {
            context = ContextUtils.sApplicationContext;
        }
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(nArray);
        int n2 = typedArray.getResourceId(typedArray.getIndex(0), 0);
        Resources resources = typedArray.getResources();
        typedArray.recycle();
        typedArray = Bitmap.Config.ARGB_8888;
        BitmapFactory.Options options2 = options;
        options2();
        options2.inJustDecodeBounds = false;
        options.inPreferredConfig = typedArray;
        Bitmap bitmap2 = BitmapFactory.decodeResource((Resources)resources, (int)n2, (BitmapFactory.Options)options);
        if (bitmap2 != null) {
            return bitmap2;
        }
        if (resources != context.getResources() && (bitmap = BitmapFactory.decodeResource((Resources)context.getResources(), (int)n2, (BitmapFactory.Options)options2)) != null) {
            return bitmap;
        }
        context = HandleViewResources.getHandleDrawable(context, nArray);
        if (!$assertionsDisabled && context == null) {
            throw new AssertionError();
        }
        int n3 = context.getIntrinsicWidth();
        n2 = context.getIntrinsicHeight();
        typedArray = Bitmap.createBitmap((int)n3, (int)n2, (Bitmap.Config)typedArray);
        Canvas canvas = new Canvas((Bitmap)typedArray);
        context.setBounds(0, 0, n3, n2);
        context.draw(canvas);
        return typedArray;
    }

    public static float getHandleHorizontalPaddingRatio() {
        return 0.25f;
    }

    public static Bitmap getLeftHandleBitmap(Context context) {
        return HandleViewResources.getHandleBitmap(context, LEFT_HANDLE_ATTRS);
    }

    public static Bitmap getCenterHandleBitmap(Context context) {
        return HandleViewResources.getHandleBitmap(context, CENTER_HANDLE_ATTRS);
    }

    public static Bitmap getRightHandleBitmap(Context context) {
        return HandleViewResources.getHandleBitmap(context, RIGHT_HANDLE_ATTRS);
    }

    static {
        $assertionsDisabled = HandleViewResources.class.desiredAssertionStatus() ^ true;
        LEFT_HANDLE_ATTRS = new int[]{16843461};
        CENTER_HANDLE_ATTRS = new int[]{16843463};
        RIGHT_HANDLE_ATTRS = new int[]{16843462};
    }
}

