/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.ui.events.devices;

import android.hardware.input.InputManager;
import org.chromium.base.ContextUtils;
import org.chromium.base.ThreadUtils;
import org.chromium.base.annotations.JNINamespace;

@JNINamespace(value="ui")
public class InputDeviceObserver
implements InputManager.InputDeviceListener {
    public static final InputDeviceObserver INSTANCE;
    public static final /* synthetic */ boolean $assertionsDisabled;
    public InputManager mInputManager;
    public InputManager.InputDeviceListener mInputDeviceListener;
    public int mObserversCounter;

    public static void addObserver() {
        if (!$assertionsDisabled && !ThreadUtils.runningOnUiThread()) {
            throw new AssertionError();
        }
        INSTANCE.attachObserver();
    }

    public static void removeObserver() {
        if (!$assertionsDisabled && !ThreadUtils.runningOnUiThread()) {
            throw new AssertionError();
        }
        INSTANCE.detachObserver();
    }

    private void attachObserver() {
        if (this.mObserversCounter++ == 0) {
            this.mInputManager = (InputManager)ContextUtils.sApplicationContext.getSystemService("input");
            this.mInputManager.registerInputDeviceListener((InputManager.InputDeviceListener)this, null);
        }
    }

    private void detachObserver() {
        if (!$assertionsDisabled && this.mObserversCounter <= 0) {
            throw new AssertionError();
        }
        if (--this.mObserversCounter == 0) {
            this.mInputManager.unregisterInputDeviceListener((InputManager.InputDeviceListener)this);
            this.mInputManager = null;
        }
    }

    private native void nativeInputConfigurationChanged();

    static {
        $assertionsDisabled = InputDeviceObserver.class.desiredAssertionStatus() ^ true;
        INSTANCE = new InputDeviceObserver();
    }

    public void onInputDeviceChanged(int n2) {
        this.nativeInputConfigurationChanged();
    }

    public void onInputDeviceRemoved(int n2) {
        this.nativeInputConfigurationChanged();
    }

    public void onInputDeviceAdded(int n2) {
        this.nativeInputConfigurationChanged();
    }
}

