/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.ui.base;

import a.b.a.a;
import a.b.p.e.f;
import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.ClipData;
import android.content.ClipDescription;
import android.content.ClipboardManager;
import android.content.Context;
import android.text.Spanned;
import android.text.style.CharacterStyle;
import android.text.style.ParagraphStyle;
import android.text.style.UpdateAppearance;
import com.vccorp.content.R;
import org.chromium.base.BuildInfo;
import org.chromium.base.ContextUtils;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.base.metrics.RecordUserAction;

@JNINamespace(value="ui")
public class Clipboard
implements ClipboardManager.OnPrimaryClipChangedListener {
    @SuppressLint(value={"StaticFieldLeak"})
    public static Clipboard sInstance;
    public final Context mContext;
    public final ClipboardManager mClipboardManager;
    public long mNativeClipboard;

    public static Clipboard getInstance() {
        if (sInstance == null) {
            sInstance = new Clipboard();
        }
        return sInstance;
    }

    public Clipboard() {
        Clipboard clipboard = this;
        this.mContext = ContextUtils.sApplicationContext;
        clipboard.mClipboardManager = (ClipboardManager)this.mContext.getSystemService("clipboard");
        clipboard.mClipboardManager.addPrimaryClipChangedListener((ClipboardManager.OnPrimaryClipChangedListener)this);
    }

    private String getCoercedText() {
        ClipData clipData;
        try {
            clipData = this.mClipboardManager.getPrimaryClip();
        }
        catch (Exception exception) {
            return null;
        }
        return clipData.getItemAt(0).coerceToText(this.mContext).toString();
    }

    private boolean hasStyleSpan(Spanned spanned) {
        Class[] classArray = new Class[3];
        Class[] classArray2 = classArray;
        classArray[0] = CharacterStyle.class;
        classArray[1] = ParagraphStyle.class;
        classArray[2] = UpdateAppearance.class;
        int n2 = classArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Spanned spanned2 = spanned;
            Class clazz = classArray2[i2];
            if (spanned2.nextSpanTransition(-1, spanned2.length(), clazz) >= spanned.length()) continue;
            return true;
        }
        return false;
    }

    private String getHTMLText() {
        try {
            Clipboard clipboard = this;
            return clipboard.clipDataToHtmlText(clipboard.mClipboardManager.getPrimaryClip());
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void setHTMLText(String string2, String string3) {
        this.setPrimaryClipNoException(ClipData.newHtmlText((CharSequence)"html", (CharSequence)string3, (String)string2));
    }

    private void clear() {
        this.setPrimaryClipNoException(ClipData.newPlainText(null, null));
    }

    private void setNativePtr(long l2) {
        this.mNativeClipboard = l2;
    }

    @TargetApi(value=26)
    private void onPrimaryClipTimestampInvalidated() {
        ClipDescription clipDescription = this.mClipboardManager.getPrimaryClipDescription();
        if (clipDescription == null) {
            return;
        }
        Clipboard clipboard = this;
        long l2 = clipDescription.getTimestamp();
        clipboard.nativeOnPrimaryClipTimestampInvalidated(clipboard.mNativeClipboard, l2);
    }

    private native void nativeOnPrimaryClipChanged(long var1);

    private native void nativeOnPrimaryClipTimestampInvalidated(long var1, long var3);

    public String clipDataToHtmlText(ClipData object) {
        ClipDescription clipDescription = object.getDescription();
        if (clipDescription.hasMimeType("text/html")) {
            return object.getItemAt(0).getHtmlText();
        }
        if (clipDescription.hasMimeType("text/plain")) {
            if (!((object = object.getItemAt(0).getText()) instanceof Spanned)) {
                return null;
            }
            if (this.hasStyleSpan((Spanned)(this = (Spanned)object))) {
                return a.a((Spanned)this, 0);
            }
        }
        return null;
    }

    public void setText(String string2) {
        this.setPrimaryClipNoException(ClipData.newPlainText((CharSequence)"text", (CharSequence)string2));
    }

    public void setPrimaryClipNoException(ClipData clipData) {
        try {
            ((Clipboard)((Object)string2)).mClipboardManager.setPrimaryClip(clipData);
        }
        catch (Exception exception) {
            Clipboard clipboard = string2;
            String string2 = clipboard.mContext.getString(R.string.copy_to_clipboard_failure_message);
            f.a((Context)clipboard.mContext, (CharSequence)string2, (int)0).a.show();
        }
    }

    public void onPrimaryClipChanged() {
        RecordUserAction.record("MobileClipboardChanged");
        long l2 = this.mNativeClipboard;
        if (l2 != 0L) {
            this.nativeOnPrimaryClipChanged(l2);
        }
    }

    public void copyUrlToClipboard(String string2) {
        Clipboard clipboard = clipboard2;
        Clipboard clipboard2 = ClipData.newPlainText((CharSequence)"url", (CharSequence)string2);
        clipboard.mClipboardManager.setPrimaryClip((ClipData)clipboard2);
        Context context = clipboard.mContext;
        int n2 = R.string.url_copied;
        int n3 = 0;
        f.a((Context)context, (CharSequence)context.getResources().getText((int)n2), (int)n3).a.show();
    }

    public void onWindowFocusChanged(boolean bl) {
        if (this.mNativeClipboard != 0L && bl && BuildInfo.isAtLeastQ()) {
            this.onPrimaryClipTimestampInvalidated();
            return;
        }
    }
}

