/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.net;

import a.b.a.j;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import org.chromium.base.annotations.JNINamespace;

@JNINamespace(value="net::android")
public class AndroidKeyStore {
    public static final String TAG = "AndroidKeyStore";

    public static String getPrivateKeyClassName(PrivateKey privateKey) {
        return privateKey.getClass().getName();
    }

    public static boolean privateKeySupportsSignature(PrivateKey privateKey, String string2) {
        try {
            Signature.getInstance(string2).initSign(privateKey);
            return true;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[]{};
            j.b(TAG, "Exception while checking support for " + string2 + ": " + exception, objectArray);
            return false;
        }
        catch (InvalidKeyException invalidKeyException) {
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
        return false;
    }

    public static boolean privateKeySupportsCipher(PrivateKey privateKey, String string2) {
        Cipher cipher = Cipher.getInstance(string2);
        try {
            cipher.init(1, privateKey);
            return true;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[]{};
            j.b(TAG, "Exception while checking support for " + string2 + ": " + exception, objectArray);
            return false;
        }
        catch (InvalidKeyException invalidKeyException) {
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
        return false;
    }

    public static byte[] signWithPrivateKey(PrivateKey objectArray, String string2, byte[] byArray) {
        Signature signature;
        Signature signature2;
        Signature signature3;
        try {
            Signature signature4 = Signature.getInstance(string2);
            signature3 = signature4;
            signature2 = signature4;
            signature = signature4;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            objectArray = new Object[]{};
            j.b(TAG, "Signature algorithm " + string2 + " not supported: " + noSuchAlgorithmException, objectArray);
            return null;
        }
        try {
            signature2.initSign((PrivateKey)objectArray);
            signature.update(byArray);
            return signature3.sign();
        }
        catch (Exception exception) {
            String string3 = "Exception while signing message with " + string2 + " and " + objectArray.getAlgorithm() + " private key (" + objectArray.getClass().getName() + "): " + exception;
            objectArray = new Object[]{};
            j.b(TAG, string3, objectArray);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] encryptWithPrivateKey(PrivateKey objectArray, String string2, byte[] byArray) {
        Object[] objectArray2;
        block5: {
            Cipher cipher;
            Cipher cipher2;
            try {
                Cipher cipher3 = Cipher.getInstance(string2);
                cipher2 = cipher3;
                cipher = cipher3;
            }
            catch (NoSuchPaddingException noSuchPaddingException) {
                break block5;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
                break block5;
            }
            try {
                cipher2.init(1, (Key)objectArray);
                return cipher.doFinal(byArray);
            }
            catch (Exception exception) {
                String string3 = "Exception while encrypting input with " + string2 + " and " + objectArray.getAlgorithm() + " private key (" + objectArray.getClass().getName() + "): " + exception;
                objectArray = new Object[]{};
                j.b(TAG, string3, objectArray);
                return null;
            }
        }
        String string4 = "Cipher " + string2 + " not supported: " + objectArray2;
        objectArray2 = new Object[]{};
        j.b(TAG, string4, objectArray2);
        return null;
    }
}

