/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.media;

import a.b.a.j;
import android.os.Build;
import org.chromium.base.ContextUtils;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.media.VideoCapture;
import org.chromium.media.VideoCaptureCamera;
import org.chromium.media.VideoCaptureCamera2;
import org.chromium.media.VideoCaptureFormat;

@JNINamespace(value="media")
public class VideoCaptureFactory {
    public static boolean isLReleaseOrLater() {
        return Build.VERSION.SDK_INT >= 21;
    }

    public static boolean isLegacyOrDeprecatedDevice(int n2) {
        return !VideoCaptureFactory.isLReleaseOrLater() || VideoCaptureCamera2.isLegacyDevice(n2);
    }

    public static VideoCapture createVideoCapture(int n2, long l2) {
        if (VideoCaptureFactory.isLegacyOrDeprecatedDevice(n2)) {
            return new VideoCaptureCamera(n2, l2);
        }
        return new VideoCaptureCamera2(n2, l2);
    }

    public static int getNumberOfCameras() {
        return ChromiumCameraInfo.getNumberOfCameras();
    }

    public static int getCaptureApiType(int n2) {
        if (VideoCaptureFactory.isLegacyOrDeprecatedDevice(n2)) {
            return VideoCaptureCamera.getCaptureApiType(n2);
        }
        return VideoCaptureCamera2.getCaptureApiType(n2);
    }

    public static int getFacingMode(int n2) {
        if (VideoCaptureFactory.isLegacyOrDeprecatedDevice(n2)) {
            return VideoCaptureCamera.getFacingMode(n2);
        }
        return VideoCaptureCamera2.getFacingMode(n2);
    }

    public static String getDeviceName(int n2) {
        if (VideoCaptureFactory.isLegacyOrDeprecatedDevice(n2)) {
            return VideoCaptureCamera.getName(n2);
        }
        return VideoCaptureCamera2.getName(n2);
    }

    public static VideoCaptureFormat[] getDeviceSupportedFormats(int n2) {
        if (VideoCaptureFactory.isLegacyOrDeprecatedDevice(n2)) {
            return VideoCaptureCamera.getDeviceSupportedFormats(n2);
        }
        return VideoCaptureCamera2.getDeviceSupportedFormats(n2);
    }

    public static int getCaptureFormatWidth(VideoCaptureFormat videoCaptureFormat) {
        return videoCaptureFormat.getWidth();
    }

    public static int getCaptureFormatHeight(VideoCaptureFormat videoCaptureFormat) {
        return videoCaptureFormat.getHeight();
    }

    public static int getCaptureFormatFramerate(VideoCaptureFormat videoCaptureFormat) {
        return videoCaptureFormat.getFramerate();
    }

    public static int getCaptureFormatPixelFormat(VideoCaptureFormat videoCaptureFormat) {
        return videoCaptureFormat.getPixelFormat();
    }

    public static /* synthetic */ boolean access$000() {
        return VideoCaptureFactory.isLReleaseOrLater();
    }

    public static class ChromiumCameraInfo {
        public static int sNumberOfSystemCameras = -1;
        public static final String TAG = "cr.media";

        public static int getNumberOfCameras() {
            if (sNumberOfSystemCameras == -1) {
                if (Build.VERSION.SDK_INT < 23 && ContextUtils.sApplicationContext.getPackageManager().checkPermission("android.permission.CAMERA", ContextUtils.sApplicationContext.getPackageName()) != 0) {
                    sNumberOfSystemCameras = 0;
                    Object[] objectArray = new Object[]{};
                    j.d(TAG, "Missing android.permission.CAMERA permission, no system camera available.", objectArray);
                } else {
                    sNumberOfSystemCameras = VideoCaptureFactory.isLReleaseOrLater() ? VideoCaptureCamera2.getNumberOfCameras() : VideoCaptureCamera.getNumberOfCameras();
                }
            }
            return sNumberOfSystemCameras;
        }

        public static /* synthetic */ int access$100() {
            return ChromiumCameraInfo.getNumberOfCameras();
        }
    }
}

