/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.media;

import a.a.a.a.a;
import a.b.a.j;
import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.media.DeniedByServerException;
import android.media.MediaCrypto;
import android.media.MediaCryptoException;
import android.media.MediaDrm;
import android.media.MediaDrmException;
import android.media.NotProvisionedException;
import android.media.UnsupportedSchemeException;
import android.os.Build;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.UUID;
import org.chromium.base.Callback;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.base.annotations.MainDex;
import org.chromium.media.MediaDrmSessionManager;
import org.chromium.media.MediaDrmStorageBridge;

@JNINamespace(value="media")
@MainDex
@SuppressLint(value={"WrongConstant"})
@TargetApi(value=19)
public class MediaDrmBridge {
    public static final String TAG = "cr_media";
    public static final String SECURITY_LEVEL = "securityLevel";
    public static final String SERVER_CERTIFICATE = "serviceCertificate";
    public static final String ORIGIN = "origin";
    public static final String PRIVACY_MODE = "privacyMode";
    public static final String SESSION_SHARING = "sessionSharing";
    public static final String ENABLE = "enable";
    public static final long INVALID_NATIVE_MEDIA_DRM_BRIDGE = 0L;
    public static final String FIRST_API_LEVEL = "ro.product.first_api_level";
    public static final UUID WIDEVINE_UUID;
    public static final byte[] DUMMY_KEY_ID;
    public static final byte[] UNPROVISION;
    public static final MediaCryptoDeferrer sMediaCryptoDeferrer;
    public static final /* synthetic */ boolean $assertionsDisabled;
    public MediaDrm mMediaDrm;
    public MediaCrypto mMediaCrypto;
    public long mNativeMediaDrmBridge;
    public UUID mSchemeUUID;
    public final boolean mRequiresMediaCrypto;
    public MediaDrmSessionManager.SessionId mMediaCryptoSession;
    public MediaDrmSessionManager mSessionManager;
    public MediaDrmStorageBridge mStorage;
    public boolean mProvisioningPending;
    public boolean mOriginSet;
    public SessionEventDeferrer mSessionEventDeferrer;

    public static List<KeyStatus> getDummyKeysInfo(int n2) {
        ArrayList<KeyStatus> arrayList = new ArrayList<KeyStatus>();
        arrayList.add(new KeyStatus(DUMMY_KEY_ID, n2, null));
        return arrayList;
    }

    public static UUID getUUIDFromBytes(byte[] byArray) {
        int n2;
        if (byArray.length != 16) {
            return null;
        }
        long l2 = 0L;
        long l3 = 0L;
        for (n2 = 0; n2 < 8; ++n2) {
            l2 = l2 << 8 | (long)(byArray[n2] & 0xFF);
        }
        for (n2 = 8; n2 < 16; ++n2) {
            l3 = l3 << 8 | (long)(byArray[n2] & 0xFF);
        }
        return new UUID(l2, l3);
    }

    private boolean isNativeMediaDrmBridgeValid() {
        return this.mNativeMediaDrmBridge != 0L;
    }

    private boolean isWidevine() {
        return this.mSchemeUUID.equals(WIDEVINE_UUID);
    }

    @TargetApi(value=23)
    public MediaDrmBridge(UUID uUID, boolean bl, long l2, long l3) {
        MediaDrmBridge mediaDrmBridge = this;
        mediaDrmBridge.mSchemeUUID = uUID;
        mediaDrmBridge.mMediaDrm = new MediaDrm(uUID);
        this.mRequiresMediaCrypto = bl;
        this.mNativeMediaDrmBridge = l2;
        if (!$assertionsDisabled && !this.isNativeMediaDrmBridgeValid()) {
            throw new AssertionError();
        }
        this.mStorage = new MediaDrmStorageBridge(l3);
        this.mSessionManager = new MediaDrmSessionManager(this.mStorage);
        this.mProvisioningPending = false;
        this.mMediaDrm.setOnEventListener((MediaDrm.OnEventListener)new EventListener(null));
        if (Build.VERSION.SDK_INT >= 23) {
            MediaDrmBridge mediaDrmBridge2 = this;
            mediaDrmBridge2.mMediaDrm.setOnExpirationUpdateListener((MediaDrm.OnExpirationUpdateListener)new ExpirationUpdateListener(null), null);
            mediaDrmBridge2.mMediaDrm.setOnKeyStatusChangeListener((MediaDrm.OnKeyStatusChangeListener)new KeyStatusChangeListener(null), null);
        }
        if (this.isWidevine()) {
            MediaDrmBridge mediaDrmBridge3 = this;
            mediaDrmBridge3.mMediaDrm.setPropertyString(PRIVACY_MODE, ENABLE);
            mediaDrmBridge3.mMediaDrm.setPropertyString(SESSION_SHARING, ENABLE);
        }
    }

    private boolean createMediaCrypto() {
        block12: {
            Object object;
            block11: {
                if (!$assertionsDisabled && objectArray.mMediaDrm == null) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && objectArray.mProvisioningPending) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && objectArray.mMediaCryptoSession != null) {
                    throw new AssertionError();
                }
                try {
                    object = objectArray.openSession();
                    if (object != null) break block11;
                }
                catch (NotProvisionedException notProvisionedException) {
                    j.a(TAG, "Not provisioned during openSession()");
                    if (!sMediaCryptoDeferrer.isProvisioning()) {
                        super.startProvisioning();
                        return true;
                    }
                    j.a(TAG, "defer CreateMediaCrypto() calls");
                    sMediaCryptoDeferrer.defer(new Runnable(){

                        @Override
                        public void run() {
                            MediaDrmBridge.this.createMediaCrypto();
                        }
                    });
                    return true;
                }
                Object[] objectArray = new Object[]{};
                j.b(TAG, "Cannot create MediaCrypto Session.", objectArray);
                return false;
            }
            objectArray.mMediaCryptoSession = MediaDrmSessionManager.SessionId.createTemporarySessionId(object);
            object = objectArray.mMediaCryptoSession.toHexString();
            j.a(TAG, "MediaCrypto Session created: %s", object);
            if (!MediaCrypto.isCryptoSchemeSupported((UUID)objectArray.mSchemeUUID)) break block12;
            Object[] objectArray = objectArray;
            Object[] objectArray2 = objectArray;
            objectArray.mMediaCrypto = new MediaCrypto(objectArray.mSchemeUUID, objectArray.mMediaCryptoSession.drmId());
            j.a(TAG, "MediaCrypto successfully created!");
            super.onMediaCryptoReady(objectArray2.mMediaCrypto);
            return true;
        }
        try {
            j.b(TAG, "Cannot create MediaCrypto for unsupported scheme.", new Object[0]);
        }
        catch (MediaCryptoException mediaCryptoException) {
            Object[] objectArray = new Object[1];
            Object[] objectArray3 = objectArray;
            objectArray[0] = mediaCryptoException;
            j.b(TAG, "Cannot create MediaCrypto", objectArray3);
        }
        super.release();
        return false;
    }

    private byte[] openSession() {
        Object[] objectArray;
        if (!$assertionsDisabled && objectArray.mMediaDrm == null) {
            throw new AssertionError();
        }
        try {
            return (byte[])objectArray.mMediaDrm.openSession().clone();
        }
        catch (MediaDrmException mediaDrmException) {
            Object[] objectArray2 = objectArray;
            Object[] objectArray3 = new Object[1];
            objectArray = objectArray3;
            objectArray3[0] = mediaDrmException;
            j.b(TAG, "Cannot open a new session", objectArray);
            super.release();
            return null;
        }
        catch (NotProvisionedException notProvisionedException) {
            throw notProvisionedException;
        }
        catch (RuntimeException runtimeException) {
            Object[] objectArray4 = objectArray;
            Object[] objectArray5 = new Object[1];
            objectArray = objectArray5;
            objectArray5[0] = runtimeException;
            j.b(TAG, "Cannot open a new session", objectArray);
            super.release();
            return null;
        }
    }

    public static boolean isCryptoSchemeSupported(byte[] object, String string2) {
        object = MediaDrmBridge.getUUIDFromBytes(object);
        if (string2.isEmpty()) {
            return MediaDrm.isCryptoSchemeSupported((UUID)object);
        }
        return MediaDrm.isCryptoSchemeSupported((UUID)object, (String)string2);
    }

    public static int getFirstApiLevel() {
        int n2;
        Class<?> clazz = Class.forName("android.os.SystemProperties");
        Class[] classArray = new Class[2];
        classArray[0] = String.class;
        classArray[1] = Integer.TYPE;
        Method method = clazz.getMethod("getInt", classArray);
        Object[] objectArray = new Object[2];
        objectArray[0] = FIRST_API_LEVEL;
        try {
            objectArray[1] = 0;
            n2 = (Integer)method.invoke(null, objectArray);
        }
        catch (Exception exception) {
            Object[] objectArray2 = new Object[1];
            Object[] objectArray3 = objectArray2;
            objectArray2[0] = exception;
            j.b("Exception while getting system property %s. Using default.", FIRST_API_LEVEL, objectArray3);
            n2 = 0;
        }
        return n2;
    }

    public static MediaDrmBridge create(byte[] object, String objectArray, String string2, boolean bl, long l2, long l3) {
        UUID uUID = MediaDrmBridge.getUUIDFromBytes(object);
        object = uUID;
        if (uUID != null && MediaDrm.isCryptoSchemeSupported((UUID)object)) {
            MediaDrmBridge mediaDrmBridge;
            try {
                MediaDrmBridge mediaDrmBridge2;
                mediaDrmBridge = mediaDrmBridge2;
                mediaDrmBridge2 = new MediaDrmBridge((UUID)object, bl, l2, l3);
            }
            catch (IllegalStateException illegalStateException) {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = illegalStateException;
                j.b(TAG, "Failed to create MediaDrmBridge", objectArray);
                return null;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Object[] objectArray3 = new Object[1];
                objectArray = objectArray3;
                objectArray3[0] = illegalArgumentException;
                j.b(TAG, "Failed to create MediaDrmBridge", objectArray);
                return null;
            }
            catch (UnsupportedSchemeException unsupportedSchemeException) {
                Object[] objectArray4 = new Object[1];
                objectArray = objectArray4;
                objectArray4[0] = unsupportedSchemeException;
                j.b(TAG, "Unsupported DRM scheme", objectArray);
                return null;
            }
            if (!string2.isEmpty() && !mediaDrmBridge.setSecurityLevel(string2)) {
                return null;
            }
            if (!objectArray.isEmpty() && !mediaDrmBridge.setOrigin((String)objectArray)) {
                return null;
            }
            if (bl && !mediaDrmBridge.createMediaCrypto()) {
                return null;
            }
            return mediaDrmBridge;
        }
        return null;
    }

    private boolean setOrigin(String string2) {
        if (!$assertionsDisabled && Build.VERSION.SDK_INT < 23) {
            throw new AssertionError();
        }
        if (!this.isWidevine()) {
            j.a(TAG, "Property origin isn't supported");
            return true;
        }
        if (!$assertionsDisabled && this.mMediaDrm == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && string2.isEmpty()) {
            throw new AssertionError();
        }
        MediaDrmBridge mediaDrmBridge = this;
        MediaDrmBridge mediaDrmBridge2 = mediaDrmBridge;
        MediaDrm mediaDrm = mediaDrmBridge.mMediaDrm;
        mediaDrm.setPropertyString(ORIGIN, string2);
        try {
            mediaDrmBridge2.mOriginSet = true;
            return true;
        }
        catch (IllegalStateException illegalStateException) {
            Object[] objectArray = new Object[2];
            Object[] objectArray2 = objectArray;
            objectArray[0] = string2;
            objectArray[1] = illegalStateException;
            j.b(TAG, "Failed to set security origin %s", objectArray2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Object[] objectArray = new Object[2];
            Object[] objectArray3 = objectArray;
            objectArray[0] = string2;
            objectArray[1] = illegalArgumentException;
            j.b(TAG, "Failed to set security origin %s", objectArray3);
        }
        Object[] objectArray = new Object[1];
        Object[] objectArray4 = objectArray;
        objectArray[0] = string2;
        j.b(TAG, "Security origin %s not supported!", objectArray4);
        return false;
    }

    private boolean setSecurityLevel(String string2) {
        if (!this.isWidevine()) {
            j.a(TAG, "Security level is not supported.");
            return true;
        }
        if (!$assertionsDisabled && this.mMediaDrm == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && string2.isEmpty()) {
            throw new AssertionError();
        }
        Object[] objectArray = this.mMediaDrm.getPropertyString(SECURITY_LEVEL);
        Object[] objectArray2 = new Object[2];
        Object[] objectArray3 = objectArray2;
        objectArray2[0] = objectArray;
        objectArray2[1] = string2;
        j.c(TAG, "Security level: current %s, new %s", objectArray3);
        if (string2.equals(objectArray)) {
            return true;
        }
        MediaDrm mediaDrm = this.mMediaDrm;
        try {
            mediaDrm.setPropertyString(SECURITY_LEVEL, string2);
            return true;
        }
        catch (IllegalStateException illegalStateException) {
            Object[] objectArray4 = new Object[2];
            objectArray = objectArray4;
            objectArray4[0] = string2;
            objectArray4[1] = illegalStateException;
            j.b(TAG, "Failed to set security level %s", objectArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Object[] objectArray5 = new Object[2];
            objectArray = objectArray5;
            objectArray5[0] = string2;
            objectArray5[1] = illegalArgumentException;
            j.b(TAG, "Failed to set security level %s", objectArray);
        }
        Object[] objectArray6 = new Object[1];
        Object[] objectArray7 = objectArray6;
        objectArray6[0] = string2;
        j.b(TAG, "Security level %s not supported!", objectArray7);
        return false;
    }

    private boolean setServerCertificate(byte[] objectArray) {
        if (!this.isWidevine()) {
            j.a(TAG, "Setting server certificate is not supported.");
            return true;
        }
        MediaDrm mediaDrm = this.mMediaDrm;
        try {
            mediaDrm.setPropertyByteArray(SERVER_CERTIFICATE, objectArray);
            return true;
        }
        catch (IllegalStateException illegalStateException) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = illegalStateException;
            j.b(TAG, "Failed to set server certificate", objectArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Object[] objectArray3 = new Object[1];
            objectArray = objectArray3;
            objectArray3[0] = illegalArgumentException;
            j.b(TAG, "Failed to set server certificate", objectArray);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void provision() {
        if (!$assertionsDisabled) {
            if (objectArray.mMediaDrm == null) throw new AssertionError();
        }
        if (!$assertionsDisabled) {
            if (objectArray.mProvisioningPending) throw new AssertionError();
        }
        if (!$assertionsDisabled) {
            if (objectArray.mRequiresMediaCrypto) throw new AssertionError();
        }
        if (!objectArray.mOriginSet) {
            Object[] objectArray = new Object[]{};
            j.b(TAG, "Calling provision() without an origin.", objectArray);
            super.nativeOnProvisioningComplete(objectArray.mNativeMediaDrmBridge, false);
            return;
        }
        try {
            byte[] byArray = objectArray.openSession();
            if (byArray != null) {
                super.closeSessionNoException(MediaDrmSessionManager.SessionId.createTemporarySessionId(byArray));
            }
            super.nativeOnProvisioningComplete(objectArray.mNativeMediaDrmBridge, true);
            return;
        }
        catch (NotProvisionedException notProvisionedException) {
            super.startProvisioning();
        }
    }

    private void unprovision() {
        if (this.mMediaDrm == null) {
            return;
        }
        if (!this.mOriginSet) {
            return;
        }
        this.provideProvisionResponse(UNPROVISION);
    }

    private void destroy() {
        this.mNativeMediaDrmBridge = 0L;
        if (this.mMediaDrm != null) {
            this.release();
        }
    }

    private void release() {
        if (!$assertionsDisabled && this.mMediaDrm == null) {
            throw new AssertionError();
        }
        for (MediaDrmSessionManager.SessionId sessionId : this.mSessionManager.getAllSessionIds()) {
            try {
                this.mMediaDrm.removeKeys(sessionId.drmId());
            }
            catch (Exception exception) {
                Object[] objectArray = new Object[1];
                Object[] objectArray2 = objectArray;
                objectArray[0] = exception;
                j.b(TAG, "removeKeys failed: ", objectArray2);
            }
            this.closeSessionNoException(sessionId);
            this.onSessionClosed(sessionId);
        }
        this.mSessionManager = new MediaDrmSessionManager(this.mStorage);
        Object object = this.mMediaCryptoSession;
        if (object != null) {
            this.closeSessionNoException((MediaDrmSessionManager.SessionId)object);
            this.mMediaCryptoSession = null;
        }
        if ((object = this.mMediaDrm) != null) {
            object.release();
            this.mMediaDrm = null;
        }
        if ((object = this.mMediaCrypto) != null) {
            object.release();
            this.mMediaCrypto = null;
        } else {
            this.onMediaCryptoReady(null);
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private MediaDrm.KeyRequest getKeyRequest(MediaDrmSessionManager.SessionId var1_2, byte[] var2_3, String var3_4, int var4_5, HashMap<String, String> var5_6) {
        block8: {
            if (!MediaDrmBridge.$assertionsDisabled && this.mMediaDrm == null) {
                throw new AssertionError();
            }
            if (!MediaDrmBridge.$assertionsDisabled && this.mMediaCryptoSession == null) {
                throw new AssertionError();
            }
            if (!MediaDrmBridge.$assertionsDisabled && this.mProvisioningPending) {
                throw new AssertionError();
            }
            if (var5_6 == null) {
                var5_6 = v0;
                v0 = new HashMap<K, V>();
            }
            var6_7 = null;
            if (var4_5 != 3) ** GOTO lbl15
            var1_2 = var1_2.keySetId();
            break block8;
lbl15:
            // 1 sources

            var1_2 = var1_2.drmId();
        }
        if (MediaDrmBridge.$assertionsDisabled || var1_2 != null) ** GOTO lbl20
        try {
            throw new AssertionError();
lbl20:
            // 1 sources

            this = this.mMediaDrm.getKeyRequest((byte[])var1_2, var2_3, var3_4, var4_5, var5_6);
        }
        catch (IllegalStateException var0_1) {
            if (Build.VERSION.SDK_INT >= 21 && var0_1 instanceof MediaDrm.MediaDrmStateException) {
                v1 = new Object[1];
                var1_2 = v1;
                v1[0] = var0_1;
                j.b("cr_media", "MediaDrmStateException fired during getKeyRequest().", var1_2);
            }
            this = var6_7;
        }
        var1_2 = this != null ? "successed" : "failed";
        j.a("cr_media", "getKeyRequest %s!", (Object)var1_2);
        return this;
    }

    private void createSessionFromNative(byte[] byArray, String string2, int n2, String[] stringArray, long l2) {
        HashMap<String, String> hashMap;
        HashMap<String, String> hashMap2 = hashMap;
        hashMap = new HashMap<String, String>();
        if (stringArray != null) {
            if (stringArray.length % 2 == 0) {
                for (int i2 = 0; i2 < stringArray.length; i2 += 2) {
                    hashMap2.put(stringArray[i2], stringArray[i2 + 1]);
                }
            } else {
                throw new IllegalArgumentException("Additional data array doesn't have equal keys/values");
            }
        }
        this.createSession(byArray, string2, n2, hashMap2, l2);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void createSession(byte[] object, String objectArray, int n2, HashMap<String, String> hashMap, long l2) {
        void var1_4;
        Object object2;
        boolean bl;
        block12: {
            j.a(TAG, "createSession()");
            if (objectArray3.mMediaDrm == null) {
                Object[] objectArray2 = objectArray3;
                Object[] objectArray3 = new Object[]{};
                j.b(TAG, "createSession() called when MediaDrm is null.", objectArray3);
                super.onPromiseRejected(l2, "MediaDrm released previously.");
                return;
            }
            if (!$assertionsDisabled) {
                if (objectArray3.mMediaCryptoSession == null) throw new AssertionError();
            }
            if (!$assertionsDisabled) {
                if (objectArray3.mProvisioningPending) throw new AssertionError();
            }
            bl = false;
            Object var8_10 = null;
            try {
                object2 = super.openSession();
                if (object2 == null) {
                    super.onPromiseRejected(l2, "Open session failed.");
                    return;
                }
                bl = true;
                if (!$assertionsDisabled && n2 != 1) {
                    if (n2 != 2) throw new AssertionError();
                }
                object2 = n2 == 2 ? (Object)MediaDrmSessionManager.SessionId.createPersistentSessionId((byte[])object2) : (Object)MediaDrmSessionManager.SessionId.createTemporarySessionId((byte[])object2);
            }
            catch (NotProvisionedException notProvisionedException) {
                object2 = var8_10;
                break block12;
            }
            try {
                MediaDrm.KeyRequest keyRequest = super.getKeyRequest((MediaDrmSessionManager.SessionId)object2, (byte[])object, (String)objectArray, n2, hashMap);
                object = keyRequest;
                if (keyRequest == null) {
                    super.closeSessionNoException((MediaDrmSessionManager.SessionId)object2);
                    super.onPromiseRejected(l2, "Generate request failed.");
                    return;
                }
                j.a(TAG, "createSession(): Session (%s) created.", (Object)((MediaDrmSessionManager.SessionId)object2).toHexString());
                if (super.isNativeMediaDrmBridgeValid()) {
                    super.nativeOnPromiseResolvedWithSession(objectArray3.mNativeMediaDrmBridge, l2, ((MediaDrmSessionManager.SessionId)object2).emeId());
                }
                super.onSessionMessage((MediaDrmSessionManager.SessionId)object2, (MediaDrm.KeyRequest)object);
                objectArray3.mSessionManager.put((MediaDrmSessionManager.SessionId)object2, (String)objectArray, n2);
                return;
            }
            catch (NotProvisionedException notProvisionedException) {}
        }
        Object[] objectArray4 = new Object[1];
        objectArray = objectArray4;
        objectArray4[0] = var1_4;
        j.b(TAG, "Device not provisioned", objectArray);
        if (bl) {
            super.closeSessionNoException((MediaDrmSessionManager.SessionId)object2);
        }
        super.onPromiseRejected(l2, "Device not provisioned during createSession().");
    }

    private MediaDrmSessionManager.SessionId getSessionIdByEmeId(byte[] object) {
        if (objectArray.mMediaCryptoSession == null) {
            Object[] objectArray = new Object[]{};
            j.b(TAG, "Session doesn't exist because media crypto session is not created.", objectArray);
            return null;
        }
        MediaDrmSessionManager.SessionId sessionId = objectArray.mSessionManager.getSessionIdByEmeId((byte[])object);
        object = sessionId;
        if (sessionId == null) {
            return null;
        }
        if (!$assertionsDisabled && objectArray.mMediaCryptoSession.isEqual((MediaDrmSessionManager.SessionId)object)) {
            throw new AssertionError();
        }
        return object;
    }

    private MediaDrmSessionManager.SessionId getSessionIdByDrmId(byte[] object) {
        if (objectArray.mMediaCryptoSession == null) {
            Object[] objectArray = new Object[]{};
            j.b(TAG, "Session doesn't exist because media crypto session is not created.", objectArray);
            return null;
        }
        MediaDrmSessionManager.SessionId sessionId = objectArray.mSessionManager.getSessionIdByDrmId((byte[])object);
        object = sessionId;
        if (sessionId == null) {
            return null;
        }
        if (!$assertionsDisabled && objectArray.mMediaCryptoSession.isEqual((MediaDrmSessionManager.SessionId)object)) {
            throw new AssertionError();
        }
        return object;
    }

    private void closeSession(byte[] byArray, long l2) {
        j.a(TAG, "closeSession()");
        if (((MediaDrmBridge)((Object)string2)).mMediaDrm == null) {
            ((MediaDrmBridge)((Object)string2)).onPromiseRejected(l2, "closeSession() called when MediaDrm is null.");
            return;
        }
        MediaDrmSessionManager.SessionId sessionId = ((MediaDrmBridge)((Object)string2)).getSessionIdByEmeId(byArray);
        if (sessionId == null) {
            ((MediaDrmBridge)((Object)string2)).onPromiseRejected(l2, a.a("Invalid sessionId in closeSession(): ").append(MediaDrmSessionManager.SessionId.toHexString(byArray)).toString());
            return;
        }
        try {
            ((MediaDrmBridge)((Object)string2)).mMediaDrm.removeKeys(sessionId.drmId());
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = exception;
            j.b(TAG, "removeKeys failed: ", objectArray2);
        }
        MediaDrmBridge mediaDrmBridge = string2;
        mediaDrmBridge.closeSessionNoException(sessionId);
        mediaDrmBridge.mSessionManager.remove(sessionId);
        if (mediaDrmBridge.isNativeMediaDrmBridgeValid()) {
            MediaDrmBridge mediaDrmBridge2 = string2;
            mediaDrmBridge2.nativeOnPromiseResolved(mediaDrmBridge2.mNativeMediaDrmBridge, l2);
        }
        if (((MediaDrmBridge)((Object)string2)).isNativeMediaDrmBridgeValid()) {
            MediaDrmBridge mediaDrmBridge3 = string2;
            mediaDrmBridge3.nativeOnSessionClosed(mediaDrmBridge3.mNativeMediaDrmBridge, sessionId.emeId());
        }
        String string2 = sessionId.toHexString();
        j.a(TAG, "Session %s closed", (Object)string2);
    }

    private void closeSessionNoException(MediaDrmSessionManager.SessionId objectArray) {
        try {
            this.mMediaDrm.closeSession(objectArray.drmId());
        }
        catch (Exception exception) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = exception;
            j.b(TAG, "closeSession failed: ", objectArray);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateSession(byte[] object, byte[] object2, long l2) {
        j.a(TAG, "updateSession()");
        if (this.mMediaDrm == null) {
            this.onPromiseRejected(l2, "updateSession() called when MediaDrm is null.");
            return;
        }
        MediaDrmSessionManager.SessionId sessionId = this.getSessionIdByEmeId((byte[])object);
        if (sessionId == null) {
            if (!$assertionsDisabled) throw new AssertionError();
            this.onPromiseRejected(l2, a.a("Invalid session in updateSession: ").append(MediaDrmSessionManager.SessionId.toHexString((byte[])object)).toString());
            return;
        }
        try {
            KeyUpdatedCallback keyUpdatedCallback;
            object = this.mSessionManager.get(sessionId);
            boolean bl = ((MediaDrmSessionManager.SessionInfo)object).keyType() == 3;
            byte[] byArray = null;
            if (bl) {
                j.a(TAG, "updateSession() for key release");
                if (!$assertionsDisabled) {
                    if (sessionId.keySetId() == null) throw new AssertionError();
                }
                this.mMediaDrm.provideKeyResponse(sessionId.keySetId(), (byte[])object2);
            } else {
                byArray = this.mMediaDrm.provideKeyResponse(sessionId.drmId(), (byte[])object2);
            }
            object2 = keyUpdatedCallback;
            keyUpdatedCallback = new KeyUpdatedCallback(sessionId, l2, bl);
            if (bl) {
                this.mSessionManager.clearPersistentSessionInfo(sessionId, (Callback<Boolean>)object2);
                return;
            }
            if (((MediaDrmSessionManager.SessionInfo)object).keyType() == 2 && byArray != null && byArray.length > 0) {
                this.mSessionManager.setKeySetId(sessionId, byArray, (Callback<Boolean>)object2);
                return;
            }
            ((KeyUpdatedCallback)object2).onResult(true);
            return;
        }
        catch (IllegalStateException illegalStateException) {
            Object[] objectArray = new Object[1];
            object2 = objectArray;
            objectArray[0] = illegalStateException;
            j.b(TAG, "failed to provide key response", (Object[])object2);
        }
        catch (DeniedByServerException deniedByServerException) {
            Object[] objectArray = new Object[1];
            object2 = objectArray;
            objectArray[0] = deniedByServerException;
            j.b(TAG, "failed to provide key response", (Object[])object2);
        }
        catch (NotProvisionedException notProvisionedException) {
            Object[] objectArray = new Object[1];
            object2 = objectArray;
            objectArray[0] = notProvisionedException;
            j.b(TAG, "failed to provide key response", (Object[])object2);
        }
        MediaDrmBridge mediaDrmBridge = this;
        mediaDrmBridge.onPromiseRejected(l2, "Update session failed.");
        mediaDrmBridge.release();
    }

    @TargetApi(value=23)
    private void loadSession(byte[] byArray, final long l2) {
        j.a(TAG, "loadSession()");
        if (!$assertionsDisabled && this.mProvisioningPending) {
            throw new AssertionError();
        }
        this.mSessionManager.load(byArray, new Callback<MediaDrmSessionManager.SessionId>(){

            @Override
            public void onResult(MediaDrmSessionManager.SessionId sessionId) {
                if (sessionId == null) {
                    MediaDrmBridge.this.onPersistentLicenseNoExist(l2);
                    return;
                }
                MediaDrmBridge.this.loadSessionWithLoadedStorage(sessionId, l2);
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @TargetApi(value=23)
    private void loadSessionWithLoadedStorage(MediaDrmSessionManager.SessionId sessionId, long l2) {
        try {
            Object object = this.openSession();
            if (object == null) {
                this.onPromiseRejected(l2, "Failed to open session to load license.");
                return;
            }
            this.mSessionManager.setDrmId(sessionId, (byte[])object);
            if (!$assertionsDisabled) {
                if (!Arrays.equals(sessionId.drmId(), (byte[])object)) throw new AssertionError();
            }
            MediaDrmSessionManager.SessionInfo sessionInfo = this.mSessionManager.get(sessionId);
            object = sessionInfo;
            if (sessionInfo.keyType() == 3) {
                j.d(TAG, "Persistent license is waiting for release ack.", new Object[0]);
                if (this.isNativeMediaDrmBridgeValid()) {
                    MediaDrmBridge mediaDrmBridge = this;
                    mediaDrmBridge.nativeOnPromiseResolvedWithSession(mediaDrmBridge.mNativeMediaDrmBridge, l2, sessionId.emeId());
                }
                object = MediaDrmBridge.getDummyKeysInfo(1).toArray();
                boolean bl = false;
                boolean bl2 = true;
                if (!this.isNativeMediaDrmBridgeValid()) return;
                MediaDrmBridge mediaDrmBridge = this;
                mediaDrmBridge.nativeOnSessionKeysChange(mediaDrmBridge.mNativeMediaDrmBridge, sessionId.emeId(), (Object[])object, bl, bl2);
                return;
            }
            if (!$assertionsDisabled) {
                if (((MediaDrmSessionManager.SessionInfo)object).keyType() != 2) throw new AssertionError();
            }
            if (!$assertionsDisabled) {
                if (this.mSessionEventDeferrer != null) throw new AssertionError();
            }
            this.mSessionEventDeferrer = new SessionEventDeferrer(sessionId);
            if (!$assertionsDisabled) {
                if (sessionId.keySetId() == null) throw new AssertionError();
            }
            MediaDrmBridge mediaDrmBridge = this;
            mediaDrmBridge.mMediaDrm.restoreKeys(sessionId.drmId(), sessionId.keySetId());
            if (mediaDrmBridge.isNativeMediaDrmBridgeValid()) {
                MediaDrmBridge mediaDrmBridge2 = this;
                mediaDrmBridge2.nativeOnPromiseResolvedWithSession(mediaDrmBridge2.mNativeMediaDrmBridge, l2, sessionId.emeId());
            }
            this.mSessionEventDeferrer.fire();
            this.mSessionEventDeferrer = null;
            return;
        }
        catch (IllegalStateException illegalStateException) {
            if (!$assertionsDisabled) {
                if (sessionId.drmId() == null) throw new AssertionError();
            }
            MediaDrmBridge mediaDrmBridge = this;
            mediaDrmBridge.closeSessionNoException(sessionId);
            mediaDrmBridge.mSessionManager.clearPersistentSessionInfo(sessionId, new Callback<Boolean>(l2){
                public final /* synthetic */ long val$promiseId;
                {
                    this.val$promiseId = l2;
                }

                @Override
                public void onResult(Boolean objectArray) {
                    if (!objectArray.booleanValue()) {
                        objectArray = new Object[]{};
                        j.d(MediaDrmBridge.TAG, "Failed to clear persistent storage for non-exist license", objectArray);
                    }
                    MediaDrmBridge.this.onPersistentLicenseNoExist(this.val$promiseId);
                }
            });
            return;
        }
        catch (NotProvisionedException notProvisionedException) {
            MediaDrmBridge mediaDrmBridge = this;
            Object[] objectArray = new Object[]{};
            j.d(TAG, "Persistent license load fail because origin isn't provisioned.", objectArray);
            mediaDrmBridge.closeSessionNoException(sessionId);
            mediaDrmBridge.mSessionManager.clearPersistentSessionInfo(sessionId, new /* invalid duplicate definition of identical inner class */);
        }
    }

    private void onPersistentLicenseNoExist(long l2) {
        MediaDrmSessionManager.SessionId sessionId = MediaDrmSessionManager.SessionId.createNoExistSessionId();
        if (this.isNativeMediaDrmBridgeValid()) {
            MediaDrmBridge mediaDrmBridge = this;
            mediaDrmBridge.nativeOnPromiseResolvedWithSession(mediaDrmBridge.mNativeMediaDrmBridge, l2, sessionId.emeId());
        }
    }

    private void onPersistentLicenseLoadFail(MediaDrmSessionManager.SessionId sessionId, long l2) {
        MediaDrmBridge mediaDrmBridge = this;
        mediaDrmBridge.closeSessionNoException(sessionId);
        mediaDrmBridge.mSessionManager.clearPersistentSessionInfo(sessionId, new /* invalid duplicate definition of identical inner class */);
    }

    private void removeSession(byte[] object, final long l2) {
        Callback<Boolean> callback;
        j.a(TAG, "removeSession()");
        MediaDrmSessionManager.SessionId sessionId = this.getSessionIdByEmeId((byte[])object);
        object = sessionId;
        if (sessionId == null) {
            this.onPromiseRejected(l2, "Session doesn't exist");
            return;
        }
        MediaDrmSessionManager.SessionInfo sessionInfo = this.mSessionManager.get((MediaDrmSessionManager.SessionId)object);
        if (sessionInfo.keyType() == 1) {
            this.onPromiseRejected(l2, "Removing temporary session isn't implemented");
            return;
        }
        if (!$assertionsDisabled && ((MediaDrmSessionManager.SessionId)object).keySetId() == null) {
            throw new AssertionError();
        }
        Callback<Boolean> callback2 = callback;
        callback = new Callback<Boolean>((MediaDrmSessionManager.SessionId)object, sessionInfo){
            public final /* synthetic */ MediaDrmSessionManager.SessionId val$sessionId;
            public final /* synthetic */ MediaDrmSessionManager.SessionInfo val$sessionInfo;
            {
                this.val$sessionId = sessionId;
                this.val$sessionInfo = sessionInfo;
            }

            @Override
            public void onResult(Boolean bl) {
                if (!bl.booleanValue()) {
                    MediaDrmBridge.this.onPromiseRejected(l2, "Fail to update persistent storage");
                    return;
                }
                MediaDrmBridge.this.doRemoveSession(this.val$sessionId, this.val$sessionInfo.mimeType(), l2);
            }
        };
        this.mSessionManager.setKeyType((MediaDrmSessionManager.SessionId)object, 3, callback2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doRemoveSession(MediaDrmSessionManager.SessionId sessionId, String string2, long l2) {
        try {
            string2 = objectArray2.getKeyRequest(sessionId, null, string2, 3, null);
            if (string2 == null) {
                super.onPromiseRejected(l2, "Fail to generate key release request");
                return;
            }
            if (objectArray2.isNativeMediaDrmBridgeValid()) {
                super.nativeOnPromiseResolved(objectArray2.mNativeMediaDrmBridge, l2);
            }
            super.onSessionMessage(sessionId, (MediaDrm.KeyRequest)string2);
            return;
        }
        catch (NotProvisionedException notProvisionedException) {
            Object[] objectArray = objectArray2;
            Object[] objectArray2 = new Object[]{};
            j.b(TAG, "removeSession called on unprovisioned device", objectArray2);
            super.onPromiseRejected(l2, "Unknown failure");
        }
    }

    private String getSecurityLevel() {
        if (objectArray.mMediaDrm != null && objectArray.isWidevine()) {
            return objectArray.mMediaDrm.getPropertyString(SECURITY_LEVEL);
        }
        Object[] objectArray = new Object[]{};
        j.b(TAG, "getSecurityLevel(): MediaDrm is null or security level is not supported.", objectArray);
        return "";
    }

    private void startProvisioning() {
        j.a(TAG, "startProvisioning");
        if (!$assertionsDisabled && mediaDrmBridge2.mProvisioningPending) {
            throw new AssertionError();
        }
        mediaDrmBridge2.mProvisioningPending = true;
        if (!$assertionsDisabled && mediaDrmBridge2.mMediaDrm == null) {
            throw new AssertionError();
        }
        if (!mediaDrmBridge2.isNativeMediaDrmBridgeValid()) {
            return;
        }
        if (mediaDrmBridge2.mRequiresMediaCrypto) {
            sMediaCryptoDeferrer.onProvisionStarted();
        }
        MediaDrmBridge mediaDrmBridge = mediaDrmBridge2;
        MediaDrmBridge mediaDrmBridge2 = mediaDrmBridge.mMediaDrm.getProvisionRequest();
        mediaDrmBridge.nativeOnProvisionRequest(mediaDrmBridge.mNativeMediaDrmBridge, mediaDrmBridge2.getDefaultUrl(), mediaDrmBridge2.getData());
    }

    private void processProvisionResponse(boolean bl, byte[] byArray) {
        j.a(TAG, "processProvisionResponse()");
        if (!$assertionsDisabled && this.mMediaCryptoSession != null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !this.mProvisioningPending) {
            throw new AssertionError();
        }
        this.mProvisioningPending = false;
        boolean bl2 = false;
        bl = this.mMediaDrm != null ? (bl ? this.provideProvisionResponse(byArray) : false) : bl2;
        MediaDrmBridge mediaDrmBridge = this;
        mediaDrmBridge.onProvisioned(bl);
        if (mediaDrmBridge.mRequiresMediaCrypto) {
            sMediaCryptoDeferrer.onProvisionDone();
        }
    }

    private void deferEventHandleIfNeeded(MediaDrmSessionManager.SessionId sessionId, Runnable runnable) {
        SessionEventDeferrer sessionEventDeferrer = this.mSessionEventDeferrer;
        if (sessionEventDeferrer != null && sessionEventDeferrer.shouldDefer(sessionId)) {
            this.mSessionEventDeferrer.defer(runnable);
            return;
        }
        runnable.run();
    }

    private void onMediaCryptoReady(MediaCrypto mediaCrypto) {
        if (this.isNativeMediaDrmBridgeValid()) {
            MediaDrmBridge mediaDrmBridge = this;
            mediaDrmBridge.nativeOnMediaCryptoReady(mediaDrmBridge.mNativeMediaDrmBridge, mediaCrypto);
        }
    }

    private void onPromiseResolved(long l2) {
        if (this.isNativeMediaDrmBridgeValid()) {
            MediaDrmBridge mediaDrmBridge = this;
            mediaDrmBridge.nativeOnPromiseResolved(mediaDrmBridge.mNativeMediaDrmBridge, l2);
        }
    }

    private void onPromiseResolvedWithSession(long l2, MediaDrmSessionManager.SessionId sessionId) {
        if (this.isNativeMediaDrmBridgeValid()) {
            MediaDrmBridge mediaDrmBridge = this;
            mediaDrmBridge.nativeOnPromiseResolvedWithSession(mediaDrmBridge.mNativeMediaDrmBridge, l2, sessionId.emeId());
        }
    }

    private void onPromiseRejected(long l2, String string2) {
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = string2;
        j.b(TAG, "onPromiseRejected: %s", objectArray2);
        if (this.isNativeMediaDrmBridgeValid()) {
            MediaDrmBridge mediaDrmBridge = this;
            mediaDrmBridge.nativeOnPromiseRejected(mediaDrmBridge.mNativeMediaDrmBridge, l2, string2);
        }
    }

    @TargetApi(value=23)
    private void onSessionMessage(MediaDrmSessionManager.SessionId sessionId, MediaDrm.KeyRequest keyRequest) {
        if (!this.isNativeMediaDrmBridgeValid()) {
            return;
        }
        int n2 = Build.VERSION.SDK_INT >= 23 ? keyRequest.getRequestType() : keyRequest.getDefaultUrl().isEmpty() ^ 1;
        MediaDrmBridge mediaDrmBridge = this;
        mediaDrmBridge.nativeOnSessionMessage(mediaDrmBridge.mNativeMediaDrmBridge, sessionId.emeId(), n2, keyRequest.getData());
    }

    private void onSessionClosed(MediaDrmSessionManager.SessionId sessionId) {
        if (this.isNativeMediaDrmBridgeValid()) {
            MediaDrmBridge mediaDrmBridge = this;
            mediaDrmBridge.nativeOnSessionClosed(mediaDrmBridge.mNativeMediaDrmBridge, sessionId.emeId());
        }
    }

    private void onSessionKeysChange(MediaDrmSessionManager.SessionId sessionId, Object[] objectArray, boolean bl, boolean bl2) {
        if (this.isNativeMediaDrmBridgeValid()) {
            MediaDrmBridge mediaDrmBridge = this;
            mediaDrmBridge.nativeOnSessionKeysChange(mediaDrmBridge.mNativeMediaDrmBridge, sessionId.emeId(), objectArray, bl, bl2);
        }
    }

    private void onSessionExpirationUpdate(MediaDrmSessionManager.SessionId sessionId, long l2) {
        if (this.isNativeMediaDrmBridgeValid()) {
            MediaDrmBridge mediaDrmBridge = this;
            mediaDrmBridge.nativeOnSessionExpirationUpdate(mediaDrmBridge.mNativeMediaDrmBridge, sessionId.emeId(), l2);
        }
    }

    private native void nativeOnMediaCryptoReady(long var1, MediaCrypto var3);

    private native void nativeOnProvisionRequest(long var1, String var3, byte[] var4);

    private native void nativeOnProvisioningComplete(long var1, boolean var3);

    private native void nativeOnPromiseResolved(long var1, long var3);

    private native void nativeOnPromiseResolvedWithSession(long var1, long var3, byte[] var5);

    private native void nativeOnPromiseRejected(long var1, long var3, String var5);

    private native void nativeOnSessionMessage(long var1, byte[] var3, int var4, byte[] var5);

    private native void nativeOnSessionClosed(long var1, byte[] var3);

    private native void nativeOnSessionKeysChange(long var1, byte[] var3, Object[] var4, boolean var5, boolean var6);

    private native void nativeOnSessionExpirationUpdate(long var1, byte[] var3, long var4);

    public static /* synthetic */ List access$1500(int n2) {
        return MediaDrmBridge.getDummyKeysInfo(n2);
    }

    public static /* synthetic */ void access$1600(MediaDrmBridge mediaDrmBridge, MediaDrmSessionManager.SessionId sessionId, Object[] objectArray, boolean bl, boolean bl2) {
        if (mediaDrmBridge.isNativeMediaDrmBridgeValid()) {
            MediaDrmBridge mediaDrmBridge2 = mediaDrmBridge;
            mediaDrmBridge2.nativeOnSessionKeysChange(mediaDrmBridge2.mNativeMediaDrmBridge, sessionId.emeId(), objectArray, bl, bl2);
        }
    }

    public static /* synthetic */ void access$1900(MediaDrmBridge mediaDrmBridge, MediaDrmSessionManager.SessionId sessionId, long l2) {
        if (mediaDrmBridge.isNativeMediaDrmBridgeValid()) {
            MediaDrmBridge mediaDrmBridge2 = mediaDrmBridge;
            mediaDrmBridge2.nativeOnSessionExpirationUpdate(mediaDrmBridge2.mNativeMediaDrmBridge, sessionId.emeId(), l2);
        }
    }

    public static /* synthetic */ void access$2000(MediaDrmBridge mediaDrmBridge, long l2) {
        if (mediaDrmBridge.isNativeMediaDrmBridgeValid()) {
            MediaDrmBridge mediaDrmBridge2 = mediaDrmBridge;
            mediaDrmBridge2.nativeOnPromiseResolved(mediaDrmBridge2.mNativeMediaDrmBridge, l2);
        }
    }

    static {
        $assertionsDisabled = MediaDrmBridge.class.desiredAssertionStatus() ^ true;
        WIDEVINE_UUID = UUID.fromString("edef8ba9-79d6-4ace-a3c8-27dcd51d21ed");
        DUMMY_KEY_ID = new byte[]{0};
        UNPROVISION = a.b.a.a.a("unprovision");
        sMediaCryptoDeferrer = new MediaCryptoDeferrer();
    }

    public boolean provideProvisionResponse(byte[] objectArray) {
        if (objectArray != null && objectArray.length != 0) {
            try {
                objectArray4.mMediaDrm.provideProvisionResponse(objectArray);
                return true;
            }
            catch (IllegalStateException illegalStateException) {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = illegalStateException;
                j.b(TAG, "failed to provide provision response", objectArray);
            }
            catch (DeniedByServerException deniedByServerException) {
                Object[] objectArray3 = new Object[1];
                objectArray = objectArray3;
                objectArray3[0] = deniedByServerException;
                j.b(TAG, "failed to provide provision response", objectArray);
            }
            return false;
        }
        Object[] objectArray4 = new Object[]{};
        j.b(TAG, "Invalid provision response.", objectArray4);
        return false;
    }

    public void onProvisioned(boolean bl) {
        if (!this.mRequiresMediaCrypto) {
            MediaDrmBridge mediaDrmBridge = this;
            mediaDrmBridge.nativeOnProvisioningComplete(mediaDrmBridge.mNativeMediaDrmBridge, bl);
            if (!bl) {
                this.release();
            }
            return;
        }
        if (!bl) {
            this.release();
            return;
        }
        if (!this.mOriginSet) {
            this.createMediaCrypto();
            return;
        }
        this.mStorage.onProvisioned(new Callback<Boolean>(){
            public static final /* synthetic */ boolean $assertionsDisabled;

            static {
                $assertionsDisabled = MediaDrmBridge.class.desiredAssertionStatus() ^ true;
            }

            @Override
            public void onResult(Boolean bl) {
                if (!$assertionsDisabled && objectArray2.MediaDrmBridge.this.mMediaCryptoSession != null) {
                    throw new AssertionError();
                }
                if (!bl.booleanValue()) {
                    Object[] objectArray = objectArray2;
                    Object[] objectArray2 = new Object[]{};
                    j.b(MediaDrmBridge.TAG, "Failed to initialize storage for origin", objectArray2);
                    objectArray.MediaDrmBridge.this.release();
                    return;
                }
                objectArray2.MediaDrmBridge.this.createMediaCrypto();
            }
        });
    }

    @MainDex
    private class KeyUpdatedCallback
    implements Callback<Boolean> {
        public final MediaDrmSessionManager.SessionId mSessionId;
        public final long mPromiseId;
        public final boolean mIsKeyRelease;

        public KeyUpdatedCallback(MediaDrmSessionManager.SessionId sessionId, long l2, boolean bl) {
            this.mSessionId = sessionId;
            this.mPromiseId = l2;
            this.mIsKeyRelease = bl;
        }

        @Override
        public void onResult(Boolean object) {
            if (!((Boolean)object).booleanValue()) {
                MediaDrmBridge.this.onPromiseRejected(this.mPromiseId, "failed to update key after response accepted");
                return;
            }
            object = MediaDrmBridge.TAG;
            String string2 = "Key successfully %s for session %s";
            String string3 = this.mIsKeyRelease ? "released" : "added";
            KeyUpdatedCallback keyUpdatedCallback = this;
            j.a((String)object, string2, (Object)string3, (Object)this.mSessionId.toHexString());
            MediaDrmBridge.access$2000(keyUpdatedCallback.MediaDrmBridge.this, this.mPromiseId);
            if (!keyUpdatedCallback.mIsKeyRelease && Build.VERSION.SDK_INT < 23) {
                MediaDrmBridge.access$1600(MediaDrmBridge.this, this.mSessionId, MediaDrmBridge.getDummyKeysInfo(0).toArray(), true, this.mIsKeyRelease);
            }
        }
    }

    @TargetApi(value=23)
    @MainDex
    private class ExpirationUpdateListener
    implements MediaDrm.OnExpirationUpdateListener {
        public static final /* synthetic */ boolean $assertionsDisabled;

        public ExpirationUpdateListener() {
        }

        public /* synthetic */ ExpirationUpdateListener(1 var2_2) {
        }

        static {
            $assertionsDisabled = MediaDrmBridge.class.desiredAssertionStatus() ^ true;
        }

        public void onExpirationUpdate(MediaDrm object, byte[] byArray, long l2) {
            object = MediaDrmBridge.this.getSessionIdByDrmId(byArray);
            if (!$assertionsDisabled && object == null) {
                throw new AssertionError();
            }
            MediaDrmBridge.this.deferEventHandleIfNeeded((MediaDrmSessionManager.SessionId)object, new Runnable((MediaDrmSessionManager.SessionId)object, l2){
                public final /* synthetic */ MediaDrmSessionManager.SessionId val$sessionId;
                public final /* synthetic */ long val$expirationTime;
                {
                    this.val$sessionId = sessionId;
                    this.val$expirationTime = l2;
                }

                @Override
                public void run() {
                    j.a(MediaDrmBridge.TAG, a.a("ExpirationUpdate: ").append(this.val$sessionId.toHexString()).append(", ").append(this.val$expirationTime).toString());
                    MediaDrmBridge.access$1900(MediaDrmBridge.this, this.val$sessionId, this.val$expirationTime);
                }
            });
        }
    }

    @TargetApi(value=23)
    @MainDex
    private class KeyStatusChangeListener
    implements MediaDrm.OnKeyStatusChangeListener {
        public static final /* synthetic */ boolean $assertionsDisabled;

        public KeyStatusChangeListener() {
        }

        private List<KeyStatus> getKeysInfo(List<MediaDrm.KeyStatus> object) {
            ArrayList arrayList;
            ArrayList arrayList2 = arrayList;
            arrayList = new ArrayList();
            object = object.iterator();
            while (object.hasNext()) {
                MediaDrm.KeyStatus keyStatus = (MediaDrm.KeyStatus)object.next();
                arrayList2.add(new KeyStatus(keyStatus.getKeyId(), keyStatus.getStatusCode(), null));
            }
            return arrayList2;
        }

        public /* synthetic */ KeyStatusChangeListener(1 var2_2) {
        }

        static {
            $assertionsDisabled = MediaDrmBridge.class.desiredAssertionStatus() ^ true;
        }

        public void onKeyStatusChange(MediaDrm object, byte[] byArray, List<MediaDrm.KeyStatus> list, boolean bl) {
            object = MediaDrmBridge.this.getSessionIdByDrmId(byArray);
            if (!$assertionsDisabled && object == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && MediaDrmBridge.this.mSessionManager.get((MediaDrmSessionManager.SessionId)object) == null) {
                throw new AssertionError();
            }
            boolean bl2 = MediaDrmBridge.this.mSessionManager.get((MediaDrmSessionManager.SessionId)object).keyType() == 3;
            MediaDrmBridge.this.deferEventHandleIfNeeded((MediaDrmSessionManager.SessionId)object, new Runnable((MediaDrmSessionManager.SessionId)object, bl, list, bl2){
                public final /* synthetic */ MediaDrmSessionManager.SessionId val$sessionId;
                public final /* synthetic */ boolean val$hasNewUsableKey;
                public final /* synthetic */ List val$keyInformation;
                public final /* synthetic */ boolean val$isKeyRelease;
                {
                    this.val$sessionId = sessionId;
                    this.val$hasNewUsableKey = bl;
                    this.val$keyInformation = list;
                    this.val$isKeyRelease = bl2;
                }

                @Override
                public void run() {
                    j.a(MediaDrmBridge.TAG, a.a("KeysStatusChange: ").append(this.val$sessionId.toHexString()).append(", ").append(this.val$hasNewUsableKey).toString());
                    KeyStatusChangeListener keyStatusChangeListener = KeyStatusChangeListener.this;
                    MediaDrmBridge.access$1600(keyStatusChangeListener.MediaDrmBridge.this, this.val$sessionId, keyStatusChangeListener.getKeysInfo(this.val$keyInformation).toArray(), this.val$hasNewUsableKey, this.val$isKeyRelease);
                }
            });
        }
    }

    @MainDex
    private class EventListener
    implements MediaDrm.OnEventListener {
        public static final /* synthetic */ boolean $assertionsDisabled;

        public EventListener() {
        }

        public /* synthetic */ EventListener(1 var2_2) {
        }

        static {
            $assertionsDisabled = MediaDrmBridge.class.desiredAssertionStatus() ^ true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void onEvent(MediaDrm object, byte[] object2, int n2, int n3, byte[] byArray) {
            Object[] objectArray;
            block9: {
                int n4;
                String string2;
                byte[] byArray2;
                Object object3;
                MediaDrmBridge mediaDrmBridge;
                if (object2 == null) {
                    Object[] objectArray2 = new Object[1];
                    objectArray = objectArray2;
                    objectArray2[0] = n2;
                    j.b(MediaDrmBridge.TAG, "EventListener: No session for event %d.", objectArray);
                    return;
                }
                object = objectArray.MediaDrmBridge.this.getSessionIdByDrmId((byte[])object2);
                if (object == null) {
                    Object[] objectArray3 = new Object[1];
                    objectArray = objectArray3;
                    objectArray3[0] = MediaDrmSessionManager.SessionId.toHexString((byte[])object2);
                    j.b(MediaDrmBridge.TAG, "EventListener: Invalid session %s", objectArray);
                    return;
                }
                object2 = objectArray.MediaDrmBridge.this.mSessionManager.get((MediaDrmSessionManager.SessionId)object);
                if (n2 != 2) {
                    if (n2 != 3) {
                        if (n2 != 4) {
                            objectArray = new Object[]{};
                            j.b(MediaDrmBridge.TAG, "Invalid DRM event " + n2, objectArray);
                            return;
                        }
                        j.a(MediaDrmBridge.TAG, "MediaDrm.EVENT_VENDOR_DEFINED");
                        if ($assertionsDisabled) return;
                        throw new AssertionError();
                    }
                    j.a(MediaDrmBridge.TAG, "MediaDrm.EVENT_KEY_EXPIRED");
                    if (Build.VERSION.SDK_INT >= 23) return;
                    Object object4 = object2;
                    objectArray = objectArray.MediaDrmBridge.this;
                    object2 = MediaDrmBridge.getDummyKeysInfo(1).toArray();
                    n2 = 0;
                    n3 = ((MediaDrmSessionManager.SessionInfo)object4).keyType() == 3 ? 1 : 0;
                    MediaDrmBridge.access$1600((MediaDrmBridge)objectArray, (MediaDrmSessionManager.SessionId)object, (Object[])object2, n2 != 0, n3 != 0);
                    return;
                }
                j.a(MediaDrmBridge.TAG, "MediaDrm.EVENT_KEY_REQUIRED");
                try {
                    mediaDrmBridge = objectArray.MediaDrmBridge.this;
                    object3 = object;
                    byArray2 = byArray;
                    string2 = ((MediaDrmSessionManager.SessionInfo)object2).mimeType();
                    n4 = ((MediaDrmSessionManager.SessionInfo)object2).keyType();
                }
                catch (NotProvisionedException notProvisionedException) {
                    Object[] objectArray4 = new Object[1];
                    object = objectArray4;
                    objectArray4[0] = notProvisionedException;
                    j.b(MediaDrmBridge.TAG, "Device not provisioned", (Object[])object);
                    return;
                }
                object2 = mediaDrmBridge.getKeyRequest((MediaDrmSessionManager.SessionId)object3, byArray2, string2, n4, null);
                if (object2 == null) break block9;
                objectArray.MediaDrmBridge.this.onSessionMessage((MediaDrmSessionManager.SessionId)object, (MediaDrm.KeyRequest)object2);
                return;
            }
            if (Build.VERSION.SDK_INT < 23) {
                MediaDrmBridge.access$1600(objectArray.MediaDrmBridge.this, (MediaDrmSessionManager.SessionId)object, MediaDrmBridge.getDummyKeysInfo(4).toArray(), false, false);
            }
            objectArray = new Object[]{};
            j.b(MediaDrmBridge.TAG, "EventListener: getKeyRequest failed.", objectArray);
        }
    }

    @MainDex
    private static class KeyStatus {
        public final byte[] mKeyId;
        public final int mStatusCode;

        public KeyStatus(byte[] byArray, int n2) {
            this.mKeyId = byArray;
            this.mStatusCode = n2;
        }

        private byte[] getKeyId() {
            return this.mKeyId;
        }

        private int getStatusCode() {
            return this.mStatusCode;
        }

        public /* synthetic */ KeyStatus(byte[] byArray, int n2, 1 var3_3) {
            this.mKeyId = byArray;
            this.mStatusCode = n2;
        }
    }

    private static class SessionEventDeferrer {
        public final MediaDrmSessionManager.SessionId mSessionId;
        public final ArrayList<Runnable> mEventHandlers;

        public SessionEventDeferrer(MediaDrmSessionManager.SessionId sessionId) {
            SessionEventDeferrer sessionEventDeferrer = this;
            sessionEventDeferrer.mSessionId = sessionId;
            sessionEventDeferrer.mEventHandlers = new ArrayList();
        }

        public boolean shouldDefer(MediaDrmSessionManager.SessionId sessionId) {
            return this.mSessionId.isEqual(sessionId);
        }

        public void defer(Runnable runnable) {
            this.mEventHandlers.add(runnable);
        }

        public void fire() {
            Iterator<Runnable> iterator = this.mEventHandlers.iterator();
            while (iterator.hasNext()) {
                iterator.next().run();
            }
            this.mEventHandlers.clear();
        }
    }

    private static class MediaCryptoDeferrer {
        public static final /* synthetic */ boolean $assertionsDisabled;
        public boolean mIsProvisioning = false;
        public final Queue<Runnable> mEventHandlers = new ArrayDeque<Runnable>();

        static {
            $assertionsDisabled = MediaDrmBridge.class.desiredAssertionStatus() ^ true;
        }

        public boolean isProvisioning() {
            return this.mIsProvisioning;
        }

        public void onProvisionStarted() {
            if (!$assertionsDisabled && this.mIsProvisioning) {
                throw new AssertionError();
            }
            this.mIsProvisioning = true;
        }

        public void defer(Runnable runnable) {
            if (!$assertionsDisabled && !this.mIsProvisioning) {
                throw new AssertionError();
            }
            this.mEventHandlers.add(runnable);
        }

        public void onProvisionDone() {
            if (!$assertionsDisabled && !this.mIsProvisioning) {
                throw new AssertionError();
            }
            this.mIsProvisioning = false;
            while (!this.mEventHandlers.isEmpty()) {
                MediaCryptoDeferrer mediaCryptoDeferrer = this;
                j.a(MediaDrmBridge.TAG, "run deferred CreateMediaCrypto() calls");
                this.mEventHandlers.remove();
                mediaCryptoDeferrer.mEventHandlers.element().run();
                if (!mediaCryptoDeferrer.mIsProvisioning) continue;
                j.a(MediaDrmBridge.TAG, "provision triggerred while running deferred CreateMediaCrypto()");
                return;
            }
        }
    }
}

