/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.media;

import a.b.a.j;
import android.annotation.TargetApi;
import android.media.MediaFormat;
import android.os.Build;
import android.support.annotation.VisibleForTesting;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.base.annotations.MainDex;

@JNINamespace(value="media")
@MainDex
public class HdrMetadata {
    public static final String TAG = "HdrMetadata";
    public static final int MAX_CHROMATICITY = 50000;
    public static final /* synthetic */ boolean $assertionsDisabled;
    public long mNativeJniHdrMetadata;
    public final Object mLock = new Object();

    public static HdrMetadata create(long l2) {
        return new HdrMetadata(l2);
    }

    @VisibleForTesting
    public HdrMetadata() {
        this.mNativeJniHdrMetadata = 0L;
    }

    public HdrMetadata(long l2) {
        if (!$assertionsDisabled && l2 == 0L) {
            throw new AssertionError();
        }
        this.mNativeJniHdrMetadata = l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close() {
        Object object = this.mLock;
        synchronized (object) {
            this.mNativeJniHdrMetadata = 0L;
            return;
        }
    }

    private native int nativePrimaries(long var1);

    private int getColorStandard() {
        HdrMetadata hdrMetadata = this;
        switch (hdrMetadata.nativePrimaries(hdrMetadata.mNativeJniHdrMetadata)) {
            default: {
                return -1;
            }
            case 9: {
                return 6;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return 4;
            }
            case 1: 
        }
        return 1;
    }

    private native int nativeColorTransfer(long var1);

    private int getColorTransfer() {
        HdrMetadata hdrMetadata = this;
        int n2 = hdrMetadata.nativeColorTransfer(hdrMetadata.mNativeJniHdrMetadata);
        if (n2 != 1) {
            if (n2 != 16) {
                if (n2 != 18) {
                    switch (n2) {
                        default: {
                            return -1;
                        }
                        case 8: {
                            return 1;
                        }
                        case 6: 
                        case 7: {
                            return 3;
                        }
                    }
                }
                return 7;
            }
            return 6;
        }
        return 3;
    }

    private native int nativeRange(long var1);

    private int getColorRange() {
        HdrMetadata hdrMetadata = this;
        int n2 = hdrMetadata.nativeRange(hdrMetadata.mNativeJniHdrMetadata);
        if (n2 != 1) {
            if (n2 != 2) {
                return -1;
            }
            return 1;
        }
        return 2;
    }

    private native float nativePrimaryRChromaticityX(long var1);

    private float primaryRChromaticityX() {
        HdrMetadata hdrMetadata = this;
        return hdrMetadata.nativePrimaryRChromaticityX(hdrMetadata.mNativeJniHdrMetadata);
    }

    private native float nativePrimaryRChromaticityY(long var1);

    private float primaryRChromaticityY() {
        HdrMetadata hdrMetadata = this;
        return hdrMetadata.nativePrimaryRChromaticityY(hdrMetadata.mNativeJniHdrMetadata);
    }

    private native float nativePrimaryGChromaticityX(long var1);

    private float primaryGChromaticityX() {
        HdrMetadata hdrMetadata = this;
        return hdrMetadata.nativePrimaryGChromaticityX(hdrMetadata.mNativeJniHdrMetadata);
    }

    private native float nativePrimaryGChromaticityY(long var1);

    private float primaryGChromaticityY() {
        HdrMetadata hdrMetadata = this;
        return hdrMetadata.nativePrimaryGChromaticityY(hdrMetadata.mNativeJniHdrMetadata);
    }

    private native float nativePrimaryBChromaticityX(long var1);

    private float primaryBChromaticityX() {
        HdrMetadata hdrMetadata = this;
        return hdrMetadata.nativePrimaryBChromaticityX(hdrMetadata.mNativeJniHdrMetadata);
    }

    private native float nativePrimaryBChromaticityY(long var1);

    private float primaryBChromaticityY() {
        HdrMetadata hdrMetadata = this;
        return hdrMetadata.nativePrimaryBChromaticityY(hdrMetadata.mNativeJniHdrMetadata);
    }

    private native float nativeWhitePointChromaticityX(long var1);

    private float whitePointChromaticityX() {
        HdrMetadata hdrMetadata = this;
        return hdrMetadata.nativeWhitePointChromaticityX(hdrMetadata.mNativeJniHdrMetadata);
    }

    private native float nativeWhitePointChromaticityY(long var1);

    private float whitePointChromaticityY() {
        HdrMetadata hdrMetadata = this;
        return hdrMetadata.nativeWhitePointChromaticityY(hdrMetadata.mNativeJniHdrMetadata);
    }

    private native float nativeMaxMasteringLuminance(long var1);

    private float maxMasteringLuminance() {
        HdrMetadata hdrMetadata = this;
        return hdrMetadata.nativeMaxMasteringLuminance(hdrMetadata.mNativeJniHdrMetadata);
    }

    private native float nativeMinMasteringLuminance(long var1);

    private float minMasteringLuminance() {
        HdrMetadata hdrMetadata = this;
        return hdrMetadata.nativeMinMasteringLuminance(hdrMetadata.mNativeJniHdrMetadata);
    }

    private native int nativeMaxContentLuminance(long var1);

    private int maxContentLuminance() {
        HdrMetadata hdrMetadata = this;
        return hdrMetadata.nativeMaxContentLuminance(hdrMetadata.mNativeJniHdrMetadata);
    }

    private native int nativeMaxFrameAverageLuminance(long var1);

    private int maxFrameAverageLuminance() {
        HdrMetadata hdrMetadata = this;
        return hdrMetadata.nativeMaxFrameAverageLuminance(hdrMetadata.mNativeJniHdrMetadata);
    }

    static {
        $assertionsDisabled = HdrMetadata.class.desiredAssertionStatus() ^ true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @TargetApi(value=24)
    public void addMetadataToFormat(MediaFormat object) {
        Object object2 = this.mLock;
        synchronized (object2) {
            if (!$assertionsDisabled && this.mNativeJniHdrMetadata == 0L) {
                throw new AssertionError();
            }
            if (Build.VERSION.SDK_INT < 24) {
                j.b(TAG, "HDR not supported before Android N", new Object[0]);
                return;
            }
            int n2 = this.getColorStandard();
            if (n2 != -1) {
                object.setInteger("color-standard", n2);
            }
            if ((n2 = this.getColorTransfer()) != -1) {
                object.setInteger("color-transfer", n2);
            }
            if ((n2 = this.getColorRange()) != -1) {
                object.setInteger("color-range", n2);
            }
            Object object3 = object2;
            Object object4 = object;
            ByteBuffer byteBuffer = ByteBuffer.wrap(new byte[25]);
            object = object;
            ByteBuffer byteBuffer2 = object;
            HdrMetadata hdrMetadata = this;
            HdrMetadata hdrMetadata2 = hdrMetadata;
            HdrMetadata hdrMetadata3 = hdrMetadata;
            Object object5 = object;
            HdrMetadata hdrMetadata4 = this;
            HdrMetadata hdrMetadata5 = hdrMetadata4;
            HdrMetadata hdrMetadata6 = hdrMetadata4;
            Object object6 = object;
            HdrMetadata hdrMetadata7 = this;
            HdrMetadata hdrMetadata8 = hdrMetadata7;
            HdrMetadata hdrMetadata9 = hdrMetadata7;
            Object object7 = object;
            HdrMetadata hdrMetadata10 = this;
            HdrMetadata hdrMetadata11 = hdrMetadata10;
            HdrMetadata hdrMetadata12 = hdrMetadata10;
            Object object8 = object;
            HdrMetadata hdrMetadata13 = this;
            HdrMetadata hdrMetadata14 = hdrMetadata13;
            HdrMetadata hdrMetadata15 = hdrMetadata13;
            Object object9 = object;
            HdrMetadata hdrMetadata16 = this;
            HdrMetadata hdrMetadata17 = hdrMetadata16;
            HdrMetadata hdrMetadata18 = hdrMetadata16;
            Object object10 = object;
            HdrMetadata hdrMetadata19 = this;
            HdrMetadata hdrMetadata20 = hdrMetadata19;
            HdrMetadata hdrMetadata21 = hdrMetadata19;
            Object object11 = object;
            HdrMetadata hdrMetadata22 = this;
            HdrMetadata hdrMetadata23 = hdrMetadata22;
            HdrMetadata hdrMetadata24 = hdrMetadata22;
            Object object12 = object;
            HdrMetadata hdrMetadata25 = this;
            HdrMetadata hdrMetadata26 = hdrMetadata25;
            HdrMetadata hdrMetadata27 = hdrMetadata25;
            Object object13 = object;
            HdrMetadata hdrMetadata28 = this;
            HdrMetadata hdrMetadata29 = this;
            HdrMetadata hdrMetadata30 = this;
            Object object14 = object;
            ((ByteBuffer)object14).order(ByteOrder.LITTLE_ENDIAN);
            ((ByteBuffer)object14).put((byte)0);
            ((ByteBuffer)object).putShort((short)(hdrMetadata30.nativePrimaryRChromaticityX(hdrMetadata30.mNativeJniHdrMetadata) * 50000.0f + 0.5f));
            ((ByteBuffer)object).putShort((short)(hdrMetadata29.nativePrimaryRChromaticityY(hdrMetadata29.mNativeJniHdrMetadata) * 50000.0f + 0.5f));
            float f2 = hdrMetadata28.nativePrimaryGChromaticityX(hdrMetadata28.mNativeJniHdrMetadata);
            ((ByteBuffer)object13).putShort((short)(f2 * 50000.0f + 0.5f));
            float f3 = hdrMetadata27.nativePrimaryGChromaticityY(hdrMetadata26.mNativeJniHdrMetadata);
            ((ByteBuffer)object12).putShort((short)(f3 * 50000.0f + 0.5f));
            float f4 = hdrMetadata24.nativePrimaryBChromaticityX(hdrMetadata23.mNativeJniHdrMetadata);
            ((ByteBuffer)object11).putShort((short)(f4 * 50000.0f + 0.5f));
            float f5 = hdrMetadata21.nativePrimaryBChromaticityY(hdrMetadata20.mNativeJniHdrMetadata);
            ((ByteBuffer)object10).putShort((short)(f5 * 50000.0f + 0.5f));
            float f6 = hdrMetadata18.nativeWhitePointChromaticityX(hdrMetadata17.mNativeJniHdrMetadata);
            ((ByteBuffer)object9).putShort((short)(f6 * 50000.0f + 0.5f));
            float f7 = hdrMetadata15.nativeWhitePointChromaticityY(hdrMetadata14.mNativeJniHdrMetadata);
            ((ByteBuffer)object8).putShort((short)(f7 * 50000.0f + 0.5f));
            float f8 = hdrMetadata12.nativeMaxMasteringLuminance(hdrMetadata11.mNativeJniHdrMetadata);
            ((ByteBuffer)object7).putShort((short)(f8 + 0.5f));
            float f9 = hdrMetadata9.nativeMinMasteringLuminance(hdrMetadata8.mNativeJniHdrMetadata);
            ((ByteBuffer)object6).putShort((short)(f9 + 0.5f));
            ((ByteBuffer)object5).putShort((short)hdrMetadata6.nativeMaxContentLuminance(hdrMetadata5.mNativeJniHdrMetadata));
            byteBuffer2.putShort((short)hdrMetadata3.nativeMaxFrameAverageLuminance(hdrMetadata2.mNativeJniHdrMetadata));
            byteBuffer.rewind();
            object4.setByteBuffer("hdr-static-info", (ByteBuffer)object);
            // ** MonitorExit[v0] (shouldn't be in output)
            return;
        }
    }
}

