/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.device.sensors;

import a.b.a.j;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.os.Build;
import java.util.List;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.device.sensors.PlatformSensorProvider;

@JNINamespace(value="device")
public class PlatformSensor
implements SensorEventListener {
    public static final double MICROSECONDS_IN_SECOND = 1000000.0;
    public static final double SECONDS_IN_MICROSECOND = 1.0E-6;
    public static final double SECONDS_IN_NANOSECOND = 1.0E-9;
    public static final String TAG = "PlatformSensor";
    public static final double SENSOR_FREQUENCY_NORMAL = 5.0;
    public static final /* synthetic */ boolean $assertionsDisabled;
    public long mNativePlatformSensorAndroid;
    public final Sensor mSensor;
    public final int mMinDelayUsec;
    public final int mReadingCount;
    public double mCurrentPollingFrequency;
    public final PlatformSensorProvider mProvider;

    public static PlatformSensor create(int n2, int n3, PlatformSensorProvider platformSensorProvider) {
        List list = platformSensorProvider.getSensorManager().getSensorList(n2);
        if (list.isEmpty()) {
            return null;
        }
        return new PlatformSensor((Sensor)list.get(0), n3, platformSensorProvider);
    }

    public PlatformSensor(Sensor sensor, int n2, PlatformSensorProvider platformSensorProvider) {
        this.mReadingCount = n2;
        this.mProvider = platformSensorProvider;
        this.mSensor = sensor;
        this.mMinDelayUsec = this.mSensor.getMinDelay();
    }

    private void unregisterListener() {
        if (this.mCurrentPollingFrequency == 0.0) {
            return;
        }
        PlatformSensor platformSensor = this;
        this.mProvider.getSensorManager().unregisterListener((SensorEventListener)platformSensor, platformSensor.mSensor);
    }

    private int getSamplingPeriod(double d2) {
        return (int)(1.0 / d2 * 1000000.0);
    }

    private native void nativeNotifyPlatformSensorError(long var1);

    private native void nativeUpdatePlatformSensorReading(long var1, double var3, double var5, double var7, double var9, double var11);

    static {
        $assertionsDisabled = PlatformSensor.class.desiredAssertionStatus() ^ true;
    }

    public void initPlatformSensorAndroid(long l2) {
        if (!$assertionsDisabled && l2 == 0L) {
            throw new AssertionError();
        }
        this.mNativePlatformSensorAndroid = l2;
    }

    public int getReportingMode() {
        if (Build.VERSION.SDK_INT >= 21) {
            return this.mSensor.getReportingMode() == 0 ? 1 : 0;
        }
        return 1;
    }

    public double getDefaultConfiguration() {
        return 5.0;
    }

    public double getMaximumSupportedFrequency() {
        int n2 = this.mMinDelayUsec;
        if (n2 == 0) {
            return this.getDefaultConfiguration();
        }
        double d2 = (double)n2 * 1.0E-6;
        return 1.0 / d2;
    }

    public boolean startSensor(double d2) {
        boolean bl;
        if (this.mCurrentPollingFrequency == d2) {
            return true;
        }
        PlatformSensor platformSensor = this;
        platformSensor.unregisterListener();
        platformSensor.mProvider.sensorStarted(this);
        try {
            PlatformSensor platformSensor2 = this;
            bl = platformSensor.mProvider.getSensorManager().registerListener((SensorEventListener)platformSensor2, platformSensor2.mSensor, this.getSamplingPeriod(d2), this.mProvider.getHandler());
        }
        catch (RuntimeException runtimeException) {
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = runtimeException;
            j.d(TAG, "Failed to register sensor listener.", objectArray2);
            bl = false;
        }
        if (!bl) {
            this.stopSensor();
            return bl;
        }
        this.mCurrentPollingFrequency = d2;
        return bl;
    }

    public void stopSensor() {
        PlatformSensor platformSensor = this;
        platformSensor.unregisterListener();
        platformSensor.mProvider.sensorStopped(this);
        platformSensor.mCurrentPollingFrequency = 0.0;
    }

    public boolean checkSensorConfiguration(double d2) {
        return this.mMinDelayUsec <= this.getSamplingPeriod(d2);
    }

    public void sensorDestroyed() {
        this.stopSensor();
        this.mNativePlatformSensorAndroid = 0L;
    }

    public void sensorError() {
        PlatformSensor platformSensor = this;
        platformSensor.nativeNotifyPlatformSensorError(platformSensor.mNativePlatformSensorAndroid);
    }

    public void updateSensorReading(double d2, double d3, double d4, double d5, double d6) {
        PlatformSensor platformSensor = this;
        platformSensor.nativeUpdatePlatformSensorReading(platformSensor.mNativePlatformSensorAndroid, d2, d3, d4, d5, d6);
    }

    public void onAccuracyChanged(Sensor sensor, int n2) {
    }

    public void onSensorChanged(SensorEvent sensorEvent) {
        if (objectArray.mNativePlatformSensorAndroid == 0L) {
            Object[] objectArray = new Object[]{};
            j.d(TAG, "Should not get sensor events after PlatformSensorAndroid is destroyed.", objectArray);
            return;
        }
        float[] fArray = sensorEvent.values;
        if (sensorEvent.values.length < objectArray.mReadingCount) {
            objectArray.sensorError();
            objectArray.stopSensor();
            return;
        }
        double d2 = (double)sensorEvent.timestamp * 1.0E-9;
        int n2 = fArray.length;
        if (n2 != 1) {
            if (n2 != 2) {
                if (n2 != 3) {
                    objectArray.updateSensorReading(d2, fArray[0], fArray[1], fArray[2], fArray[3]);
                } else {
                    objectArray.updateSensorReading(d2, fArray[0], fArray[1], fArray[2], 0.0);
                }
            } else {
                objectArray.updateSensorReading(d2, fArray[0], fArray[1], 0.0, 0.0);
            }
        } else {
            objectArray.updateSensorReading(d2, fArray[0], 0.0, 0.0, 0.0);
        }
    }
}

