/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content_shell;

import a.b.a.g;
import a.b.d.a.c;
import a.b.p.a.d;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.Toast;
import com.vccorp.content.R;
import org.chromium.base.CommandLine;
import org.chromium.base.ThreadUtils;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.base.library_loader.LibraryLoader;
import org.chromium.components.embedder_support.view.ContentViewRenderView;
import org.chromium.content_public.browser.WebContents;
import org.chromium.content_shell.OnConfigListener;
import org.chromium.content_shell.OnWebViewListener;
import org.chromium.content_shell.Shell;
import org.chromium.ui.base.WindowAndroid;

@JNINamespace(value="content")
public class ShellManager
extends FrameLayout {
    public static final String ACTIVE_SHELL_URL_KEY = "ACTIVE_SHELL_URL_KEY";
    public static final String TAG;
    public static String DEFAULT_SHELL_URL;
    public static final String STRING_BLANK = "about://blank";
    public static final String RUN_WEB_TESTS_SWITCH = "run-web-tests";
    public static String mStartupUrl;
    public static final /* synthetic */ boolean $assertionsDisabled;
    public d mWindow;
    public Shell mActiveShell;
    public d mWindowAndroid;
    public ContentViewRenderView mContentViewRenderView;
    public boolean isInited;
    public OnWebViewListener onWebViewListener;
    public OnConfigListener configListener;

    public ShellManager(Context context) {
        ShellManager shellManager = this;
        super(context);
        shellManager.isInited = false;
        shellManager.initView();
    }

    public ShellManager(Context context, AttributeSet attributeSet) {
        ShellManager shellManager = this;
        super(context, attributeSet);
        shellManager.isInited = false;
        shellManager.initView();
    }

    private void initView() {
        LibraryLoader libraryLoader;
        if (!CommandLine.isInitialized()) {
            this.initCommandLine();
            String[] stringArray = ShellManager.getCommandLineParamsFromIntent(new Intent());
            if (stringArray != null) {
                CommandLine.getInstance().appendSwitchesAndArguments(stringArray);
            }
        }
        ShellManager shellManager = this;
        g.a();
        try {
            libraryLoader = LibraryLoader.sInstance;
        }
        catch (a.b.a.a.d d2) {
            Log.e((String)TAG, (String)"ContentView initialization failed.", (Throwable)d2);
            System.exit(-1);
            return;
        }
        libraryLoader.ensureInitialized(3);
        ShellManager.nativeInit((Object)shellManager);
        shellManager.settingView(new Bundle());
    }

    private Object createShell(long l2) {
        if (this.mContentViewRenderView == null) {
            this.mContentViewRenderView = new ContentViewRenderView(this.getContext());
            this.mContentViewRenderView.onNativeLibraryLoaded(this.mWindow);
        }
        ShellManager shellManager = this;
        Shell shell = (Shell)((LayoutInflater)shellManager.getContext().getSystemService("layout_inflater")).inflate(R.layout.shell_view, null);
        shell.initialize(l2, this.mWindow);
        shell.setOnWebViewListener(this.onWebViewListener);
        shell.setConfigListener(this.configListener);
        shellManager.onWebViewListener.onShellReady(shell);
        Shell shell2 = shellManager.mActiveShell;
        if (shell2 != null) {
            this.removeShell(shell2);
        }
        this.showShell(shell);
        return shell;
    }

    private void showShell(Shell object) {
        Shell shell = object;
        shell.setContentViewRenderView(this.mContentViewRenderView);
        this.addView((View)shell, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.mActiveShell = object;
        object = this.mActiveShell.getWebContents();
        if (object != null) {
            this.mContentViewRenderView.setCurrentWebContents((WebContents)object);
            object.onShow();
        }
    }

    private void removeShell(Shell shell) {
        if (shell == this.mActiveShell) {
            this.mActiveShell = null;
        }
        if (shell.getParent() == null) {
            return;
        }
        ShellManager shellManager = this;
        Shell shell2 = shell;
        shell2.setContentViewRenderView(null);
        shellManager.removeView((View)shell2);
        shellManager.onWebViewListener.onRemoveShell();
    }

    public static native void nativeInit(Object var0);

    public static native void nativeLaunchShell(String var0);

    public static String[] getCommandLineParamsFromIntent(Intent intent) {
        return intent != null ? intent.getStringArrayExtra("commandLineArgs") : null;
    }

    public static /* synthetic */ boolean access$002(ShellManager shellManager, boolean bl) {
        shellManager.isInited = bl;
        return bl;
    }

    static {
        $assertionsDisabled = ShellManager.class.desiredAssertionStatus() ^ true;
        TAG = ShellManager.class.getName();
        DEFAULT_SHELL_URL = "https://www.google.com.vn/";
        mStartupUrl = STRING_BLANK;
    }

    public void finishInitialization(Bundle bundle) {
        String string2 = !TextUtils.isEmpty((CharSequence)mStartupUrl) ? mStartupUrl : DEFAULT_SHELL_URL;
        if (bundle != null && bundle.containsKey(ACTIVE_SHELL_URL_KEY)) {
            string2 = bundle.getString(ACTIVE_SHELL_URL_KEY);
        }
        this.launchShell(string2);
    }

    public void initializationFailed() {
        Log.e((String)TAG, (String)"ContentView initialization failed.");
        Toast.makeText((Context)this.getContext(), (int)R.string.browser_process_initialization_failed, (int)0).show();
    }

    public void setWindow(d d2) {
        if (!$assertionsDisabled && d2 == null) {
            throw new AssertionError();
        }
        this.mWindow = d2;
        this.mContentViewRenderView = new ContentViewRenderView(this.getContext());
        this.mContentViewRenderView.onNativeLibraryLoaded(d2);
    }

    public WindowAndroid getWindow() {
        return this.mWindow;
    }

    public ContentViewRenderView getContentViewRenderView() {
        return this.mContentViewRenderView;
    }

    public void setStartupUrl(String string2) {
        mStartupUrl = string2;
    }

    public Shell getActiveShell() {
        return this.mActiveShell;
    }

    public void launchShell(String string2) {
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            ThreadUtils.assertOnUiThread();
            Shell shell = ((ShellManager)((Object)shell)).mActiveShell;
            ShellManager.nativeLaunchShell(string2);
            if (shell != null) {
                shell.close();
            }
        }
    }

    public void initCommandLine() {
        if (!CommandLine.isInitialized()) {
            CommandLine.initFromFile("/data/local/tmp/content-shell-command-line");
        }
    }

    public void destroy() {
        Object object = this.mActiveShell;
        if (object != null) {
            this.removeShell((Shell)((Object)object));
        }
        if ((object = this.mContentViewRenderView) != null) {
            ((ContentViewRenderView)((Object)object)).destroy();
            this.mContentViewRenderView = null;
        }
    }

    public void restoreBundle(Bundle bundle) {
        this.mWindowAndroid.restoreInstanceState(bundle);
        if (TextUtils.isEmpty((CharSequence)mStartupUrl)) {
            mStartupUrl = STRING_BLANK;
        }
        if (bundle != null && bundle.containsKey(ACTIVE_SHELL_URL_KEY)) {
            mStartupUrl = bundle.getString(ACTIVE_SHELL_URL_KEY);
            if (this.isInited && !TextUtils.isEmpty((CharSequence)mStartupUrl) && !mStartupUrl.equals(STRING_BLANK)) {
                this.launchShell(mStartupUrl);
            }
        }
    }

    public void saveInstanceState(Bundle bundle) {
        if (this.getActiveShell() != null) {
            WebContents webContents = this.getActiveShell().getWebContents();
            if (webContents != null) {
                bundle.putString(ACTIVE_SHELL_URL_KEY, webContents.getLastCommittedUrl());
            }
            this.mWindowAndroid.saveInstanceState(bundle);
        }
    }

    public void onActivityResult(int n2, int n3, Intent intent) {
        d d2 = ((ShellManager)((Object)d2)).mWindowAndroid;
        WindowAndroid.IntentCallback intentCallback = (WindowAndroid.IntentCallback)d2.mOutstandingIntents.get(n2);
        d d3 = d2;
        d3.mOutstandingIntents.delete(n2);
        String string2 = d3.mIntentErrors.remove(n2);
        if (intentCallback != null) {
            intentCallback.onIntentCompleted(d2, n3, intent);
        } else if (string2 != null) {
            d2.showCallbackNonExistentError(string2);
        }
    }

    public void onDetachedFromWindow() {
        ShellManager shellManager = this;
        super.onDetachedFromWindow();
        shellManager.destroy();
    }

    public void settingView(final Bundle bundle) {
        ShellManager shellManager = this;
        shellManager.mWindowAndroid = new d(this.getContext(), false);
        shellManager.mWindowAndroid.restoreInstanceState(bundle);
        shellManager.setWindow(shellManager.mWindowAndroid);
        shellManager.mWindowAndroid.setAnimationPlaceholderView((View)this.getContentViewRenderView().getSurfaceView());
        mStartupUrl = DEFAULT_SHELL_URL;
        if (!TextUtils.isEmpty((CharSequence)mStartupUrl)) {
            this.setStartupUrl(Shell.sanitizeUrl(mStartupUrl));
        }
        if (CommandLine.getInstance().hasSwitch(RUN_WEB_TESTS_SWITCH)) {
            c c2 = c.get(3);
            try {
                c2.startBrowserProcessesSync(false);
            }
            catch (a.b.a.a.d d2) {
                Log.e((String)TAG, (String)"Failed to load native library.", (Throwable)d2);
                System.exit(-1);
            }
        } else {
            c c3 = c.get(3);
            try {
                c3.startBrowserProcessesAsync(true, false, new c.a(){

                    @Override
                    public void onSuccess() {
                        1 v0 = this;
                        ShellManager.access$002(v0.ShellManager.this, true);
                        v0.ShellManager.this.finishInitialization(bundle);
                    }

                    @Override
                    public void onFailure() {
                        ShellManager.this.initializationFailed();
                    }
                });
            }
            catch (a.b.a.a.d d3) {
                Log.e((String)TAG, (String)"Unable to load native library.", (Throwable)d3);
                System.exit(-1);
            }
        }
    }

    public void setOnWebViewListener(OnWebViewListener onWebViewListener) {
        this.onWebViewListener = onWebViewListener;
    }

    public void setConfigListener(OnConfigListener onConfigListener) {
        this.configListener = onConfigListener;
    }
}

