/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content_public.browser;

import a.b.d.b.a;
import android.support.annotation.Nullable;
import java.util.Locale;
import java.util.Map;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.content_public.common.ResourceRequestBody;

@JNINamespace(value="content")
public class LoadUrlParams {
    public String mUrl;
    public String mInitiatorOrigin;
    public int mLoadUrlType;
    public int mTransitionType;
    public a mReferrer;
    public Map<String, String> mExtraHeaders;
    public String mVerbatimHeaders;
    public int mUaOverrideOption;
    public ResourceRequestBody mPostData;
    public String mBaseUrlForDataUrl;
    public String mVirtualUrlForDataUrl;
    public String mDataUrlAsString;
    public boolean mCanLoadLocalResources;
    public boolean mIsRendererInitiated;
    public boolean mShouldReplaceCurrentEntry;
    public long mIntentReceivedTimestamp;
    public long mInputStartTimestamp;
    public boolean mHasUserGesture;
    public boolean mShouldClearHistoryList;

    public LoadUrlParams(String string2) {
        this(string2, 0);
    }

    public LoadUrlParams(String string2, int n2) {
        LoadUrlParams loadUrlParams = this;
        this.mUrl = string2;
        loadUrlParams.mTransitionType = n2;
        loadUrlParams.mLoadUrlType = 0;
        loadUrlParams.mUaOverrideOption = 0;
        loadUrlParams.mPostData = null;
        loadUrlParams.mBaseUrlForDataUrl = null;
        loadUrlParams.mVirtualUrlForDataUrl = null;
        loadUrlParams.mDataUrlAsString = null;
    }

    public static LoadUrlParams createLoadDataParams(String string2, String string3, boolean bl) {
        return LoadUrlParams.createLoadDataParams(string2, string3, bl, null);
    }

    public static LoadUrlParams createLoadDataParams(String string2, String string3, boolean bl, String string4) {
        LoadUrlParams loadUrlParams = new LoadUrlParams(LoadUrlParams.buildDataUri(string2, string3, bl, string4), 0);
        loadUrlParams.setLoadType(2);
        loadUrlParams.setTransitionType(1);
        return loadUrlParams;
    }

    public static String buildDataUri(String string2, String string3, boolean bl, String string4) {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder2("data:");
        stringBuilder.append(string3);
        if (string4 != null && !string4.isEmpty()) {
            stringBuilder2.append(";charset=" + string4);
        }
        if (bl) {
            stringBuilder2.append(";base64");
        }
        StringBuilder stringBuilder3 = stringBuilder2;
        stringBuilder2.append(",");
        stringBuilder3.append(string2);
        return stringBuilder3.toString();
    }

    public static LoadUrlParams createLoadDataParamsWithBaseUrl(String string2, String string3, boolean bl, String string4, String string5) {
        return LoadUrlParams.createLoadDataParamsWithBaseUrl(string2, string3, bl, string4, string5, null);
    }

    public static LoadUrlParams createLoadDataParamsWithBaseUrl(String object, String string2, boolean bl, String string3, String string4, String string5) {
        Object object2;
        if (string3 != null && string3.toLowerCase(Locale.US).startsWith("data:")) {
            object2 = object = LoadUrlParams.createLoadDataParams((String)object, string2, bl, string5);
        } else {
            object2 = LoadUrlParams.createLoadDataParams("", string2, bl, string5);
            if (string3 == null) {
                string3 = "about:blank";
            }
            ((LoadUrlParams)object2).setBaseUrlForDataUrl(string3);
            if (string4 == null) {
                string4 = "about:blank";
            }
            ((LoadUrlParams)object2).setVirtualUrlForDataUrl(string4);
            ((LoadUrlParams)object2).setDataUrlAsString(LoadUrlParams.buildDataUri((String)object, string2, bl, string5));
        }
        return object2;
    }

    public static LoadUrlParams createLoadHttpPostParams(String string2, byte[] byArray) {
        LoadUrlParams loadUrlParams = new LoadUrlParams(string2, 0);
        loadUrlParams.setLoadType(1);
        loadUrlParams.setTransitionType(1);
        loadUrlParams.setPostData(ResourceRequestBody.createFromBytes(byArray));
        return loadUrlParams;
    }

    private String getExtraHeadersString(String string2, boolean bl) {
        StringBuilder stringBuilder;
        if (((LoadUrlParams)((Object)stringBuilder2)).mExtraHeaders == null) {
            return null;
        }
        LoadUrlParams loadUrlParams = stringBuilder2;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder();
        for (Map.Entry<String, String> entry : loadUrlParams.mExtraHeaders.entrySet()) {
            if (stringBuilder2.length() > 0) {
                stringBuilder2.append(string2);
            }
            Object object = stringBuilder2;
            ((StringBuilder)object).append(entry.getKey().toLowerCase(Locale.US));
            ((StringBuilder)object).append(":");
            stringBuilder2.append(entry.getValue());
        }
        if (bl) {
            stringBuilder2.append(string2);
        }
        return stringBuilder2.toString();
    }

    public static native boolean nativeIsDataScheme(String var0);

    public void setUrl(String string2) {
        this.mUrl = string2;
    }

    public String getUrl() {
        return this.mUrl;
    }

    public void setInitiatorOrigin(String string2) {
        this.mInitiatorOrigin = string2;
    }

    @Nullable
    public String getInitiatorOrigin() {
        return this.mInitiatorOrigin;
    }

    public String getBaseUrl() {
        return this.mBaseUrlForDataUrl;
    }

    public void setLoadType(int n2) {
        this.mLoadUrlType = n2;
    }

    public void setTransitionType(int n2) {
        this.mTransitionType = n2;
    }

    public int getTransitionType() {
        return this.mTransitionType;
    }

    public void setReferrer(a a2) {
    }

    public a getReferrer() {
        return null;
    }

    public void setExtraHeaders(Map<String, String> map) {
        this.mExtraHeaders = map;
    }

    public Map<String, String> getExtraHeaders() {
        return this.mExtraHeaders;
    }

    public String getExtraHeadersString() {
        return this.getExtraHeadersString("\n", false);
    }

    public String getExtraHttpRequestHeadersString() {
        return this.getExtraHeadersString("\r\n", true);
    }

    public void setVerbatimHeaders(String string2) {
        this.mVerbatimHeaders = string2;
    }

    public String getVerbatimHeaders() {
        return this.mVerbatimHeaders;
    }

    public void setOverrideUserAgent(int n2) {
        this.mUaOverrideOption = n2;
    }

    public int getUserAgentOverrideOption() {
        return this.mUaOverrideOption;
    }

    public void setPostData(ResourceRequestBody resourceRequestBody) {
        this.mPostData = resourceRequestBody;
    }

    public ResourceRequestBody getPostData() {
        return this.mPostData;
    }

    public void setBaseUrlForDataUrl(String string2) {
        this.mBaseUrlForDataUrl = string2;
    }

    public String getVirtualUrlForDataUrl() {
        return this.mVirtualUrlForDataUrl;
    }

    public void setVirtualUrlForDataUrl(String string2) {
        this.mVirtualUrlForDataUrl = string2;
    }

    public String getDataUrlAsString() {
        return this.mDataUrlAsString;
    }

    public void setDataUrlAsString(String string2) {
        this.mDataUrlAsString = string2;
    }

    public void setCanLoadLocalResources(boolean bl) {
        this.mCanLoadLocalResources = bl;
    }

    public boolean getCanLoadLocalResources() {
        return this.mCanLoadLocalResources;
    }

    public int getLoadUrlType() {
        return this.mLoadUrlType;
    }

    public void setIsRendererInitiated(boolean bl) {
        this.mIsRendererInitiated = bl;
    }

    public boolean getIsRendererInitiated() {
        return this.mIsRendererInitiated;
    }

    public void setShouldReplaceCurrentEntry(boolean bl) {
        this.mShouldReplaceCurrentEntry = bl;
    }

    public boolean getShouldReplaceCurrentEntry() {
        return this.mShouldReplaceCurrentEntry;
    }

    public void setIntentReceivedTimestamp(long l2) {
        this.mIntentReceivedTimestamp = l2;
    }

    public long getIntentReceivedTimestamp() {
        return this.mIntentReceivedTimestamp;
    }

    public void setInputStartTimestamp(long l2) {
        this.mInputStartTimestamp = l2;
    }

    public long getInputStartTimestamp() {
        return this.mInputStartTimestamp;
    }

    public void setHasUserGesture(boolean bl) {
        this.mHasUserGesture = bl;
    }

    public boolean getHasUserGesture() {
        return this.mHasUserGesture;
    }

    public void setShouldClearHistoryList(boolean bl) {
        this.mShouldClearHistoryList = bl;
    }

    public boolean getShouldClearHistoryList() {
        return this.mShouldClearHistoryList;
    }

    public boolean isBaseUrlDataScheme() {
        if (this.mBaseUrlForDataUrl == null && this.mLoadUrlType == 2) {
            return true;
        }
        return LoadUrlParams.nativeIsDataScheme(this.mBaseUrlForDataUrl);
    }
}

