/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser.selection;

import a.a.a.a.a;
import a.b.a.g;
import a.b.c.b.f.b;
import a.b.c.b.f.c;
import a.b.c.b.f.e;
import a.b.c.b.f.j;
import a.b.c.b.f.k;
import a.b.c.b.f.m;
import a.b.c.b.f.n;
import a.b.c.b.f.o;
import a.b.c.b.f.p;
import a.b.c.b.f.q;
import a.b.c.b.f.r;
import a.b.c.b.h;
import a.b.c.b.n;
import a.b.c.b.y;
import a.b.d.a.i;
import a.b.d.a.u;
import a.b.d.a.w;
import a.b.p.b.a;
import android.annotation.TargetApi;
import android.content.ActivityNotFoundException;
import android.content.ClipDescription;
import android.content.ClipboardManager;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.content.res.Resources;
import android.graphics.Rect;
import android.os.Build;
import android.provider.Settings;
import android.support.annotation.Nullable;
import android.text.Spanned;
import android.text.TextUtils;
import android.text.style.CharacterStyle;
import android.text.style.ParagraphStyle;
import android.text.style.UpdateAppearance;
import android.view.ActionMode;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.view.textclassifier.TextClassification;
import android.view.textclassifier.TextClassifier;
import com.vccorp.content.R;
import java.lang.reflect.Constructor;
import java.util.List;
import org.chromium.base.BuildInfo;
import org.chromium.base.ThreadUtils;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.base.metrics.RecordUserAction;
import org.chromium.content.browser.GestureListenerManagerImpl;
import org.chromium.content.browser.input.ImeAdapterImpl;
import org.chromium.content.browser.webcontents.WebContentsImpl;
import org.chromium.content_public.browser.ActionModeCallbackHelper;
import org.chromium.content_public.browser.WebContents;
import org.chromium.ui.base.DeviceFormFactor;
import org.chromium.ui.base.ViewAndroidDelegate;
import org.chromium.ui.base.WindowAndroid;

@JNINamespace(value="content")
@TargetApi(value=21)
public class SelectionPopupControllerImpl
extends ActionModeCallbackHelper
implements i,
w,
a.b.c.b.w,
n.a,
ViewAndroidDelegate.ContainerViewObserver,
a.b.a.o {
    public static final String TAG = "SelectionPopupCtlr";
    public static final int MAX_SHARE_QUERY_LENGTH = 100000;
    public static final int SHOW_DELAY_MS = 300;
    public static final int MENU_ITEM_ORDER_TEXT_PROCESS_START = 100;
    public static boolean sShouldGetReadbackViewFromWindowAndroid;
    public static final /* synthetic */ boolean $assertionsDisabled;
    public Context mContext;
    public WindowAndroid mWindowAndroid;
    public WebContentsImpl mWebContents;
    public ActionMode.Callback mCallback;
    public long mNativeSelectionPopupController;
    public u.b mResultCallback;
    public ActionMode.Callback mNonSelectionCallback;
    public final Rect mSelectionRect;
    public Runnable mRepeatingHideRunnable;
    public View mView;
    public ActionMode mActionMode;
    public int mAllowedMenuItems;
    public boolean mHidden;
    public boolean mEditable;
    public boolean mIsPasswordType;
    public boolean mIsInsertionForTesting;
    public boolean mCanSelectAllForPastePopup;
    public boolean mCanEditRichly;
    public boolean mUnselectAllOnDismiss;
    public String mLastSelectedText;
    public int mLastSelectionOffset;
    public boolean mIsInHandleDragging;
    public boolean mHasSelection;
    public n mPastePopupMenu;
    public boolean mWasPastePopupShowingOnInsertionDragStart;
    public u mSelectionClient;
    public r mSelectionMetricsLogger;
    public a.b.c.b.n mPopupController;
    public u.a mClassificationResult;
    public boolean mPreserveSelectionOnNextLossOfFocus;
    public q mHandleObserver;
    public a.b.c.b.f.a mAdditionalMenuItemProvider;

    public static void setShouldGetReadbackViewFromWindowAndroid() {
        sShouldGetReadbackViewFromWindowAndroid = true;
    }

    public static SelectionPopupControllerImpl fromWebContents(WebContents webContents) {
        return ((WebContentsImpl)webContents).getOrSetUserData(SelectionPopupControllerImpl.class, UserDataFactoryLazyHolder.INSTANCE);
    }

    public static SelectionPopupControllerImpl createForTesting(WebContents webContents, a.b.c.b.n n2) {
        return new SelectionPopupControllerImpl(webContents, n2, false);
    }

    public static SelectionPopupControllerImpl createForTesting(WebContents webContents) {
        return new SelectionPopupControllerImpl(webContents, null, false);
    }

    public SelectionPopupControllerImpl(WebContents webContents) {
        SelectionPopupControllerImpl selectionPopupControllerImpl = this;
        selectionPopupControllerImpl(webContents, null, true);
        selectionPopupControllerImpl.setActionModeCallback(ActionModeCallbackHelper.EMPTY_CALLBACK);
    }

    public SelectionPopupControllerImpl(WebContents object, a.b.c.b.n n2, boolean bl) {
        SelectionPopupControllerImpl selectionPopupControllerImpl = this;
        this.mSelectionRect = new Rect();
        this.mWebContents = (WebContentsImpl)object;
        selectionPopupControllerImpl.mPopupController = n2;
        selectionPopupControllerImpl.mContext = selectionPopupControllerImpl.mWebContents.getContext();
        selectionPopupControllerImpl.mWindowAndroid = selectionPopupControllerImpl.mWebContents.getTopLevelNativeWindow();
        object = selectionPopupControllerImpl.mWebContents.getViewAndroidDelegate();
        if (object != null) {
            this.mView = ((ViewAndroidDelegate)object).getContainerView();
            ((ViewAndroidDelegate)object).addObserver(this);
        }
        this.mAllowedMenuItems = 7;
        this.mRepeatingHideRunnable = new Runnable(){
            public static final /* synthetic */ boolean $assertionsDisabled;

            static {
                $assertionsDisabled = SelectionPopupControllerImpl.class.desiredAssertionStatus() ^ true;
            }

            @Override
            public void run() {
                if (!$assertionsDisabled && !SelectionPopupControllerImpl.this.mHidden) {
                    throw new AssertionError();
                }
                1 v0 = this;
                long l2 = v0.SelectionPopupControllerImpl.this.getDefaultHideDuration();
                v0.SelectionPopupControllerImpl.this.mView.postDelayed(SelectionPopupControllerImpl.this.mRepeatingHideRunnable, l2 - 1L);
                v0.SelectionPopupControllerImpl.this.hideActionModeTemporarily(l2);
            }
        };
        object = y.a(this.mWebContents);
        if (object != null) {
            ((y)object).a(this);
        }
        if (bl) {
            SelectionPopupControllerImpl selectionPopupControllerImpl2 = this;
            selectionPopupControllerImpl2.mNativeSelectionPopupController = selectionPopupControllerImpl2.nativeInit(selectionPopupControllerImpl2.mWebContents);
            object = ImeAdapterImpl.fromWebContents(selectionPopupControllerImpl2.mWebContents);
            if (object != null) {
                ((ImeAdapterImpl)object).addEventObserver(this);
            }
        }
        this.mResultCallback = new SmartSelectionCallback(null);
        this.mLastSelectedText = "";
        this.initHandleObserver();
        ThreadUtils.assertOnUiThread();
        if (h.a == null) {
            h.a = new h();
        }
        this.mAdditionalMenuItemProvider = h.a.a();
        this.getPopupController().a.add(this);
    }

    public static String sanitizeQuery(String string2, int n2) {
        if (!TextUtils.isEmpty((CharSequence)string2) && string2.length() >= n2) {
            Object[] objectArray = new Object[]{};
            a.b.a.j.d(TAG, a.a("Truncating oversized query (").append(string2.length()).append(").").toString(), objectArray);
            return string2.substring(0, n2) + "\u2026";
        }
        return string2;
    }

    private boolean isActionModeSupported() {
        return this.mCallback != ActionModeCallbackHelper.EMPTY_CALLBACK;
    }

    private ActionMode startFloatingActionMode() {
        if (!$assertionsDisabled && Build.VERSION.SDK_INT < 23) {
            throw new AssertionError();
        }
        ActionMode.Callback callback = this.mCallback;
        return this.mView.startActionMode((ActionMode.Callback)new c(this, callback), 1);
    }

    private void createAndShowPastePopup() {
        if (this.mView.getParent() != null && this.mView.getVisibility() == 0) {
            n.a a2;
            if (!this.supportsFloatingActionMode() && !this.canPaste() && this.mNonSelectionCallback == null) {
                return;
            }
            SelectionPopupControllerImpl selectionPopupControllerImpl = this;
            selectionPopupControllerImpl.destroyPastePopup();
            n.a a3 = a2;
            a2 = new n.a(){

                @Override
                public void paste() {
                    2 v0 = this;
                    v0.SelectionPopupControllerImpl.this.paste();
                    v0.SelectionPopupControllerImpl.this.mWebContents.dismissTextHandles();
                }

                @Override
                public void pasteAsPlainText() {
                    2 v0 = this;
                    v0.SelectionPopupControllerImpl.this.pasteAsPlainText();
                    v0.SelectionPopupControllerImpl.this.mWebContents.dismissTextHandles();
                }

                @Override
                public boolean canPaste() {
                    return SelectionPopupControllerImpl.this.canPaste();
                }

                @Override
                public void selectAll() {
                    SelectionPopupControllerImpl.this.selectAll();
                }

                @Override
                public boolean canSelectAll() {
                    return SelectionPopupControllerImpl.this.canSelectAll();
                }

                @Override
                public boolean canPasteAsPlainText() {
                    return SelectionPopupControllerImpl.this.canPasteAsPlainText();
                }
            };
            Context context = (Context)selectionPopupControllerImpl.mWindowAndroid.getContext().get();
            if (context == null) {
                return;
            }
            this.mPastePopupMenu = this.supportsFloatingActionMode() ? new e(context, this.mView, a3, this.mNonSelectionCallback) : new j(context, this.mView, a3);
            this.showPastePopup();
            return;
        }
    }

    private void showPastePopup() {
        try {
            this.mPastePopupMenu.a(this.getSelectionRectRelativeToContainingView());
        }
        catch (WindowManager.BadTokenException badTokenException) {}
    }

    private void hideActionMode(boolean bl) {
        if (!this.isFloatingActionMode()) {
            return;
        }
        if (this.mHidden == bl) {
            return;
        }
        this.mHidden = bl;
        if (this.mHidden) {
            this.mRepeatingHideRunnable.run();
        } else {
            SelectionPopupControllerImpl selectionPopupControllerImpl = this;
            selectionPopupControllerImpl.mView.removeCallbacks(this.mRepeatingHideRunnable);
            selectionPopupControllerImpl.hideActionModeTemporarily(300L);
        }
    }

    private void hideActionModeTemporarily(long l2) {
        if (!$assertionsDisabled && !this.isFloatingActionMode()) {
            throw new AssertionError();
        }
        if (Build.VERSION.SDK_INT >= 23 && this.isActionModeValid()) {
            this.mActionMode.hide(l2);
        }
    }

    private boolean isFloatingActionMode() {
        return this.supportsFloatingActionMode() && this.isActionModeValid() && this.mActionMode.getType() == 1;
    }

    private long getDefaultHideDuration() {
        if (this.supportsFloatingActionMode()) {
            return ViewConfiguration.getDefaultActionModeHideDuration();
        }
        return 2000L;
    }

    public static void initializeMenu(Context context, ActionMode actionMode, Menu menu2) {
        try {
            actionMode.getMenuInflater().inflate(R.menu.select_action_menu, menu2);
        }
        catch (Resources.NotFoundException notFoundException) {
            new MenuInflater(context).inflate(R.menu.select_action_menu, menu2);
        }
    }

    @TargetApi(value=26)
    public static void setPasteAsPlainTextMenuItemTitle(Menu menu2) {
        if ((menu2 = menu2.findItem(R.id.select_action_menu_paste_as_plain_text)) == null) {
            return;
        }
        if (!$assertionsDisabled && Build.VERSION.SDK_INT < 26) {
            throw new AssertionError();
        }
        menu2.setTitle(17039385);
    }

    private void createActionMenu(ActionMode actionMode, Menu menu2) {
        a.b.c.b.f.a a2;
        SelectionPopupControllerImpl selectionPopupControllerImpl = this;
        SelectionPopupControllerImpl.initializeMenu(this.mContext, actionMode, menu2);
        this.updateAssistMenuItem(menu2);
        this.removeActionMenuItemsIfNecessary(menu2);
        SelectionPopupControllerImpl.setPasteAsPlainTextMenuItemTitle(menu2);
        actionMode = (Context)selectionPopupControllerImpl.mWindowAndroid.getContext().get();
        u.a a3 = selectionPopupControllerImpl.mClassificationResult;
        if (a3 != null && (a2 = this.mAdditionalMenuItemProvider) != null && actionMode != null) {
            a3 = a3.g;
            ((b)a2).a((Context)actionMode, menu2, (TextClassification)a3);
        }
        if (this.hasSelection() && !this.isSelectionPassword()) {
            this.initializeTextProcessingMenu(menu2);
            return;
        }
    }

    private void removeActionMenuItemsIfNecessary(Menu menu2) {
        if (!this.isFocusedNodeEditable() || !this.canPaste()) {
            Menu menu3 = menu2;
            menu3.removeItem(R.id.select_action_menu_paste);
            menu3.removeItem(R.id.select_action_menu_paste_as_plain_text);
        }
        if (!this.canPasteAsPlainText()) {
            menu2.removeItem(R.id.select_action_menu_paste_as_plain_text);
        }
        if (!this.hasSelection()) {
            Menu menu4 = menu2;
            menu4.removeItem(R.id.select_action_menu_select_all);
            menu4.removeItem(R.id.select_action_menu_cut);
            menu4.removeItem(R.id.select_action_menu_copy);
            menu4.removeItem(R.id.select_action_menu_share);
            menu4.removeItem(R.id.select_action_menu_web_search);
            return;
        }
        if (!this.isFocusedNodeEditable()) {
            menu2.removeItem(R.id.select_action_menu_cut);
        }
        if (this.isFocusedNodeEditable() || !this.isSelectActionModeAllowed(1)) {
            menu2.removeItem(R.id.select_action_menu_share);
        }
        if (this.isFocusedNodeEditable() || this.mWebContents.isIncognito() || !this.isSelectActionModeAllowed(2)) {
            menu2.removeItem(R.id.select_action_menu_web_search);
        }
        if (this.isSelectionPassword()) {
            Menu menu5 = menu2;
            menu5.removeItem(R.id.select_action_menu_copy);
            menu5.removeItem(R.id.select_action_menu_cut);
        }
    }

    private boolean canPaste() {
        return ((ClipboardManager)this.mContext.getSystemService("clipboard")).hasPrimaryClip();
    }

    private boolean hasStyleSpan(Spanned spanned) {
        Class[] classArray = new Class[3];
        Class[] classArray2 = classArray;
        classArray[0] = CharacterStyle.class;
        classArray[1] = ParagraphStyle.class;
        classArray[2] = UpdateAppearance.class;
        int n2 = classArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Spanned spanned2 = spanned;
            Class clazz = classArray2[i2];
            if (spanned2.nextSpanTransition(-1, spanned2.length(), clazz) >= spanned.length()) continue;
            return true;
        }
        return false;
    }

    private void updateAssistMenuItem(Menu object) {
        if (Build.VERSION.SDK_INT < 26) {
            return;
        }
        u.a a2 = this.mClassificationResult;
        if (a2 != null && a2.a()) {
            Menu menu2 = object;
            object = this.mClassificationResult.c;
            menu2.add(R.id.select_action_menu_assist_items, 16908353, 1, (CharSequence)object).setIcon(this.mClassificationResult.d);
        }
    }

    private void initializeTextProcessingMenu(Menu menu2) {
        if (Build.VERSION.SDK_INT >= 23 && this.isSelectActionModeAllowed(4)) {
            List list = this.mContext.getPackageManager().queryIntentActivities(SelectionPopupControllerImpl.createProcessTextIntent(), 0);
            for (int i2 = 0; i2 < list.size(); ++i2) {
                ResolveInfo resolveInfo = (ResolveInfo)list.get(i2);
                CharSequence charSequence = resolveInfo.loadLabel(this.mContext.getPackageManager());
                menu2.add(R.id.select_action_menu_text_processing_menus, 0, i2 + 100, charSequence).setIntent(this.createProcessTextIntentForResolveInfo(resolveInfo)).setShowAsAction(1);
            }
            return;
        }
    }

    @TargetApi(value=23)
    public static Intent createProcessTextIntent() {
        return new Intent().setAction("android.intent.action.PROCESS_TEXT").setType("text/plain");
    }

    @TargetApi(value=23)
    private Intent createProcessTextIntentForResolveInfo(ResolveInfo resolveInfo) {
        boolean bl = this.isFocusedNodeEditable() ^ true;
        return SelectionPopupControllerImpl.createProcessTextIntent().putExtra("android.intent.extra.PROCESS_TEXT_READONLY", bl).setClassName(resolveInfo.activityInfo.packageName, resolveInfo.activityInfo.name);
    }

    private Rect getSelectionRectRelativeToContainingView() {
        float f2 = this.getDeviceScaleFactor();
        Rect rect = this.mSelectionRect;
        Rect rect2 = new Rect((int)((float)rect.left * f2), (int)((float)rect.top * f2), (int)((float)rect.right * f2), (int)((float)rect.bottom * f2));
        rect2.offset(0, (int)this.mWebContents.getRenderCoordinates().k);
        return rect2;
    }

    private float getDeviceScaleFactor() {
        return this.mWebContents.getRenderCoordinates().j;
    }

    private int getActionType(int n2, int n3) {
        if (n3 == 16908353) {
            return 105;
        }
        if (n2 == R.id.select_action_menu_select_all) {
            return 200;
        }
        if (n2 == R.id.select_action_menu_cut) {
            return 103;
        }
        if (n2 == R.id.select_action_menu_copy) {
            return 101;
        }
        if (n2 != R.id.select_action_menu_paste && n2 != R.id.select_action_menu_paste_as_plain_text) {
            if (n2 == R.id.select_action_menu_share) {
                return 104;
            }
            if (n2 == 16908353) {
                return 105;
            }
            return 108;
        }
        return 102;
    }

    private void processText(Intent intent) {
        WindowAndroid.IntentCallback intentCallback;
        Intent intent2;
        WindowAndroid windowAndroid;
        RecordUserAction.record("MobileActionMode.ProcessTextIntent");
        if (!$assertionsDisabled && Build.VERSION.SDK_INT < 23) {
            throw new AssertionError();
        }
        String string2 = SelectionPopupControllerImpl.sanitizeQuery(this.getSelectedText(), 1000);
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return;
        }
        intent.putExtra("android.intent.extra.PROCESS_TEXT", string2);
        try {
            windowAndroid = this.mWindowAndroid;
            intent2 = intent;
            intentCallback = new WindowAndroid.IntentCallback(){

                @Override
                public void onIntentCompleted(WindowAndroid windowAndroid, int n2, Intent intent) {
                    SelectionPopupControllerImpl.this.onReceivedProcessTextResult(n2, intent);
                }
            };
        }
        catch (ActivityNotFoundException activityNotFoundException) {}
        windowAndroid.showIntent(intent2, intentCallback, null);
    }

    private boolean isIncognito() {
        return this.mWebContents.isIncognito();
    }

    private boolean isSelectActionModeAllowed(int n2) {
        boolean bl = (this.mAllowedMenuItems & n2) != 0;
        if (n2 == 1) {
            return bl && this.isShareAvailable();
        }
        return bl;
    }

    private void setTextHandlesTemporarilyHidden(boolean bl) {
        long l2 = this.mNativeSelectionPopupController;
        if (l2 == 0L) {
            return;
        }
        this.nativeSetTextHandlesTemporarilyHidden(l2, bl);
    }

    private a.b.c.b.n getPopupController() {
        if (this.mPopupController == null) {
            this.mPopupController = a.b.c.b.n.a(this.mWebContents);
        }
        return this.mPopupController;
    }

    private Context getContext() {
        return this.mContext;
    }

    private void initHandleObserver() {
        ThreadUtils.assertOnUiThread();
        if (h.a == null) {
            h.a = new h();
        }
        this.mHandleObserver = h.a.a(() -> {
            if (sShouldGetReadbackViewFromWindowAndroid) {
                a.a a2 = ((SelectionPopupControllerImpl)a2).mWindowAndroid;
                return a2 == null ? null : ((WindowAndroid)a2).getReadbackView();
            }
            return ((SelectionPopupControllerImpl)a2).mView;
        });
    }

    private void onSelectWordAroundCaretAck(boolean bl, int n2, int n3) {
        u u2 = ((SelectionPopupControllerImpl)((Object)u2)).mSelectionClient;
        if (u2 != null) {
            u2.selectWordAroundCaretAck(bl, n2, n3);
        }
    }

    private boolean isShareAvailable() {
        Intent intent;
        SelectionPopupControllerImpl selectionPopupControllerImpl = selectionPopupControllerImpl2;
        SelectionPopupControllerImpl selectionPopupControllerImpl2 = intent;
        new Intent("android.intent.action.SEND").setType("text/plain");
        return selectionPopupControllerImpl.mContext.getPackageManager().queryIntentActivities((Intent)selectionPopupControllerImpl2, 65536).size() > 0;
    }

    public static boolean isDeviceProvisioned(Context context) {
        if (context != null && context.getContentResolver() != null) {
            return Settings.Global.getInt((ContentResolver)context.getContentResolver(), (String)"device_provisioned", (int)0) != 0;
        }
        return true;
    }

    private void nativeSelectionPopupControllerDestroyed() {
        this.mNativeSelectionPopupController = 0L;
    }

    private native long nativeInit(WebContents var1);

    private native void nativeSetTextHandlesTemporarilyHidden(long var1, boolean var3);

    public static /* synthetic */ u.a access$902(SelectionPopupControllerImpl selectionPopupControllerImpl, u.a a2) {
        selectionPopupControllerImpl.mClassificationResult = a2;
        return a2;
    }

    static {
        $assertionsDisabled = SelectionPopupControllerImpl.class.desiredAssertionStatus() ^ true;
    }

    @Override
    public void onUpdateContainerView(ViewGroup viewGroup) {
        if (!$assertionsDisabled && viewGroup == null) {
            throw new AssertionError();
        }
        if (this.isActionModeValid()) {
            this.finishActionMode();
        }
        ViewGroup viewGroup2 = viewGroup;
        this.mUnselectAllOnDismiss = true;
        this.destroyPastePopup();
        viewGroup2.setClickable(true);
        this.mView = viewGroup2;
        this.initHandleObserver();
    }

    @Override
    public void onNodeAttributeUpdated(boolean bl, boolean bl2) {
        this.updateSelectionState(bl, bl2);
    }

    @Override
    public void setActionModeCallback(ActionMode.Callback callback) {
        this.mCallback = callback;
    }

    public void setNonSelectionActionModeCallback(ActionMode.Callback callback) {
        this.mNonSelectionCallback = callback;
    }

    public u.b getResultCallback() {
        return this.mResultCallback;
    }

    public u.a getClassificationResult() {
        return this.mClassificationResult;
    }

    public u getSelectionClient() {
        return this.mSelectionClient;
    }

    @Override
    public boolean isActionModeValid() {
        return this.mActionMode != null;
    }

    @Override
    public void setAllowedMenuItems(int n2) {
        this.mAllowedMenuItems = n2;
    }

    public void showSelectionMenu(int n2, int n3, int n4, int n5, int n6, boolean bl, boolean bl2, String object, int n7, boolean bl3, boolean bl4, boolean bl5, int n8) {
        if (this.supportsFloatingActionMode()) {
            n5 += n6;
        }
        this.mSelectionRect.set(n2, n3, n4, n5);
        this.mEditable = bl;
        this.mLastSelectedText = object;
        this.mLastSelectionOffset = n7;
        n2 = ((String)object).length() != 0 ? 1 : 0;
        this.mHasSelection = n2;
        this.mIsPasswordType = bl2;
        this.mCanSelectAllForPastePopup = bl3;
        this.mCanEditRichly = bl4;
        this.mUnselectAllOnDismiss = true;
        if (this.hasSelection()) {
            u u2;
            r r2;
            n2 = SelectionPopupControllerImpl.isDeviceProvisioned(this.mContext) ^ true | this.mWebContents.isIncognito();
            if (n2 == 0 && (r2 = this.mSelectionMetricsLogger) != null && n8 != 7) {
                if (n8 != 9) {
                    if (n8 != 10) {
                        Object var5_11;
                        Object[] objectArray;
                        SelectionPopupControllerImpl selectionPopupControllerImpl = this;
                        String string2 = selectionPopupControllerImpl.mLastSelectedText;
                        n5 = selectionPopupControllerImpl.mLastSelectionOffset;
                        Context context = r2.f;
                        Constructor constructor = r.c;
                        Object[] objectArray2 = objectArray = new Object[2];
                        objectArray2[0] = context;
                        int n9 = 1;
                        int n10 = bl ? 4 : 2;
                        try {
                            objectArray[n9] = object = Integer.valueOf(n10);
                            var5_11 = constructor.newInstance(objectArray);
                        }
                        catch (ReflectiveOperationException reflectiveOperationException) {
                            var5_11 = null;
                        }
                        r r3 = r2;
                        r3.g = var5_11;
                        r3.i = new p();
                        r3.i.a(string2, n5);
                        r3.i.g = n5;
                        r3.a(((o)r3.h).a(0));
                    } else {
                        r2.a(this.mLastSelectedText, this.mLastSelectionOffset, 201, null);
                    }
                } else {
                    r2.a(this.mLastSelectedText, this.mLastSelectionOffset, this.mClassificationResult);
                }
            }
            if (n2 == 0 && n8 == 9) {
                this.showActionModeOrClearOnFailure();
                return;
            }
            if (n2 != 0 || (u2 = this.mSelectionClient) == null || !u2.requestSelectionPopupUpdates(bl5)) {
                this.showActionModeOrClearOnFailure();
            }
        } else {
            this.createAndShowPastePopup();
        }
    }

    public void showActionModeOrClearOnFailure() {
        if (this.isActionModeSupported() && this.hasSelection()) {
            if (this.isActionModeValid() && !this.isFloatingActionMode()) {
                try {
                    this.mActionMode.invalidate();
                }
                catch (NullPointerException nullPointerException) {
                    Object[] objectArray = new Object[1];
                    Object[] objectArray2 = objectArray;
                    objectArray[0] = nullPointerException;
                    a.b.a.j.d(TAG, "Ignoring NPE from ActionMode.invalidate() as workaround for L", objectArray2);
                }
                this.hideActionMode(false);
                return;
            }
            this.destroyActionModeAndKeepSelection();
            if (!$assertionsDisabled && this.mWebContents == null) {
                throw new AssertionError();
            }
            ActionMode actionMode = this.supportsFloatingActionMode() ? this.startFloatingActionMode() : this.mView.startActionMode(this.mCallback);
            if (actionMode != null) {
                g.a(this.mContext, actionMode);
            }
            this.mActionMode = actionMode;
            this.mUnselectAllOnDismiss = true;
            if (!this.isActionModeValid()) {
                this.clearSelection();
            }
            return;
        }
    }

    @Override
    public boolean supportsFloatingActionMode() {
        return Build.VERSION.SDK_INT >= 23;
    }

    @Override
    public void hide() {
        this.destroyPastePopup();
    }

    public void destroyPastePopup() {
        if (this.isPastePopupShowing()) {
            this.mPastePopupMenu.hide();
            this.mPastePopupMenu = null;
        }
    }

    public boolean isPastePopupShowing() {
        return this.mPastePopupMenu != null;
    }

    @Override
    public void finishActionMode() {
        this.mHidden = false;
        View view = this.mView;
        if (view != null) {
            view.removeCallbacks(this.mRepeatingHideRunnable);
        }
        if (this.isActionModeValid()) {
            this.mActionMode.finish();
            this.mActionMode = null;
        }
    }

    public void invalidateContentRect() {
        if (this.supportsFloatingActionMode() && this.isActionModeValid()) {
            this.mActionMode.invalidateContentRect();
        }
    }

    @Override
    public void onWindowFocusChanged(boolean bl) {
        if (this.supportsFloatingActionMode() && this.isActionModeValid()) {
            this.mActionMode.onWindowFocusChanged(bl);
        }
    }

    @Override
    public void onAttachedToWindow() {
        this.updateTextSelectionUI(true);
    }

    @Override
    public void onDetachedFromWindow() {
        this.updateTextSelectionUI(false);
    }

    @Override
    public void onWindowAndroidChanged(WindowAndroid windowAndroid) {
        SelectionPopupControllerImpl selectionPopupControllerImpl = this;
        selectionPopupControllerImpl.mWindowAndroid = windowAndroid;
        selectionPopupControllerImpl.initHandleObserver();
        selectionPopupControllerImpl.destroyPastePopup();
    }

    @Override
    public void onRotationChanged(int n2) {
        if (Build.VERSION.SDK_INT >= 23 && this.isActionModeValid()) {
            SelectionPopupControllerImpl selectionPopupControllerImpl = this;
            selectionPopupControllerImpl.hidePopupsAndPreserveSelection();
            selectionPopupControllerImpl.showActionModeOrClearOnFailure();
        }
    }

    @Override
    public void onViewFocusChanged(boolean bl, boolean bl2) {
        if (bl) {
            this.restoreSelectionPopupsIfNecessary();
        } else {
            SelectionPopupControllerImpl selectionPopupControllerImpl = this;
            ImeAdapterImpl.fromWebContents(selectionPopupControllerImpl.mWebContents).cancelRequestToScrollFocusedEditableNodeIntoView();
            if (selectionPopupControllerImpl.getPreserveSelectionOnNextLossOfFocus()) {
                SelectionPopupControllerImpl selectionPopupControllerImpl2 = this;
                selectionPopupControllerImpl2.setPreserveSelectionOnNextLossOfFocus(false);
                selectionPopupControllerImpl2.hidePopupsAndPreserveSelection();
            } else {
                SelectionPopupControllerImpl selectionPopupControllerImpl3 = this;
                selectionPopupControllerImpl3.destroyActionModeAndUnselect();
                selectionPopupControllerImpl3.mWebContents.dismissTextHandles();
                Object object = selectionPopupControllerImpl3.mWebContents;
                if (object != null && (object = a.b.c.b.n.a((WebContents)object)) != null) {
                    ((a.b.c.b.n)object).a();
                }
                this.clearSelection();
            }
        }
    }

    public void setScrollInProgress(boolean bl) {
        this.hideActionMode(bl);
    }

    @Override
    public void onCreateActionMode(ActionMode actionMode, Menu menu2) {
        String string2 = DeviceFormFactor.isWindowOnTablet(((SelectionPopupControllerImpl)((Object)string2)).mWindowAndroid) ? ((SelectionPopupControllerImpl)((Object)string2)).mContext.getString(R.string.actionbar_textselection_title) : null;
        ActionMode actionMode2 = actionMode;
        actionMode2.setTitle((CharSequence)string2);
        actionMode2.setSubtitle(null);
    }

    @Override
    public boolean onPrepareActionMode(ActionMode actionMode, Menu menu2) {
        a.b.c.b.f.a a2 = this.mAdditionalMenuItemProvider;
        if (a2 != null) {
            ((b)a2).a.clear();
        }
        Menu menu3 = menu2;
        menu3.removeGroup(R.id.select_action_menu_default_items);
        menu3.removeGroup(R.id.select_action_menu_assist_items);
        menu3.removeGroup(R.id.select_action_menu_text_processing_menus);
        menu3.removeGroup(16908353);
        this.createActionMenu(actionMode, menu3);
        return true;
    }

    public boolean canPasteAsPlainText() {
        if (Build.VERSION.SDK_INT < 26) {
            return false;
        }
        if (!this.mCanEditRichly) {
            return false;
        }
        Object object = (ClipboardManager)this.mContext.getSystemService("clipboard");
        if (!object.hasPrimaryClip()) {
            return false;
        }
        object = object.getPrimaryClip();
        ClipDescription clipDescription = object.getDescription();
        object = object.getItemAt(0).getText();
        if (clipDescription.hasMimeType("text/plain") && object instanceof Spanned && this.hasStyleSpan((Spanned)object)) {
            return true;
        }
        return clipDescription.hasMimeType("text/html");
    }

    @Override
    public boolean onActionItemClicked(ActionMode actionMode, MenuItem menuItem) {
        block17: {
            block8: {
                int n2;
                block16: {
                    block15: {
                        int n3;
                        block14: {
                            block13: {
                                block12: {
                                    block11: {
                                        block10: {
                                            block9: {
                                                block7: {
                                                    r r2;
                                                    if (!selectionPopupControllerImpl.isActionModeValid()) {
                                                        return true;
                                                    }
                                                    MenuItem menuItem2 = menuItem;
                                                    n3 = menuItem2.getItemId();
                                                    n2 = menuItem2.getGroupId();
                                                    if (selectionPopupControllerImpl.hasSelection() && (r2 = selectionPopupControllerImpl.mSelectionMetricsLogger) != null) {
                                                        r2.a(selectionPopupControllerImpl.mLastSelectedText, selectionPopupControllerImpl.mLastSelectionOffset, selectionPopupControllerImpl.getActionType(n3, n2), selectionPopupControllerImpl.mClassificationResult);
                                                    }
                                                    if (n2 != R.id.select_action_menu_assist_items || n3 != 16908353) break block7;
                                                    selectionPopupControllerImpl.doAssistAction();
                                                    actionMode.finish();
                                                    break block8;
                                                }
                                                if (n3 != R.id.select_action_menu_select_all) break block9;
                                                selectionPopupControllerImpl.selectAll();
                                                break block8;
                                            }
                                            if (n3 != R.id.select_action_menu_cut) break block10;
                                            selectionPopupControllerImpl.cut();
                                            actionMode.finish();
                                            break block8;
                                        }
                                        if (n3 != R.id.select_action_menu_copy) break block11;
                                        selectionPopupControllerImpl.copy();
                                        actionMode.finish();
                                        break block8;
                                    }
                                    if (n3 != R.id.select_action_menu_paste) break block12;
                                    selectionPopupControllerImpl.paste();
                                    actionMode.finish();
                                    break block8;
                                }
                                if (Build.VERSION.SDK_INT < 26 || n3 != R.id.select_action_menu_paste_as_plain_text) break block13;
                                selectionPopupControllerImpl.pasteAsPlainText();
                                actionMode.finish();
                                break block8;
                            }
                            if (n3 != R.id.select_action_menu_share) break block14;
                            selectionPopupControllerImpl.share();
                            actionMode.finish();
                            break block8;
                        }
                        if (n3 != R.id.select_action_menu_web_search) break block15;
                        selectionPopupControllerImpl.search();
                        actionMode.finish();
                        break block8;
                    }
                    if (n2 != R.id.select_action_menu_text_processing_menus) break block16;
                    selectionPopupControllerImpl.processText(menuItem.getIntent());
                    break block8;
                }
                if (n2 != 16908353) break block17;
                a.b.c.b.f.a a2 = selectionPopupControllerImpl.mAdditionalMenuItemProvider;
                if (a2 != null) {
                    SelectionPopupControllerImpl selectionPopupControllerImpl = selectionPopupControllerImpl.mView;
                    if ((menuItem = ((b)a2).a.get(menuItem)) != null) {
                        menuItem.onClick((View)selectionPopupControllerImpl);
                    }
                    actionMode.finish();
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void onDestroyActionMode() {
        this.mActionMode = null;
        if (this.mUnselectAllOnDismiss) {
            this.clearSelection();
        }
    }

    @Override
    public void onGetContentRect(ActionMode actionMode, View view, Rect rect) {
        rect.set(this.getSelectionRectRelativeToContainingView());
    }

    public void doAssistAction() {
        u.a a2 = this.mClassificationResult;
        if (a2 != null && a2.a()) {
            if (!$assertionsDisabled) {
                a2 = this.mClassificationResult;
                if (a2.f == null && a2.e == null) {
                    throw new AssertionError();
                }
            }
            a2 = this.mClassificationResult;
            View.OnClickListener onClickListener = a2.f;
            if (onClickListener != null) {
                onClickListener.onClick(this.mView);
                return;
            }
            if (a2.e != null) {
                a2 = (Context)this.mWindowAndroid.getContext().get();
                if (a2 == null) {
                    return;
                }
                a2.startActivity(this.mClassificationResult.e);
                return;
            }
            return;
        }
    }

    public void selectAll() {
        SelectionPopupControllerImpl selectionPopupControllerImpl = this;
        selectionPopupControllerImpl.mWebContents.selectAll();
        selectionPopupControllerImpl.mClassificationResult = null;
        if (selectionPopupControllerImpl.isFocusedNodeEditable()) {
            RecordUserAction.record("MobileActionMode.SelectAllWasEditable");
        } else {
            RecordUserAction.record("MobileActionMode.SelectAllWasNonEditable");
        }
    }

    public void cut() {
        this.mWebContents.cut();
    }

    public void copy() {
        this.mWebContents.copy();
    }

    public void paste() {
        this.mWebContents.paste();
    }

    public void pasteAsPlainText() {
        this.mWebContents.pasteAsPlainText();
    }

    public void share() {
        Object object;
        RecordUserAction.record("MobileActionMode.Share");
        String string2 = SelectionPopupControllerImpl.sanitizeQuery(selectionPopupControllerImpl2.getSelectedText(), 100000);
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return;
        }
        SelectionPopupControllerImpl selectionPopupControllerImpl = selectionPopupControllerImpl2;
        Intent intent = new Intent("android.intent.action.SEND");
        intent.setType("text/plain");
        intent.putExtra("android.intent.extra.TEXT", string2);
        try {
            SelectionPopupControllerImpl selectionPopupControllerImpl2 = Intent.createChooser((Intent)intent, (CharSequence)selectionPopupControllerImpl2.mContext.getString(R.string.actionbar_share));
            object = selectionPopupControllerImpl2;
        }
        catch (ActivityNotFoundException activityNotFoundException) {}
        object.setFlags(0x10000000);
        selectionPopupControllerImpl.mContext.startActivity((Intent)selectionPopupControllerImpl2);
    }

    public void search() {
        Intent intent;
        Intent intent2;
        RecordUserAction.record("MobileActionMode.WebSearch");
        String string2 = SelectionPopupControllerImpl.sanitizeQuery(this.getSelectedText(), 1000);
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return;
        }
        Intent intent3 = intent2 = intent;
        intent3("android.intent.action.WEB_SEARCH");
        intent3.putExtra("new_search", true);
        intent3.putExtra("query", string2);
        intent.putExtra("com.android.browser.application_id", this.mContext.getPackageName());
        intent.addFlags(0x10000000);
        try {
            this.mContext.startActivity(intent2);
        }
        catch (ActivityNotFoundException activityNotFoundException) {}
    }

    public boolean isSelectionPassword() {
        return this.mIsPasswordType;
    }

    public boolean isFocusedNodeEditable() {
        return this.mEditable;
    }

    public boolean isInsertionForTesting() {
        return this.mIsInsertionForTesting;
    }

    public boolean canSelectAll() {
        return this.mCanSelectAllForPastePopup;
    }

    @Override
    public void onReceivedProcessTextResult(int n2, Intent intent) {
        if (this.mWebContents != null && n2 == -1 && intent != null) {
            if (this.hasSelection() && this.isFocusedNodeEditable()) {
                CharSequence charSequence = intent.getCharSequenceExtra("android.intent.extra.PROCESS_TEXT");
                if (charSequence != null) {
                    this.mWebContents.replace(charSequence.toString());
                }
                return;
            }
            return;
        }
    }

    public void setPreserveSelectionOnNextLossOfFocus(boolean bl) {
        this.mPreserveSelectionOnNextLossOfFocus = bl;
    }

    public boolean getPreserveSelectionOnNextLossOfFocus() {
        return this.mPreserveSelectionOnNextLossOfFocus;
    }

    public void updateTextSelectionUI(boolean bl) {
        this.setTextHandlesTemporarilyHidden(bl ^ true);
        if (bl) {
            this.restoreSelectionPopupsIfNecessary();
        } else {
            SelectionPopupControllerImpl selectionPopupControllerImpl = this;
            selectionPopupControllerImpl.destroyActionModeAndKeepSelection();
            selectionPopupControllerImpl.getPopupController().a();
        }
    }

    public void restoreSelectionPopupsIfNecessary() {
        if (this.hasSelection() && !this.isActionModeValid()) {
            this.showActionModeOrClearOnFailure();
        }
    }

    /*
     * Unable to fully structure code
     */
    public void onSelectionEvent(int var1_3, int var2_4, int var3_9, int var4_10, int var5_11) {
        block27: {
            if (var2_4 == var4_10) {
                ++var4_10;
            }
            if (var3_9 == var5_11) {
                ++var5_11;
            }
            switch (var1_3) {
                default: {
                    if (SelectionPopupControllerImpl.$assertionsDisabled) {
                        break;
                    }
                    break block27;
                }
                case 10: {
                    if (this.mWasPastePopupShowingOnInsertionDragStart) {
                        var2_5 = this.mSelectionRect;
                        this.mWebContents.showContextMenuAtTouchHandle(var2_5.left, var2_5.bottom);
                    }
                    this.mWasPastePopupShowingOnInsertionDragStart = false;
                    var2_6 = this.mHandleObserver;
                    if (var2_6 == null) ** GOTO lbl58
                    ** GOTO lbl57
                }
                case 9: {
                    v0 = this;
                    v0.mWasPastePopupShowingOnInsertionDragStart = v0.isPastePopupShowing();
                    v0.destroyPastePopup();
                    v0.mIsInHandleDragging = true;
                    break;
                }
                case 8: {
                    v1 = this;
                    v1.destroyPastePopup();
                    v1.mIsInsertionForTesting = false;
                    if (v1.hasSelection()) break;
                    this.mSelectionRect.setEmpty();
                    break;
                }
                case 7: {
                    if (this.mWasPastePopupShowingOnInsertionDragStart) {
                        this.destroyPastePopup();
                    } else {
                        var2_7 = this.mSelectionRect;
                        this.mWebContents.showContextMenuAtTouchHandle(var2_7.left, var2_7.bottom);
                    }
                    this.mWasPastePopupShowingOnInsertionDragStart = false;
                    break;
                }
                case 6: {
                    v2 = this;
                    v2.mSelectionRect.set(var2_4, var3_9, var4_10, var5_11);
                    if (!v2.getGestureListenerManager().isScrollInProgress() && this.isPastePopupShowing()) {
                        this.showPastePopup();
                    } else {
                        this.destroyPastePopup();
                    }
                    if (!this.mIsInHandleDragging) break;
                    ** GOTO lbl81
                }
                case 5: {
                    this.mSelectionRect.set(var2_4, var3_9, var4_10, var5_11);
                    this.mIsInsertionForTesting = true;
                    break;
                }
                case 4: {
                    v3 = this;
                    v3.mWebContents.showContextMenuAtTouchHandle(var2_4, var5_11);
                    var2_6 = v3.mHandleObserver;
                    if (var2_6 == null) ** GOTO lbl58
lbl57:
                    // 2 sources

                    ((k)var2_6).b();
lbl58:
                    // 3 sources

                    this.mIsInHandleDragging = false;
                    break;
                }
                case 3: {
                    this.hideActionMode(true);
                    this.mIsInHandleDragging = true;
                    break;
                }
                case 2: {
                    v4 = this;
                    v4.mLastSelectedText = "";
                    v4.mLastSelectionOffset = 0;
                    v4.mHasSelection = false;
                    v4.mUnselectAllOnDismiss = false;
                    v4.mSelectionRect.setEmpty();
                    var2_8 = v4.mSelectionClient;
                    if (var2_8 != null) {
                        var2_8.cancelAllRequests();
                    }
                    this.finishActionMode();
                    break;
                }
                case 1: {
                    v5 = this;
                    v5.mSelectionRect.set(var2_4, var3_9, var4_10, var5_11);
                    v5.invalidateContentRect();
                    if (!v5.mIsInHandleDragging) break;
lbl81:
                    // 2 sources

                    this.performHapticFeedback();
                }
                case 0: 
            }
            if (this.mSelectionClient != null) {
                v6 = this;
                var0_1 = v6.getDeviceScaleFactor();
                v7 = v6.mSelectionRect;
                var2_4 = (int)((float)v7.left * var0_1);
                var0_2 = (int)((float)v7.bottom * var0_1);
                v6.mSelectionClient.onSelectionEvent(var1_3, var2_4, var0_2);
            }
            return;
        }
        throw new AssertionError((Object)"Invalid selection event type.");
    }

    public GestureListenerManagerImpl getGestureListenerManager() {
        return GestureListenerManagerImpl.fromWebContents(this.mWebContents);
    }

    public void onDragUpdate(float f2, float f3) {
        if (this.mHandleObserver != null) {
            float f4 = this.getDeviceScaleFactor();
            f2 *= f4;
            float f5 = f3 * f4 + this.mWebContents.getRenderCoordinates().k;
            k k2 = (k)this.mHandleObserver;
            if (((m)k2.a).b.getReadbackView() != null) {
                if (k2.c && f5 != k2.i) {
                    if (k2.b.isRunning()) {
                        k k3 = k2;
                        k3.b.cancel();
                        k3.a();
                        k3.f = k3.d;
                        k3.g = k3.e;
                    } else {
                        k k4 = k2;
                        k4.f = k4.h;
                        k4.g = k4.i;
                    }
                    k2.b.start();
                } else if (!k2.b.isRunning()) {
                    ((m)k2.a).a(f2, f5);
                }
                k k5 = k2;
                k2.h = f2;
                k5.i = f5;
                k5.c = true;
            }
        }
    }

    public void clearSelection() {
        if (this.mWebContents != null && this.isActionModeSupported()) {
            this.mWebContents.collapseSelection();
            this.mClassificationResult = null;
            return;
        }
    }

    public void performHapticFeedback() {
        if (BuildInfo.isAtLeastQ()) {
            this.mView.performHapticFeedback(9);
        }
    }

    public void onSelectionChanged(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2) && ((SelectionPopupControllerImpl)((Object)u2)).hasSelection()) {
            r r2 = ((SelectionPopupControllerImpl)((Object)u2)).mSelectionMetricsLogger;
            if (r2 != null) {
                r2.a(((SelectionPopupControllerImpl)((Object)u2)).mLastSelectedText, ((SelectionPopupControllerImpl)((Object)u2)).mLastSelectionOffset, 107, null);
            }
            ((SelectionPopupControllerImpl)((Object)u2)).destroyActionModeAndKeepSelection();
        }
        ((SelectionPopupControllerImpl)((Object)u2)).mLastSelectedText = string2;
        u u2 = ((SelectionPopupControllerImpl)((Object)u2)).mSelectionClient;
        if (u2 != null) {
            u2.onSelectionChanged(string2);
        }
    }

    public void setSelectionClient(@Nullable u u2) {
        this.mSelectionClient = u2;
        if ((u2 = this.mSelectionClient) != null) {
            this.mSelectionMetricsLogger = (r)u2.getSelectionMetricsLogger();
        }
        this.mClassificationResult = null;
        if (!$assertionsDisabled && this.mHidden) {
            throw new AssertionError();
        }
    }

    public void setSelectionInsertionHandleObserver(@Nullable q q2) {
        this.mHandleObserver = q2;
    }

    public void hidePopupsAndPreserveSelection() {
        SelectionPopupControllerImpl selectionPopupControllerImpl = this;
        selectionPopupControllerImpl.destroyActionModeAndKeepSelection();
        selectionPopupControllerImpl.getPopupController().a();
    }

    public void destroyActionModeAndUnselect() {
        this.mUnselectAllOnDismiss = true;
        this.finishActionMode();
    }

    public void destroyActionModeAndKeepSelection() {
        this.mUnselectAllOnDismiss = false;
        this.finishActionMode();
    }

    public void updateSelectionState(boolean bl, boolean bl2) {
        if (!bl) {
            this.destroyPastePopup();
        }
        if (bl != this.isFocusedNodeEditable() || bl2 != this.isSelectionPassword()) {
            this.mEditable = bl;
            this.mIsPasswordType = bl2;
            if (this.isActionModeValid()) {
                this.mActionMode.invalidate();
            }
        }
    }

    public boolean hasSelection() {
        return this.mHasSelection;
    }

    @Override
    public String getSelectedText() {
        return this.mLastSelectedText;
    }

    public void destroySelectActionMode() {
        this.finishActionMode();
    }

    public boolean isSelectActionBarShowing() {
        return this.isActionModeValid();
    }

    @Override
    public ActionModeCallbackHelper getActionModeCallbackHelper() {
        return this;
    }

    public void setTextClassifier(TextClassifier textClassifier) {
        if (!$assertionsDisabled && Build.VERSION.SDK_INT < 26) {
            throw new AssertionError();
        }
        if ((this = ((SelectionPopupControllerImpl)this).getSelectionClient()) != null) {
            this.setTextClassifier(textClassifier);
        }
    }

    public TextClassifier getTextClassifier() {
        if (!$assertionsDisabled && Build.VERSION.SDK_INT < 26) {
            throw new AssertionError();
        }
        return (this = ((SelectionPopupControllerImpl)this).getSelectionClient()) == null ? null : this.getTextClassifier();
    }

    public TextClassifier getCustomTextClassifier() {
        if (!$assertionsDisabled && Build.VERSION.SDK_INT < 26) {
            throw new AssertionError();
        }
        return (this = ((SelectionPopupControllerImpl)this).getSelectionClient()) == null ? null : this.getCustomTextClassifier();
    }

    private class SmartSelectionCallback
    implements u.b {
        public SmartSelectionCallback() {
        }

        public /* synthetic */ SmartSelectionCallback(1 var2_2) {
        }

        @Override
        public void onClassified(u.a a2) {
            if (!SelectionPopupControllerImpl.this.hasSelection()) {
                SelectionPopupControllerImpl.access$902(SelectionPopupControllerImpl.this, null);
                return;
            }
            if (a2.a <= 0 && a2.b >= 0) {
                SelectionPopupControllerImpl.access$902(SelectionPopupControllerImpl.this, a2);
                if (a2.a == 0 && a2.b == 0) {
                    if (SelectionPopupControllerImpl.this.mSelectionMetricsLogger != null) {
                        SelectionPopupControllerImpl.this.mSelectionMetricsLogger.a(SelectionPopupControllerImpl.this.mLastSelectedText, SelectionPopupControllerImpl.this.mLastSelectionOffset, SelectionPopupControllerImpl.this.mClassificationResult);
                    }
                    SelectionPopupControllerImpl.this.showActionModeOrClearOnFailure();
                    return;
                }
                SelectionPopupControllerImpl.this.mWebContents.adjustSelectionByCharacterOffset(a2.a, a2.b, true);
                return;
            }
            SmartSelectionCallback smartSelectionCallback = this;
            SelectionPopupControllerImpl.access$902(smartSelectionCallback.SelectionPopupControllerImpl.this, null);
            smartSelectionCallback.SelectionPopupControllerImpl.this.showActionModeOrClearOnFailure();
        }
    }

    public static interface ReadbackViewCallback {
        public View getReadbackView();
    }

    private static final class UserDataFactoryLazyHolder {
        public static final WebContentsImpl.UserDataFactory<SelectionPopupControllerImpl> INSTANCE = SelectionPopupControllerImpl::new;

        public static /* synthetic */ WebContentsImpl.UserDataFactory access$000() {
            return INSTANCE;
        }
    }
}

