/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser.input;

import a.b.a.g;
import a.b.a.o;
import a.b.c.b.d.O;
import a.b.c.b.d.T;
import a.b.c.b.d.U;
import a.b.c.b.d.a;
import a.b.c.b.d.b;
import a.b.c.b.d.c;
import a.b.c.b.d.d;
import a.b.c.b.w;
import a.b.c.b.y;
import a.b.d.a.h;
import a.b.d.a.i;
import a.b.d.a.j;
import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Color;
import android.graphics.Rect;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.ResultReceiver;
import android.os.SystemClock;
import android.text.SpannableString;
import android.text.TextUtils;
import android.text.style.BackgroundColorSpan;
import android.text.style.CharacterStyle;
import android.text.style.SuggestionSpan;
import android.text.style.UnderlineSpan;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.ExtractedText;
import android.view.inputmethod.InputConnection;
import android.view.inputmethod.InputMethodManager;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.chromium.base.ContextUtils;
import org.chromium.base.TraceEvent;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.content.browser.webcontents.WebContentsImpl;
import org.chromium.content_public.browser.WebContents;
import org.chromium.ui.base.ViewAndroidDelegate;

@JNINamespace(value="content")
public class ImeAdapterImpl
implements h,
w,
o {
    public static final String TAG = "cr_Ime";
    public static final boolean DEBUG_LOGS = false;
    public static final float SUGGESTION_HIGHLIGHT_BACKGROUND_TRANSPARENCY = 0.4f;
    public static final int COMPOSITION_KEY_CODE = 229;
    public static final int IME_FLAG_NO_PERSONALIZED_LEARNING = 0x1000000;
    public static final int DEFAULT_SUGGESTION_SPAN_COLOR = -2000107320;
    public static final /* synthetic */ boolean $assertionsDisabled;
    public long mNativeImeAdapterAndroid;
    public j mInputMethodManagerWrapper;
    public a mInputConnection;
    public a.a mInputConnectionFactory;
    public ShowKeyboardResultReceiver mShowKeyboardResultReceiver;
    public final WebContentsImpl mWebContents;
    public ViewAndroidDelegate mViewDelegate;
    public c mCursorAnchorInfoController;
    public final List<i> mEventObservers = new ArrayList<i>();
    public int mTextInputType = 0;
    public int mTextInputFlags;
    public int mTextInputMode = 0;
    public boolean mNodeEditable;
    public boolean mNodePassword;
    public final Rect mFocusPreOSKViewportRect = new Rect();
    public Configuration mCurrentConfig;
    public int mLastSelectionStart;
    public int mLastSelectionEnd;
    public String mLastText;
    public int mLastCompositionStart;
    public int mLastCompositionEnd;
    public boolean mRestartInputOnNextStateUpdate;
    public boolean mIsConnected;

    public static ImeAdapterImpl fromWebContents(WebContents webContents) {
        return ((WebContentsImpl)webContents).getOrSetUserData(ImeAdapterImpl.class, UserDataFactoryLazyHolder.INSTANCE);
    }

    public static j createDefaultInputMethodManagerWrapper(Context context) {
        return new d(context);
    }

    public ImeAdapterImpl(WebContents object) {
        d d2;
        this.mWebContents = (WebContentsImpl)object;
        this.mViewDelegate = this.mWebContents.getViewAndroidDelegate();
        if (!$assertionsDisabled && this.mViewDelegate == null) {
            throw new AssertionError();
        }
        object = ContextUtils.sApplicationContext;
        d d3 = d2;
        d2 = new d((Context)object);
        this.mCurrentConfig = new Configuration(this.mViewDelegate.getContainerView().getResources().getConfiguration());
        if (Build.VERSION.SDK_INT >= 21) {
            c.a a2;
            object = a2;
            a2 = new c.a(){

                @Override
                public CharSequence getText() {
                    return ImeAdapterImpl.this.mLastText;
                }

                @Override
                public int getSelectionStart() {
                    return ImeAdapterImpl.this.mLastSelectionStart;
                }

                @Override
                public int getSelectionEnd() {
                    return ImeAdapterImpl.this.mLastSelectionEnd;
                }

                @Override
                public int getComposingTextStart() {
                    return ImeAdapterImpl.this.mLastCompositionStart;
                }

                @Override
                public int getComposingTextEnd() {
                    return ImeAdapterImpl.this.mLastCompositionEnd;
                }
            };
            this.mCursorAnchorInfoController = new c(d3, (c.a)object, new b());
        } else {
            this.mCursorAnchorInfoController = null;
        }
        ImeAdapterImpl imeAdapterImpl = this;
        imeAdapterImpl.mInputMethodManagerWrapper = d3;
        imeAdapterImpl.mNativeImeAdapterAndroid = imeAdapterImpl.nativeInit(imeAdapterImpl.mWebContents);
        y.a(imeAdapterImpl.mWebContents).a(this);
    }

    private boolean isHardwareKeyboardAttached() {
        return this.mCurrentConfig.keyboard != 1;
    }

    private void createInputConnectionFactory() {
        if (this.mInputConnectionFactory != null) {
            return;
        }
        this.mInputConnectionFactory = new T(this.mInputMethodManagerWrapper);
    }

    private boolean isValid() {
        return this.mNativeImeAdapterAndroid != 0L && this.mIsConnected;
    }

    private boolean focusedNodeAllowsSoftKeyboard() {
        return this.mTextInputType != 0 && this.mTextInputMode != 1;
    }

    private boolean focusedNodeEditable() {
        return this.mTextInputType != 0;
    }

    private View getContainerView() {
        return this.mViewDelegate.getContainerView();
    }

    private void setInputConnection(a a2) {
        a a3 = this.mInputConnection;
        if (a3 == a2) {
            return;
        }
        if (a3 != null) {
            ((O)a3).g();
        }
        this.mInputConnection = a2;
    }

    public static int getModifiers(int n2) {
        int n3 = 0;
        if ((n2 & 1) != 0) {
            n3 = 1;
        }
        if ((n2 & 2) != 0) {
            n3 |= 4;
        }
        if ((n2 & 0x1000) != 0) {
            n3 |= 2;
        }
        if ((n2 & 0x100000) != 0) {
            n3 |= 0x200;
        }
        if ((n2 & 0x200000) != 0) {
            n3 |= 0x400;
        }
        return n3;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateState(int n2, int n3, int n4, boolean bl, String string2, int n5, int n6, int n7, int n8, boolean bl2) {
        TraceEvent.begin("ImeAdapter.updateState", null);
        boolean bl3 = false;
        int n9 = 0;
        try {
            block20: {
                block19: {
                    block18: {
                        if (this.mRestartInputOnNextStateUpdate) {
                            bl3 = true;
                            this.mRestartInputOnNextStateUpdate = false;
                        }
                        this.mTextInputFlags = n3;
                        if (this.mTextInputMode != n4) {
                            this.mTextInputMode = n4;
                            n3 = n4 == 1 && !this.isHardwareKeyboardAttached() ? 1 : 0;
                            bl3 = true;
                        } else {
                            n3 = n9;
                        }
                        if (this.mTextInputType == n2) break block18;
                        this.mTextInputType = n2;
                        if (n2 == 0) break block19;
                        bl3 = true;
                        break block20;
                    }
                    if (n2 != 0) break block20;
                }
                n3 = 1;
            }
            int n10 = n2;
            n2 = this.focusedNodeEditable() ? 1 : 0;
            n4 = n10 == 2 ? 1 : 0;
            if (this.mNodeEditable != n2 || this.mNodePassword != n4) {
                Iterator<i> iterator = this.mEventObservers.iterator();
                while (iterator.hasNext()) {
                    iterator.next().onNodeAttributeUpdated(n2 != 0, n4 != 0);
                }
                this.mNodeEditable = n2;
                this.mNodePassword = n4;
            }
            if (!(this.mCursorAnchorInfoController == null || TextUtils.equals((CharSequence)this.mLastText, (CharSequence)string2) && this.mLastSelectionStart == n5 && this.mLastSelectionEnd == n6 && this.mLastCompositionStart == n7 && this.mLastCompositionEnd == n8)) {
                c c2 = this.mCursorAnchorInfoController;
                if (c2.a) {
                    c2.n = null;
                }
            }
            this.mLastText = string2;
            this.mLastSelectionStart = n5;
            this.mLastSelectionEnd = n6;
            this.mLastCompositionStart = n7;
            this.mLastCompositionEnd = n8;
            if (n3 != 0) {
                this.hideKeyboard();
            } else {
                if (bl3) {
                    this.restartInput();
                }
                if (bl && this.focusedNodeAllowsSoftKeyboard()) {
                    this.showSoftKeyboard();
                }
            }
            if (this.mInputConnection == null) return;
            boolean bl4 = this.mTextInputType != 14 && this.mTextInputType != 15;
            ((O)this.mInputConnection).a(string2, n5, n6, n7, n8, bl4, bl2);
            return;
        }
        finally {
            TraceEvent.end("ImeAdapter.updateState", null);
        }
    }

    private void showSoftKeyboard() {
        if (!this.isValid()) {
            return;
        }
        ImeAdapterImpl imeAdapterImpl = this;
        ViewGroup viewGroup = imeAdapterImpl.mViewDelegate.getContainerView();
        j j2 = imeAdapterImpl.mInputMethodManagerWrapper;
        ResultReceiver resultReceiver = imeAdapterImpl.getNewShowKeyboardReceiver();
        ((d)j2).a((View)viewGroup, 0, resultReceiver);
        if (viewGroup.getResources().getConfiguration().keyboard != 1) {
            this.mWebContents.scrollFocusedEditableNodeIntoView();
        }
    }

    private void updateAfterViewSizeChanged() {
        if (!this.mFocusPreOSKViewportRect.isEmpty()) {
            Rect rect;
            Rect rect2 = rect;
            ImeAdapterImpl imeAdapterImpl = this;
            rect2();
            imeAdapterImpl.mViewDelegate.getContainerView().getWindowVisibleDisplayFrame(rect2);
            if (!rect.equals((Object)imeAdapterImpl.mFocusPreOSKViewportRect)) {
                if (rect2.width() == this.mFocusPreOSKViewportRect.width()) {
                    if (!$assertionsDisabled && this.mWebContents == null) {
                        throw new AssertionError();
                    }
                    this.mWebContents.scrollFocusedEditableNodeIntoView();
                }
                this.cancelRequestToScrollFocusedEditableNodeIntoView();
            }
        }
    }

    private void updateOnTouchDown() {
        this.cancelRequestToScrollFocusedEditableNodeIntoView();
    }

    private void hideKeyboard() {
        if (!this.isValid()) {
            return;
        }
        ImeAdapterImpl imeAdapterImpl = this;
        Object object = imeAdapterImpl.mViewDelegate.getContainerView();
        if (((d)imeAdapterImpl.mInputMethodManagerWrapper).a((View)object)) {
            ViewGroup viewGroup = object;
            object = this.mInputMethodManagerWrapper;
            ((d)object).a(viewGroup.getWindowToken(), 0, null);
        }
        if (!this.focusedNodeEditable() && (object = this.mInputConnection) != null) {
            this.restartInput();
            ((O)object).g();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isTextInputType(int n2) {
        if (n2 == 0) return false;
        if (n2 == 8) return false;
        if (n2 == 12) return false;
        if (n2 == 9) return false;
        if (n2 == 10) return false;
        if (n2 == 11) return false;
        if (n2 != 13) return true;
        return false;
    }

    private void onNativeDestroyed() {
        ImeAdapterImpl imeAdapterImpl = c2;
        imeAdapterImpl.resetAndHideKeyboard();
        imeAdapterImpl.mNativeImeAdapterAndroid = 0L;
        imeAdapterImpl.mIsConnected = false;
        c c2 = imeAdapterImpl.mCursorAnchorInfoController;
        if (c2 != null) {
            c c3 = c2;
            c3.a = false;
            c3.d = null;
            c3.e = false;
            c3.n = null;
        }
    }

    private void advanceFocusInForm(int n2) {
        long l2 = this.mNativeImeAdapterAndroid;
        if (l2 == 0L) {
            return;
        }
        this.nativeAdvanceFocusInForm(l2, n2);
    }

    private void onImeEvent() {
        Iterator<i> iterator = this.mEventObservers.iterator();
        while (iterator.hasNext()) {
            iterator.next().a();
        }
        if (this.mNodeEditable) {
            this.mWebContents.dismissTextHandles();
        }
    }

    private void focusedNodeChanged(boolean bl) {
        c c2 = this.mCursorAnchorInfoController;
        if (c2 != null) {
            c c3 = c2;
            c3.a = bl;
            c3.d = null;
            c3.e = false;
            c3.n = null;
        }
        if (this.mTextInputType != 0 && this.mInputConnection != null && bl) {
            this.mRestartInputOnNextStateUpdate = true;
        }
    }

    private void updateFrameInfo(float f2, float f3, boolean bl, boolean bl2, float f4, float f5, float f6) {
        c c2 = imeAdapterImpl.mCursorAnchorInfoController;
        if (c2 == null) {
            return;
        }
        ImeAdapterImpl imeAdapterImpl = imeAdapterImpl.mViewDelegate.getContainerView();
        if (c2.a) {
            c c3 = c2;
            c.b b2 = c3.t;
            int[] nArray = c3.p;
            ((b)b2).a((View)imeAdapterImpl, nArray);
            float f7 = c3.p[0];
            f3 = (float)c3.p[1] + f3;
            if (!c3.e || f2 != c2.f || f7 != c2.g || f3 != c2.h || bl != c2.i || bl2 != c2.j || f4 != c2.k || f5 != c2.l || f6 != c2.m) {
                c c4 = c2;
                c4.n = null;
                c4.e = true;
                c2.f = f2;
                c2.g = f7;
                c2.h = f3;
                c2.i = bl;
                c2.j = bl2;
                c2.k = f4;
                c2.l = f5;
                c2.m = f6;
            }
            if (c2.b || c2.c && c2.n == null) {
                c2.a((View)imeAdapterImpl);
            }
        }
    }

    private int getUnderlineColorForSuggestionSpan(SuggestionSpan suggestionSpan) {
        Class<SuggestionSpan> clazz = SuggestionSpan.class;
        Method method = clazz.getMethod("getUnderlineColor", new Class[0]);
        try {
            return (Integer)method.invoke((Object)suggestionSpan, new Object[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return -2000107320;
        }
        catch (InvocationTargetException invocationTargetException) {
            return -2000107320;
        }
        catch (IllegalAccessException illegalAccessException) {
            return -2000107320;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void populateImeTextSpansFromJava(CharSequence characterStyleArray, long l2) {
        if (!(characterStyleArray instanceof SpannableString)) {
            return;
        }
        SpannableString spannableString = (SpannableString)characterStyleArray;
        for (CharacterStyle characterStyle : (CharacterStyle[])spannableString.getSpans(0, characterStyleArray.length(), CharacterStyle.class)) {
            void var7_11;
            int n2 = spannableString.getSpanFlags((Object)characterStyle);
            if (characterStyle instanceof BackgroundColorSpan) {
                ImeAdapterImpl.nativeAppendBackgroundColorSpan(l2, spannableString.getSpanStart((Object)characterStyle), spannableString.getSpanEnd((Object)characterStyle), ((BackgroundColorSpan)characterStyle).getBackgroundColor());
                continue;
            }
            if (characterStyle instanceof UnderlineSpan) {
                ImeAdapterImpl.nativeAppendUnderlineSpan(l2, spannableString.getSpanStart((Object)characterStyle), spannableString.getSpanEnd((Object)characterStyle));
                continue;
            }
            if (!(characterStyle instanceof SuggestionSpan)) continue;
            SuggestionSpan suggestionSpan = (SuggestionSpan)characterStyle;
            n2 = (n2 & 0x100) != 0 ? 1 : 0;
            int n3 = (suggestionSpan.getFlags() & 1) != 0 ? 1 : 0;
            int n4 = (suggestionSpan.getFlags() & 2) != 0 ? 1 : 0;
            boolean bl = (suggestionSpan.getFlags() & 4) != 0;
            if (n3 == 0 && n4 == 0 && !bl) continue;
            int n5 = n4;
            n3 = this.getUnderlineColorForSuggestionSpan(suggestionSpan);
            n4 = (int)((float)Color.alpha((int)n3) * 0.4f);
            n4 = (n3 & 0xFFFFFF) + (n4 << 24);
            int n6 = spannableString.getSpanStart((Object)suggestionSpan);
            int n7 = spannableString.getSpanEnd((Object)suggestionSpan);
            boolean bl2 = n5 != 0 || bl;
            if (bl) {
                String[] stringArray = new String[]{};
            } else {
                String[] stringArray = suggestionSpan.getSuggestions();
            }
            ImeAdapterImpl.nativeAppendSuggestionSpan(l2, n6, n7, bl2, n2 != 0, n3, n4, (String[])var7_11);
        }
    }

    private void cancelComposition() {
        if (this.mInputConnection != null) {
            this.restartInput();
        }
    }

    private void setCharacterBounds(float[] fArray) {
        c c2 = imeAdapterImpl.mCursorAnchorInfoController;
        if (c2 == null) {
            return;
        }
        ImeAdapterImpl imeAdapterImpl = imeAdapterImpl.mViewDelegate.getContainerView();
        if (c2.a && !Arrays.equals(fArray, c2.d)) {
            c2.n = null;
            c2.d = fArray;
            if (c2.e) {
                c2.a((View)imeAdapterImpl);
            }
        }
    }

    private void onConnectedToRenderProcess() {
        ImeAdapterImpl imeAdapterImpl = this;
        imeAdapterImpl.mIsConnected = true;
        imeAdapterImpl.createInputConnectionFactory();
        imeAdapterImpl.resetAndHideKeyboard();
    }

    private native long nativeInit(WebContents var1);

    private native boolean nativeSendKeyEvent(long var1, KeyEvent var3, int var4, int var5, long var6, int var8, int var9, boolean var10, int var11);

    public static native void nativeAppendUnderlineSpan(long var0, int var2, int var3);

    public static native void nativeAppendBackgroundColorSpan(long var0, int var2, int var3, int var4);

    public static native void nativeAppendSuggestionSpan(long var0, int var2, int var3, boolean var4, boolean var5, int var6, int var7, String[] var8);

    private native void nativeSetComposingText(long var1, CharSequence var3, String var4, int var5);

    private native void nativeCommitText(long var1, CharSequence var3, String var4, int var5);

    private native void nativeFinishComposingText(long var1);

    private native void nativeSetEditableSelectionOffsets(long var1, int var3, int var4);

    private native void nativeSetComposingRegion(long var1, int var3, int var4);

    private native void nativeDeleteSurroundingText(long var1, int var3, int var4);

    private native void nativeDeleteSurroundingTextInCodePoints(long var1, int var3, int var4);

    private native boolean nativeRequestTextInputStateUpdate(long var1);

    private native void nativeRequestCursorUpdate(long var1, boolean var3, boolean var4);

    private native void nativeAdvanceFocusInForm(long var1, int var3);

    static {
        $assertionsDisabled = ImeAdapterImpl.class.desiredAssertionStatus() ^ true;
    }

    public InputConnection getActiveInputConnection() {
        return this.mInputConnection;
    }

    @Override
    public InputConnection onCreateInputConnection(EditorInfo editorInfo) {
        WebContentsImpl webContentsImpl = this.mWebContents;
        boolean bl = webContentsImpl != null && !webContentsImpl.isIncognito();
        return this.onCreateInputConnection(editorInfo, bl);
    }

    @Override
    public boolean onCheckIsTextEditor() {
        return ImeAdapterImpl.isTextInputType(this.mTextInputType);
    }

    public void addEventObserver(i i2) {
        this.mEventObservers.add(i2);
    }

    public a onCreateInputConnection(EditorInfo object, boolean bl) {
        ((EditorInfo)object).imeOptions = 0x12000000;
        if (!bl) {
            ((EditorInfo)object).imeOptions |= 0x1000000;
        }
        if (!this.focusedNodeEditable()) {
            this.setInputConnection(null);
            return null;
        }
        if (this.mInputConnectionFactory == null) {
            return null;
        }
        ImeAdapterImpl imeAdapterImpl = this;
        ViewGroup viewGroup = imeAdapterImpl.mViewDelegate.getContainerView();
        a.a a2 = imeAdapterImpl.mInputConnectionFactory;
        int n2 = imeAdapterImpl.mTextInputType;
        int n3 = imeAdapterImpl.mTextInputFlags;
        int n4 = imeAdapterImpl.mTextInputMode;
        int n5 = imeAdapterImpl.mLastSelectionStart;
        int n6 = imeAdapterImpl.mLastSelectionEnd;
        imeAdapterImpl.setInputConnection(((T)a2).a((View)viewGroup, this, n2, n3, n4, n5, n6, (EditorInfo)object));
        object = imeAdapterImpl.mCursorAnchorInfoController;
        if (object != null) {
            ((c)object).a(false, false, (View)viewGroup);
        }
        if (this.isValid()) {
            ImeAdapterImpl imeAdapterImpl2 = this;
            imeAdapterImpl2.nativeRequestCursorUpdate(imeAdapterImpl2.mNativeImeAdapterAndroid, false, false);
        }
        return this.mInputConnection;
    }

    public void setInputMethodManagerWrapper(j j2) {
        ((ImeAdapterImpl)((Object)c2)).mInputMethodManagerWrapper = j2;
        c c2 = ((ImeAdapterImpl)((Object)c2)).mCursorAnchorInfoController;
        if (c2 != null) {
            c2.r = j2;
        }
    }

    public void setInputConnectionFactory(a.a a2) {
        this.mInputConnectionFactory = a2;
    }

    public a.a getInputConnectionFactoryForTest() {
        return this.mInputConnectionFactory;
    }

    public void setTriggerDelayedOnCreateInputConnectionForTest(boolean bl) {
        ((T)this.mInputConnectionFactory).g = bl;
    }

    public InputConnection getInputConnectionForTest() {
        return this.mInputConnection;
    }

    public void setComposingTextForTest(CharSequence charSequence, int n2) {
        ((O)this.mInputConnection).g.post(() -> this.mInputConnection.setComposingText(charSequence, n2));
    }

    public void onShowKeyboardReceiveResult(int n2) {
        ViewGroup viewGroup = this.mViewDelegate.getContainerView();
        if (n2 == 2) {
            viewGroup.getWindowVisibleDisplayFrame(this.mFocusPreOSKViewportRect);
        } else if (g.a((View)viewGroup) && n2 == 0) {
            this.mWebContents.scrollFocusedEditableNodeIntoView();
        }
    }

    public void cancelRequestToScrollFocusedEditableNodeIntoView() {
        this.mFocusPreOSKViewportRect.setEmpty();
    }

    public ResultReceiver getNewShowKeyboardReceiver() {
        if (this.mShowKeyboardResultReceiver == null) {
            this.mShowKeyboardResultReceiver = new ShowKeyboardResultReceiver(this, new Handler());
        }
        return this.mShowKeyboardResultReceiver;
    }

    @Override
    public void onConfigurationChanged(Configuration configuration) {
        if (!this.isValid()) {
            return;
        }
        Configuration configuration2 = this.mCurrentConfig;
        if (configuration2.keyboard == configuration.keyboard && configuration2.keyboardHidden == configuration.keyboardHidden && configuration2.hardKeyboardHidden == configuration.hardKeyboardHidden) {
            return;
        }
        this.mCurrentConfig = new Configuration(configuration);
        if (this.focusedNodeAllowsSoftKeyboard()) {
            ImeAdapterImpl imeAdapterImpl = this;
            imeAdapterImpl.restartInput();
            imeAdapterImpl.showSoftKeyboard();
        } else if (this.focusedNodeEditable()) {
            ImeAdapterImpl imeAdapterImpl = this;
            imeAdapterImpl.restartInput();
            if (!imeAdapterImpl.isHardwareKeyboardAttached()) {
                this.hideKeyboard();
            } else {
                this.showSoftKeyboard();
            }
        }
    }

    @Override
    public void onWindowFocusChanged(boolean bl) {
        Object object = ((ImeAdapterImpl)object).mInputConnectionFactory;
        if (object != null) {
            T.a a2;
            object = (T)object;
            if (!bl && (a2 = ((T)object).e) != null) {
                a2.a();
            }
            if ((object = ((T)object).c) != null) {
                ((U)((Object)object)).b(bl);
            }
        }
    }

    @Override
    public void onAttachedToWindow() {
        Object object = ((ImeAdapterImpl)object).mInputConnectionFactory;
        if (object != null && (object = ((T)object).c) != null) {
            ((U)((Object)object)).a();
        }
    }

    @Override
    public void onDetachedFromWindow() {
        ImeAdapterImpl imeAdapterImpl = object;
        imeAdapterImpl.resetAndHideKeyboard();
        Object object = imeAdapterImpl.mInputConnectionFactory;
        if (object != null) {
            object = (T)object;
            T.a a2 = ((T)object).e;
            if (a2 != null) {
                a2.a();
            }
            if ((object = ((T)object).c) != null) {
                ((U)((Object)object)).b();
            }
        }
    }

    @Override
    public void onViewFocusChanged(boolean bl, boolean bl2) {
        if (!bl && bl2) {
            ((ImeAdapterImpl)object).resetAndHideKeyboard();
        }
        if ((object = ((ImeAdapterImpl)object).mInputConnectionFactory) != null) {
            T.a a2;
            Object object = (T)object;
            if (!bl && (a2 = ((T)object).e) != null) {
                a2.a();
            }
            if ((object = ((T)object).c) != null) {
                ((U)((Object)object)).a(bl);
            }
        }
    }

    public boolean dispatchKeyEvent(KeyEvent keyEvent) {
        a a2 = this.mInputConnection;
        if (a2 != null) {
            ((O)a2).b(keyEvent);
            return true;
        }
        return this.sendKeyEvent(keyEvent);
    }

    public void resetAndHideKeyboard() {
        this.mTextInputType = 0;
        this.mTextInputFlags = 0;
        this.mTextInputMode = 0;
        this.mRestartInputOnNextStateUpdate = false;
        this.hideKeyboard();
    }

    public void reset() {
        this.resetAndHideKeyboard();
    }

    public void updateSelection(int n2, int n3, int n4, int n5) {
        ImeAdapterImpl imeAdapterImpl = imeAdapterImpl.mViewDelegate.getContainerView();
        InputMethodManager inputMethodManager = ((d)imeAdapterImpl.mInputMethodManagerWrapper).a();
        if (inputMethodManager != null) {
            inputMethodManager.updateSelection((View)imeAdapterImpl, n2, n3, n4, n5);
        }
    }

    public void updateExtractedText(int n2, ExtractedText extractedText) {
        ImeAdapterImpl imeAdapterImpl = imeAdapterImpl.mViewDelegate.getContainerView();
        InputMethodManager inputMethodManager = ((d)imeAdapterImpl.mInputMethodManagerWrapper).a();
        if (inputMethodManager != null) {
            inputMethodManager.updateExtractedText((View)imeAdapterImpl, n2, extractedText);
        }
    }

    public void restartInput() {
        if (!((ImeAdapterImpl)((Object)a2)).isValid()) {
            return;
        }
        ViewGroup viewGroup = ((ImeAdapterImpl)((Object)a2)).mViewDelegate.getContainerView();
        InputMethodManager inputMethodManager = ((d)((ImeAdapterImpl)((Object)a2)).mInputMethodManagerWrapper).a();
        if (inputMethodManager != null) {
            inputMethodManager.restartInput((View)viewGroup);
        }
        a a2 = ((ImeAdapterImpl)((Object)a2)).mInputConnection;
        if (a2 != null) {
            ((O)a2).d();
        }
    }

    public boolean performContextMenuAction(int n2) {
        switch (n2) {
            default: {
                return false;
            }
            case 0x1020022: {
                this.mWebContents.paste();
                return true;
            }
            case 0x1020021: {
                this.mWebContents.copy();
                return true;
            }
            case 0x1020020: {
                this.mWebContents.cut();
                return true;
            }
            case 16908319: 
        }
        this.mWebContents.selectAll();
        return true;
    }

    public boolean performEditorAction(int n2) {
        if (!this.isValid()) {
            return false;
        }
        if (n2 != 5) {
            if (n2 != 7) {
                this.sendSyntheticKeyPress(66, 22);
            } else {
                this.advanceFocusInForm(2);
            }
        } else {
            this.advanceFocusInForm(1);
        }
        return true;
    }

    public void notifyUserAction() {
        ((d)this.mInputMethodManagerWrapper).b();
    }

    public void sendSyntheticKeyPress(int n2, int n3) {
        long l2;
        ImeAdapterImpl imeAdapterImpl = this;
        long l3 = l2 = SystemClock.uptimeMillis();
        imeAdapterImpl.sendKeyEvent(new KeyEvent(l3, l3, 0, n2, 0, 0, -1, 0, n3));
        long l4 = l2;
        imeAdapterImpl.sendKeyEvent(new KeyEvent(l4, l4, 1, n2, 0, 0, -1, 0, n3));
    }

    public boolean sendCompositionToNative(CharSequence charSequence, int n2, boolean bl, int n3) {
        if (!this.isValid()) {
            return false;
        }
        ImeAdapterImpl imeAdapterImpl = this;
        imeAdapterImpl.onImeEvent();
        long l2 = SystemClock.uptimeMillis();
        imeAdapterImpl.nativeSendKeyEvent(imeAdapterImpl.mNativeImeAdapterAndroid, null, 7, 0, l2, 229, 0, false, n3);
        if (bl) {
            ImeAdapterImpl imeAdapterImpl2 = this;
            CharSequence charSequence2 = charSequence;
            imeAdapterImpl2.nativeCommitText(imeAdapterImpl2.mNativeImeAdapterAndroid, charSequence2, charSequence2.toString(), n2);
        } else {
            ImeAdapterImpl imeAdapterImpl3 = this;
            CharSequence charSequence3 = charSequence;
            imeAdapterImpl3.nativeSetComposingText(imeAdapterImpl3.mNativeImeAdapterAndroid, charSequence3, charSequence3.toString(), n2);
        }
        ImeAdapterImpl imeAdapterImpl4 = this;
        imeAdapterImpl4.nativeSendKeyEvent(imeAdapterImpl4.mNativeImeAdapterAndroid, null, 9, 0, l2, 229, 0, false, n3);
        return true;
    }

    public boolean finishComposingText() {
        if (!this.isValid()) {
            return false;
        }
        ImeAdapterImpl imeAdapterImpl = this;
        imeAdapterImpl.nativeFinishComposingText(imeAdapterImpl.mNativeImeAdapterAndroid);
        return true;
    }

    public boolean sendKeyEvent(KeyEvent keyEvent) {
        block7: {
            int n2;
            block6: {
                block5: {
                    if (!this.isValid()) {
                        return false;
                    }
                    n2 = keyEvent.getAction();
                    if (n2 != 0) break block5;
                    n2 = 8;
                    break block6;
                }
                if (n2 != 1) break block7;
                n2 = 9;
            }
            Iterator<i> iterator = this.mEventObservers.iterator();
            while (iterator.hasNext()) {
                iterator.next().a(keyEvent);
            }
            ImeAdapterImpl imeAdapterImpl = this;
            imeAdapterImpl.onImeEvent();
            return imeAdapterImpl.nativeSendKeyEvent(imeAdapterImpl.mNativeImeAdapterAndroid, keyEvent, n2, ImeAdapterImpl.getModifiers(keyEvent.getMetaState()), keyEvent.getEventTime(), keyEvent.getKeyCode(), keyEvent.getScanCode(), false, keyEvent.getUnicodeChar());
        }
        return false;
    }

    public boolean deleteSurroundingText(int n2, int n3) {
        ImeAdapterImpl imeAdapterImpl = this;
        imeAdapterImpl.onImeEvent();
        if (!imeAdapterImpl.isValid()) {
            return false;
        }
        ImeAdapterImpl imeAdapterImpl2 = this;
        long l2 = SystemClock.uptimeMillis();
        imeAdapterImpl2.nativeSendKeyEvent(imeAdapterImpl2.mNativeImeAdapterAndroid, null, 7, 0, l2, 229, 0, false, 0);
        imeAdapterImpl2.nativeDeleteSurroundingText(imeAdapterImpl2.mNativeImeAdapterAndroid, n2, n3);
        long l3 = SystemClock.uptimeMillis();
        imeAdapterImpl2.nativeSendKeyEvent(imeAdapterImpl2.mNativeImeAdapterAndroid, null, 9, 0, l3, 229, 0, false, 0);
        return true;
    }

    public boolean deleteSurroundingTextInCodePoints(int n2, int n3) {
        ImeAdapterImpl imeAdapterImpl = this;
        imeAdapterImpl.onImeEvent();
        if (!imeAdapterImpl.isValid()) {
            return false;
        }
        ImeAdapterImpl imeAdapterImpl2 = this;
        long l2 = SystemClock.uptimeMillis();
        imeAdapterImpl2.nativeSendKeyEvent(imeAdapterImpl2.mNativeImeAdapterAndroid, null, 7, 0, l2, 229, 0, false, 0);
        imeAdapterImpl2.nativeDeleteSurroundingTextInCodePoints(imeAdapterImpl2.mNativeImeAdapterAndroid, n2, n3);
        long l3 = SystemClock.uptimeMillis();
        imeAdapterImpl2.nativeSendKeyEvent(imeAdapterImpl2.mNativeImeAdapterAndroid, null, 9, 0, l3, 229, 0, false, 0);
        return true;
    }

    public boolean setEditableSelectionOffsets(int n2, int n3) {
        if (!this.isValid()) {
            return false;
        }
        ImeAdapterImpl imeAdapterImpl = this;
        imeAdapterImpl.nativeSetEditableSelectionOffsets(imeAdapterImpl.mNativeImeAdapterAndroid, n2, n3);
        return true;
    }

    public boolean setComposingRegion(int n2, int n3) {
        if (!this.isValid()) {
            return false;
        }
        if (n2 <= n3) {
            ImeAdapterImpl imeAdapterImpl = this;
            imeAdapterImpl.nativeSetComposingRegion(imeAdapterImpl.mNativeImeAdapterAndroid, n2, n3);
        } else {
            ImeAdapterImpl imeAdapterImpl = this;
            imeAdapterImpl.nativeSetComposingRegion(imeAdapterImpl.mNativeImeAdapterAndroid, n3, n2);
        }
        return true;
    }

    public boolean requestTextInputStateUpdate() {
        if (!this.isValid()) {
            return false;
        }
        if (this.mInputConnection == null) {
            return false;
        }
        ImeAdapterImpl imeAdapterImpl = this;
        return imeAdapterImpl.nativeRequestTextInputStateUpdate(imeAdapterImpl.mNativeImeAdapterAndroid);
    }

    public boolean onRequestCursorUpdates(int n2) {
        c c2;
        boolean bl = (n2 & 1) != 0;
        n2 = (n2 & 2) != 0 ? 1 : 0;
        if (this.isValid()) {
            ImeAdapterImpl imeAdapterImpl = this;
            imeAdapterImpl.nativeRequestCursorUpdate(imeAdapterImpl.mNativeImeAdapterAndroid, bl, n2 != 0);
        }
        if ((c2 = this.mCursorAnchorInfoController) == null) {
            return false;
        }
        return c2.a(bl, n2 != 0, (View)this.mViewDelegate.getContainerView());
    }

    private static final class UserDataFactoryLazyHolder {
        public static final WebContentsImpl.UserDataFactory<ImeAdapterImpl> INSTANCE = ImeAdapterImpl::new;

        public static /* synthetic */ WebContentsImpl.UserDataFactory access$000() {
            return INSTANCE;
        }
    }

    private static class ShowKeyboardResultReceiver
    extends ResultReceiver {
        public final WeakReference<ImeAdapterImpl> mImeAdapter;

        public ShowKeyboardResultReceiver(ImeAdapterImpl imeAdapterImpl, Handler handler) {
            super(handler);
            this.mImeAdapter = new WeakReference<ImeAdapterImpl>(imeAdapterImpl);
        }

        public void onReceiveResult(int n2, Bundle bundle) {
            ImeAdapterImpl imeAdapterImpl = (ImeAdapterImpl)((ShowKeyboardResultReceiver)((Object)imeAdapterImpl)).mImeAdapter.get();
            if (imeAdapterImpl == null) {
                return;
            }
            imeAdapterImpl.onShowKeyboardReceiveResult(n2);
        }
    }
}

