/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser;

import a.b.a.j;
import android.app.ActivityManager;
import android.content.ComponentCallbacks;
import android.content.ComponentCallbacks2;
import android.content.res.Configuration;
import org.chromium.base.ContextUtils;
import org.chromium.base.annotations.JNINamespace;

@JNINamespace(value="content")
public class MemoryMonitorAndroid {
    public static final String TAG = "MemoryMonitorAndroid";
    public static final ActivityManager.MemoryInfo sMemoryInfo = new ActivityManager.MemoryInfo();
    public static ComponentCallbacks2 sCallbacks;

    public static void getMemoryInfo(long l2) {
        try {
            ((ActivityManager)ContextUtils.sApplicationContext.getSystemService("activity")).getMemoryInfo(sMemoryInfo);
        }
        catch (RuntimeException runtimeException) {
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = runtimeException;
            j.b(TAG, "Failed to get memory info due to a runtime exception: %s", objectArray2);
            ActivityManager.MemoryInfo memoryInfo = sMemoryInfo;
            memoryInfo.availMem = 1L;
            memoryInfo.lowMemory = true;
            memoryInfo.threshold = 1L;
            memoryInfo.totalMem = 1L;
        }
        ActivityManager.MemoryInfo memoryInfo = sMemoryInfo;
        MemoryMonitorAndroid.nativeGetMemoryInfoCallback(memoryInfo.availMem, memoryInfo.lowMemory, memoryInfo.threshold, memoryInfo.totalMem, l2);
    }

    public static void registerComponentCallbacks() {
        sCallbacks = new ComponentCallbacks2(){

            public void onTrimMemory(int n2) {
                if (n2 != 20) {
                    MemoryMonitorAndroid.nativeOnTrimMemory(n2);
                }
            }

            public void onLowMemory() {
            }

            public void onConfigurationChanged(Configuration configuration) {
            }
        };
        ContextUtils.sApplicationContext.registerComponentCallbacks((ComponentCallbacks)sCallbacks);
    }

    public static native void nativeGetMemoryInfoCallback(long var0, boolean var2, long var3, long var5, long var7);

    public static native void nativeOnTrimMemory(int var0);

    public static /* synthetic */ void access$000(int n2) {
        MemoryMonitorAndroid.nativeOnTrimMemory(n2);
    }
}

