/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser;

import a.b.a.d.f;
import a.b.a.d.l;
import a.b.a.d.p;
import a.b.a.g;
import a.b.a.j;
import a.b.c.a.a;
import a.b.c.a.e;
import a.b.c.b.d;
import a.b.c.b.g;
import a.b.c.b.r;
import a.b.c.b.s;
import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.ParcelFileDescriptor;
import android.text.TextUtils;
import com.vccorp.base.library_loader.Linker;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.chromium.base.ApplicationStatus;
import org.chromium.base.Callback;
import org.chromium.base.ContextUtils;
import org.chromium.base.CpuFeatures;
import org.chromium.base.ThreadUtils;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.base.library_loader.LibraryLoader;
import org.chromium.base.process_launcher.FileDescriptorInfo;
import org.chromium.content.browser.ContentFeatureList;
import org.chromium.content.browser.GpuProcessCallback;
import org.chromium.content.browser.LauncherThread;

@JNINamespace(value="content::internal")
public final class ChildProcessLauncherHelperImpl {
    public static final String TAG = "ChildProcLH";
    public static final String NUM_SANDBOXED_SERVICES_KEY = "com.vccorp.content.browser.NUM_SANDBOXED_SERVICES";
    public static final String SANDBOXED_SERVICES_NAME = "com.vccorp.content.app.SandboxedProcessService";
    public static final String NUM_PRIVILEGED_SERVICES_KEY = "com.vccorp.content.browser.NUM_PRIVILEGED_SERVICES";
    public static final String PRIVILEGED_SERVICES_NAME = "com.vccorp.content.app.PrivilegedProcessService";
    public static s sSpareSandboxedConnection;
    public static s sSparePrivilegedConntection;
    public static f sSandboxedChildConnectionAllocator;
    public static a.b.c.b.g sSandboxedChildConnectionRanking;
    public static final Map<Integer, ChildProcessLauncherHelperImpl> sLauncherByPid;
    public static f sPrivilegedChildConnectionAllocator;
    public static f.a sSandboxedServiceFactoryForTesting;
    public static int sSandboxedServicesCountForTesting;
    public static String sSandboxedServicesNameForTesting;
    public static d sBindingManager;
    public static boolean sApplicationInForegroundOnUiThread;
    public static boolean sLinkerInitialized;
    public static long sLinkerLoadAddress;
    public static final /* synthetic */ boolean $assertionsDisabled;
    public final a.b.c.b.g mRanking;
    public final d mBindingManager;
    public final boolean mSandboxed;
    public final String mProcessType;
    public final boolean mCanUseWarmUpConnection;
    public final p.a mLauncherDelegate = new p.a(){
        public static final /* synthetic */ boolean $assertionsDisabled;

        static {
            $assertionsDisabled = ChildProcessLauncherHelperImpl.class.desiredAssertionStatus() ^ true;
        }

        @Override
        public l getBoundConnection(f object, l.g g2) {
            if (!s2.ChildProcessLauncherHelperImpl.this.mCanUseWarmUpConnection) {
                return null;
            }
            s s2 = s2.ChildProcessLauncherHelperImpl.this.mSandboxed ? sSpareSandboxedConnection : sSparePrivilegedConntection;
            if (s2 == null) {
                return null;
            }
            if (!s.a && !LauncherThread.runningOnLauncherThread()) {
                throw new AssertionError();
            }
            if (!s2.b() && s2.b == object && s2.e == null) {
                s s3 = s2;
                s3.e = g2;
                object = s3.c;
                if (s3.d) {
                    if (g2 != null) {
                        r r2;
                        r r3 = r2;
                        r2 = new r(s2, g2);
                        LauncherThread.sHandler.post((Runnable)r3);
                    }
                    s2.a();
                }
            } else {
                object = null;
            }
            return object;
        }

        @Override
        public void onBeforeConnectionAllocated(Bundle bundle) {
            ChildProcessLauncherHelperImpl.populateServiceBundle(bundle);
        }

        @Override
        public void onBeforeConnectionSetup(Bundle bundle) {
            Bundle bundle2 = bundle;
            bundle2.putInt("com.google.android.apps.chrome.extra.cpu_count", CpuFeatures.nativeGetCoreCount());
            bundle2.putLong("com.google.android.apps.chrome.extra.cpu_features", CpuFeatures.nativeGetCpuFeatures());
            if (LibraryLoader.useCrazyLinker()) {
                bundle.putBundle("com.vccorp.base.android.linker.shared_relros", Linker.a.g());
            }
        }

        @Override
        public void onConnectionEstablished(l l2) {
            if (!$assertionsDisabled && !LauncherThread.runningOnLauncherThread()) {
                throw new AssertionError();
            }
            int n2 = l2.g();
            if (n2 > 0) {
                sLauncherByPid.put(n2, ChildProcessLauncherHelperImpl.this);
                if (ChildProcessLauncherHelperImpl.this.mRanking != null) {
                    1 v0 = this;
                    v0.ChildProcessLauncherHelperImpl.this.mRanking.a(l2, false, 1L, false, 1);
                    if (v0.ChildProcessLauncherHelperImpl.this.mBindingManager != null) {
                        ChildProcessLauncherHelperImpl.this.mBindingManager.a();
                    }
                }
            }
            if (ChildProcessLauncherHelperImpl.this.mNativeChildProcessLauncherHelper != 0L) {
                ChildProcessLauncherHelperImpl.nativeOnChildProcessStarted(ChildProcessLauncherHelperImpl.this.mNativeChildProcessLauncherHelper, l2.g());
            }
            ChildProcessLauncherHelperImpl.access$802(ChildProcessLauncherHelperImpl.this, 0L);
        }

        @Override
        public void onConnectionLost(l l2) {
            if (!$assertionsDisabled && !LauncherThread.runningOnLauncherThread()) {
                throw new AssertionError();
            }
            if (l2.g() == 0) {
                return;
            }
            sLauncherByPid.remove(l2.g());
            if (ChildProcessLauncherHelperImpl.this.mBindingManager != null) {
                ChildProcessLauncherHelperImpl.this.mBindingManager.b(l2);
            }
            if (ChildProcessLauncherHelperImpl.this.mRanking != null) {
                1 v0 = this;
                v0.ChildProcessLauncherHelperImpl.this.mRanking.b(l2);
                if (v0.ChildProcessLauncherHelperImpl.this.mBindingManager != null) {
                    ChildProcessLauncherHelperImpl.this.mBindingManager.a();
                }
            }
        }
    };
    public final p mLauncher;
    public long mNativeChildProcessLauncherHelper;
    public int mEffectiveImportance = 1;
    public boolean mVisible;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static FileDescriptorInfo makeFdInfo(int n2, int n3, boolean bl, long l2, long l3) {
        ParcelFileDescriptor parcelFileDescriptor;
        if (!$assertionsDisabled) {
            if (!LauncherThread.runningOnLauncherThread()) throw new AssertionError();
        }
        if (bl) {
            parcelFileDescriptor = ParcelFileDescriptor.adoptFd((int)n3);
            return new FileDescriptorInfo(n2, parcelFileDescriptor, l2, l3);
        }
        try {
            parcelFileDescriptor = ParcelFileDescriptor.fromFd((int)n3);
            return new FileDescriptorInfo(n2, parcelFileDescriptor, l2, l3);
        }
        catch (IOException iOException) {
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = iOException;
            j.b(TAG, "Invalid FD provided for process connection, aborting connection.", objectArray2);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static ChildProcessLauncherHelperImpl createAndStart(long l2, String[] stringArray, FileDescriptorInfo[] fileDescriptorInfoArray, boolean bl) {
        boolean bl2;
        Object object;
        block7: {
            block8: {
                if (!$assertionsDisabled && !LauncherThread.runningOnLauncherThread()) {
                    throw new AssertionError();
                }
                object = g.a(stringArray, "type");
                bl2 = true;
                if ("renderer".equals(object)) break block7;
                if ("gpu-process".equals(object)) break block8;
                if (!$assertionsDisabled && !"utility".equals(object)) {
                    throw new AssertionError();
                }
                if (!"network".equals(g.a(stringArray, "service-sandbox-type"))) break block7;
            }
            bl2 = false;
        }
        if ("gpu-process".equals(object)) {
            GpuProcessCallback gpuProcessCallback;
            object = gpuProcessCallback;
            gpuProcessCallback = new GpuProcessCallback();
        } else {
            object = null;
        }
        ChildProcessLauncherHelperImpl childProcessLauncherHelperImpl = new ChildProcessLauncherHelperImpl(l2, stringArray, fileDescriptorInfoArray, bl2, bl, (IBinder)object);
        childProcessLauncherHelperImpl.start();
        return childProcessLauncherHelperImpl;
    }

    public static void warmUp(final Context context, final boolean bl) {
        Runnable runnable;
        if (!$assertionsDisabled && !ThreadUtils.runningOnUiThread()) {
            throw new AssertionError();
        }
        Runnable runnable2 = runnable;
        runnable = new Runnable(){

            @Override
            public void run() {
                ChildProcessLauncherHelperImpl.warmUpOnLauncherThread(context, bl);
            }
        };
        LauncherThread.sHandler.post(runnable2);
    }

    public static void warmUpOnLauncherThread(Context context, boolean bl) {
        s s2 = bl ? sSpareSandboxedConnection : sSparePrivilegedConntection;
        if (s2 != null) {
            boolean bl2 = s2.c == null || s2.e != null;
            if (!bl2) {
                return;
            }
        }
        Bundle bundle = ChildProcessLauncherHelperImpl.populateServiceBundle(new Bundle());
        f f2 = ChildProcessLauncherHelperImpl.getConnectionAllocator(context, bl);
        if (bl) {
            sSpareSandboxedConnection = new s(context, f2, bundle);
        } else {
            sSparePrivilegedConntection = new s(context, f2, bundle);
        }
    }

    public static void startModerateBindingManagement(final Context context) {
        Runnable runnable;
        if (!$assertionsDisabled && !ThreadUtils.runningOnUiThread()) {
            throw new AssertionError();
        }
        Runnable runnable2 = runnable;
        runnable = new Runnable(){

            @Override
            public void run() {
                f f2 = ChildProcessLauncherHelperImpl.getConnectionAllocator(context, true);
                sBindingManager = new d(context, f2.c.length, sSandboxedChildConnectionRanking);
            }
        };
        LauncherThread.sHandler.post(runnable2);
        sApplicationInForegroundOnUiThread = ApplicationStatus.getStateForApplication() == 1 || ApplicationStatus.getStateForApplication() == 2;
        ApplicationStatus.sApplicationStateListeners.a(n2 -> {
            if (n2 != 0) {
                if (n2 != 1 && n2 != 2) {
                    if (sApplicationInForegroundOnUiThread) {
                        ChildProcessLauncherHelperImpl.onSentToBackground();
                    }
                } else if (!sApplicationInForegroundOnUiThread) {
                    ChildProcessLauncherHelperImpl.onBroughtToForeground();
                }
            }
        });
    }

    public static void onSentToBackground() {
        if (!$assertionsDisabled && !ThreadUtils.runningOnUiThread()) {
            throw new AssertionError();
        }
        sApplicationInForegroundOnUiThread = false;
        LauncherThread.sHandler.post(() -> {
            d d2 = sBindingManager;
            if (d2 != null) {
                d2.c();
            }
        });
    }

    public static void onBroughtToForeground() {
        if (!$assertionsDisabled && !ThreadUtils.runningOnUiThread()) {
            throw new AssertionError();
        }
        sApplicationInForegroundOnUiThread = true;
        LauncherThread.sHandler.post(() -> {
            d d2 = sBindingManager;
            if (d2 != null) {
                d2.b();
            }
        });
    }

    public static void setSandboxServicesSettingsForTesting(f.a a2, int n2, String string2) {
        sSandboxedServiceFactoryForTesting = a2;
        sSandboxedServicesCountForTesting = n2;
        sSandboxedServicesNameForTesting = string2;
    }

    public static f getConnectionAllocator(Context object, boolean bl) {
        if (!$assertionsDisabled && !LauncherThread.runningOnLauncherThread()) {
            throw new AssertionError();
        }
        String string2 = a.b.c.b.e.f ? a.b.c.b.e.a : ContextUtils.sApplicationContext.getPackageName();
        boolean bl2 = a.b.c.b.e.f && a.b.c.b.e.d;
        boolean bl3 = bl && a.b.c.b.e.f && a.b.c.b.e.b;
        if (!bl) {
            if (sPrivilegedChildConnectionAllocator == null) {
                sPrivilegedChildConnectionAllocator = f.a(object, LauncherThread.sHandler, null, string2, PRIVILEGED_SERVICES_NAME, NUM_PRIVILEGED_SERVICES_KEY, bl2, bl3, true);
            }
            return sPrivilegedChildConnectionAllocator;
        }
        if (sSandboxedChildConnectionAllocator == null) {
            f f2;
            Object[] objectArray = new Object[1];
            Object object2 = objectArray;
            objectArray[0] = string2;
            j.d(TAG, "Create a new ChildConnectionAllocator with package name = %s, sandboxed = true", object2);
            object2 = () -> {
                Object object = sSandboxedChildConnectionRanking;
                if (((a.b.c.b.g)object).d.isEmpty()) {
                    object = null;
                } else {
                    List<g.a> list = ((a.b.c.b.g)object).d;
                    object = list.get((int)(list.size() - 1)).a;
                }
                if (object != null) {
                    ((l)object).m();
                }
            };
            if (sSandboxedServicesCountForTesting != -1) {
                Handler handler;
                f f3;
                object = !TextUtils.isEmpty((CharSequence)sSandboxedServicesNameForTesting) ? sSandboxedServicesNameForTesting : e.class.getName();
                int n2 = sSandboxedServicesCountForTesting;
                f2 = f3;
                Handler handler2 = handler;
                handler2();
                f3 = new f(handler, (Runnable)object2, string2, (String)object, bl2, bl3, false, n2);
            } else {
                f2 = f.a(object, LauncherThread.sHandler, (Runnable)object2, string2, SANDBOXED_SERVICES_NAME, NUM_SANDBOXED_SERVICES_KEY, bl2, bl3, false);
            }
            object = sSandboxedServiceFactoryForTesting;
            if (object != null) {
                f2.l = object;
            }
            sSandboxedChildConnectionAllocator = f2;
            sSandboxedChildConnectionRanking = new a.b.c.b.g(ChildProcessLauncherHelperImpl.sSandboxedChildConnectionAllocator.c.length);
        }
        return sSandboxedChildConnectionAllocator;
    }

    public ChildProcessLauncherHelperImpl(long l2, String[] stringArray, FileDescriptorInfo[] fileDescriptorInfoArray, boolean bl, boolean bl2, IBinder object) {
        p p2;
        if (!$assertionsDisabled && !LauncherThread.runningOnLauncherThread()) {
            throw new AssertionError();
        }
        this.mNativeChildProcessLauncherHelper = l2;
        this.mSandboxed = bl;
        this.mCanUseWarmUpConnection = bl2;
        f f2 = ChildProcessLauncherHelperImpl.getConnectionAllocator(ContextUtils.sApplicationContext, bl);
        Handler handler = LauncherThread.sHandler;
        p.a a2 = this.mLauncherDelegate;
        object = object == null ? null : Arrays.asList(object);
        p p3 = p2;
        p3(handler, a2, stringArray, fileDescriptorInfoArray, f2, (List<IBinder>)object);
        this.mLauncher = p3;
        this.mProcessType = g.a(stringArray, "type");
        if (bl) {
            ChildProcessLauncherHelperImpl childProcessLauncherHelperImpl = this;
            childProcessLauncherHelperImpl.mRanking = sSandboxedChildConnectionRanking;
            childProcessLauncherHelperImpl.mBindingManager = sBindingManager;
        } else {
            ChildProcessLauncherHelperImpl childProcessLauncherHelperImpl = this;
            childProcessLauncherHelperImpl.mRanking = null;
            childProcessLauncherHelperImpl.mBindingManager = null;
        }
    }

    private void start() {
        this.mLauncher.a(true, true);
    }

    private String getProcessType() {
        return TextUtils.isEmpty((CharSequence)this.mProcessType) ? "" : this.mProcessType;
    }

    private void getTerminationInfoAndStop(long l2) {
        l l3 = ((ChildProcessLauncherHelperImpl)object).mLauncher.h;
        if (l3 == null) {
            return;
        }
        ChildProcessLauncherHelperImpl childProcessLauncherHelperImpl = object;
        l l4 = l3;
        Object object = l4.p();
        ChildProcessLauncherHelperImpl.nativeSetTerminationInfo(l2, l4.c(), l3.k(), l3.i(), (int)object[3], (int)object[2], (int)object[1]);
        LauncherThread.sHandler.post(() -> this.mLauncher.e());
    }

    private void setPriority(int n2, boolean bl, boolean n3, boolean bl2, long l2, boolean bl3, boolean bl4, int n4) {
        int n5;
        a.b.c.b.g g2;
        d d2;
        if (!$assertionsDisabled && !LauncherThread.runningOnLauncherThread()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.mLauncher.a() != n2) {
            throw new AssertionError();
        }
        if (ChildProcessLauncherHelperImpl.getByPid(n2) == null) {
            return;
        }
        l l3 = this.mLauncher.h;
        boolean bl5 = a.b.c.b.e.f && a.b.c.b.e.e;
        if (bl5) {
            bl = false;
            bl4 = false;
        }
        bl5 = ContentFeatureList.nativeIsEnabled("BackgroundMediaRendererHasModerateBinding");
        boolean bl6 = ContentFeatureList.nativeIsEnabled("ServiceWorkerForegroundPriority");
        n3 = !(bl && l2 == 0L || n4 == 2 || n3 != 0 && !bl5) ? (!(bl && l2 > 0L && bl3 || bl4 || n4 == 1 || n3 != 0 && bl5 || bl2 && bl6) ? 0 : 1) : 2;
        if (bl && !this.mVisible && (d2 = this.mBindingManager) != null) {
            d2.a(l3);
        }
        this.mVisible = bl;
        if (this.mEffectiveImportance != n3 && n3 != 0) {
            if (n3 != 1) {
                if (n3 != 2) {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                } else {
                    l3.b();
                }
            } else {
                l3.a();
            }
        }
        if ((g2 = this.mRanking) != null) {
            g2.b(l3, bl, l2, bl3, n4);
            d d3 = this.mBindingManager;
            if (d3 != null) {
                d3.a();
            }
        }
        if ((n5 = this.mEffectiveImportance) != n3 && n5 != 0) {
            if (n5 != 1) {
                if (n5 != 2) {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                } else {
                    l3.r();
                }
            } else {
                l3.q();
            }
        }
        this.mEffectiveImportance = n3;
    }

    public static void stop(int n2) {
        if (!$assertionsDisabled && !LauncherThread.runningOnLauncherThread()) {
            throw new AssertionError();
        }
        int n3 = n2;
        Object object = n3;
        j.a(TAG, "stopping child connection: pid=%d", object);
        object = ChildProcessLauncherHelperImpl.getByPid(n3);
        if (object != null) {
            ((ChildProcessLauncherHelperImpl)object).mLauncher.e();
        }
    }

    private void dumpProcessStack(int n2) {
        if (!$assertionsDisabled && !LauncherThread.runningOnLauncherThread()) {
            throw new AssertionError();
        }
        ChildProcessLauncherHelperImpl childProcessLauncherHelperImpl = ChildProcessLauncherHelperImpl.getByPid(n2);
        if (childProcessLauncherHelperImpl != null) {
            childProcessLauncherHelperImpl.mLauncher.h.f();
        }
    }

    public static native void nativeOnChildProcessStarted(long var0, int var2);

    public static void initLinker() {
        if (!$assertionsDisabled && !LauncherThread.runningOnLauncherThread()) {
            throw new AssertionError();
        }
        if (sLinkerInitialized) {
            return;
        }
        if (LibraryLoader.useCrazyLinker() && (sLinkerLoadAddress = Linker.a.f()) == 0L) {
            Object[] objectArray = new Object[]{};
            j.c(TAG, "Shared RELRO support disabled!", objectArray);
        }
        sLinkerInitialized = true;
    }

    public static a getLinkerParamsForNewConnection() {
        if (!$assertionsDisabled && !LauncherThread.runningOnLauncherThread()) {
            throw new AssertionError();
        }
        ChildProcessLauncherHelperImpl.initLinker();
        if (!$assertionsDisabled && !sLinkerInitialized) {
            throw new AssertionError();
        }
        if (sLinkerLoadAddress == 0L) {
            return null;
        }
        if (Linker.a()) {
            Linker linker = Linker.a;
            return new a(sLinkerLoadAddress, true, linker.h());
        }
        return new a(sLinkerLoadAddress, true);
    }

    public static Bundle populateServiceBundle(Bundle bundle) {
        if (a.b.c.b.e.f) {
            bundle.putInt("com.vccorp.content.common.child_service_params.library_process_type", a.b.c.b.e.c);
        }
        boolean bl = a.b.c.b.e.f && a.b.c.b.e.d;
        bundle.putBoolean("com.vccorp.base.process_launcher.extra.bind_to_caller", bl);
        a a2 = ChildProcessLauncherHelperImpl.getLinkerParamsForNewConnection();
        if (a2 != null) {
            long l2 = a2.a;
            bundle.putLong("com.vccorp.content.common.linker_params.base_load_address", l2);
            bundle.putBoolean("com.vccorp.content.common.linker_params.wait_for_shared_relro", a2.b);
            bundle.putString("com.vccorp.content.common.linker_params.test_runner_class_name", a2.c);
        }
        return bundle;
    }

    public static ChildProcessLauncherHelperImpl getByPid(int n2) {
        return sLauncherByPid.get(n2);
    }

    public static void getProcessIdsByType(Callback<Map<String, List<Integer>>> callback) {
        LauncherThread.sHandler.post(() -> ChildProcessLauncherHelperImpl.a(new Handler(), callback));
    }

    public static Map<Integer, ChildProcessLauncherHelperImpl> getAllProcessesForTesting() {
        return sLauncherByPid;
    }

    public static ChildProcessLauncherHelperImpl createAndStartForTesting(String[] stringArray, FileDescriptorInfo[] fileDescriptorInfoArray, boolean bl, boolean bl2, IBinder iBinder, boolean bl3) {
        ChildProcessLauncherHelperImpl childProcessLauncherHelperImpl = new ChildProcessLauncherHelperImpl(0L, stringArray, fileDescriptorInfoArray, bl, bl2, iBinder);
        childProcessLauncherHelperImpl.mLauncher.a(bl3, true);
        return childProcessLauncherHelperImpl;
    }

    public static int getConnectedServicesCountForTesting() {
        f f2 = sPrivilegedChildConnectionAllocator;
        int n2 = f2 == null ? 0 : f2.a();
        return ChildProcessLauncherHelperImpl.getConnectedSandboxedServicesCountForTesting() + n2;
    }

    public static int getConnectedSandboxedServicesCountForTesting() {
        f f2 = sSandboxedChildConnectionAllocator;
        return f2 == null ? 0 : f2.a();
    }

    public static l getWarmUpConnectionForTesting(boolean bl) {
        Object object = bl ? sSpareSandboxedConnection : sSparePrivilegedConntection;
        object = object == null ? null : ((s)object).c;
        return object;
    }

    public static native void nativeSetTerminationInfo(long var0, int var2, boolean var3, boolean var4, int var5, int var6, int var7);

    public static /* synthetic */ void a(Handler handler, Callback callback) {
        HashMap hashMap;
        HashMap hashMap2 = hashMap;
        Object object = sLauncherByPid;
        Callback<Map.Entry> callback2 = arg_0 -> ChildProcessLauncherHelperImpl.a(new HashMap(), arg_0);
        object = object.entrySet().iterator();
        while (object.hasNext()) {
            callback2.onResult((Map.Entry)object.next());
        }
        handler.post(() -> callback.onResult(hashMap2));
    }

    public static /* synthetic */ void a(Map map, Map.Entry entry) {
        String string2 = ((ChildProcessLauncherHelperImpl)entry.getValue()).getProcessType();
        List list = (List)map.get(string2);
        if (list == null) {
            ArrayList arrayList;
            list = arrayList;
            map.put(string2, new ArrayList());
        }
        list.add(entry.getKey());
    }

    public static /* synthetic */ s access$200() {
        return sSpareSandboxedConnection;
    }

    public static /* synthetic */ s access$300() {
        return sSparePrivilegedConntection;
    }

    public static /* synthetic */ Bundle access$400(Bundle bundle) {
        return ChildProcessLauncherHelperImpl.populateServiceBundle(bundle);
    }

    public static /* synthetic */ Map access$500() {
        return sLauncherByPid;
    }

    public static /* synthetic */ void access$900(long l2, int n2) {
        ChildProcessLauncherHelperImpl.nativeOnChildProcessStarted(l2, n2);
    }

    public static /* synthetic */ long access$802(ChildProcessLauncherHelperImpl childProcessLauncherHelperImpl, long l2) {
        childProcessLauncherHelperImpl.mNativeChildProcessLauncherHelper = l2;
        return l2;
    }

    public static /* synthetic */ void access$1000(Context context, boolean bl) {
        ChildProcessLauncherHelperImpl.warmUpOnLauncherThread(context, bl);
    }

    public static /* synthetic */ d access$1102(d d2) {
        sBindingManager = d2;
        return sBindingManager;
    }

    public static /* synthetic */ a.b.c.b.g access$1200() {
        return sSandboxedChildConnectionRanking;
    }

    static {
        $assertionsDisabled = ChildProcessLauncherHelperImpl.class.desiredAssertionStatus() ^ true;
        sLauncherByPid = new HashMap<Integer, ChildProcessLauncherHelperImpl>();
        sSandboxedServicesCountForTesting = -1;
    }

    public int getPidForTesting() {
        if (!$assertionsDisabled && !LauncherThread.runningOnLauncherThread()) {
            throw new AssertionError();
        }
        return this.mLauncher.a();
    }

    public l getChildProcessConnection() {
        return this.mLauncher.h;
    }

    public f getChildConnectionAllocatorForTesting() {
        return this.mLauncher.f;
    }
}

