/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser;

import a.b.a.a.d;
import a.b.a.e.k;
import a.b.a.g;
import a.b.a.j;
import a.b.c.b.p;
import a.b.d.a.c;
import a.b.d.a.z;
import a.b.p.c.c;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.os.StrictMode;
import com.vccorp.content.browser.TracingControllerAndroidImpl;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;
import org.chromium.base.BuildInfo;
import org.chromium.base.ContextUtils;
import org.chromium.base.ThreadUtils;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.base.library_loader.LibraryLoader;
import org.chromium.base.task.PostTask;
import org.chromium.content.app.ContentMain;

@JNINamespace(value="content")
public class BrowserStartupControllerImpl
implements c {
    public static final String TAG = "cr.BrowserStartup";
    public static final int STARTUP_SUCCESS = -1;
    public static final int STARTUP_FAILURE = 1;
    public static BrowserStartupControllerImpl sInstance;
    public static boolean sShouldStartGpuProcessOnBrowserStartup;
    public static final /* synthetic */ boolean $assertionsDisabled;
    public final List<c.a> mAsyncStartupCallbacks = new ArrayList<c.a>();
    public final List<c.a> mServiceManagerCallbacks = new ArrayList<c.a>();
    public boolean mHasStartedInitializingBrowserProcess;
    public boolean mPostResourceExtractionTasksCompleted;
    public boolean mHasCalledContentStart;
    public boolean mFullBrowserStartupDone;
    public boolean mStartupSuccess;
    public int mLibraryProcessType;
    public int mCurrentBrowserStartType = 0;
    public boolean mLaunchFullBrowserAfterServiceManagerStart;
    public boolean mServiceManagerStarted;
    public TracingControllerAndroidImpl mTracingController;

    public static void setShouldStartGpuProcessOnBrowserStartup(boolean bl) {
        sShouldStartGpuProcessOnBrowserStartup = bl;
    }

    public static void browserStartupComplete(int n2) {
        BrowserStartupControllerImpl browserStartupControllerImpl = sInstance;
        if (browserStartupControllerImpl != null) {
            browserStartupControllerImpl.executeEnqueuedCallbacks(n2);
        }
    }

    public static void serviceManagerStartupComplete() {
        BrowserStartupControllerImpl browserStartupControllerImpl = sInstance;
        if (browserStartupControllerImpl != null) {
            browserStartupControllerImpl.serviceManagerStarted();
        }
    }

    public static boolean shouldStartGpuProcessOnBrowserStartup() {
        return sShouldStartGpuProcessOnBrowserStartup;
    }

    public BrowserStartupControllerImpl(int n2) {
        this.mLibraryProcessType = n2;
        if (BuildInfo.isDebugAndroid()) {
            PostTask.postDelayedTask(z.a, new Runnable(){

                @Override
                public void run() {
                    BrowserStartupControllerImpl.this.addStartupCompletedObserver(new c.a(){
                        public static final /* synthetic */ boolean $assertionsDisabled;

                        static {
                            $assertionsDisabled = BrowserStartupControllerImpl.class.desiredAssertionStatus() ^ true;
                        }

                        @Override
                        public void onSuccess() {
                            if (!$assertionsDisabled && tracingControllerAndroidImpl.BrowserStartupControllerImpl.this.mTracingController != null) {
                                throw new AssertionError();
                            }
                            Context context = ContextUtils.sApplicationContext;
                            1 v0 = tracingControllerAndroidImpl;
                            BrowserStartupControllerImpl.access$002(v0.BrowserStartupControllerImpl.this, new TracingControllerAndroidImpl(context));
                            TracingControllerAndroidImpl tracingControllerAndroidImpl = v0.BrowserStartupControllerImpl.this.mTracingController;
                            context.registerReceiver((BroadcastReceiver)tracingControllerAndroidImpl.b, (IntentFilter)tracingControllerAndroidImpl.c);
                        }

                        @Override
                        public void onFailure() {
                        }
                    });
                }
            }, 0L);
        }
    }

    public static c get(int n2) {
        if (!$assertionsDisabled && !ThreadUtils.runningOnUiThread()) {
            throw new AssertionError((Object)"Tried to start the browser on the wrong thread.");
        }
        ThreadUtils.assertOnUiThread();
        if (sInstance == null) {
            if (!$assertionsDisabled && 1 != n2 && 3 != n2) {
                throw new AssertionError();
            }
            sInstance = new BrowserStartupControllerImpl(n2);
        }
        if (!$assertionsDisabled && BrowserStartupControllerImpl.sInstance.mLibraryProcessType != n2) {
            throw new AssertionError((Object)"Wrong process type");
        }
        return sInstance;
    }

    public static void overrideInstanceForTest(c c2) {
        sInstance = (BrowserStartupControllerImpl)c2;
    }

    private void serviceManagerStarted() {
        this.mServiceManagerStarted = true;
        if (this.mLaunchFullBrowserAfterServiceManagerStart) {
            this.mCurrentBrowserStartType = 0;
            if (this.contentStart() > 0) {
                this.enqueueCallbackExecution(1);
            }
            return;
        }
        if (this.mCurrentBrowserStartType == 1) {
            this.executeServiceManagerCallbacks(-1);
        }
        this.recordStartupUma();
    }

    private void executeEnqueuedCallbacks(int n2) {
        if (!$assertionsDisabled && !ThreadUtils.runningOnUiThread()) {
            throw new AssertionError((Object)"Callback from browser startup from wrong thread.");
        }
        this.mFullBrowserStartupDone = true;
        boolean bl = n2 <= 0;
        this.mStartupSuccess = bl;
        for (c.a a2 : this.mAsyncStartupCallbacks) {
            if (this.mStartupSuccess) {
                a2.onSuccess();
                continue;
            }
            a2.onFailure();
        }
        BrowserStartupControllerImpl browserStartupControllerImpl = this;
        this.mAsyncStartupCallbacks.clear();
        browserStartupControllerImpl.executeServiceManagerCallbacks(n2);
        browserStartupControllerImpl.recordStartupUma();
    }

    private void executeServiceManagerCallbacks(int n2) {
        n2 = n2 <= 0 ? 1 : 0;
        this.mStartupSuccess = n2;
        for (c.a a2 : this.mServiceManagerCallbacks) {
            if (this.mStartupSuccess) {
                a2.onSuccess();
                continue;
            }
            a2.onFailure();
        }
        this.mServiceManagerCallbacks.clear();
    }

    private void enqueueCallbackExecution(final int n2) {
        PostTask.postDelayedTask(z.c, new Runnable(){

            @Override
            public void run() {
                BrowserStartupControllerImpl.this.executeEnqueuedCallbacks(n2);
            }
        }, 0L);
    }

    private void postStartupCompleted(final c.a a2) {
        PostTask.postDelayedTask(z.c, new Runnable(){

            @Override
            public void run() {
                if (BrowserStartupControllerImpl.this.mStartupSuccess) {
                    a2.onSuccess();
                } else {
                    a2.onFailure();
                }
            }
        }, 0L);
    }

    public static native void nativeSetCommandLineFlags(boolean var0);

    public static native boolean nativeIsOfficialBuild();

    public static native void nativeFlushStartupTasks();

    public static /* synthetic */ TracingControllerAndroidImpl access$002(BrowserStartupControllerImpl browserStartupControllerImpl, TracingControllerAndroidImpl tracingControllerAndroidImpl) {
        browserStartupControllerImpl.mTracingController = tracingControllerAndroidImpl;
        return tracingControllerAndroidImpl;
    }

    public static /* synthetic */ int access$202(BrowserStartupControllerImpl browserStartupControllerImpl, int n2) {
        browserStartupControllerImpl.mCurrentBrowserStartType = n2;
        return n2;
    }

    public static /* synthetic */ void access$700(boolean bl) {
        BrowserStartupControllerImpl.nativeSetCommandLineFlags(bl);
    }

    public static /* synthetic */ boolean access$602(BrowserStartupControllerImpl browserStartupControllerImpl, boolean bl) {
        browserStartupControllerImpl.mPostResourceExtractionTasksCompleted = bl;
        return bl;
    }

    static {
        $assertionsDisabled = BrowserStartupControllerImpl.class.desiredAssertionStatus() ^ true;
    }

    @Override
    public void startBrowserProcessesAsync(boolean bl, final boolean bl2, c.a a2) {
        if (!$assertionsDisabled && !ThreadUtils.runningOnUiThread()) {
            throw new AssertionError((Object)"Tried to start the browser on the wrong thread.");
        }
        p.a.a(p.a(this.mFullBrowserStartupDone, this.mServiceManagerStarted, bl2));
        if (!(this.mFullBrowserStartupDone || bl2 && this.mServiceManagerStarted)) {
            if (bl2) {
                this.mServiceManagerCallbacks.add(a2);
            } else {
                this.mAsyncStartupCallbacks.add(a2);
            }
            BrowserStartupControllerImpl browserStartupControllerImpl = this;
            boolean bl3 = browserStartupControllerImpl.mLaunchFullBrowserAfterServiceManagerStart;
            boolean bl4 = browserStartupControllerImpl.mCurrentBrowserStartType == 1 && !bl2;
            this.mLaunchFullBrowserAfterServiceManagerStart = bl3 | bl4;
            if (!this.mHasStartedInitializingBrowserProcess) {
                Runnable runnable;
                this.mHasStartedInitializingBrowserProcess = true;
                sShouldStartGpuProcessOnBrowserStartup = bl;
                Runnable runnable2 = runnable;
                runnable = new Runnable(){

                    @Override
                    public void run() {
                        ThreadUtils.assertOnUiThread();
                        if (BrowserStartupControllerImpl.this.mHasCalledContentStart) {
                            return;
                        }
                        2 v0 = this;
                        BrowserStartupControllerImpl.access$202(v0.BrowserStartupControllerImpl.this, bl2 ? 1 : 0);
                        if (v0.BrowserStartupControllerImpl.this.contentStart() > 0) {
                            BrowserStartupControllerImpl.this.enqueueCallbackExecution(1);
                        }
                    }
                };
                this.prepareToStartBrowserProcess(false, runnable2);
            } else if (this.mServiceManagerStarted && this.mLaunchFullBrowserAfterServiceManagerStart) {
                this.mCurrentBrowserStartType = 0;
                if (this.contentStart() > 0) {
                    this.enqueueCallbackExecution(1);
                }
            }
            return;
        }
        this.postStartupCompleted(a2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void startBrowserProcessesSync(boolean bl) {
        block7: {
            block9: {
                block10: {
                    block8: {
                        p.a.a(p.a(this.mFullBrowserStartupDone, this.mServiceManagerStarted, false));
                        if (this.mFullBrowserStartupDone) break block7;
                        if (!this.mHasStartedInitializingBrowserProcess || !this.mPostResourceExtractionTasksCompleted) {
                            this.prepareToStartBrowserProcess(bl, null);
                        }
                        bl = true;
                        if (this.mHasCalledContentStart) break block8;
                        this.mCurrentBrowserStartType = 0;
                        if (this.contentStart() <= 0) break block9;
                        break block10;
                    }
                    if (this.mCurrentBrowserStartType != 1) break block9;
                    this.mCurrentBrowserStartType = 0;
                    if (this.contentStart() <= 0) break block9;
                }
                this.enqueueCallbackExecution(1);
                bl = false;
            }
            if (bl) {
                this.flushStartupTasks();
            }
        }
        if (!$assertionsDisabled && !this.mFullBrowserStartupDone) {
            throw new AssertionError();
        }
        if (this.mStartupSuccess) {
            return;
        }
        throw new d(4);
    }

    public int contentStart() {
        int n2 = this.mCurrentBrowserStartType == 1 ? 1 : 0;
        int n3 = n2;
        n2 = this.contentMainStart(n2 != 0);
        this.mHasCalledContentStart = true;
        if (n3 == 0) {
            this.mLaunchFullBrowserAfterServiceManagerStart = false;
        }
        return n2;
    }

    public int contentMainStart(boolean bl) {
        return ContentMain.nativeStart(bl);
    }

    public void flushStartupTasks() {
        BrowserStartupControllerImpl.nativeFlushStartupTasks();
    }

    public boolean isStartupSuccessfullyCompleted() {
        ThreadUtils.assertOnUiThread();
        return this.mFullBrowserStartupDone && this.mStartupSuccess;
    }

    public boolean isServiceManagerSuccessfullyStarted() {
        ThreadUtils.assertOnUiThread();
        return this.mServiceManagerStarted && this.mStartupSuccess;
    }

    public void addStartupCompletedObserver(c.a a2) {
        ThreadUtils.assertOnUiThread();
        if (this.mFullBrowserStartupDone) {
            this.postStartupCompleted(a2);
        } else {
            this.mAsyncStartupCallbacks.add(a2);
        }
    }

    public void prepareToStartBrowserProcess(final boolean bl, final Runnable runnable) {
        Runnable runnable2;
        StrictMode.ThreadPolicy threadPolicy = new Object[1];
        Object object = threadPolicy;
        threadPolicy[0] = bl;
        j.c(TAG, "Initializing chromium process, singleProcess=%b", (Object[])object);
        object = StrictMode.allowThreadDiskReads();
        try {
            LibraryLoader.sInstance.ensureInitialized(this.mLibraryProcessType);
        }
        catch (Throwable throwable) {
            StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)object);
            throw throwable;
        }
        StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)object);
        object = runnable2;
        runnable2 = new Runnable(){

            @Override
            public void run() {
                if (!BrowserStartupControllerImpl.this.mPostResourceExtractionTasksCompleted) {
                    5 v0 = this;
                    g.a();
                    BrowserStartupControllerImpl.nativeSetCommandLineFlags(v0.bl);
                    BrowserStartupControllerImpl.access$602(v0.BrowserStartupControllerImpl.this, true);
                }
                if ((this = runnable) != null) {
                    this.run();
                }
            }
        };
        a.b.p.c.c.a().d = z.c;
        if (runnable == null) {
            a.b.p.c.c.a().e();
            object.run();
        } else {
            a.b.p.c.c.a().a((Runnable)object);
        }
    }

    public void recordStartupUma() {
        p p2 = p.a;
        p.a.c = true;
        for (int i2 = 0; i2 < 4; ++i2) {
            if (p2.b[i2] <= 0) continue;
            int n2 = 0;
            while (true) {
                int[] nArray = p2.b;
                if (n2 >= p2.b[i2]) break;
                p2.b(i2);
                ++n2;
            }
            nArray[i2] = 0;
        }
    }

    public void initChromiumBrowserProcessForTests() {
        a.b.p.c.c c2 = a.b.p.c.c.a();
        c2.d = z.c;
        String string2 = "en";
        if (c2.c == null && !a.b.p.c.c.d()) {
            c2.c = c2.new c.a(string2);
            PostTask.postDelayedTask(k.c, c2.c, 0L);
        }
        c2.e();
        BrowserStartupControllerImpl.nativeSetCommandLineFlags(false);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface BrowserStartType {
        public static final int FULL_BROWSER = 0;
        public static final int SERVICE_MANAGER_ONLY = 1;
    }
}

