/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base.process_launcher;

import a.b.a.b.b;
import a.b.a.d.q;
import a.b.a.d.r;
import a.b.a.d.s;
import a.b.a.j;
import android.app.Service;
import android.content.Intent;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Parcelable;
import android.os.Process;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;
import javax.annotation.concurrent.GuardedBy;
import org.chromium.base.ContextUtils;
import org.chromium.base.ThreadUtils;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.base.annotations.MainDex;
import org.chromium.base.process_launcher.FileDescriptorInfo;

@JNINamespace(value="base::android")
@MainDex
public abstract class ChildProcessService
extends Service {
    public static final String MAIN_THREAD_NAME = "ChildProcessMain";
    public static final String TAG = "ChildProcessService";
    public static boolean sCreateCalled;
    public static int sSplitApkWorkaroundResult;
    public static final /* synthetic */ boolean $assertionsDisabled;
    public final q mDelegate;
    public final Object mBinderLock = new Object();
    public final Object mLibraryInitializedLock = new Object();
    public boolean mBindToCallerCheck;
    @GuardedBy(value="mBinderLock")
    public int mBoundCallingPid;
    public Thread mMainThread;
    public String[] mCommandLineParams;
    public FileDescriptorInfo[] mFdInfos;
    @GuardedBy(value="mLibraryInitializedLock")
    public boolean mLibraryInitialized;
    public boolean mServiceBound;
    public s mParentProcess;
    public final r.a mBinder = new r.a(){
        public static final /* synthetic */ boolean $assertionsDisabled;

        static {
            $assertionsDisabled = ChildProcessService.class.desiredAssertionStatus() ^ true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean bindToCaller() {
            if (!$assertionsDisabled && !ChildProcessService.this.mBindToCallerCheck) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && !ChildProcessService.this.mServiceBound) {
                throw new AssertionError();
            }
            1 v0 = this;
            Object object = v0.ChildProcessService.this.mBinderLock;
            synchronized (object) {
                try {
                    int n2 = Binder.getCallingPid();
                    if (v0.ChildProcessService.this.mBoundCallingPid == 0) {
                        ChildProcessService.access$302(ChildProcessService.this, n2);
                    }
                    if (ChildProcessService.this.mBoundCallingPid != n2) {
                        j.b(ChildProcessService.TAG, "Service is already bound by pid %d, cannot bind for pid %d", ChildProcessService.this.mBoundCallingPid, n2);
                        return false;
                    }
                }
                finally {
                    Throwable throwable;
                    throw throwable;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void setupConnection(Bundle bundle, s s2, List<IBinder> list) {
            1 v2;
            if (!$assertionsDisabled && !ChildProcessService.this.mServiceBound) {
                throw new AssertionError();
            }
            1 v0 = this;
            Object object = v0.ChildProcessService.this.mBinderLock;
            synchronized (object) {
                if (v0.ChildProcessService.this.mBindToCallerCheck && ChildProcessService.this.mBoundCallingPid == 0) {
                    j.b(ChildProcessService.TAG, "Service has not been bound with bindToCaller()", new Object[0]);
                    s2.a(-1);
                    return;
                }
                1 v1 = this;
                v2 = v1;
                // MONITOREXIT @DISABLED, blocks:[0, 1] lbl14 : MonitorExitStatement: MONITOREXIT : var4_4
                s2.a(Process.myPid());
                ChildProcessService.access$402(v1.ChildProcessService.this, s2);
            }
            v2.ChildProcessService.this.processConnectionBundle(bundle, list);
        }

        @Override
        public void forceKill() {
            if (!$assertionsDisabled && !ChildProcessService.this.mServiceBound) {
                throw new AssertionError();
            }
            Process.killProcess((int)Process.myPid());
        }

        @Override
        public void onMemoryPressure(int n2) {
            ThreadUtils.getUiThreadHandler().post(() -> {
                if (n2 >= b.c.c()) {
                    b.c.a(n2);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void dumpProcessStack() {
            Object object;
            if (!$assertionsDisabled && !object.ChildProcessService.this.mServiceBound) {
                throw new AssertionError();
            }
            1 v0 = object;
            object = v0.ChildProcessService.this.mLibraryInitializedLock;
            synchronized (object) {
                if (!v0.ChildProcessService.this.mLibraryInitialized) {
                    j.b(ChildProcessService.TAG, "Cannot dump process stack before native is loaded", new Object[0]);
                    return;
                }
            }
            ChildProcessService.nativeDumpProcessStack();
        }
    };

    public static void setSplitApkWorkaroundResult(int n2) {
        sSplitApkWorkaroundResult = n2;
    }

    public ChildProcessService(q q2) {
        this.mDelegate = q2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processConnectionBundle(Bundle bundle, List<IBinder> list) {
        ChildProcessService childProcessService = this;
        bundle.setClassLoader(this.getApplicationContext().getClassLoader());
        Thread thread = childProcessService.mMainThread;
        synchronized (thread) {
            if (childProcessService.mCommandLineParams == null) {
                this.mCommandLineParams = bundle.getStringArray("com.vccorp.base.process_launcher.extra.command_line");
                this.mMainThread.notifyAll();
            }
            if (!$assertionsDisabled && this.mCommandLineParams == null) {
                throw new AssertionError();
            }
            Parcelable[] parcelableArray = bundle.getParcelableArray("com.vccorp.base.process_launcher.extra.extraFiles");
            if (parcelableArray != null) {
                this.mFdInfos = new FileDescriptorInfo[parcelableArray.length];
                System.arraycopy(parcelableArray, 0, this.mFdInfos, 0, parcelableArray.length);
            }
            ChildProcessService childProcessService2 = this;
            childProcessService2.mDelegate.onConnectionSetup(bundle, list);
            childProcessService2.mMainThread.notifyAll();
            return;
        }
    }

    public static native void nativeRegisterFileDescriptors(String[] var0, int[] var1, int[] var2, long[] var3, long[] var4);

    public static native void nativeExitChildProcess();

    public static native void nativeDumpProcessStack();

    public static /* synthetic */ int access$302(ChildProcessService childProcessService, int n2) {
        childProcessService.mBoundCallingPid = n2;
        return n2;
    }

    public static /* synthetic */ s access$402(ChildProcessService childProcessService, s s2) {
        childProcessService.mParentProcess = s2;
        return s2;
    }

    public static /* synthetic */ void access$800() {
        ChildProcessService.nativeDumpProcessStack();
    }

    public static /* synthetic */ Thread access$900(ChildProcessService childProcessService) {
        return childProcessService.mMainThread;
    }

    public static /* synthetic */ String[] access$1000(ChildProcessService childProcessService) {
        return childProcessService.mCommandLineParams;
    }

    public static /* synthetic */ q access$1100(ChildProcessService childProcessService) {
        return childProcessService.mDelegate;
    }

    public static /* synthetic */ boolean access$702(ChildProcessService childProcessService, boolean bl) {
        childProcessService.mLibraryInitialized = bl;
        return bl;
    }

    public static /* synthetic */ FileDescriptorInfo[] access$1200(ChildProcessService childProcessService) {
        return childProcessService.mFdInfos;
    }

    public static /* synthetic */ void access$1300(String[] stringArray, int[] nArray, int[] nArray2, long[] lArray, long[] lArray2) {
        ChildProcessService.nativeRegisterFileDescriptors(stringArray, nArray, nArray2, lArray, lArray2);
    }

    public static /* synthetic */ int access$1400() {
        return sSplitApkWorkaroundResult;
    }

    public static /* synthetic */ s access$400(ChildProcessService childProcessService) {
        return childProcessService.mParentProcess;
    }

    public static /* synthetic */ void access$1500() {
        ChildProcessService.nativeExitChildProcess();
    }

    static {
        $assertionsDisabled = ChildProcessService.class.desiredAssertionStatus() ^ true;
        sSplitApkWorkaroundResult = 0;
    }

    public void onCreate() {
        super.onCreate();
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = Process.myPid();
        j.c(TAG, "Creating new ChildProcessService pid=%d", objectArray2);
        if (!sCreateCalled) {
            ChildProcessService childProcessService = this;
            sCreateCalled = true;
            ContextUtils.initApplicationContext(childProcessService.getApplicationContext());
            childProcessService.mDelegate.onServiceCreated();
            childProcessService.mMainThread = new Thread(new Runnable(){
                public static final /* synthetic */ boolean $assertionsDisabled;

                static {
                    $assertionsDisabled = ChildProcessService.class.desiredAssertionStatus() ^ true;
                }

                /*
                 * Exception decompiling
                 */
                @Override
                public void run() {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [38[WHILELOOP]], but top level block is 16[TRYBLOCK]
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }
            }, MAIN_THREAD_NAME);
            childProcessService.mMainThread.start();
            return;
        }
        throw new RuntimeException("Illegal child process reuse.");
    }

    public void onDestroy() {
        super.onDestroy();
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = Process.myPid();
        j.c(TAG, "Destroying ChildProcessService pid=%d", objectArray2);
        System.exit(0);
    }

    public IBinder onBind(Intent intent) {
        if (!$assertionsDisabled && this.mServiceBound) {
            throw new AssertionError();
        }
        ChildProcessService childProcessService = this;
        this.stopSelf();
        childProcessService.mBindToCallerCheck = intent.getBooleanExtra("com.vccorp.base.process_launcher.extra.bind_to_caller", false);
        childProcessService.mServiceBound = true;
        childProcessService.mDelegate.onServiceBound(intent);
        new Handler(Looper.getMainLooper()).post(() -> this.mDelegate.preloadNativeLibrary(this.getApplicationContext()));
        return childProcessService.mBinder;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SplitApkWorkaroundResult {
        public static final int NOT_RUN = 0;
        public static final int NO_ENTRIES = 1;
        public static final int ONE_ENTRY = 2;
        public static final int MULTIPLE_ENTRIES = 3;
        public static final int TOPLEVEL_EXCEPTION = 4;
        public static final int LOOP_EXCEPTION = 5;
        public static final int NUM_ENTRIES = 6;
    }
}

