/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base;

import a.a.a.a.a;
import android.annotation.SuppressLint;
import android.os.Looper;
import android.os.MessageQueue;
import android.os.SystemClock;
import android.util.Log;
import android.util.Printer;
import org.chromium.base.CommandLine;
import org.chromium.base.EarlyTraceEvent;
import org.chromium.base.ThreadUtils;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.base.annotations.MainDex;

@JNINamespace(value="base::android")
@MainDex
public class TraceEvent
implements AutoCloseable {
    public static volatile boolean sEnabled;
    public static volatile boolean sATraceEnabled;
    public final String mName;

    public TraceEvent(String string2, String string3) {
        this.mName = string2;
        TraceEvent.begin(string2, string3);
    }

    public static TraceEvent scoped(String string2, String string3) {
        if (!EarlyTraceEvent.enabled() && !sEnabled) {
            return null;
        }
        return new TraceEvent(string2, string3);
    }

    public static TraceEvent scoped(String string2) {
        return TraceEvent.scoped(string2, null);
    }

    public static void registerNativeEnabledObserver() {
        TraceEvent.nativeRegisterEnabledObserver();
    }

    public static void setEnabled(boolean bl) {
        if (bl) {
            EarlyTraceEvent.disable();
        }
        if (sEnabled != bl) {
            sEnabled = bl;
            if (sATraceEnabled) {
                return;
            }
            Looper looper = ThreadUtils.getUiThreadHandler().getLooper();
            BasicLooperMonitor basicLooperMonitor = bl ? LooperMonitorHolder.sInstance : null;
            looper.setMessageLogging((Printer)basicLooperMonitor);
        }
    }

    public static void maybeEnableEarlyTracing() {
        EarlyTraceEvent.maybeEnable();
        if (EarlyTraceEvent.isActive()) {
            ThreadUtils.getUiThreadHandler().getLooper().setMessageLogging((Printer)LooperMonitorHolder.sInstance);
        }
    }

    public static void setATraceEnabled(boolean bl) {
        if (sATraceEnabled == bl) {
            return;
        }
        sATraceEnabled = bl;
        if (sATraceEnabled) {
            TraceEvent.nativeStartATrace();
        } else {
            TraceEvent.nativeStopATrace();
        }
    }

    public static boolean enabled() {
        return sEnabled;
    }

    public static void instant(String string2) {
        if (sEnabled) {
            TraceEvent.nativeInstant(string2, null);
        }
    }

    public static void instant(String string2, String string3) {
        if (sEnabled) {
            TraceEvent.nativeInstant(string2, string3);
        }
    }

    public static void startAsync(String string2, long l2) {
        EarlyTraceEvent.startAsync(string2, l2);
        if (sEnabled) {
            TraceEvent.nativeStartAsync(string2, l2);
        }
    }

    public static void finishAsync(String string2, long l2) {
        EarlyTraceEvent.finishAsync(string2, l2);
        if (sEnabled) {
            TraceEvent.nativeFinishAsync(string2, l2);
        }
    }

    public static void begin(String string2) {
        TraceEvent.begin(string2, null);
    }

    public static void begin(String string2, String string3) {
        EarlyTraceEvent.begin(string2);
        if (sEnabled) {
            TraceEvent.nativeBegin(string2, string3);
        }
    }

    public static void end(String string2) {
        TraceEvent.end(string2, null);
    }

    public static void end(String string2, String string3) {
        EarlyTraceEvent.end(string2);
        if (sEnabled) {
            TraceEvent.nativeEnd(string2, string3);
        }
    }

    public static native void nativeRegisterEnabledObserver();

    public static native void nativeStartATrace();

    public static native void nativeStopATrace();

    public static native void nativeInstant(String var0, String var1);

    public static native void nativeBegin(String var0, String var1);

    public static native void nativeEnd(String var0, String var1);

    public static native void nativeBeginToplevel(String var0);

    public static native void nativeEndToplevel(String var0);

    public static native void nativeStartAsync(String var0, long var1);

    public static native void nativeFinishAsync(String var0, long var1);

    public static /* synthetic */ boolean access$000() {
        return sEnabled;
    }

    public static /* synthetic */ void access$100(String string2) {
        TraceEvent.nativeBeginToplevel(string2);
    }

    public static /* synthetic */ void access$200(String string2) {
        TraceEvent.nativeEndToplevel(string2);
    }

    @Override
    public void close() {
        TraceEvent.end(this.mName, null);
    }

    private static final class LooperMonitorHolder {
        public static final BasicLooperMonitor sInstance;

        public static /* synthetic */ BasicLooperMonitor access$500() {
            return sInstance;
        }

        static {
            BasicLooperMonitor basicLooperMonitor;
            if (CommandLine.getInstance().hasSwitch("enable-idle-tracing")) {
                IdleTracingLooperMonitor idleTracingLooperMonitor;
                basicLooperMonitor = idleTracingLooperMonitor;
                idleTracingLooperMonitor = new IdleTracingLooperMonitor(null);
            } else {
                BasicLooperMonitor basicLooperMonitor2;
                basicLooperMonitor = basicLooperMonitor2;
                basicLooperMonitor2 = new BasicLooperMonitor(null);
            }
            sInstance = basicLooperMonitor;
        }
    }

    private static final class IdleTracingLooperMonitor
    extends BasicLooperMonitor
    implements MessageQueue.IdleHandler {
        public static final String TAG = "TraceEvent.LooperMonitor";
        public static final String IDLE_EVENT_NAME = "Looper.queueIdle";
        public static final long FRAME_DURATION_MILLIS = 16L;
        public static final long MIN_INTERESTING_DURATION_MILLIS = 16L;
        public static final long MIN_INTERESTING_BURST_DURATION_MILLIS = 48L;
        public long mLastIdleStartedAt;
        public long mLastWorkStartedAt;
        public int mNumTasksSeen;
        public int mNumIdlesSeen;
        public int mNumTasksSinceLastIdle;
        public boolean mIdleMonitorAttached;

        public IdleTracingLooperMonitor() {
            super(null);
        }

        @SuppressLint(value={"LongLogTag"})
        private final void syncIdleMonitoring() {
            if (sEnabled && !this.mIdleMonitorAttached) {
                IdleTracingLooperMonitor idleTracingLooperMonitor = this;
                idleTracingLooperMonitor.mLastIdleStartedAt = SystemClock.elapsedRealtime();
                Looper.myQueue().addIdleHandler((MessageQueue.IdleHandler)this);
                idleTracingLooperMonitor.mIdleMonitorAttached = true;
                Log.v((String)TAG, (String)"attached idle handler");
            } else if (this.mIdleMonitorAttached && !sEnabled) {
                Looper.myQueue().removeIdleHandler((MessageQueue.IdleHandler)this);
                this.mIdleMonitorAttached = false;
                Log.v((String)TAG, (String)"detached idle handler");
            }
        }

        @SuppressLint(value={"LongLogTag"})
        public static void traceAndLog(int n2, String string2) {
            TraceEvent.instant("TraceEvent.LooperMonitor:IdleStats", string2);
            Log.println((int)n2, (String)TAG, (String)string2);
        }

        public /* synthetic */ IdleTracingLooperMonitor(1 var1_1) {
            super(null);
        }

        @Override
        public final void beginHandling(String string2) {
            if (this.mNumTasksSinceLastIdle == 0) {
                TraceEvent.end(IDLE_EVENT_NAME, null);
            }
            this.mLastWorkStartedAt = SystemClock.elapsedRealtime();
            this.syncIdleMonitoring();
            super.beginHandling(string2);
        }

        @Override
        public final void endHandling(String string2) {
            long l2 = SystemClock.elapsedRealtime() - this.mLastWorkStartedAt;
            if (l2 > 16L) {
                IdleTracingLooperMonitor.traceAndLog(5, "observed a task that took " + l2 + "ms: " + string2);
            }
            IdleTracingLooperMonitor idleTracingLooperMonitor = this;
            super.endHandling(string2);
            idleTracingLooperMonitor.syncIdleMonitoring();
            ++idleTracingLooperMonitor.mNumTasksSeen;
            ++idleTracingLooperMonitor.mNumTasksSinceLastIdle;
        }

        public final boolean queueIdle() {
            long l2 = SystemClock.elapsedRealtime();
            if (this.mLastIdleStartedAt == 0L) {
                this.mLastIdleStartedAt = l2;
            }
            long l3 = l2 - this.mLastIdleStartedAt;
            ++this.mNumIdlesSeen;
            TraceEvent.begin(IDLE_EVENT_NAME, this.mNumTasksSinceLastIdle + " tasks since last idle.");
            if (l3 > 48L) {
                IdleTracingLooperMonitor.traceAndLog(3, this.mNumTasksSeen + " tasks and " + this.mNumIdlesSeen + " idles processed so far, " + this.mNumTasksSinceLastIdle + " tasks bursted and " + l3 + "ms elapsed since last idle");
            }
            IdleTracingLooperMonitor idleTracingLooperMonitor = this;
            idleTracingLooperMonitor.mLastIdleStartedAt = l2;
            idleTracingLooperMonitor.mNumTasksSinceLastIdle = 0;
            return true;
        }
    }

    private static class BasicLooperMonitor
    implements Printer {
        public static final String LOOPER_TASK_PREFIX = "Looper.dispatch: ";
        public static final int SHORTEST_LOG_PREFIX_LENGTH;
        public static final /* synthetic */ boolean $assertionsDisabled;
        public String mCurrentTarget;

        public BasicLooperMonitor() {
        }

        public static String getTraceEventName(String string2) {
            return a.a(LOOPER_TASK_PREFIX).append(BasicLooperMonitor.getTarget(string2)).append("(").append(BasicLooperMonitor.getTargetName(string2)).append(")").toString();
        }

        public static String getTarget(String string2) {
            int n2 = string2.indexOf(40, SHORTEST_LOG_PREFIX_LENGTH);
            int n3 = n2 == -1 ? -1 : string2.indexOf(41, n2);
            return n3 != -1 ? string2.substring(n2 + 1, n3) : "";
        }

        public static String getTargetName(String string2) {
            int n2 = string2.indexOf(125, SHORTEST_LOG_PREFIX_LENGTH);
            int n3 = n2 == -1 ? -1 : string2.indexOf(58, n2);
            if (n3 == -1) {
                n3 = string2.length();
            }
            return n2 != -1 ? string2.substring(n2 + 2, n3) : "";
        }

        public /* synthetic */ BasicLooperMonitor(1 var1_1) {
        }

        static {
            $assertionsDisabled = TraceEvent.class.desiredAssertionStatus() ^ true;
            SHORTEST_LOG_PREFIX_LENGTH = 18;
        }

        public void println(String string2) {
            if (string2.startsWith(">")) {
                this.beginHandling(string2);
            } else {
                if (!$assertionsDisabled && !string2.startsWith("<")) {
                    throw new AssertionError();
                }
                this.endHandling(string2);
            }
        }

        public void beginHandling(String string2) {
            boolean bl = EarlyTraceEvent.isActive();
            if (sEnabled || bl) {
                this.mCurrentTarget = BasicLooperMonitor.getTraceEventName(string2);
                if (sEnabled) {
                    TraceEvent.nativeBeginToplevel(this.mCurrentTarget);
                } else {
                    EarlyTraceEvent.begin(this.mCurrentTarget);
                }
            }
        }

        public void endHandling(String string2) {
            boolean bl = EarlyTraceEvent.isActive();
            if ((sEnabled || bl) && this.mCurrentTarget != null) {
                if (sEnabled) {
                    TraceEvent.nativeEndToplevel(this.mCurrentTarget);
                } else {
                    EarlyTraceEvent.end(this.mCurrentTarget);
                }
            }
            this.mCurrentTarget = null;
        }
    }
}

