/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base;

import a.b.a.e.b;
import a.b.a.j;
import a.b.a.m;
import android.annotation.SuppressLint;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.os.Build;
import android.os.Environment;
import android.os.SystemClock;
import android.system.Os;
import android.text.TextUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicBoolean;
import org.chromium.base.ContextUtils;
import org.chromium.base.annotations.MainDex;
import org.chromium.base.metrics.RecordHistogram;

@MainDex
public abstract class PathUtils {
    public static final String TAG = "PathUtils";
    public static final String THUMBNAIL_DIRECTORY_NAME = "textures";
    public static final int DATA_DIRECTORY = 0;
    public static final int THUMBNAIL_DIRECTORY = 1;
    public static final int CACHE_DIRECTORY = 2;
    public static final int NUM_DIRECTORIES = 3;
    public static final AtomicBoolean sInitializationStarted;
    public static FutureTask<String[]> sDirPathFetchTask;
    public static String sDataDirectorySuffix;
    public static String sCacheSubDirectory;
    public static final /* synthetic */ boolean $assertionsDisabled;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String[] getOrComputeDirectoryPaths() {
        block11: {
            if (PathUtils.sDirPathFetchTask.cancel(false) == false) return PathUtils.sDirPathFetchTask.get();
            var0 = m.h();
            var1_1 = null;
            v0 = PathUtils.setPrivateDataDirectorySuffixInternal();
            {
                catch (Throwable var2_2) {
                    break block11;
                }
                catch (Throwable v1) {}
                var1_1 = v1;
                {
                    throw v1;
                }
            }
            var0.close();
            return v0;
        }
        if (var1_1 == null) ** GOTO lbl29
        try {
            var0.close();
            throw var2_2;
        }
        catch (Throwable v2) {
            try {
                var1_1.addSuppressed(v2);
                throw var2_2;
            }
            catch (ExecutionException v3) {
                return null;
            }
            catch (InterruptedException v4) {}
            return null;
lbl29:
            // 1 sources

            var0.close();
            throw var2_2;
        }
    }

    @SuppressLint(value={"NewApi"})
    public static void chmod(String objectArray, int n2) {
        if (Build.VERSION.SDK_INT < 21) {
            return;
        }
        try {
            Os.chmod((String)objectArray, (int)n2);
        }
        catch (Exception exception) {
            String string2 = "Failed to set permissions for path \"" + (String)objectArray + "\"";
            objectArray = new Object[]{};
            j.b(TAG, string2, objectArray);
        }
    }

    public static String[] setPrivateDataDirectorySuffixInternal() {
        String[] stringArray = new String[3];
        String[] stringArray2 = stringArray;
        Context context = ContextUtils.sApplicationContext;
        stringArray2[0] = context.getDir(sDataDirectorySuffix, 0).getPath();
        PathUtils.chmod(stringArray2[0], 448);
        stringArray[1] = context.getDir(THUMBNAIL_DIRECTORY_NAME, 0).getPath();
        if (context.getCacheDir() != null) {
            stringArray2[2] = sCacheSubDirectory == null ? context.getCacheDir().getPath() : new File(context.getCacheDir(), sCacheSubDirectory).getPath();
        }
        return stringArray2;
    }

    public static void setPrivateDataDirectorySuffix(String string2, String string3) {
        if (!sInitializationStarted.getAndSet(true)) {
            if (!$assertionsDisabled && ContextUtils.sApplicationContext == null) {
                throw new AssertionError();
            }
            sDataDirectorySuffix = string2;
            sCacheSubDirectory = string3;
            sDirPathFetchTask = new FutureTask<String[]>(PathUtils::setPrivateDataDirectorySuffixInternal);
            b.THREAD_POOL_EXECUTOR.execute(sDirPathFetchTask);
        }
    }

    public static void setPrivateDataDirectorySuffix(String string2) {
        PathUtils.setPrivateDataDirectorySuffix(string2, null);
    }

    public static String getDirectoryPath(int n2) {
        return Holder.DIRECTORY_PATHS[n2];
    }

    public static String getDataDirectory() {
        if (!$assertionsDisabled && sDirPathFetchTask == null) {
            throw new AssertionError((Object)"setDataDirectorySuffix must be called first.");
        }
        return PathUtils.getDirectoryPath(0);
    }

    public static String getCacheDirectory() {
        if (!$assertionsDisabled && sDirPathFetchTask == null) {
            throw new AssertionError((Object)"setDataDirectorySuffix must be called first.");
        }
        return PathUtils.getDirectoryPath(2);
    }

    public static String getThumbnailCacheDirectory() {
        if (!$assertionsDisabled && sDirPathFetchTask == null) {
            throw new AssertionError((Object)"setDataDirectorySuffix must be called first.");
        }
        return PathUtils.getDirectoryPath(1);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getDownloadsDirectory() {
        Throwable throwable3222222;
        Throwable throwable2;
        m m2;
        block8: {
            m2 = m.g();
            throwable2 = null;
            long l2 = SystemClock.elapsedRealtime();
            String string2 = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DOWNLOADS).getPath();
            m m3 = m2;
            String string3 = "Android.StrictMode.DownloadsDir";
            long l3 = SystemClock.elapsedRealtime();
            {
                catch (Throwable throwable3222222) {
                    break block8;
                }
                catch (Throwable throwable4) {}
                {
                    throw throwable4;
                }
            }
            {
                RecordHistogram.recordTimesHistogram(string3, l3 - l2);
                m3.close();
            }
            return string2;
        }
        if (throwable2 == null) {
            m2.close();
            throw throwable3222222;
        }
        try {
            m2.close();
            throw throwable3222222;
        }
        catch (Throwable throwable5) {
            throwable2.addSuppressed(throwable5);
            throw throwable3222222;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String[] getAllPrivateDownloadsDirectories() {
        ArrayList arrayList;
        File[] fileArray;
        Object object;
        block11: {
            if (Build.VERSION.SDK_INT >= 19) {
                object = m.h();
                Throwable throwable = null;
                try {
                    fileArray = ContextUtils.sApplicationContext.getExternalFilesDirs(Environment.DIRECTORY_DOWNLOADS);
                    ((m)object).close();
                    break block11;
                }
                catch (Throwable throwable2) {
                    throw throwable2;
                }
                catch (Throwable throwable3) {}
                if (throwable == null) {
                    ((m)object).close();
                    throw throwable3;
                }
                try {
                    ((m)object).close();
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    throwable.addSuppressed(throwable4);
                    throw throwable3;
                }
            }
            File[] fileArray2 = new File[1];
            fileArray = fileArray2;
            fileArray2[0] = Environment.getExternalStorageDirectory();
        }
        object = arrayList;
        arrayList = new ArrayList();
        int n2 = 0;
        while (true) {
            if (n2 >= fileArray.length) {
                Object object2 = object;
                return ((ArrayList)object2).toArray(new String[((ArrayList)object2).size()]);
            }
            if (fileArray[n2] != null && !TextUtils.isEmpty((CharSequence)fileArray[n2].getAbsolutePath())) {
                ((ArrayList)object).add(fileArray[n2].getAbsolutePath());
            }
            ++n2;
        }
    }

    public static String getNativeLibraryDirectory() {
        ApplicationInfo applicationInfo = ContextUtils.sApplicationContext.getApplicationInfo();
        int n2 = applicationInfo.flags;
        if ((n2 & 0x80) == 0 && (n2 & 1) != 0) {
            return "/system/lib/";
        }
        return applicationInfo.nativeLibraryDir;
    }

    public static String getExternalStorageDirectory() {
        return Environment.getExternalStorageDirectory().getAbsolutePath();
    }

    public static /* synthetic */ String[] access$000() {
        return PathUtils.getOrComputeDirectoryPaths();
    }

    static {
        $assertionsDisabled = PathUtils.class.desiredAssertionStatus() ^ true;
        sInitializationStarted = new AtomicBoolean();
    }

    private static class Holder {
        public static final String[] DIRECTORY_PATHS = PathUtils.getOrComputeDirectoryPaths();

        public static /* synthetic */ String[] access$100() {
            return DIRECTORY_PATHS;
        }
    }
}

