
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     services/viz/public/interfaces/compositing/quads.mojom
//

package com.vccorp.viz.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


public final class DrawQuadState extends com.vccorp.mojo.bindings.Union {

    public static final class Tag {
        public static final int DebugBorderQuadState = 0;
        public static final int RenderPassQuadState = 1;
        public static final int SolidColorQuadState = 2;
        public static final int StreamVideoQuadState = 3;
        public static final int SurfaceQuadState = 4;
        public static final int TextureQuadState = 5;
        public static final int TileQuadState = 6;
        public static final int YuvVideoQuadState = 7;
        public static final int VideoHoleQuadState = 8;
    };
    private DebugBorderQuadState mDebugBorderQuadState;
    private RenderPassQuadState mRenderPassQuadState;
    private SolidColorQuadState mSolidColorQuadState;
    private StreamVideoQuadState mStreamVideoQuadState;
    private SurfaceQuadState mSurfaceQuadState;
    private TextureQuadState mTextureQuadState;
    private TileQuadState mTileQuadState;
    private YuvVideoQuadState mYuvVideoQuadState;
    private VideoHoleQuadState mVideoHoleQuadState;

    public void setDebugBorderQuadState(DebugBorderQuadState debugBorderQuadState) {
        this.mTag = Tag.DebugBorderQuadState;
        this.mDebugBorderQuadState = debugBorderQuadState;
    }

    public DebugBorderQuadState getDebugBorderQuadState() {
        assert this.mTag == Tag.DebugBorderQuadState;
        return this.mDebugBorderQuadState;
    }

    public void setRenderPassQuadState(RenderPassQuadState renderPassQuadState) {
        this.mTag = Tag.RenderPassQuadState;
        this.mRenderPassQuadState = renderPassQuadState;
    }

    public RenderPassQuadState getRenderPassQuadState() {
        assert this.mTag == Tag.RenderPassQuadState;
        return this.mRenderPassQuadState;
    }

    public void setSolidColorQuadState(SolidColorQuadState solidColorQuadState) {
        this.mTag = Tag.SolidColorQuadState;
        this.mSolidColorQuadState = solidColorQuadState;
    }

    public SolidColorQuadState getSolidColorQuadState() {
        assert this.mTag == Tag.SolidColorQuadState;
        return this.mSolidColorQuadState;
    }

    public void setStreamVideoQuadState(StreamVideoQuadState streamVideoQuadState) {
        this.mTag = Tag.StreamVideoQuadState;
        this.mStreamVideoQuadState = streamVideoQuadState;
    }

    public StreamVideoQuadState getStreamVideoQuadState() {
        assert this.mTag == Tag.StreamVideoQuadState;
        return this.mStreamVideoQuadState;
    }

    public void setSurfaceQuadState(SurfaceQuadState surfaceQuadState) {
        this.mTag = Tag.SurfaceQuadState;
        this.mSurfaceQuadState = surfaceQuadState;
    }

    public SurfaceQuadState getSurfaceQuadState() {
        assert this.mTag == Tag.SurfaceQuadState;
        return this.mSurfaceQuadState;
    }

    public void setTextureQuadState(TextureQuadState textureQuadState) {
        this.mTag = Tag.TextureQuadState;
        this.mTextureQuadState = textureQuadState;
    }

    public TextureQuadState getTextureQuadState() {
        assert this.mTag == Tag.TextureQuadState;
        return this.mTextureQuadState;
    }

    public void setTileQuadState(TileQuadState tileQuadState) {
        this.mTag = Tag.TileQuadState;
        this.mTileQuadState = tileQuadState;
    }

    public TileQuadState getTileQuadState() {
        assert this.mTag == Tag.TileQuadState;
        return this.mTileQuadState;
    }

    public void setYuvVideoQuadState(YuvVideoQuadState yuvVideoQuadState) {
        this.mTag = Tag.YuvVideoQuadState;
        this.mYuvVideoQuadState = yuvVideoQuadState;
    }

    public YuvVideoQuadState getYuvVideoQuadState() {
        assert this.mTag == Tag.YuvVideoQuadState;
        return this.mYuvVideoQuadState;
    }

    public void setVideoHoleQuadState(VideoHoleQuadState videoHoleQuadState) {
        this.mTag = Tag.VideoHoleQuadState;
        this.mVideoHoleQuadState = videoHoleQuadState;
    }

    public VideoHoleQuadState getVideoHoleQuadState() {
        assert this.mTag == Tag.VideoHoleQuadState;
        return this.mVideoHoleQuadState;
    }


    @Override
    public final void encode(org.chromium.mojo.bindings.Encoder encoder0, int offset) {
        encoder0.encode(com.vccorp.mojo.bindings.BindingsHelper.UNION_SIZE, offset);
        encoder0.encode(this.mTag, offset + 4);
        switch (mTag) {
            case Tag.DebugBorderQuadState: {
                
                encoder0.encode(this.mDebugBorderQuadState, offset + 8, false);
                break;
            }
            case Tag.RenderPassQuadState: {
                
                encoder0.encode(this.mRenderPassQuadState, offset + 8, false);
                break;
            }
            case Tag.SolidColorQuadState: {
                
                encoder0.encode(this.mSolidColorQuadState, offset + 8, false);
                break;
            }
            case Tag.StreamVideoQuadState: {
                
                encoder0.encode(this.mStreamVideoQuadState, offset + 8, false);
                break;
            }
            case Tag.SurfaceQuadState: {
                
                encoder0.encode(this.mSurfaceQuadState, offset + 8, false);
                break;
            }
            case Tag.TextureQuadState: {
                
                encoder0.encode(this.mTextureQuadState, offset + 8, false);
                break;
            }
            case Tag.TileQuadState: {
                
                encoder0.encode(this.mTileQuadState, offset + 8, false);
                break;
            }
            case Tag.YuvVideoQuadState: {
                
                encoder0.encode(this.mYuvVideoQuadState, offset + 8, false);
                break;
            }
            case Tag.VideoHoleQuadState: {
                
                encoder0.encode(this.mVideoHoleQuadState, offset + 8, false);
                break;
            }
            default: {
                break;
            }
        }
    }

    public static DrawQuadState deserialize(com.vccorp.mojo.bindings.Message message) {
        return decode(new com.vccorp.mojo.bindings.Decoder(message).decoderForSerializedUnion(), 0);
    }

    public static final DrawQuadState decode(com.vccorp.mojo.bindings.Decoder decoder0, int offset) {
        com.vccorp.mojo.bindings.DataHeader dataHeader = decoder0.readDataHeaderForUnion(offset);
        if (dataHeader.size == 0) {
            return null;
        }
        DrawQuadState result = new DrawQuadState();
        switch (dataHeader.elementsOrVersion) {
            case Tag.DebugBorderQuadState: {
                
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(offset + com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE, false);
                result.mDebugBorderQuadState = DebugBorderQuadState.decode(decoder1);
                result.mTag = Tag.DebugBorderQuadState;
                break;
            }
            case Tag.RenderPassQuadState: {
                
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(offset + com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE, false);
                result.mRenderPassQuadState = RenderPassQuadState.decode(decoder1);
                result.mTag = Tag.RenderPassQuadState;
                break;
            }
            case Tag.SolidColorQuadState: {
                
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(offset + com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE, false);
                result.mSolidColorQuadState = SolidColorQuadState.decode(decoder1);
                result.mTag = Tag.SolidColorQuadState;
                break;
            }
            case Tag.StreamVideoQuadState: {
                
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(offset + com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE, false);
                result.mStreamVideoQuadState = StreamVideoQuadState.decode(decoder1);
                result.mTag = Tag.StreamVideoQuadState;
                break;
            }
            case Tag.SurfaceQuadState: {
                
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(offset + com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE, false);
                result.mSurfaceQuadState = SurfaceQuadState.decode(decoder1);
                result.mTag = Tag.SurfaceQuadState;
                break;
            }
            case Tag.TextureQuadState: {
                
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(offset + com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE, false);
                result.mTextureQuadState = TextureQuadState.decode(decoder1);
                result.mTag = Tag.TextureQuadState;
                break;
            }
            case Tag.TileQuadState: {
                
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(offset + com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE, false);
                result.mTileQuadState = TileQuadState.decode(decoder1);
                result.mTag = Tag.TileQuadState;
                break;
            }
            case Tag.YuvVideoQuadState: {
                
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(offset + com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE, false);
                result.mYuvVideoQuadState = YuvVideoQuadState.decode(decoder1);
                result.mTag = Tag.YuvVideoQuadState;
                break;
            }
            case Tag.VideoHoleQuadState: {
                
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(offset + com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE, false);
                result.mVideoHoleQuadState = VideoHoleQuadState.decode(decoder1);
                result.mTag = Tag.VideoHoleQuadState;
                break;
            }
            default: {
                break;
            }
        }
        return result;
    }
}