
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     services/viz/public/interfaces/compositing/copy_output_result.mojom
//

package com.vccorp.viz.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


public final class CopyOutputResult extends org.chromium.mojo.bindings.Struct {

    private static final int STRUCT_SIZE = 64;
    private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(64, 0)};
    private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    public int format;
    public com.vccorp.gfx.mojom.Rect rect;
    public com.vccorp.skia.mojom.Bitmap bitmap;
    public com.vccorp.gpu.mojom.Mailbox mailbox;
    public com.vccorp.gpu.mojom.SyncToken syncToken;
    public com.vccorp.gfx.mojom.ColorSpace colorSpace;
    public TextureReleaser releaser;

    private CopyOutputResult(int version) {
        super(STRUCT_SIZE, version);
    }

    public CopyOutputResult() {
        this(0);
    }

    public static CopyOutputResult deserialize(com.vccorp.mojo.bindings.Message message) {
        return decode(new com.vccorp.mojo.bindings.Decoder(message));
    }

    /**
     * Similar to the method above, but deserializes from a |ByteBuffer| instance.
     *
     * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
     */
    public static CopyOutputResult deserialize(java.nio.ByteBuffer data) {
        return deserialize(new com.vccorp.mojo.bindings.Message(
                data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
    }

    @SuppressWarnings("unchecked")
    public static CopyOutputResult decode(com.vccorp.mojo.bindings.Decoder decoder0) {
        if (decoder0 == null) {
            return null;
        }
        decoder0.increaseStackDepth();
        CopyOutputResult result;
        try {
            com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            final int elementsOrVersion = mainDataHeader.elementsOrVersion;
            result = new CopyOutputResult(elementsOrVersion);
                {
                    
                result.format = decoder0.readInt(8);
                    CopyOutputResultFormat.validate(result.format);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, false);
                result.rect = com.vccorp.gfx.mojom.Rect.decode(decoder1);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(24, true);
                result.bitmap = com.vccorp.skia.mojom.Bitmap.decode(decoder1);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(32, true);
                result.mailbox = com.vccorp.gpu.mojom.Mailbox.decode(decoder1);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(40, true);
                result.syncToken = com.vccorp.gpu.mojom.SyncToken.decode(decoder1);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(48, true);
                result.colorSpace = com.vccorp.gfx.mojom.ColorSpace.decode(decoder1);
                }
                {
                    
                result.releaser = decoder0.readServiceInterface(56, true, TextureReleaser.MANAGER);
                }

        } finally {
            decoder0.decreaseStackDepth();
        }
        return result;
    }

    @SuppressWarnings("unchecked")
    @Override
    protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
        org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        
        encoder0.encode(this.format, 8);
        
        encoder0.encode(this.rect, 16, false);
        
        encoder0.encode(this.bitmap, 24, true);
        
        encoder0.encode(this.mailbox, 32, true);
        
        encoder0.encode(this.syncToken, 40, true);
        
        encoder0.encode(this.colorSpace, 48, true);
        
        encoder0.encode(this.releaser, 56, true, TextureReleaser.MANAGER);
    }
}